/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc;

import com.metamatrix.core.classloader.URLClassLoaderRegistry;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ClassLoaderUtil;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.jdbc.JdbcDriver;
import com.metamatrix.modeler.jdbc.JdbcDriverContainer;
import com.metamatrix.modeler.jdbc.JdbcDriverProperty;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcManager;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.JdbcSourceContainer;
import com.metamatrix.modeler.jdbc.JdbcSourceProperty;
import com.metamatrix.modeler.jdbc.custom.ExcelConnectionHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class JdbcManagerImpl
implements JdbcManager {
    public static final int MISSING_DRIVER_CLASS = 1001;
    public static final int VALID_SOURCE = 1002;
    public static final int NAME_NOT_SPECIFIED = 1003;
    public static final int NAME_MUST_BEGIN_WITH_LETTER_OR_NUMBER = 1004;
    public static final int NO_AVAILABLE_DRIVER_CLASS_NAMES = 1005;
    public static final int PREFERRED_NOT_SPECIFIED = 1006;
    public static final int PREFERRED_NOT_IN_AVAILABLE = 1007;
    public static final int NO_JARS_SPECIFIED = 1008;
    public static final int VALID_DRIVER = 1009;
    public static final int ILLEGAL_CHAR_AT_START_OF_CLASS_NAME = 1010;
    public static final int ILLEGAL_CHAR_IN_CLASS_NAME = 1011;
    public static final int JAR_FILE_URI_NOT_SPECIFIED = 1012;
    public static final int JAR_FILE_DOESNT_EXIST = 1013;
    public static final int MALFORMED_URL = 1014;
    public static final int PROPERTY_NAME_MISSING = 1015;
    public static final int PROPERTY_VALUE_MISSING = 1016;
    public static final int ERROR_BUILDING_CLASSLOADER = 1017;
    public static final int UNABLE_TO_FIND_DRIVER = 1018;
    public static final int ERROR_CHECKING_DRIVER_CLASS = 1019;
    public static final int URL_NOT_SPECIFIED = 1020;
    public static final int URL_MUST_START_WITH_JDBC = 1021;
    public static final int ERROR_FINDING_DRIVER_CLASS = 1022;
    public static final int MALFORMED_URL_SYNTAX = 1023;
    public static final int AVAILABLE_CLASSES_COMPLETE = 1100;
    public static final int AVAILABLE_CLASSES_WITH_WARNINGS = 1102;
    public static final int AVAILABLE_CLASSES_WITH_ERRORS = 1103;
    public static final int AVAILABLE_CLASSES_WITH_WARNINGS_AND_ERRORS = 1104;
    private static final String PID = "com.metamatrix.modeler.jdbc";
    public static final String JDBC_MODEL = "jdbcModel.xmi";
    private static JdbcManager shared;
    private final String name;
    private Resource resource;
    private JdbcDriverContainer drivers;
    private JdbcSourceContainer sources;
    private final Object driversLock = new Object();
    private final Object sourcesLock = new Object();
    private final URLClassLoaderRegistry classLoaderRegistry;
    static /* synthetic */ Class class$java$sql$Driver;
    static /* synthetic */ Class class$javax$sql$DataSource;
    static /* synthetic */ Class class$javax$sql$XADataSource;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$lang$String;

    public static JdbcManager create(String name, File folder, Container container) throws JdbcException {
        if (shared == null) {
            URI uri = URI.createFileURI((String)new File(folder, JDBC_MODEL).getAbsolutePath());
            Resource model = container.getResource(uri, true);
            JdbcManagerImpl mgr = new JdbcManagerImpl(name, model);
            mgr.start();
            shared = mgr;
        }
        return shared;
    }

    public static JdbcManager get() {
        return shared;
    }

    public JdbcManagerImpl(String name, Resource resource) {
        ArgCheck.isNotNull((Object)name);
        ArgCheck.isNotZeroLength((String)name);
        ArgCheck.isNotNull((Object)resource);
        this.name = name;
        this.resource = resource;
        this.classLoaderRegistry = new URLClassLoaderRegistry();
    }

    public String getName() {
        return this.name;
    }

    public void start() throws JdbcException {
        URI uri;
        File f;
        if (!this.resource.isLoaded() && (f = new File((uri = this.resource.getURI()).toFileString())).canRead() && f.exists() && f.length() != 0L) {
            try {
                Map options = this.resource.getResourceSet() != null ? this.resource.getResourceSet().getLoadOptions() : Collections.EMPTY_MAP;
                this.resource.load(options);
            }
            catch (IOException e) {
                Object[] params = new Object[]{this.resource.getURI()};
                String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Error_loading_resource", params);
                throw new JdbcException((Throwable)e, msg);
            }
        }
    }

    public void shutdown() {
        if (this.resource != null) {
            this.resource.unload();
        }
        this.sources = null;
        this.drivers = null;
    }

    public boolean hasChanges() {
        return true;
    }

    public void saveChanges(IProgressMonitor monitor) throws IOException {
        if (!this.hasChanges()) {
            return;
        }
        Assertion.isNotNull((Object)this.resource);
        this.resource.save(new HashMap());
    }

    public void reload(IProgressMonitor monitor) throws JdbcException {
        this.shutdown();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getJdbcDrivers() {
        if (this.drivers == null) {
            Object object = this.driversLock;
            synchronized (object) {
                if (this.drivers == null) {
                    EList roots = this.getResource().getContents();
                    Iterator iter = roots.iterator();
                    while (iter.hasNext()) {
                        EObject root = (EObject)iter.next();
                        if (!(root instanceof JdbcDriverContainer)) continue;
                        this.drivers = (JdbcDriverContainer)root;
                        break;
                    }
                    if (this.drivers == null) {
                        this.drivers = this.getFactory().createJdbcDriverContainer();
                        roots.add(this.drivers);
                    }
                }
            }
        }
        return this.drivers.getJdbcDrivers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getJdbcSources() {
        if (this.sources == null) {
            Object object = this.sourcesLock;
            synchronized (object) {
                if (this.sources == null) {
                    EList roots = this.getResource().getContents();
                    Iterator iter = roots.iterator();
                    while (iter.hasNext()) {
                        EObject root = (EObject)iter.next();
                        if (!(root instanceof JdbcSourceContainer)) continue;
                        this.sources = (JdbcSourceContainer)root;
                        break;
                    }
                    if (this.sources == null) {
                        this.sources = this.getFactory().createJdbcSourceContainer();
                        roots.add(this.sources);
                    }
                }
            }
        }
        return this.sources.getJdbcSources();
    }

    public JdbcFactory getFactory() {
        return JdbcFactory.eINSTANCE;
    }

    public JdbcDriver findBestDriver(JdbcSource source) {
        ArgCheck.isNotNull((Object)source);
        return this.findBestDriver(source, false);
    }

    public JdbcDriver findBestDriver(JdbcSource source, boolean requireDriverClass) {
        ArgCheck.isNotNull((Object)source);
        JdbcDriver[] bestDrivers = this.findDrivers(source, requireDriverClass);
        return bestDrivers.length != 0 ? bestDrivers[0] : null;
    }

    public JdbcDriver[] findDrivers(JdbcSource source) {
        return this.findDrivers(source, false);
    }

    protected JdbcDriver[] findDrivers(JdbcSource source, boolean requireDriverClass) {
        ArgCheck.isNotNull((Object)source);
        String sourceDriverName = source.getDriverName();
        String sourceDriverClass = source.getDriverClass();
        JdbcDriver sourceDriver = source.getJdbcDriver();
        ArrayList<JdbcDriver> results = new ArrayList<JdbcDriver>();
        ArrayList allDrivers = new ArrayList(this.getJdbcDrivers());
        for (int i = 0; i < 6; ++i) {
            Iterator iter = allDrivers.iterator();
            while (iter.hasNext()) {
                boolean nameMatch = false;
                boolean classMatch = false;
                boolean prefClassMatch = false;
                boolean refMatch = false;
                JdbcDriver driver = (JdbcDriver)iter.next();
                if (sourceDriverName != null && sourceDriverName.equals(driver.getName())) {
                    nameMatch = true;
                }
                if (sourceDriverClass != null) {
                    if (sourceDriverClass.equals(driver.getPreferredDriverClassName())) {
                        prefClassMatch = true;
                        classMatch = true;
                    }
                    if (!prefClassMatch) {
                        EList availableClasses = driver.getAvailableDriverClassNames();
                        Iterator classIter = availableClasses.iterator();
                        while (classIter.hasNext()) {
                            String className = (String)classIter.next();
                            if (!sourceDriverClass.equals(className)) continue;
                            classMatch = true;
                            break;
                        }
                    }
                }
                if (sourceDriver == driver) {
                    refMatch = true;
                }
                if (requireDriverClass && !classMatch && !prefClassMatch) continue;
                if (i == 0 && nameMatch && prefClassMatch && classMatch && refMatch) {
                    if (results.contains(driver)) continue;
                    results.add(driver);
                    continue;
                }
                if (i == 1 && nameMatch && prefClassMatch && classMatch) {
                    if (results.contains(driver)) continue;
                    results.add(driver);
                    continue;
                }
                if (i == 2 && nameMatch && classMatch) {
                    if (results.contains(driver)) continue;
                    results.add(driver);
                    continue;
                }
                if (i == 3 && prefClassMatch) {
                    if (results.contains(driver)) continue;
                    results.add(driver);
                    continue;
                }
                if (i == 4 && classMatch) {
                    if (results.contains(driver)) continue;
                    results.add(driver);
                    continue;
                }
                if (i != 5 || !nameMatch || results.contains(driver)) continue;
                results.add(driver);
            }
        }
        if (sourceDriver != null && results.isEmpty() && allDrivers.contains(sourceDriver)) {
            results.add(sourceDriver);
        }
        return results.toArray(new JdbcDriver[results.size()]);
    }

    public Resource getResource() {
        return this.resource;
    }

    public URLClassLoader getClassLoader(JdbcDriver driver) throws JdbcException {
        ArgCheck.isNotNull((Object)driver);
        EList jarFileUriList = driver.getJarFileUris();
        String[] jarFileUrls = jarFileUriList.toArray(new String[jarFileUriList.size()]);
        return this.getClassLoader(jarFileUrls);
    }

    protected URLClassLoader getClassLoader(String[] urlStrings) throws JdbcException {
        URLClassLoader loader = null;
        try {
            loader = this.classLoaderRegistry.getClassLoader(urlStrings, this.getClass().getClassLoader());
        }
        catch (MalformedURLException err) {
            String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Unable_to_create_class_loader_for_the_driver");
            throw new JdbcException((Throwable)err, msg);
        }
        return loader;
    }

    public IStatus computeAvailableDriverClasses(JdbcDriver driver, boolean driverOnly) {
        URLClassLoader loader;
        ArgCheck.isNotNull((Object)driver);
        try {
            loader = this.getClassLoader(driver);
        }
        catch (JdbcException e) {
            return new Status(0, PID, 1017, e.getMessage(), (Throwable)((Object)e));
        }
        return this.computeAvailableDriverClasses(driver, loader, driverOnly);
    }

    protected IStatus computeAvailableDriverClasses(JdbcDriver driver, URLClassLoader loader, boolean driverOnly) {
        Class[] classArray;
        ArrayList statuses = new ArrayList();
        ClassLoaderUtil helper = new ClassLoaderUtil(loader);
        if (driverOnly) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = class$java$sql$Driver == null ? (class$java$sql$Driver = JdbcManagerImpl.class$("java.sql.Driver")) : class$java$sql$Driver;
        } else {
            Class[] classArray3 = new Class[3];
            classArray3[0] = class$java$sql$Driver == null ? (class$java$sql$Driver = JdbcManagerImpl.class$("java.sql.Driver")) : class$java$sql$Driver;
            classArray3[1] = class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = JdbcManagerImpl.class$("javax.sql.DataSource")) : class$javax$sql$DataSource;
            classArray = classArray3;
            classArray3[2] = class$javax$sql$XADataSource == null ? (class$javax$sql$XADataSource = JdbcManagerImpl.class$("javax.sql.XADataSource")) : class$javax$sql$XADataSource;
        }
        Class[] assignables = classArray;
        Class[] driverClasses = helper.getAssignablePublicClassesWithNoArgConstructors(assignables);
        if (helper.hasProblems()) {
            statuses.addAll(helper.getProblems());
        }
        int numClasses = driverClasses.length;
        boolean updateAvailableClasses = true;
        Status resultStatus = null;
        if (statuses.isEmpty()) {
            Object[] params = new Object[]{new Integer(numClasses)};
            String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Computed_available_classes_with_no_warnings_or_errors", params);
            resultStatus = new Status(0, PID, 1100, msg, null);
        } else {
            String msg;
            Object[] params;
            int numErrors = 0;
            int numWarnings = 0;
            Iterator iter = statuses.iterator();
            while (iter.hasNext()) {
                IStatus aStatus = (IStatus)iter.next();
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = statuses.toArray(new IStatus[statuses.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                params = new Object[]{new Integer(numClasses), new Integer(numWarnings)};
                msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Computed_available_classes_with_warnings", params);
                resultStatus = new MultiStatus(PID, 1102, statusArray, msg, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                updateAvailableClasses = false;
                params = new Object[]{new Integer(numClasses), new Integer(numErrors)};
                msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Computing_available_classes_resulted_in_errors", params);
                resultStatus = new MultiStatus(PID, 1103, statusArray, msg, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                updateAvailableClasses = false;
                params = new Object[]{new Integer(numClasses), new Integer(numWarnings), new Integer(numErrors)};
                msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Computing_available_classes_resulted_in_warnings_and_errors", params);
                resultStatus = new MultiStatus(PID, 1104, statusArray, msg, null);
            } else {
                params = new Object[]{new Integer(numClasses)};
                msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Computed_available_classes_with_no_warnings_or_errors", params);
                resultStatus = new MultiStatus(PID, 1100, statusArray, msg, null);
            }
        }
        if (updateAvailableClasses) {
            driver.getAvailableDriverClassNames().clear();
            for (int i = 0; i < driverClasses.length; ++i) {
                driver.getAvailableDriverClassNames().add((Object)driverClasses[i].getName());
            }
        }
        return resultStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection createConnection(JdbcSource jdbcSource, JdbcDriver jdbcDriver, String password, IProgressMonitor monitor) throws JdbcException, SQLException {
        Throwable error22;
        ConnectionThread connectionThread = new ConnectionThread(jdbcSource, jdbcDriver, password);
        connectionThread.start();
        try {
            try {
                while ((monitor == null || !monitor.isCanceled()) && connectionThread.isAlive()) {
                    Thread.sleep(100L);
                }
                if (monitor != null && monitor.isCanceled() && connectionThread.isAlive()) {
                    try {
                        connectionThread.interrupt();
                    }
                    catch (Throwable t) {
                    }
                }
                Object var8_8 = null;
                error22 = connectionThread.getThrowable();
                if (error22 == null) return connectionThread.getConnection();
            }
            catch (InterruptedException e) {
                Object var8_9 = null;
                Throwable error22 = connectionThread.getThrowable();
                if (error22 == null) return connectionThread.getConnection();
                if (error22 instanceof InterruptedException) {
                    return null;
                }
                if (error22 instanceof JdbcException) {
                    throw (JdbcException)((Object)error22);
                }
                if (error22 instanceof SQLException) {
                    throw (SQLException)error22;
                }
                if (!(error22 instanceof RuntimeException)) return connectionThread.getConnection();
                throw (RuntimeException)error22;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Throwable error22 = connectionThread.getThrowable();
            if (error22 == null) throw throwable;
            if (error22 instanceof InterruptedException) {
                return null;
            }
            if (error22 instanceof JdbcException) {
                throw (JdbcException)((Object)error22);
            }
            if (error22 instanceof SQLException) {
                throw (SQLException)error22;
            }
            if (!(error22 instanceof RuntimeException)) throw throwable;
            throw (RuntimeException)error22;
        }
        if (error22 instanceof InterruptedException) {
            return null;
        }
        if (error22 instanceof JdbcException) {
            throw (JdbcException)((Object)error22);
        }
        if (error22 instanceof SQLException) {
            throw (SQLException)error22;
        }
        if (!(error22 instanceof RuntimeException)) return connectionThread.getConnection();
        throw (RuntimeException)error22;
    }

    public Connection createConnection(JdbcSource jdbcSource, JdbcDriver jdbcDriver, String password) throws JdbcException, SQLException {
        ArgCheck.isNotNull((Object)jdbcSource);
        JdbcDriver theDriver = jdbcDriver;
        if (theDriver == null) {
            theDriver = this.findBestDriver(jdbcSource);
        }
        ArgCheck.isNotNull((Object)theDriver);
        URLClassLoader loader = this.getClassLoader(theDriver);
        ArgCheck.isNotNull((Object)loader);
        if (jdbcSource.getDriverName().equalsIgnoreCase("Microsoft Excel")) {
            return (Connection)Proxy.newProxyInstance(loader, new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcManagerImpl.class$("java.sql.Connection")) : class$java$sql$Connection}, (InvocationHandler)new ExcelConnectionHandler(this.createConnection(jdbcSource, loader, password), jdbcSource.getUrl()));
        }
        return this.createConnection(jdbcSource, loader, password);
    }

    protected Connection createConnection(JdbcSource jdbcSource, ClassLoader loader, String password) throws JdbcException, SQLException {
        ArgCheck.isNotNull((Object)jdbcSource);
        ArgCheck.isNotNull((Object)loader);
        Connection result = null;
        Object driverObject = this.createDriverObject(jdbcSource, loader, password);
        if (driverObject instanceof DataSource) {
            DataSource source = (DataSource)driverObject;
            result = source.getConnection();
        } else if (driverObject instanceof Driver) {
            Driver driver = (Driver)driverObject;
            String url = jdbcSource.getUrl();
            Properties props = this.createProperties(jdbcSource);
            String username = jdbcSource.getUsername();
            if (username != null && username.trim().length() != 0) {
                props.put("user", username);
            }
            if (password != null) {
                props.put("password", password);
            }
            result = driver.connect(url, props);
        } else {
            Assertion.assertTrue((boolean)false, (String)JdbcPlugin.Util.getString("JdbcManagerImpl.Unexpected_driver_object"));
            return null;
        }
        if (result == null) {
            throw new JdbcException(JdbcPlugin.Util.getString("JdbcManagerImpl.NullConnectionFromDriver"));
        }
        return result;
    }

    protected Object createDriverObject(JdbcSource jdbcSource, ClassLoader loader, String password) throws JdbcException, SQLException {
        IStatus status = this.isValid(jdbcSource, loader);
        if (status.getSeverity() == 4) {
            throw new JdbcException(status);
        }
        try {
            Class javaxSqlDataSourceClass;
            Class<?> driverClass = Class.forName(jdbcSource.getDriverClass(), true, loader);
            Class javaSqlDriverClass = class$java$sql$Driver == null ? (class$java$sql$Driver = JdbcManagerImpl.class$("java.sql.Driver")) : class$java$sql$Driver;
            Class clazz = javaxSqlDataSourceClass = class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = JdbcManagerImpl.class$("javax.sql.DataSource")) : class$javax$sql$DataSource;
            if (javaSqlDriverClass.isAssignableFrom(driverClass)) {
                Driver driver = (Driver)driverClass.newInstance();
                return driver;
            }
            if (javaxSqlDataSourceClass.isAssignableFrom(driverClass)) {
                DataSource dataSource = (DataSource)driverClass.newInstance();
                Properties props = this.createProperties(jdbcSource);
                if (password != null) {
                    props.put("password", password);
                }
                this.setProperties(props, dataSource);
                return dataSource;
            }
            Object[] params = new Object[]{driverClass.getName()};
            String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.The_class_{0}_does_not_implement_Driver_or_DataSource", params);
            throw new JdbcException(msg);
        }
        catch (ClassNotFoundException e) {
            throw new JdbcException(e);
        }
        catch (InstantiationException e) {
            throw new JdbcException(e);
        }
        catch (IllegalAccessException e) {
            throw new JdbcException(e);
        }
    }

    protected Properties createProperties(JdbcSource jdbcSource) {
        Properties props = new Properties();
        Iterator iter = jdbcSource.getProperties().iterator();
        while (iter.hasNext()) {
            JdbcSourceProperty prop = (JdbcSourceProperty)iter.next();
            props.put(prop.getName().toLowerCase(), prop.getValue());
        }
        return props;
    }

    protected void setProperties(Properties props, DataSource dataSource) throws JdbcException {
        Method[] methods = dataSource.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            String propertyValue;
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || (propertyValue = (String)props.get((propertyName = methodName.substring(3)).toLowerCase())) == null) continue;
            Class<?> argType = method.getParameterTypes()[0];
            Object[] params = new Object[1];
            if (argType == Integer.TYPE) {
                params[0] = Integer.decode(propertyValue);
            } else if (argType == Boolean.TYPE) {
                params[0] = Boolean.valueOf(propertyValue);
            } else if (argType == (class$java$lang$String == null ? JdbcManagerImpl.class$("java.lang.String") : class$java$lang$String)) {
                params[0] = propertyValue;
            }
            try {
                method.invoke((Object)dataSource, params);
                continue;
            }
            catch (Throwable e) {
                Object[] msgParams = new Object[]{propertyName, propertyValue};
                String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.Unable_to_set_property_to_value", msgParams);
                throw new JdbcException(msg);
            }
        }
    }

    public JdbcDriverProperty[] getPropertyDescriptions(JdbcSource jdbcSource) throws JdbcException {
        URLClassLoader loader;
        ArgCheck.isNotNull((Object)jdbcSource);
        JdbcDriver jdbcDriver = jdbcSource.getJdbcDriver();
        if (jdbcDriver != null && (loader = this.getClassLoader(jdbcDriver)) != null) {
            try {
                Object jdbcDriverObj = this.createDriverObject(jdbcSource, loader, null);
                if (jdbcDriverObj instanceof Driver) {
                    Driver driver = (Driver)jdbcDriverObj;
                    JdbcDriverProperty[] props = this.getPropertyDescriptions(driver, jdbcSource);
                    return props;
                }
                if (jdbcDriverObj instanceof DataSource) {
                    DataSource dataSource = (DataSource)jdbcDriverObj;
                    JdbcDriverProperty[] props = this.getPropertyDescriptions(dataSource, jdbcSource);
                    return props;
                }
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
        return new JdbcDriverProperty[0];
    }

    protected JdbcDriverProperty[] getPropertyDescriptions(Driver driver, JdbcSource jdbcSource) throws SQLException {
        ArgCheck.isNotNull((Object)driver);
        ArgCheck.isNotNull((Object)jdbcSource);
        DriverPropertyInfo[] propInfo = null;
        String url = jdbcSource.getUrl() != null ? jdbcSource.getUrl() : "";
        try {
            propInfo = driver.getPropertyInfo(url, null);
        }
        catch (RuntimeException err) {
            try {
                propInfo = driver.getPropertyInfo(url, new Properties());
            }
            catch (RuntimeException err2) {
                // empty catch block
            }
        }
        if (propInfo == null || propInfo.length == 0) {
            return new JdbcDriverProperty[0];
        }
        ArrayList<JdbcDriverProperty> props = new ArrayList<JdbcDriverProperty>(propInfo.length);
        for (int i = 0; i < propInfo.length; ++i) {
            DriverPropertyInfo info = propInfo[i];
            JdbcDriverProperty prop = new JdbcDriverProperty(info);
            props.add(prop);
        }
        return props.toArray(new JdbcDriverProperty[props.size()]);
    }

    protected JdbcDriverProperty[] getPropertyDescriptions(DataSource dataSource, JdbcSource jdbcSource) throws SQLException {
        Method[] methods = dataSource.getClass().getMethods();
        ArrayList<JdbcDriverProperty> props = new ArrayList<JdbcDriverProperty>();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
            String name = methodName.substring(3);
            String desc = null;
            String[] allowableValues = null;
            boolean required = true;
            JdbcDriverProperty prop = new JdbcDriverProperty(name, desc, allowableValues, true);
            props.add(prop);
        }
        return props.toArray(new JdbcDriverProperty[props.size()]);
    }

    public IStatus isValid(JdbcSource jdbcSource) {
        ArgCheck.isNotNull((Object)jdbcSource);
        return this.isValid(jdbcSource, null);
    }

    protected IStatus isValid(JdbcSource jdbcSource, ClassLoader loader) {
        Object[] params;
        ArgCheck.isNotNull((Object)jdbcSource);
        String name = jdbcSource.getName();
        if (name == null || name.trim().length() == 0) {
            int code = 1003;
            return this.createError(1003, JdbcPlugin.Util.getString("JdbcManagerImpl.The_name_is_empty"));
        }
        if (!Character.isLetterOrDigit(name.charAt(0))) {
            int code = 1004;
            return this.createError(1004, JdbcPlugin.Util.getString("JdbcManagerImpl.The_name_must_begin_with_a_letter_or_digit"));
        }
        String driverClass = jdbcSource.getDriverClass();
        if (driverClass == null || driverClass.trim().length() == 0) {
            int code = 1001;
            return this.createError(1001, JdbcPlugin.Util.getString("JdbcManagerImpl.A_driver_class_must_be_specified", (Object)jdbcSource.getName()));
        }
        IStatus error = this.checkClassNameForError(driverClass);
        if (error != null) {
            return error;
        }
        Iterator iter = jdbcSource.getProperties().iterator();
        while (iter.hasNext()) {
            JdbcSourceProperty prop = (JdbcSourceProperty)iter.next();
            String propName = prop.getName();
            String value = prop.getValue();
            if (propName == null || propName.trim().length() == 0) {
                int code = 1015;
                return this.createError(1015, JdbcPlugin.Util.getString("JdbcManagerImpl.Property_names_may_not_be_null_or_empty"));
            }
            if (value != null && value.trim().length() != 0) continue;
            int code = 1016;
            return this.createError(1016, JdbcPlugin.Util.getString("JdbcManagerImpl.Property_values_may_not_be_null_or_empty"));
        }
        if (loader == null) {
            JdbcDriver driver = this.findBestDriver(jdbcSource);
            if (driver == null) {
                int code = 1018;
                params = new Object[]{driverClass};
                return this.createWarning(1018, JdbcPlugin.Util.getString("JdbcManagerImpl.Unable_to_find_the_JDBC_driver_containing_driver_class", params));
            }
            try {
                loader = this.getClassLoader(driver);
            }
            catch (Throwable e) {
                int code = 1019;
                Object[] params2 = new Object[]{driverClass};
                return this.createWarning(1019, e, JdbcPlugin.Util.getString("JdbcManagerImpl.Error_while_validating_driver_class", params2));
            }
        }
        try {
            Class<?> driverClassClass = Class.forName(driverClass, true, loader);
            if ((class$java$sql$Driver == null ? (class$java$sql$Driver = JdbcManagerImpl.class$("java.sql.Driver")) : class$java$sql$Driver).isAssignableFrom(driverClassClass)) {
                String url = jdbcSource.getUrl();
                if (url == null || url.trim().length() == 0) {
                    int code = 1020;
                    return this.createError(1020, JdbcPlugin.Util.getString("JdbcManagerImpl.A_URL_is_required_since_the_driver_class_implements_java.sql.Driver"));
                }
                if (!url.startsWith("jdbc:")) {
                    int code = 1021;
                    return this.createWarning(1021, JdbcPlugin.Util.getString("JdbcManagerImpl.The_URL_must_begin_with_jdbc"));
                }
            }
        }
        catch (ClassNotFoundException e) {
            int code = 1022;
            params = new Object[]{driverClass};
            return this.createWarning(1022, e, JdbcPlugin.Util.getString("JdbcManagerImpl.Error_finding_driver_class", params));
        }
        int code = 1002;
        return this.createOK(1002, JdbcPlugin.Util.getString("JdbcManagerImpl.The_data_source_is_valid"));
    }

    public IStatus isValid(JdbcDriver driver) {
        ArgCheck.isNotNull((Object)driver);
        return this.isValid(driver, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus isValid(JdbcDriver driver, boolean checkDriverClasses) {
        ArgCheck.isNotNull((Object)driver);
        String name = driver.getName();
        if (name == null || name.trim().length() == 0) {
            int code = 1003;
            return this.createError(1003, JdbcPlugin.Util.getString("JdbcManagerImpl.The_name_is_empty"));
        }
        if (!Character.isLetterOrDigit(name.charAt(0))) {
            int code = 1004;
            return this.createError(1004, JdbcPlugin.Util.getString("JdbcManagerImpl.The_name_must_begin_with_a_letter_or_digit"));
        }
        if (checkDriverClasses) {
            IStatus error;
            EList availableClasses = driver.getAvailableDriverClassNames();
            if (availableClasses.isEmpty()) {
                int code = 1005;
                return this.createError(1005, JdbcPlugin.Util.getString("JdbcManagerImpl.No_java.sql.Driver_or_javax.sql.DataSource_classes_were_found", (Object)name));
            }
            Iterator iter = availableClasses.iterator();
            while (iter.hasNext()) {
                String className = (String)iter.next();
                error = this.checkClassNameForError(className);
                if (error == null) continue;
                return error;
            }
            String preferred = driver.getPreferredDriverClassName();
            if (preferred == null || preferred.trim().length() == 0) {
                int code = 1006;
                return this.createError(1006, JdbcPlugin.Util.getString("JdbcManagerImpl.A_preferred_driver_class_must_be_chosen", (Object)name));
            }
            error = this.checkClassNameForError(preferred);
            if (error != null) {
                return error;
            }
            if (!availableClasses.contains(preferred)) {
                int code = 1007;
                return this.createError(1007, JdbcPlugin.Util.getString("JdbcManagerImpl.The_preferred_driver_class_is_not_available", (Object)name));
            }
        }
        if (driver.getJarFileUris().isEmpty()) {
            int code = 1008;
            return this.createWarning(1008, JdbcPlugin.Util.getString("JdbcManagerImpl.There_are_no_JAR_files_specified.__Only_the_system_classpath_will_be_used", (Object)name));
        }
        Iterator jarFileUriIter = driver.getJarFileUris().iterator();
        if (jarFileUriIter.hasNext()) {
            String jarFileUri = (String)jarFileUriIter.next();
            if (jarFileUri == null || jarFileUri.trim().length() == 0) {
                int code = 1012;
                return this.createError(1012, JdbcPlugin.Util.getString("JdbcManagerImpl.The_jar_file_uri_is_empty", (Object)name));
            }
            boolean validUrl = false;
            InputStream stream = null;
            try {
                URL url = new URL(jarFileUri);
                stream = url.openStream();
                validUrl = true;
                return validUrl;
            }
            catch (Throwable throwable) {
                Object var10_22 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        String urlSyntax = driver.getUrlSyntax();
        if (urlSyntax != null && urlSyntax.trim().length() != 0 && !urlSyntax.startsWith("jdbc:")) {
            int code = 1023;
            String msg = JdbcPlugin.Util.getString("JdbcManagerImpl.malformedUrlSyntax", (Object)name);
            return this.createWarning(1023, msg);
        }
        int code = 1009;
        return this.createOK(1009, JdbcPlugin.Util.getString("JdbcManagerImpl.The_driver_specification_is_valid", (Object)name));
    }

    protected IStatus checkClassNameForError(String className) {
        if (className == null || className.trim().length() == 0) {
            int code = 1003;
            return this.createError(1003, JdbcPlugin.Util.getString("JdbcManagerImpl.The_class_name_is_empty"));
        }
        if (!Character.isJavaIdentifierStart(className.charAt(0))) {
            Object[] params = new Object[]{new Character(className.charAt(0))};
            int code = 1010;
            return this.createError(1010, JdbcPlugin.Util.getString("JdbcManagerImpl.A_Java_class_may_not_begin_with_the_{0}_character", (Object)params));
        }
        StringCharacterIterator iter = new StringCharacterIterator(className);
        char c = iter.next();
        while ((c = iter.next()) != '\uffff') {
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            Object[] params = new Object[]{new Character(className.charAt(0))};
            int code = 1011;
            return this.createError(1011, JdbcPlugin.Util.getString("JdbcManagerImpl.A_Java_class_may_not_contain_the_{0}_character", (Object)params));
        }
        return null;
    }

    protected IStatus createError(int code, String msg) {
        return new Status(4, PID, code, msg, null);
    }

    protected IStatus createWarning(int code, String msg) {
        return new Status(2, PID, code, msg, null);
    }

    protected IStatus createWarning(int code, Throwable t, String msg) {
        return new Status(2, PID, code, msg, t);
    }

    protected IStatus createOK(int code, String msg) {
        return new Status(0, PID, code, msg, null);
    }

    public JdbcDriver[] findDrivers(String driverName) {
        ArrayList<JdbcDriver> result = new ArrayList<JdbcDriver>();
        List instances = this.getJdbcDrivers();
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            JdbcDriver instance = (JdbcDriver)iter.next();
            if (!instance.getName().equalsIgnoreCase(driverName)) continue;
            result.add(instance);
        }
        return result.toArray(new JdbcDriver[result.size()]);
    }

    public JdbcSource[] findSources(String sourceName) {
        ArrayList<JdbcSource> result = new ArrayList<JdbcSource>();
        List instances = this.getJdbcSources();
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            JdbcSource instance = (JdbcSource)iter.next();
            if (!instance.getName().equalsIgnoreCase(sourceName)) continue;
            result.add(instance);
        }
        return result.toArray(new JdbcSource[result.size()]);
    }

    public void saveConnections(OutputStream fileOutputStream) throws IOException {
        this.resource.save(fileOutputStream, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadConnections(Resource resrc) throws IOException, JdbcException {
        EList roots = resrc.getContents();
        Iterator iter = roots.iterator();
        JdbcSourceContainer sourceContainer = null;
        while (iter.hasNext()) {
            EObject root = (EObject)iter.next();
            if (!(root instanceof JdbcSourceContainer)) continue;
            sourceContainer = (JdbcSourceContainer)root;
            break;
        }
        if (sourceContainer != null) {
            EList newSourceList = sourceContainer.getJdbcSources();
            ArrayList result = new ArrayList(newSourceList);
            ArrayList<JdbcDriver> driversToBeMoved = new ArrayList<JdbcDriver>();
            Object object = this.sourcesLock;
            synchronized (object) {
                Iterator srcIter = result.iterator();
                while (srcIter.hasNext()) {
                    JdbcSource incomingSrc = (JdbcSource)srcIter.next();
                    if (incomingSrc == null) continue;
                    JdbcDriver incomingDriver = incomingSrc.getJdbcDriver();
                    JdbcDriver localDriver = this.findBestDriver(incomingSrc, true);
                    if (localDriver != null) {
                        incomingSrc.setJdbcDriver(localDriver);
                    } else if (!driversToBeMoved.contains(incomingDriver)) {
                        driversToBeMoved.add(incomingDriver);
                    }
                    this.sources.getJdbcSources().add((Object)incomingSrc);
                }
            }
            object = this.driversLock;
            synchronized (object) {
                this.drivers.getJdbcDrivers().addAll(driversToBeMoved);
            }
            this.resource.save(Collections.EMPTY_MAP);
            resrc.unload();
            resrc.getResourceSet().getResources().remove((Object)resrc);
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConnectionThread
    extends Thread {
        private final JdbcSource jdbcSource;
        private final JdbcDriver jdbcDriver;
        private final String password;
        private Connection connection;
        private Throwable throwable;

        protected ConnectionThread(JdbcSource jdbcSource, JdbcDriver jdbcDriver, String password) {
            super("JdbcConnectionThread");
            this.jdbcSource = jdbcSource;
            this.jdbcDriver = jdbcDriver;
            this.password = password;
        }

        public void run() {
            try {
                this.connection = JdbcManagerImpl.this.createConnection(this.jdbcSource, this.jdbcDriver, this.password);
            }
            catch (Throwable t) {
                this.throwable = t;
            }
        }

        protected Connection getConnection() {
            return this.connection;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

