/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.compare.DifferenceDescriptor;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.DifferenceType;
import com.metamatrix.modeler.compare.PropertyDifference;
import com.metamatrix.modeler.core.ModelerCore;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;

public class CompareUtil {
    static /* synthetic */ Class class$com$metamatrix$metamodels$core$ModelAnnotation;
    static /* synthetic */ Class class$com$metamatrix$metamodels$core$AnnotationContainer;
    static /* synthetic */ Class class$com$metamatrix$metamodels$transformation$TransformationContainer;
    static /* synthetic */ Class class$com$metamatrix$metamodels$diagram$DiagramContainer;
    static /* synthetic */ Class class$com$metamatrix$metamodels$core$ModelImport;

    private CompareUtil() {
    }

    public static void skipChangesFromDefault(DifferenceReport report) {
        Mapping rootMapping = report.getMapping();
        if (rootMapping != null) {
            CompareUtil.skipChangesFromDefault(rootMapping, true);
        }
    }

    public static int skipChangesFromDefault(Mapping differenceNode, boolean recursive) {
        int count = 0;
        DifferenceDescriptor desc = CompareUtil.getDifferenceDescriptor(differenceNode);
        if (desc != null) {
            count += CompareUtil.skipChangesFromDefault(desc);
        }
        if (recursive) {
            Iterator iter = differenceNode.getNested().iterator();
            while (iter.hasNext()) {
                Mapping nestedNode = (Mapping)iter.next();
                count += CompareUtil.skipChangesFromDefault(nestedNode, recursive);
            }
        }
        return count;
    }

    public static int skipChangesFromDefault(DifferenceDescriptor differenceDescriptor) {
        DifferenceType diffType = differenceDescriptor.getType();
        if (diffType.getValue() == 1) {
            return 0;
        }
        if (diffType.getValue() == 2) {
            return 0;
        }
        int count = 0;
        EList propertyDifferences = differenceDescriptor.getPropertyDifferences();
        Iterator iter = propertyDifferences.iterator();
        while (iter.hasNext()) {
            PropertyDifference propDiff = (PropertyDifference)iter.next();
            if (propDiff.isSkip()) continue;
            EStructuralFeature feature = propDiff.getAffectedFeature();
            Object featureDefaultValue = feature.getDefaultValue();
            if (featureDefaultValue != null) {
                Object newValue = propDiff.getNewValue();
                if (!featureDefaultValue.equals(newValue)) continue;
                propDiff.setSkip(true);
                ++count;
                continue;
            }
            if (propDiff.getNewValue() != null || propDiff.getOldValue() == null) continue;
            propDiff.setSkip(true);
            ++count;
        }
        return count;
    }

    public static DifferenceDescriptor getDifferenceDescriptor(Mapping mappingNode) {
        MappingHelper helper = mappingNode.getHelper();
        if (helper instanceof DifferenceDescriptor) {
            return (DifferenceDescriptor)helper;
        }
        return null;
    }

    public static boolean hasInstanceof(Mapping mappingNode, Class c) {
        Iterator inputIter = mappingNode.getInputs().iterator();
        while (inputIter.hasNext()) {
            Object obj = inputIter.next();
            if (!c.isInstance(obj)) continue;
            return true;
        }
        Iterator outputIter = mappingNode.getOutputs().iterator();
        while (outputIter.hasNext()) {
            Object obj = outputIter.next();
            if (!c.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    public static int skipUnchangeableFeatures(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        int count = 0;
        EList nestedMappings = rootMapping.getNested();
        Iterator iter = nestedMappings.iterator();
        while (iter.hasNext()) {
            Mapping nestedMapping = (Mapping)iter.next();
            count += CompareUtil.skipUnchangeableFeatures(nestedMapping, true);
        }
        return count;
    }

    public static int skipUnchangeableFeatures(Mapping differenceNode, boolean recursive) {
        int count = 0;
        DifferenceDescriptor desc = CompareUtil.getDifferenceDescriptor(differenceNode);
        if (desc != null && !desc.isSkip()) {
            int type = desc.getType().getValue();
            switch (type) {
                case 1: 
                case 2: {
                    EList inputs = differenceNode.getInputs();
                    EList outputs = differenceNode.getOutputs();
                    EObject input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
                    EObject output = outputs.isEmpty() ? null : (EObject)outputs.get(0);
                    EObject obj = input != null ? input : output;
                    EObject parent = obj.eContainer();
                    if (parent == null) break;
                    EClass parentEClass = parent.eClass();
                    Iterator iter = parentEClass.getEAllContainments().iterator();
                    while (iter.hasNext()) {
                        EReference ref = (EReference)iter.next();
                        if (ref.isChangeable()) continue;
                        if (ref.isMany()) {
                            List values = (List)parent.eGet(ref);
                            if (!values.contains(obj)) continue;
                            desc.setSkip(true);
                            ++count;
                            continue;
                        }
                        EObject value = (EObject)parent.eGet(ref);
                        if (!obj.equals(value)) continue;
                        desc.setSkip(true);
                        ++count;
                    }
                    break;
                }
                case 3: {
                    Iterator iter = desc.getPropertyDifferences().iterator();
                    while (iter.hasNext()) {
                        EStructuralFeature feature;
                        boolean changeable;
                        PropertyDifference propDiff = (PropertyDifference)iter.next();
                        if (propDiff.isSkip() || (changeable = (feature = propDiff.getAffectedFeature()).isChangeable()) && (!(feature instanceof EReference) || !((EReference)feature).isContainment())) continue;
                        propDiff.setSkip(true);
                        ++count;
                    }
                    break;
                }
            }
        }
        if (recursive) {
            Iterator iter = differenceNode.getNested().iterator();
            while (iter.hasNext()) {
                Mapping nestedNode = (Mapping)iter.next();
                count += CompareUtil.skipUnchangeableFeatures(nestedNode, recursive);
            }
        }
        return count;
    }

    public static void skipDeletesOfStandardContainers(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        EList nestedMappings = rootMapping.getNested();
        Iterator iter = nestedMappings.iterator();
        while (iter.hasNext()) {
            DifferenceDescriptor desc;
            Mapping nestedMapping = (Mapping)iter.next();
            if (CompareUtil.hasInstanceof(nestedMapping, class$com$metamatrix$metamodels$core$ModelAnnotation == null ? CompareUtil.class$("com.metamatrix.metamodels.core.ModelAnnotation") : class$com$metamatrix$metamodels$core$ModelAnnotation)) {
                desc = CompareUtil.getDifferenceDescriptor(nestedMapping);
                if (desc != null && desc.isDeletion()) {
                    desc.setSkip(true);
                }
                CompareUtil.skipChangesFromDefault(nestedMapping, true);
                continue;
            }
            if (CompareUtil.hasInstanceof(nestedMapping, class$com$metamatrix$metamodels$core$AnnotationContainer == null ? CompareUtil.class$("com.metamatrix.metamodels.core.AnnotationContainer") : class$com$metamatrix$metamodels$core$AnnotationContainer)) {
                desc = CompareUtil.getDifferenceDescriptor(nestedMapping);
                if (desc == null || !desc.isDeletion()) continue;
                desc.setSkip(true);
                continue;
            }
            if (CompareUtil.hasInstanceof(nestedMapping, class$com$metamatrix$metamodels$transformation$TransformationContainer == null ? CompareUtil.class$("com.metamatrix.metamodels.transformation.TransformationContainer") : class$com$metamatrix$metamodels$transformation$TransformationContainer)) {
                desc = CompareUtil.getDifferenceDescriptor(nestedMapping);
                desc.setSkip(true);
                continue;
            }
            if (!CompareUtil.hasInstanceof(nestedMapping, class$com$metamatrix$metamodels$diagram$DiagramContainer == null ? CompareUtil.class$("com.metamatrix.metamodels.diagram.DiagramContainer") : class$com$metamatrix$metamodels$diagram$DiagramContainer)) continue;
            desc = CompareUtil.getDifferenceDescriptor(nestedMapping);
            desc.setSkip(true);
        }
    }

    public static void skipDeletesOfModelImports(DifferenceReport differences) {
        Mapping rootMapping = differences.getMapping();
        EList nestedMappings = rootMapping.getNested();
        Iterator iter = nestedMappings.iterator();
        while (iter.hasNext()) {
            Mapping nestedMapping = (Mapping)iter.next();
            if (!CompareUtil.hasInstanceof(nestedMapping, class$com$metamatrix$metamodels$core$ModelAnnotation == null ? CompareUtil.class$("com.metamatrix.metamodels.core.ModelAnnotation") : class$com$metamatrix$metamodels$core$ModelAnnotation)) continue;
            Iterator nestedIter = nestedMapping.getNested().iterator();
            while (nestedIter.hasNext()) {
                DifferenceDescriptor desc;
                Mapping nestedNested = (Mapping)nestedIter.next();
                if (!CompareUtil.hasInstanceof(nestedNested, class$com$metamatrix$metamodels$core$ModelImport == null ? CompareUtil.class$("com.metamatrix.metamodels.core.ModelImport") : class$com$metamatrix$metamodels$core$ModelImport) || (desc = CompareUtil.getDifferenceDescriptor(nestedMapping)) == null || !desc.isDeletion()) continue;
                desc.setSkip(true);
            }
        }
    }

    public static void print(DifferenceReport report, PrintStream stream) {
        CompareUtil.print(report, stream, false);
    }

    public static void print(DifferenceReport report, PrintStream stream, boolean showSkips) {
        ArgCheck.isNotNull((Object)report);
        ArgCheck.isNotNull((Object)stream);
        stream.println("");
        if (report.getTitle() != null && report.getTitle().trim().length() != 0) {
            stream.println("DifferenceReport: " + report.getTitle());
        } else {
            stream.println("DifferenceReport");
        }
        CompareUtil.printMapping(report.getMapping(), "   ", stream, showSkips);
    }

    protected static void printMapping(Mapping mapping, String prefix, PrintStream stream, boolean showSkips) {
        Iterator iter;
        String msg = prefix;
        ArrayList<String> submsgs = null;
        EList inputs = mapping.getInputs();
        EList outputs = mapping.getOutputs();
        if (mapping.getNestedIn() == null) {
            msg = msg + " Difference Report Root Mapping";
        } else if (inputs.size() == 1 || outputs.size() == 1) {
            EObject input;
            EObject output = outputs.isEmpty() ? null : (EObject)outputs.get(0);
            EObject eObject = input = inputs.isEmpty() ? null : (EObject)inputs.get(0);
            if (output != null) {
                msg = msg + ModelerCore.getModelEditor().getModelRelativePath(output);
            } else if (input != null) {
                msg = msg + ModelerCore.getModelEditor().getModelRelativePath(input);
            }
            MappingHelper helper = mapping.getHelper();
            if (helper != null && helper instanceof DifferenceDescriptor) {
                DifferenceDescriptor desc = (DifferenceDescriptor)helper;
                if (showSkips || !desc.isSkip()) {
                    DifferenceType type = desc.getType();
                    if (type.getValue() == 1) {
                        msg = msg + " (Added)";
                    } else if (type.getValue() == 2) {
                        msg = msg + " (Deleted)";
                    } else if (type.getValue() == 3) {
                        msg = msg + " (Changed)";
                        submsgs = new ArrayList<String>(desc.getPropertyDifferences().size());
                        Iterator iter2 = desc.getPropertyDifferences().iterator();
                        while (iter2.hasNext()) {
                            PropertyDifference propDiff = (PropertyDifference)iter2.next();
                            if (!showSkips && propDiff.isSkip()) continue;
                            String featureName = propDiff.getAffectedFeature().getName();
                            if (propDiff.isSkip()) {
                                featureName = featureName + " [skip]";
                            }
                            submsgs.add(featureName + " changed from " + propDiff.getOldValue());
                            String slot = CompareUtil.getString(' ', featureName.length());
                            submsgs.add(slot + "           to " + propDiff.getNewValue());
                        }
                    }
                    if (desc.isSkip()) {
                        msg = msg + " [skip]";
                    }
                }
            }
        }
        stream.println(msg);
        if (submsgs != null) {
            iter = submsgs.iterator();
            while (iter.hasNext()) {
                String submsg = (String)iter.next();
                stream.println(prefix + "    (" + submsg + ")");
            }
        }
        iter = mapping.getNested().iterator();
        while (iter.hasNext()) {
            Mapping nested = (Mapping)iter.next();
            CompareUtil.printMapping(nested, "  " + prefix, stream, showSkips);
        }
    }

    protected static String getString(char c, int length) {
        StringBuffer sb = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

