/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.processor;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.compare.DifferenceDescriptor;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.DifferenceType;
import com.metamatrix.modeler.compare.MergeProcessor;
import com.metamatrix.modeler.compare.ModelerComparePlugin;
import com.metamatrix.modeler.compare.PropertyDifference;
import com.metamatrix.modeler.compare.processor.DifferenceProcessorImpl;
import com.metamatrix.modeler.compare.selector.ModelSelector;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.util.ModelVisitorWithFinish;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;

public class MergeProcessorImpl
implements MergeProcessor {
    private static final String PLUGINID = "com.metamatrix.modeler.compare";
    protected static final int PROCESSOR_ALREADY_CLOSED = 60001;
    protected static final int NO_PROBLEMS = 60002;
    protected static final int HAS_WARNINGS = 60003;
    protected static final int HAS_ERRORS = 60004;
    protected static final int HAS_WARNINGS_AND_ERRORS = 60005;
    protected static final int NO_WARNINGS_AND_ERRORS = 60006;
    protected static final int ERROR_PLANNING_MERGE = 60010;
    protected static final int ERROR_MERGING_ADDS_AND_DELETES = 60011;
    protected static final int ERROR_MERGING_CHANGES = 60012;
    protected static final int ERROR_RESOLVING_REFERENCES = 60013;
    protected static final int AMOUNT_OF_WORK_FOR_PLANNING = 200;
    protected static final int AMOUNT_OF_WORK_FOR_MERGING_ADDS_AND_DELETES = 10000;
    protected static final int AMOUNT_OF_WORK_FOR_MERGING_CHANGES = 10000;
    protected static final int AMOUNT_OF_WORK_FOR_REFERENCE_RESOLUTION = 300;
    protected static final int AMOUNT_OF_WORK_FOR_CREATING_RESULTS = 100;
    public static final boolean DEFAULT_ADDS_MOVED_FROM_STARTING_INTO_ENDING = false;
    private final DifferenceReport differenceReport;
    private final ModelSelector sourceModelSelector;
    private IProgressMonitor monitor;
    private List problems;
    private WorkInfo workInfo;
    private ModelEditor editor;
    private Map resultObjectToSourceObject;
    private final List newRoots;
    private boolean computeTasks;
    private boolean closed;
    private final boolean moveAddedObjectsFromStartingSelector;

    public MergeProcessorImpl(DifferenceReport differenceReport, ModelSelector startingModelSelector, ModelSelector endingModelSelector, EObject[] externalReferences, boolean moveAddsRatherThanCopy) {
        ArgCheck.isNotNull((Object)differenceReport);
        ArgCheck.isNotNull((Object)startingModelSelector);
        ArgCheck.isNotNull((Object)endingModelSelector);
        this.differenceReport = differenceReport;
        this.sourceModelSelector = startingModelSelector;
        this.resultObjectToSourceObject = new HashMap();
        this.newRoots = new LinkedList();
        this.initializeResultToSourceMap(externalReferences);
        this.moveAddedObjectsFromStartingSelector = moveAddsRatherThanCopy;
    }

    public MergeProcessorImpl(DifferenceReport differenceReport, ModelSelector startingModelSelector, ModelSelector endingModelSelector, EObject[] externalReferences) {
        this(differenceReport, startingModelSelector, endingModelSelector, externalReferences, false);
    }

    public MergeProcessorImpl(DifferenceReport differenceReport, ModelSelector startingModelSelector, ModelSelector endingModelSelector) {
        this(differenceReport, startingModelSelector, endingModelSelector, null);
    }

    public MergeProcessorImpl(DifferenceProcessorImpl differenceProcessor, EObject[] externalReferences) {
        this(differenceProcessor.getDifferenceReport(), differenceProcessor.getBeforeSelector(), differenceProcessor.getAfterSelector(), externalReferences);
    }

    public MergeProcessorImpl(DifferenceProcessorImpl differenceProcessor, EObject[] externalReferences, boolean moveAddsRatherThanCopy) {
        this(differenceProcessor.getDifferenceReport(), differenceProcessor.getBeforeSelector(), differenceProcessor.getAfterSelector(), externalReferences, moveAddsRatherThanCopy);
    }

    public MergeProcessorImpl(DifferenceProcessorImpl differenceProcessor) {
        this(differenceProcessor.getDifferenceReport(), differenceProcessor.getBeforeSelector(), differenceProcessor.getAfterSelector());
    }

    private void initializeResultToSourceMap(EObject[] externalReferences) {
        if (externalReferences != null && externalReferences.length > 0) {
            for (int i = 0; i != externalReferences.length; ++i) {
                EObject obj = externalReferences[i];
                this.resultObjectToSourceObject.put(obj, obj);
            }
        }
    }

    public void setEndingToSourceMapping(Map mapping) {
        this.resultObjectToSourceObject = mapping != null ? mapping : new HashMap();
    }

    public boolean isMoveAddedObjectsFromStartingSelector() {
        return this.moveAddedObjectsFromStartingSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus execute(IProgressMonitor progressMonitor) {
        if (this.closed) {
            int code = 60001;
            String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.The_processor_has_already_been_closed");
            Status status = new Status(4, PLUGINID, 60001, msg, null);
            return status;
        }
        if (progressMonitor != null) {
            this.computeTasks = true;
            this.monitor = progressMonitor;
        } else {
            this.computeTasks = false;
            this.monitor = new NullProgressMonitor();
        }
        String taskName = this.doGetTaskName();
        int totalWork = this.doComputeTotalWork();
        this.monitor.beginTask(taskName, totalWork);
        Object[] paramsExec = new Object[]{this.sourceModelSelector.getLabel()};
        String execSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Performing_merge", paramsExec);
        this.monitor.subTask(execSubTask);
        this.newRoots.clear();
        this.editor = ModelerCore.getModelEditor();
        this.problems = new LinkedList();
        this.doExecute();
        IStatus resultStatus = null;
        try {
            String analysisSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Analyzing_problems");
            this.monitor.subTask(analysisSubTask);
            if (this.problems.isEmpty()) {
                String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_completed");
                Status status = new Status(0, PLUGINID, 60002, msg, null);
                resultStatus = status;
            } else if (this.problems.size() == 1) {
                resultStatus = (IStatus)this.problems.get(0);
            } else {
                int numErrors = 0;
                int numWarnings = 0;
                Iterator iter = this.problems.iterator();
                while (iter.hasNext()) {
                    IStatus aStatus = (IStatus)iter.next();
                    if (aStatus.getSeverity() == 2) {
                        ++numWarnings;
                        continue;
                    }
                    if (aStatus.getSeverity() != 4) continue;
                    ++numErrors;
                }
                IStatus[] statusArray = this.problems.toArray(new IStatus[this.problems.size()]);
                if (numWarnings != 0 && numErrors == 0) {
                    Object[] params = new Object[]{new Integer(numWarnings)};
                    String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_resulted_in_warnings", params);
                    resultStatus = new MultiStatus(PLUGINID, 60003, statusArray, msg, null);
                } else if (numWarnings == 0 && numErrors != 0) {
                    Object[] params = new Object[]{new Integer(numErrors)};
                    String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_resulted_in_errors", params);
                    resultStatus = new MultiStatus(PLUGINID, 60004, statusArray, msg, null);
                } else if (numWarnings != 0 && numErrors != 0) {
                    Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                    String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_resulted_in_warnings_and_errors", params);
                    resultStatus = new MultiStatus(PLUGINID, 60005, statusArray, msg, null);
                } else {
                    String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_completed_with_no_warnings_or_errors");
                    resultStatus = new MultiStatus(PLUGINID, 60006, statusArray, msg, null);
                }
            }
        }
        finally {
            this.monitor.worked(100);
        }
        return resultStatus;
    }

    public void reresolve(IProgressMonitor monitor) {
        this.doReResolveAndRebuildImports();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.doClose();
        this.closed = true;
    }

    protected IStatus newWarning(int code, String msg, Throwable t) {
        return new Status(2, PLUGINID, code, msg, t);
    }

    protected IStatus newInfo(int code, String msg, Throwable t) {
        return new Status(1, PLUGINID, code, msg, t);
    }

    protected IStatus newError(int code, String msg, Throwable t) {
        return new Status(4, PLUGINID, code, msg, t);
    }

    protected IStatus newOk(int code, String msg, Throwable t) {
        return new Status(0, PLUGINID, code, msg, t);
    }

    protected void doClose() {
        this.problems = null;
        this.monitor = null;
        this.newRoots.clear();
        this.resultObjectToSourceObject.clear();
    }

    protected int doComputeTotalWork() {
        return 20600;
    }

    protected String doGetTaskName() {
        return ModelerComparePlugin.Util.getString("MergeProcessorImpl.taskName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        IStatus status;
        String msg;
        IStatus status2;
        String msg2;
        PlanningVisitor planningVisitor = new PlanningVisitor();
        try {
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)planningVisitor);
            processor.walk((EObject)this.differenceReport, 2);
        }
        catch (Throwable e) {
            String msg3 = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_planning_the_merge");
            IStatus status3 = this.newError(60010, msg3, e);
            this.problems.add(status3);
        }
        finally {
            this.monitor.worked(200);
        }
        int numMappings = planningVisitor.getMappingCount();
        this.workInfo = new WorkInfo(numMappings, 10000);
        AddAndDeleteVisitor addAndDeleteVisitor = new AddAndDeleteVisitor();
        try {
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)addAndDeleteVisitor);
            processor.walk((EObject)this.differenceReport, 2);
        }
        catch (Throwable e) {
            String msg4 = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_merging_adds_and_deletes");
            IStatus status4 = this.newError(60011, msg4, e);
            this.problems.add(status4);
        }
        finally {
            this.monitor.worked(this.workInfo.workRemaining);
        }
        ChangeVisitor changeVisitor = new ChangeVisitor();
        try {
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)changeVisitor);
            processor.walk((EObject)this.differenceReport, 2);
        }
        catch (Throwable e) {
            msg2 = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_merging_changes");
            status2 = this.newError(60012, msg2, e);
            this.problems.add(status2);
        }
        finally {
            this.monitor.worked(this.workInfo.workRemaining);
        }
        if (this.newRoots != null && !this.newRoots.isEmpty()) {
            try {
                int indexOfLastMappedRoot = -1;
                int index = -1;
                Iterator iter = this.sourceModelSelector.getRootObjects().iterator();
                while (iter.hasNext()) {
                    Object root = iter.next();
                    ++index;
                    if (!this.resultObjectToSourceObject.containsValue(root)) continue;
                    indexOfLastMappedRoot = index;
                }
                this.sourceModelSelector.addRootObjects(this.newRoots, indexOfLastMappedRoot + 1);
            }
            catch (Throwable e) {
                msg2 = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_adding_new_root_objects");
                status2 = this.newError(60013, msg2, e);
                this.problems.add(status2);
            }
            finally {
                this.monitor.worked(300);
            }
        }
        ResolutionVisitor resolveVisitor = new ResolutionVisitor();
        try {
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)resolveVisitor);
            List sourceRoots = this.doGetSourceRoots();
            processor.walk((Collection)sourceRoots, 2);
        }
        catch (Throwable e) {
            msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_resolving_references");
            status = this.newError(60013, msg, e);
            this.problems.add(status);
        }
        finally {
            this.monitor.worked(300);
        }
        try {
            this.sourceModelSelector.rebuildModelImports();
        }
        catch (Throwable e) {
            msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_rebuilding_imports");
            status = this.newError(60013, msg, e);
            this.problems.add(status);
        }
        finally {
            this.monitor.worked(300);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReResolveAndRebuildImports() {
        IStatus status;
        String msg;
        ResolutionVisitor resolveVisitor = new ResolutionVisitor();
        try {
            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)resolveVisitor);
            List sourceRoots = this.doGetSourceRoots();
            processor.walk((Collection)sourceRoots, 2);
        }
        catch (Throwable e) {
            msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_resolving_references");
            status = this.newError(60013, msg, e);
            this.problems.add(status);
        }
        finally {
            this.monitor.worked(300);
        }
        try {
            this.sourceModelSelector.rebuildModelImports();
        }
        catch (Throwable e) {
            msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_rebuilding_imports");
            status = this.newError(60013, msg, e);
            this.problems.add(status);
        }
        finally {
            this.monitor.worked(300);
        }
    }

    protected List doGetSourceRoots() throws ModelerCoreException {
        LinkedList roots = new LinkedList(this.sourceModelSelector.getRootObjects());
        Iterator iter = this.newRoots.iterator();
        while (iter.hasNext()) {
            Object newRoot = iter.next();
            if (roots.contains(newRoot)) continue;
            roots.add(newRoot);
        }
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doProcess(Mapping mapping, boolean adds, boolean changes, boolean deletes) throws ModelerCoreException {
        try {
            MappingHelper helper = mapping.getHelper();
            if (helper == null) return;
            if (!(helper instanceof DifferenceDescriptor)) return;
            DifferenceDescriptor diffDesc = (DifferenceDescriptor)helper;
            boolean skip = diffDesc.isSkip();
            if (skip) return;
            DifferenceType type = diffDesc.getType();
            int typeValue = type.getValue();
            switch (typeValue) {
                case 1: {
                    if (!adds) return;
                    this.doAdd(mapping, diffDesc);
                    return;
                }
                case 3: {
                    if (!changes) return;
                    this.doChange(mapping, diffDesc);
                    return;
                }
                case 2: {
                    if (!deletes) return;
                    this.doDelete(mapping, diffDesc);
                    return;
                }
            }
            return;
        }
        finally {
            this.monitor.worked(this.workInfo.workPerMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPostProcess(Mapping mapping) throws ModelerCoreException {
        try {
            MappingHelper helper = mapping.getHelper();
            if (helper == null) return;
            if (!(helper instanceof DifferenceDescriptor)) return;
            DifferenceDescriptor diffDesc = (DifferenceDescriptor)helper;
            boolean skip = diffDesc.isSkip() || mapping.getNestedIn() == null;
            if (skip) return;
            DifferenceType type = diffDesc.getType();
            int typeValue = type.getValue();
            switch (typeValue) {
                case 0: 
                case 3: 
                case 4: {
                    this.doOrderContained(mapping, diffDesc);
                    return;
                }
            }
            return;
        }
        finally {
            this.monitor.worked(this.workInfo.workPerMapping);
        }
    }

    protected String computeSubtaskPath(EObject object) {
        return this.editor.getModelRelativePath(object).toString();
    }

    protected void doAdd(Mapping mapping, DifferenceDescriptor diffDesc) throws ModelerCoreException {
        EList outputs = mapping.getOutputs();
        EObject newObject = (EObject)outputs.get(0);
        if (this.computeTasks) {
            String path = this.computeSubtaskPath(newObject);
            Object[] params = new Object[]{path};
            String loadingSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.AddingSubTask", params);
            this.monitor.subTask(loadingSubTask);
        }
        EObject copy = this.moveAddedObjectsFromStartingSelector ? newObject : this.editor.copy(newObject, this.resultObjectToSourceObject);
        EReference feature = newObject.eContainmentFeature();
        if (feature == null) {
            if (this.moveAddedObjectsFromStartingSelector) {
                newObject.eResource().getContents().remove((Object)copy);
            }
            this.newRoots.add(copy);
        } else {
            EObject parent = (EObject)this.resultObjectToSourceObject.get(newObject.eContainer());
            if (feature.isMany()) {
                List values = (List)parent.eGet(feature);
                values.add(copy);
            } else {
                parent.eSet(feature, copy);
            }
        }
    }

    protected void doChange(Mapping mapping, DifferenceDescriptor diffDesc) throws ModelerCoreException {
        EList inputs = mapping.getInputs();
        EObject oldObject = (EObject)inputs.get(0);
        if (this.computeTasks) {
            String path = this.computeSubtaskPath(oldObject);
            Object[] params = new Object[]{path};
            String loadingSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.ChangingSubTask", params);
            this.monitor.subTask(loadingSubTask);
        }
        EList propDiffs = diffDesc.getPropertyDifferences();
        Iterator iter = propDiffs.iterator();
        while (iter.hasNext()) {
            PropertyDifference propDiff = (PropertyDifference)iter.next();
            if (propDiff.isSkip()) continue;
            EStructuralFeature feature = propDiff.getAffectedFeature();
            Object newValue = propDiff.getNewValue();
            Object oldValue = propDiff.getOldValue();
            if (feature.isMany()) {
                EList newValues = (EList)newValue;
                EList oldValues = (EList)oldValue;
                List newValuesInSource = this.convertFromResultsToSource(newValues);
                ECollections.setEList((EList)oldValues, (List)newValuesInSource);
                continue;
            }
            if (newValue instanceof EObject) {
                EObject newValueInSource = (EObject)this.resultObjectToSourceObject.get(newValue);
                if (newValueInSource == null) {
                    oldObject.eSet(feature, newValue);
                    continue;
                }
                oldObject.eSet(feature, newValueInSource);
                continue;
            }
            oldObject.eSet(feature, newValue);
        }
    }

    protected List convertFromResultsToSource(EList newValues) {
        ArrayList<EObject> result = new ArrayList<EObject>(newValues.size());
        Iterator iter = newValues.iterator();
        while (iter.hasNext()) {
            EObject newValue = (EObject)iter.next();
            EObject newValueInSource = (EObject)this.resultObjectToSourceObject.get(newValue);
            if (newValueInSource != null) {
                result.add(newValueInSource);
                continue;
            }
            result.add(newValue);
        }
        return result;
    }

    protected void doDelete(Mapping mapping, DifferenceDescriptor diffDesc) throws ModelerCoreException {
        EList inputs = mapping.getInputs();
        EObject deletedObject = (EObject)inputs.get(0);
        if (this.computeTasks) {
            String path = this.computeSubtaskPath(deletedObject);
            Object[] params = new Object[]{path};
            String loadingSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.RemovingSubTask", params);
            this.monitor.subTask(loadingSubTask);
        }
        this.editor.delete(deletedObject);
    }

    protected void doResolve(EObject sourceObject) throws ModelerCoreException {
        EClass metaclass = sourceObject.eClass();
        EList features = metaclass.getEAllReferences();
        Iterator iter = features.iterator();
        while (iter.hasNext()) {
            EReference ref = (EReference)iter.next();
            if (ref.isVolatile()) continue;
            if (ref.isMany()) {
                List values = (List)sourceObject.eGet(ref);
                if (values.size() == 0) continue;
                ArrayList<Object> newValues = new ArrayList<Object>(values.size());
                boolean foundNewValue = false;
                for (int i = 0; i != values.size(); ++i) {
                    Object value = values.get(i);
                    Object sourceValue = this.resultObjectToSourceObject.get(value);
                    if (sourceValue != null) {
                        if (newValues.contains(sourceValue)) continue;
                        newValues.add(sourceValue);
                        foundNewValue = true;
                        continue;
                    }
                    if (newValues.contains(value)) continue;
                    newValues.add(value);
                }
                if (!foundNewValue) continue;
                values.clear();
                values.addAll(newValues);
                continue;
            }
            Object value = sourceObject.eGet(ref);
            Object sourceValue = this.resultObjectToSourceObject.get(value);
            if (sourceValue == null) continue;
            sourceObject.eSet(ref, sourceValue);
        }
    }

    protected void recordMapping(Object source, Object result) {
        this.resultObjectToSourceObject.put(result, source);
    }

    protected void doOrderContained(Mapping mapping, DifferenceDescriptor diffDesc) throws ModelerCoreException {
        EList inputs = mapping.getInputs();
        EList outputs = mapping.getOutputs();
        if (inputs.isEmpty() || outputs.isEmpty()) {
            return;
        }
        EObject sourceObject = (EObject)inputs.get(0);
        EObject resultObject = (EObject)outputs.get(0);
        EClass sourceMetaclass = sourceObject.eClass();
        Iterator iter = sourceMetaclass.getEAllContainments().iterator();
        while (iter.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)iter.next();
            if (!feature.isMany()) continue;
            List resultsValues = (List)resultObject.eGet(feature);
            ArrayList<Object> sourceValuesFromResults = new ArrayList<Object>();
            Iterator resultValuesIter = resultsValues.iterator();
            while (resultValuesIter.hasNext()) {
                EObject resultValue = (EObject)resultValuesIter.next();
                Object sourceValue = this.resultObjectToSourceObject.get(resultValue);
                if (sourceValue == null || sourceValuesFromResults.contains(sourceValue)) continue;
                sourceValuesFromResults.add(sourceValue);
            }
            EList sourceValues = (EList)sourceObject.eGet(feature);
            Iterator sourceValueIter = sourceValues.iterator();
            while (sourceValueIter.hasNext()) {
                Object obj = sourceValueIter.next();
                if (sourceValuesFromResults.contains(obj)) continue;
                sourceValuesFromResults.add(obj);
            }
            ECollections.setEList((EList)sourceValues, sourceValuesFromResults);
        }
    }

    protected class WorkInfo {
        protected final int numMappings;
        protected final int workPerMapping;
        protected final int workRemaining;

        protected WorkInfo(int numMappings, int workForMerging) {
            this.numMappings = numMappings;
            if (numMappings > 0) {
                this.workPerMapping = numMappings <= workForMerging ? workForMerging / numMappings : 0;
                this.workRemaining = workForMerging - this.workPerMapping * numMappings;
            } else {
                this.workPerMapping = 0;
                this.workRemaining = workForMerging;
            }
        }
    }

    protected class ResolutionVisitor
    implements ModelVisitor {
        protected ResolutionVisitor() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            MergeProcessorImpl.this.doResolve(object);
            return true;
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return true;
        }
    }

    protected class ChangeVisitor
    implements ModelVisitor {
        protected ChangeVisitor() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            if (object instanceof Mapping) {
                MergeProcessorImpl.this.doProcess((Mapping)object, false, true, false);
                return true;
            }
            return true;
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return true;
        }
    }

    protected class AddAndDeleteVisitor
    implements ModelVisitorWithFinish {
        protected AddAndDeleteVisitor() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            if (object instanceof Mapping) {
                MergeProcessorImpl.this.doProcess((Mapping)object, true, false, true);
                return true;
            }
            return true;
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return true;
        }

        public void postVisit(EObject object) throws ModelerCoreException {
            if (object instanceof Mapping) {
                MergeProcessorImpl.this.doPostProcess((Mapping)object);
            }
        }
    }

    protected class PlanningVisitor
    implements ModelVisitor {
        int numMappings = 0;

        protected PlanningVisitor() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            if (object instanceof Mapping) {
                MappingHelper helper;
                ++this.numMappings;
                Mapping mapping = (Mapping)object;
                if (mapping.getNestedIn() != null && (helper = mapping.getHelper()) != null && helper instanceof DifferenceDescriptor) {
                    EList inputs = mapping.getInputs();
                    EList outputs = mapping.getOutputs();
                    if (inputs.size() == 1 && outputs.size() == 1) {
                        Object source = inputs.get(0);
                        Object result = outputs.get(0);
                        MergeProcessorImpl.this.recordMapping(source, result);
                    }
                }
            }
            return true;
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return true;
        }

        public int getMappingCount() {
            return this.numMappings;
        }
    }
}

