/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.generator;

import com.metamatrix.core.UserCancelledException;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.ModelGenerator;
import com.metamatrix.modeler.compare.ModelerComparePlugin;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public abstract class AbstractModelGenerator
implements ModelGenerator {
    private final List matcherFactories;
    private String description;
    private final List differenceReports = new LinkedList();
    private Map producedToOutputMapping;

    public AbstractModelGenerator(List matcherFactories) {
        this.matcherFactories = matcherFactories != null ? matcherFactories : Collections.EMPTY_LIST;
        this.producedToOutputMapping = new HashMap();
    }

    public void setProducedToOutputMapping(Map mapping) {
        this.producedToOutputMapping = mapping != null ? mapping : new HashMap();
    }

    public Map getProducedToOutputMapping() {
        return this.producedToOutputMapping;
    }

    public String getDescription() {
        if (this.description != null && this.description.trim().length() != 0) {
            return this.description;
        }
        String desc = this.getDefaultDescription();
        if (desc != null && desc.trim().length() != 0) {
            return desc;
        }
        return "the operation";
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus execute(IProgressMonitor progressMonitor) {
        LinkedList<IStatus> problems = new LinkedList<IStatus>();
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        IStatus diffStatus = null;
        try {
            this.doClearDifferenceReports();
            this.doGenerateOutput(monitor, problems);
            diffStatus = this.createStatus(problems);
        }
        catch (UserCancelledException e) {
            diffStatus = this.newUserCancelledStatus();
        }
        if (diffStatus.getSeverity() == 4) {
            return diffStatus;
        }
        problems.add(diffStatus);
        try {
            this.doComputeDifferenceReport(monitor, problems);
            if (this.differenceReports.size() != 0) {
                this.doPostProcessDifferenceReports();
            }
            diffStatus = this.createStatus(problems);
        }
        catch (UserCancelledException e) {
            diffStatus = this.newUserCancelledStatus();
        }
        if (diffStatus.getSeverity() == 4) {
            return diffStatus;
        }
        problems.add(diffStatus);
        try {
            this.doMergeOutputIntoOriginal(monitor, problems);
            this.doPostMerge();
        }
        catch (UserCancelledException e1) {
            IStatus mergeStatus = this.newUserCancelledStatus();
            problems.addFirst(mergeStatus);
        }
        finally {
            try {
                monitor.done();
            }
            catch (RuntimeException e) {
                ModelerComparePlugin.Util.log((Throwable)e);
            }
        }
        return this.createStatus(problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus generateOutput(IProgressMonitor progressMonitor) {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        LinkedList<IStatus> problems = new LinkedList<IStatus>();
        try {
            this.doClearDifferenceReports();
            this.doGenerateOutput(monitor, problems);
        }
        catch (UserCancelledException e) {
            IStatus status = this.newUserCancelledStatus();
            problems.addFirst(status);
        }
        finally {
            try {
                monitor.done();
            }
            catch (RuntimeException e) {
                ModelerComparePlugin.Util.log((Throwable)e);
            }
        }
        return this.createStatus(problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus computeDifferenceReport(IProgressMonitor progressMonitor) {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        LinkedList<IStatus> problems = new LinkedList<IStatus>();
        try {
            this.doComputeDifferenceReport(monitor, problems);
            if (this.differenceReports.size() != 0) {
                this.doPostProcessDifferenceReports();
            }
        }
        catch (UserCancelledException e) {
            IStatus status = this.newUserCancelledStatus();
            problems.addFirst(status);
        }
        finally {
            try {
                monitor.done();
            }
            catch (RuntimeException e) {
                ModelerComparePlugin.Util.log((Throwable)e);
            }
        }
        return this.createStatus(problems);
    }

    public List getAllDifferenceReports() {
        return this.differenceReports;
    }

    public List getDifferenceReports() {
        return this.getAllDifferenceReports();
    }

    protected void addDifferenceReport(DifferenceReport report) {
        this.differenceReports.add(report);
    }

    public List getEObjectMatcherFactories() {
        return this.matcherFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus mergeOutputIntoOriginal(IProgressMonitor progressMonitor) {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        LinkedList<IStatus> problems = new LinkedList<IStatus>();
        try {
            this.doMergeOutputIntoOriginal(monitor, problems);
            this.doPostMerge();
        }
        catch (UserCancelledException e1) {
            IStatus mergeStatus = this.newUserCancelledStatus();
            problems.addFirst(mergeStatus);
        }
        finally {
            try {
                monitor.done();
            }
            catch (RuntimeException e) {
                ModelerComparePlugin.Util.log((Throwable)e);
            }
        }
        return this.createStatus(problems);
    }

    public void close() {
    }

    protected void doClearDifferenceReports() {
        this.getAllDifferenceReports().clear();
        this.producedToOutputMapping.clear();
    }

    protected abstract void doGenerateOutput(IProgressMonitor var1, LinkedList var2) throws UserCancelledException;

    protected abstract void doComputeDifferenceReport(IProgressMonitor var1, LinkedList var2) throws UserCancelledException;

    protected abstract void doPostProcessDifferenceReports();

    protected void doPostMerge() {
    }

    protected abstract void doReresolveAndRebuildImports();

    protected abstract void doMergeOutputIntoOriginal(IProgressMonitor var1, LinkedList var2) throws UserCancelledException;

    protected String getDefaultDescription() {
        return ModelerComparePlugin.Util.getString("AbstractModelGenerator.Default_description");
    }

    protected IStatus newUserCancelledStatus() {
        Object[] params = new Object[]{this.getDescription()};
        String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.User_cancelled_operation", params);
        String pluginId = "com.metamatrix.modeler.compare";
        int code = 58003;
        Status status = new Status(2, "com.metamatrix.modeler.compare", 58003, msg, null);
        return status;
    }

    protected IStatus newSuccessStatus() {
        Object[] params = new Object[]{this.getDescription()};
        String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Success_msg", params);
        String pluginId = "com.metamatrix.modeler.compare";
        int code = 58003;
        Status status = new Status(2, "com.metamatrix.modeler.compare", 58003, msg, null);
        return status;
    }

    protected IStatus createStatus(List problems) {
        IStatus resultStatus = null;
        String pluginId = "com.metamatrix.modeler.compare";
        if (problems == null || problems.isEmpty()) {
            Object[] params = new Object[]{this.getDescription()};
            String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation", params);
            Status status = new Status(0, "com.metamatrix.modeler.compare", 58004, msg, null);
            resultStatus = status;
        } else if (problems.size() == 1) {
            resultStatus = (IStatus)problems.get(0);
        } else {
            int numErrors = 0;
            int numWarnings = 0;
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                IStatus aStatus = (IStatus)iter.next();
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                Object[] params = new Object[]{this.getDescription(), new Integer(numWarnings)};
                String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation_with_warning(s)", params);
                resultStatus = new MultiStatus("com.metamatrix.modeler.compare", 58005, statusArray, msg, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                Object[] params = new Object[]{this.getDescription(), new Integer(numErrors)};
                String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation_with_error(s)", params);
                resultStatus = new MultiStatus("com.metamatrix.modeler.compare", 58006, statusArray, msg, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                Object[] params = new Object[]{this.getDescription(), new Integer(numErrors), new Integer(numWarnings)};
                String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation_with_error(s)_and_warning(s)", params);
                resultStatus = new MultiStatus("com.metamatrix.modeler.compare", 58007, statusArray, msg, null);
            } else {
                Object[] params = new Object[]{this.getDescription()};
                String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation_with_no_errors_or_warnings", params);
                resultStatus = new MultiStatus("com.metamatrix.modeler.compare", 58008, statusArray, msg, null);
            }
        }
        return resultStatus;
    }
}

