/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xsd.aspects.validation.rules;

import com.metamatrix.metamodels.xsd.XsdPlugin;
import com.metamatrix.modeler.core.validation.StructuralFeatureValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDConstants;

public class BaseTypeRule
implements StructuralFeatureValidationRule {
    private int featureID;

    public BaseTypeRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (eObject == null || !(eObject instanceof XSDSimpleTypeDefinition)) {
            return;
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        if (value == null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, XsdPlugin.Util.getString("BaseTypeRule.The_basetype_may_not_be_null_1"));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        if (!(value instanceof XSDSimpleTypeDefinition)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, XsdPlugin.Util.getString("BaseTypeRule.The_basetype_must_be_a_simple_type_definition_2"));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        if (eObject == value) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, XsdPlugin.Util.getString("BaseTypeRule.The_datatype_cannot_have_itself_as_its_basetype_1"));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        XSDSimpleTypeDefinition datatype = (XSDSimpleTypeDefinition)eObject;
        if (this.hasCircularDependency(datatype)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, XsdPlugin.Util.getString("BaseTypeRule.Cannot_have_a_circular_dependency_in_the_datatype_hierarchy_2"));
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        context.addResult((ValidationResult)result);
    }

    private boolean hasCircularDependency(XSDSimpleTypeDefinition datatype) {
        XSDSimpleTypeDefinition baseTypeDefn;
        if (datatype == null) {
            return false;
        }
        ArrayList<BaseTypeRule> typesInHierarchy = new ArrayList<BaseTypeRule>();
        typesInHierarchy.add(this);
        if (baseTypeDefn == this) {
            return true;
        }
        for (baseTypeDefn = datatype.getBaseTypeDefinition(); baseTypeDefn != null && baseTypeDefn.getName() != null; baseTypeDefn = baseTypeDefn.getBaseTypeDefinition()) {
            if (XSDConstants.isURType((XSDTypeDefinition)baseTypeDefn)) {
                return false;
            }
            if (typesInHierarchy.contains(baseTypeDefn)) {
                return true;
            }
            typesInHierarchy.add((BaseTypeRule)baseTypeDefn);
        }
        return false;
    }
}

