/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xsd;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.relational.AccessPattern;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.DirectionKind;
import com.metamatrix.metamodels.relational.NullableType;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.ProcedureResult;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.xsd.XsdBuilderOptions;
import com.metamatrix.metamodels.xsd.XsdPlugin;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.core.workspace.ModelResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;

public class XsdSchemaBuilderImpl {
    private static final String TYPE_SUFFIX = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.type");
    private static final String ROOT_SUFFIX = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.rootSuffix");
    private static final String INPUT_SUFFIX = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.inputSuffix");
    private static final String OUTPUT_SUFFIX = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.outputSuffix");
    private static final String XSD_EXTENSION = ".xsd";
    private static final String MM_URI = "http://www.metamatrix.com/";
    public static boolean headless = false;
    private final XsdBuilderOptions ops;
    private final StringNameValidator nameValidator = new StringNameValidator();
    private final Collection addedNamespaces = new HashSet();
    private final Collection includedSchemas = new HashSet();
    private MultiStatus result;
    private XSDSchema reusableSchema;
    private Collection rootElements;
    private Collection rootElementNames;
    private Collection inputRootElements;
    private Collection inputRootElementNames;
    private HashMap outputToInputMap;
    private HashMap tableToOutputMap;
    private boolean trackMappings = false;

    public XsdSchemaBuilderImpl(XsdBuilderOptions ops) {
        ArgCheck.isNotNull((Object)ops);
        ArgCheck.isNotNull((Object)ops.getRoots());
        this.ops = ops;
    }

    public static MultiStatus buildSchemas(XsdBuilderOptions ops, IProgressMonitor monitor) {
        XsdSchemaBuilderImpl builder = new XsdSchemaBuilderImpl(ops);
        return builder.buildSchemas(monitor, null);
    }

    public Collection getRootElements() {
        if (this.rootElements == null) {
            this.rootElements = new ArrayList();
        }
        return this.rootElements;
    }

    public Collection getInputRootElements() {
        if (this.inputRootElements == null) {
            this.inputRootElements = new ArrayList();
        }
        return this.inputRootElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatus buildSchemas(IProgressMonitor monitor, MultiStatus result) {
        this.result = result == null ? new MultiStatus("com.metamatrix.metamodels.xsd", 0, XsdPlugin.Util.getString("XsdSchemaBuilderImpl.result"), null) : result;
        this.rootElements = new ArrayList();
        this.rootElementNames = new ArrayList();
        this.inputRootElements = new ArrayList();
        this.inputRootElementNames = new ArrayList();
        this.outputToInputMap = new HashMap();
        this.tableToOutputMap = new HashMap();
        this.trackMappings = this.ops.genInput() && this.ops.genOutput();
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String txnDescr = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.genxsd");
        boolean startedTxn = ModelerCore.startTxn((boolean)true, (boolean)true, (String)txnDescr, (Object)this);
        ArrayList<Object> inputRoots = new ArrayList<Object>();
        try {
            Collection roots = this.ops.getRoots();
            monitor.beginTask(XsdPlugin.Util.getString("XsdSchemaBuilderImpl.creating", roots.size()), roots.size());
            if (roots == null || roots.isEmpty()) {
                String noRoots = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.noRoots");
                this.addStatus(4, noRoots, null);
            }
            this.validateRoots(roots);
            Iterator rootIt = roots.iterator();
            while (rootIt.hasNext()) {
                boolean doSave;
                RelationalEntity root = (RelationalEntity)rootIt.next();
                if (root instanceof ProcedureResult) {
                    Procedure proc = ((ProcedureResult)root).getProcedure();
                    if (this.hasInputParameter(proc)) {
                        inputRoots.add(proc);
                    }
                } else if (root instanceof BaseTable) {
                    BaseTable table = (BaseTable)root;
                    if (table.getPrimaryKey() != null) {
                        inputRoots.add(root);
                    } else if (!table.getAccessPatterns().isEmpty()) {
                        inputRoots.add(root);
                    }
                } else if (root instanceof Procedure && this.hasInputParameter((Procedure)root)) {
                    inputRoots.add(root);
                }
                boolean bl = doSave = !this.ops.genOutput() || !rootIt.hasNext();
                if (this.ops.genOutput()) {
                    this.doBuild(root, doSave, false);
                }
                monitor.worked(1);
            }
            if (this.ops.genInput()) {
                this.createInputXsd(inputRoots);
            }
            MultiStatus multiStatus = this.result;
            return multiStatus;
        }
        catch (Exception e) {
            String err = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.err1");
            this.addStatus(4, err, e);
            MultiStatus multiStatus = this.result;
            return multiStatus;
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
    }

    private boolean hasInputParameter(Procedure proc) {
        Iterator params = proc.getParameters().iterator();
        while (params.hasNext()) {
            ProcedureParameter param = (ProcedureParameter)params.next();
            DirectionKind dir = param.getDirection();
            if (!dir.equals(DirectionKind.IN_LITERAL) && !dir.equals(DirectionKind.INOUT_LITERAL)) continue;
            return true;
        }
        return false;
    }

    private void addStatus(int severity, String msg, Throwable ex) {
        this.result.add((IStatus)new Status(severity, this.result.getPlugin(), 0, msg, ex));
    }

    private void createInputXsd(Collection inputRoots) throws CoreException {
        if (inputRoots.isEmpty()) {
            return;
        }
        this.reusableSchema = null;
        Iterator rootIt = inputRoots.iterator();
        while (rootIt.hasNext()) {
            RelationalEntity root = (RelationalEntity)rootIt.next();
            this.doBuild(root, !rootIt.hasNext(), true);
        }
    }

    private void doBuild(RelationalEntity root, boolean doSave, boolean isInput) throws CoreException {
        String fileName;
        XSDFactory XSDFACTORY = XSDFactory.eINSTANCE;
        String parentLocation = this.ops.getParentPath();
        String rootName = root.getName();
        String uniqueName = null;
        uniqueName = isInput ? this.nameValidator.createValidUniqueName(rootName + INPUT_SUFFIX, this.inputRootElementNames) : this.nameValidator.createValidUniqueName(rootName + OUTPUT_SUFFIX, this.rootElementNames);
        if (uniqueName == null) {
            uniqueName = isInput ? rootName + INPUT_SUFFIX : rootName + OUTPUT_SUFFIX;
        }
        if (isInput) {
            rootName = this.ops.getInputModelName();
            fileName = parentLocation + File.separator + rootName;
        } else {
            rootName = this.ops.getOutputModelName();
            fileName = parentLocation + File.separator + rootName;
        }
        if (rootName.endsWith(XSD_EXTENSION)) {
            int index = rootName.lastIndexOf(XSD_EXTENSION);
            rootName = rootName.substring(0, index);
        }
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        File check = new File(fileName);
        if (this.reusableSchema == null && check.exists()) {
            String fileExists = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.nameExists", (Object)root.getName(), (Object)fileName);
            this.addStatus(4, fileExists, null);
            return;
        }
        IFile resource = wsroot.getFileForLocation((IPath)new Path(fileName));
        ModelResource modelResource = null;
        XSDResourceImpl rsrc = null;
        if (headless) {
            Container cntr = ModelerCore.getModelContainer();
            rsrc = (XSDResourceImpl)cntr.getOrCreateResource(URI.createFileURI((String)fileName));
        } else if (this.reusableSchema != null) {
            modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)resource);
            if (modelResource != null) {
                rsrc = (XSDResourceImpl)modelResource.getEmfResource();
            }
        } else {
            modelResource = ModelerCore.create((IFile)resource);
            if (modelResource != null) {
                this.addStatus(1, XsdPlugin.Util.getString("XsdSchemaBuilderImpl.newModel", (Object)resource.getName()), null);
                rsrc = (XSDResourceImpl)modelResource.getEmfResource();
            }
        }
        if (rsrc != null) {
            XSDSchema schema = null;
            if (this.reusableSchema != null) {
                schema = this.reusableSchema;
            } else {
                schema = XSDFACTORY.createXSDSchema();
                rsrc.getContents().add((Object)schema);
                Map map = schema.getQNamePrefixToNamespaceMap();
                String schemaForSchemaPrefixText = "xs";
                map.put(schemaForSchemaPrefixText, "http://www.w3.org/2001/XMLSchema");
                schema.setSchemaForSchemaQNamePrefix(schemaForSchemaPrefixText);
                this.includedSchemas.clear();
                this.addedNamespaces.clear();
                this.addedNamespaces.add("http://www.w3.org/2001/XMLSchema");
                String ns = MM_URI + rootName;
                schema.setTargetNamespace(ns);
                map.put(null, ns);
                this.reusableSchema = schema;
            }
            schema.setIncrementalUpdate(false);
            XSDElementDeclaration global = XSDFACTORY.createXSDElementDeclaration();
            if (isInput) {
                global.setName(uniqueName);
                schema.getContents().add((Object)global);
                this.inputRootElements.add(global);
                this.inputRootElementNames.add(uniqueName);
                XSDElementDeclaration outGlobal = (XSDElementDeclaration)this.tableToOutputMap.get(root);
                if (this.trackMappings && outGlobal != null) {
                    this.outputToInputMap.put(outGlobal, global);
                }
            } else {
                global.setName(uniqueName + ROOT_SUFFIX);
                XSDElementDeclaration wrapper = XSDFACTORY.createXSDElementDeclaration();
                wrapper.setName(uniqueName);
                schema.getContents().add((Object)wrapper);
                this.rootElements.add(wrapper);
                this.rootElementNames.add(wrapper.getName());
                if (this.trackMappings) {
                    if (root instanceof ProcedureResult) {
                        Procedure tmp = ((ProcedureResult)root).getProcedure();
                        this.tableToOutputMap.put(tmp, wrapper);
                    } else {
                        this.tableToOutputMap.put(root, wrapper);
                    }
                }
                XSDComplexTypeDefinition wrapperType = XSDFACTORY.createXSDComplexTypeDefinition();
                wrapper.setAnonymousTypeDefinition((XSDTypeDefinition)wrapperType);
                XSDModelGroup sequence = XSDFACTORY.createXSDModelGroup();
                sequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                XSDParticle particle = XSDFACTORY.createXSDParticle();
                particle.setContent((XSDParticleContent)sequence);
                wrapperType.setContent((XSDComplexTypeContent)particle);
                XSDParticle holder = XSDFACTORY.createXSDParticle();
                holder.setContent((XSDParticleContent)global);
                holder.setMaxOccurs(-1);
                holder.setMinOccurs(0);
                sequence.getContents().add((Object)holder);
            }
            XSDComplexTypeDefinition type = XSDFACTORY.createXSDComplexTypeDefinition();
            schema.getContents().add((Object)type);
            type.setName(uniqueName + TYPE_SUFFIX);
            global.setTypeDefinition((XSDTypeDefinition)type);
            XSDModelGroup sequence = XSDFACTORY.createXSDModelGroup();
            sequence.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
            XSDParticle particle = XSDFACTORY.createXSDParticle();
            particle.setContent((XSDParticleContent)sequence);
            type.setContent((XSDComplexTypeContent)particle);
            ArrayList<ProcedureParameter> inParams = new ArrayList<ProcedureParameter>();
            ArrayList atts = new ArrayList();
            if (root instanceof BaseTable) {
                BaseTable table = (BaseTable)root;
                if (isInput) {
                    PrimaryKey pk = table.getPrimaryKey();
                    if (pk != null) {
                        Iterator pkCols = pk.getColumns().iterator();
                        while (pkCols.hasNext()) {
                            Object nextCol = pkCols.next();
                            if (atts.contains(nextCol)) continue;
                            atts.add(nextCol);
                        }
                    }
                    Iterator accessPatterns = table.getAccessPatterns().iterator();
                    while (accessPatterns.hasNext()) {
                        AccessPattern ap = (AccessPattern)accessPatterns.next();
                        Iterator apCols = ap.getColumns().iterator();
                        while (apCols.hasNext()) {
                            Object nextCol = apCols.next();
                            if (atts.contains(nextCol)) continue;
                            atts.add(nextCol);
                        }
                    }
                } else {
                    atts = new ArrayList(table.getColumns());
                }
            } else if (root instanceof ProcedureResult) {
                ProcedureResult procResult = (ProcedureResult)root;
                if (this.result != null) {
                    atts = new ArrayList(procResult.getColumns());
                }
                Procedure p = procResult.getProcedure();
                Iterator params = p.getParameters().iterator();
                while (params.hasNext()) {
                    ProcedureParameter param = (ProcedureParameter)params.next();
                    DirectionKind dir = param.getDirection();
                    if (!dir.equals(DirectionKind.IN_LITERAL) && !dir.equals(DirectionKind.INOUT_LITERAL)) continue;
                    atts.add(param);
                }
            } else if (root instanceof Procedure) {
                Iterator params = ((Procedure)root).getParameters().iterator();
                while (params.hasNext()) {
                    ProcedureParameter param = (ProcedureParameter)params.next();
                    DirectionKind dir = param.getDirection();
                    if (isInput && dir.equals(DirectionKind.IN_LITERAL) || dir.equals(DirectionKind.INOUT_LITERAL)) {
                        atts.add(param);
                        continue;
                    }
                    if (isInput) continue;
                    if (dir.equals(DirectionKind.OUT_LITERAL) || dir.equals(DirectionKind.INOUT_LITERAL)) {
                        atts.add(param);
                        continue;
                    }
                    inParams.add(param);
                }
            } else {
                String msg = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.invalidRoot", (Object)root.getClass().getName());
                this.addStatus(4, msg, null);
            }
            atts.addAll(inParams);
            Iterator attsIterator = atts.iterator();
            while (attsIterator.hasNext()) {
                NullableType nullable;
                RelationalEntity att = (RelationalEntity)attsIterator.next();
                XSDElementDeclaration next = XSDFACTORY.createXSDElementDeclaration();
                next.setName(att.getName());
                XSDTypeDefinition attType = null;
                if (att instanceof Column) {
                    Column col = (Column)att;
                    attType = (XSDTypeDefinition)col.getType();
                    nullable = col.getNullable();
                    next.setNillable(NullableType.NULLABLE_LITERAL == nullable);
                } else {
                    ProcedureParameter param = (ProcedureParameter)att;
                    attType = (XSDTypeDefinition)param.getType();
                    nullable = param.getNullable();
                    next.setNillable(NullableType.NULLABLE_LITERAL == nullable);
                    String defaultVal = param.getDefaultValue();
                    if (defaultVal != null) {
                        next.setLexicalValue(defaultVal);
                        next.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                    }
                }
                this.addImportForType(schema, attType);
                next.setTypeDefinition(attType);
                XSDParticle part = XSDFACTORY.createXSDParticle();
                part.setContent((XSDParticleContent)next);
                sequence.getContents().add((Object)part);
            }
            schema.setIncrementalUpdate(true);
            try {
                if (modelResource != null && doSave) {
                    modelResource.save((IProgressMonitor)new NullProgressMonitor(), true);
                    modelResource.getEmfResource().setModified(false);
                }
            }
            catch (Exception e) {
                String saveError = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.errSave", (Object)fileName);
                this.addStatus(4, saveError, e);
            }
        }
    }

    private void addImportForType(XSDSchema target, XSDTypeDefinition type) {
        if (target == null || type == null || type.getSchema() == null) {
            return;
        }
        String ns = type.getTargetNamespace();
        try {
            if (this.addedNamespaces.contains(ns) || this.includedSchemas.contains(type.getSchema())) {
                return;
            }
            if (ns == null) {
                XSDInclude xsdInclude = XSDFactory.eINSTANCE.createXSDInclude();
                xsdInclude.setSchemaLocation(type.eResource().getURI().toFileString());
                target.getContents().add(0, (Object)xsdInclude);
                this.includedSchemas.add(type.getSchema());
            } else {
                XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
                xsdImport.setNamespace(ns);
                xsdImport.setSchemaLocation(ns);
                target.getContents().add(0, (Object)xsdImport);
                this.addedNamespaces.add(ns);
            }
        }
        catch (Exception err) {
            String msg = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.importErr", (Object)ns);
            this.addStatus(4, msg, err);
        }
    }

    private void validateRoots(Collection roots) {
        if (roots == null || roots.isEmpty()) {
            return;
        }
        Iterator rootIT = roots.iterator();
        while (rootIT.hasNext()) {
            Object next = rootIT.next();
            if (next instanceof BaseTable || next instanceof ProcedureResult || next instanceof Procedure) continue;
            String invalidRoot = XsdPlugin.Util.getString("XsdSchemaBuilderImpl.invalidRoot", (Object)next.getClass().getName());
            throw new MetaMatrixRuntimeException(invalidRoot);
        }
    }

    public HashMap getOutputToInputMappings() {
        if (this.outputToInputMap == null) {
            this.outputToInputMap = new HashMap();
        }
        return this.outputToInputMap;
    }
}

