/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xml.namespace;

import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlNamespace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NamespaceContext {
    private static final boolean URI_MATCHING_IS_CASE_SENSITIVE = true;
    private final List nsDeclarations;
    private final NamespaceContext inherited;
    private final XmlElement element;

    public NamespaceContext(XmlElement element, NamespaceContext inheritedNS) {
        this.element = element;
        this.inherited = inheritedNS;
        this.nsDeclarations = this.element.getDeclaredNamespaces();
    }

    public List getXmlNamespaces() {
        return this.nsDeclarations;
    }

    public NamespaceContext getInherited() {
        return this.inherited;
    }

    public XmlElement getXmlElement() {
        return this.element;
    }

    public List getAllXmlNamespaces() {
        LinkedList results = new LinkedList(this.nsDeclarations);
        if (this.inherited != null) {
            results.addAll(this.inherited.getAllXmlNamespaces());
        }
        return results;
    }

    public boolean addXmlNamespace(XmlNamespace ns) {
        if (ns != null) {
            Iterator iter = this.nsDeclarations.iterator();
            while (iter.hasNext()) {
                XmlNamespace existingNS = (XmlNamespace)iter.next();
                if (existingNS.getPrefix() != null && existingNS.getPrefix().equals(ns.getPrefix())) {
                    return false;
                }
                String existingUri = existingNS.getUri();
                if (existingUri.length() == 0 || !existingUri.equalsIgnoreCase(ns.getUri())) continue;
                return false;
            }
            return this.nsDeclarations.add(ns);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.element != null) {
            sb.append(this.element.getName());
        }
        sb.append(" (");
        boolean first = true;
        Iterator iter = this.nsDeclarations.iterator();
        while (iter.hasNext()) {
            XmlNamespace ns = (XmlNamespace)iter.next();
            if (!first) {
                sb.append(",");
            }
            sb.append(ns.getPrefix());
            sb.append(":");
            sb.append(ns.getUri());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public XmlNamespace getBestNamespace(String uri) {
        HashSet prefixesFound = new HashSet();
        return this.getBestNamespace(uri, prefixesFound);
    }

    protected XmlNamespace getBestNamespace(String uri, Set prefixesFound) {
        Iterator iter = this.nsDeclarations.iterator();
        while (iter.hasNext()) {
            XmlNamespace ns = (XmlNamespace)iter.next();
            boolean urisMatch = false;
            urisMatch = ns.getUri().equals(uri);
            if (urisMatch && !prefixesFound.contains(ns.getPrefix())) {
                return ns;
            }
            prefixesFound.add(ns.getPrefix());
        }
        if (this.inherited != null) {
            return this.inherited.getBestNamespace(uri, prefixesFound);
        }
        return null;
    }
}

