/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xml.aspects.validation.rules;

import com.metamatrix.metamodels.xml.XmlDocumentNode;
import com.metamatrix.metamodels.xml.XmlDocumentPlugin;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XmlDocumentNodeDatatypeRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        if (eObject == null || !(eObject instanceof XmlDocumentNode)) {
            return;
        }
        XSDComponent xsdComponent = ((XmlDocumentNode)eObject).getXsdComponent();
        if (xsdComponent == null) {
            return;
        }
        XSDTypeDefinition typeDefn = XsdUtil.getType(xsdComponent);
        if (typeDefn != null && typeDefn.eIsProxy() && (typeDefn = (XSDTypeDefinition)EcoreUtil.resolve((EObject)typeDefn, eObject.eResource().getResourceSet())) == null) {
            Object[] params = new Object[]{((XmlDocumentNode)eObject).getName(), ((InternalEObject)XsdUtil.getType(xsdComponent)).eProxyURI()};
            String msg = XmlDocumentPlugin.Util.getString("XmlDocumentNodeDatatypeRule.xml_doc_node_references_type_that_cannot_be_resolved", params);
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg);
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        if (typeDefn instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleTypeDefn = (XSDSimpleTypeDefinition)typeDefn;
            DatatypeManager dtMgr = context.getDatatypeManager();
            if (!dtMgr.isEnterpriseDatatype((EObject)simpleTypeDefn)) {
                Object[] params = new Object[]{((XmlDocumentNode)eObject).getName()};
                String msg = XmlDocumentPlugin.Util.getString("XmlDocumentNodeDatatypeRule.xml_doc_node_must_reference_enterprise_datatype", params);
                ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
            }
        }
    }
}

