/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xml.aspects.validation;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.xml.XmlContainerNode;
import com.metamatrix.metamodels.xml.XmlDocumentNode;
import com.metamatrix.metamodels.xml.aspects.validation.AbstractXmlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelEntity;
import com.metamatrix.modeler.core.validation.ValidationContext;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractXmlNodeAspect
extends AbstractXmlAspect {
    public AbstractXmlNodeAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean shouldValidate(EObject eObject, ValidationContext context) {
        ArgCheck.isNotNull((Object)eObject);
        String validationPref = context.getPreferenceValue("xmlPreferences.validateExcludedElements");
        if (StringUtil.isEmpty((String)validationPref) || validationPref.equals("false")) {
            if (!context.shouldIgnore((Object)eObject)) {
                if (this.isExcluded(eObject, context)) {
                    return false;
                }
                for (EObject container = eObject.eContainer(); container != null; container = container.eContainer()) {
                    if (!this.isExcluded(container, context)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(EObject eObject, ValidationContext context) {
        if (eObject != null) {
            boolean excluded = false;
            if (eObject instanceof XmlDocumentNode) {
                excluded = ((XmlDocumentNode)eObject).isExcludeFromDocument();
            } else if (eObject instanceof XmlContainerNode) {
                excluded = ((XmlContainerNode)eObject).isExcludeFromDocument();
            }
            if (excluded) {
                context.addObjectToIgnore(eObject, true);
                return true;
            }
        }
        return false;
    }
}

