/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell.config;

import com.metamatrix.dqp.tools.mmshell.config.SourceType;
import com.metamatrix.dqp.tools.mmshell.config.TypeProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class TypeMappingLoader {
    private static final String CONNECTOR_ELEM = "connector";
    private static final String DRIVER_ELEM = "driver";
    private static final String PROPERTY_ELEM = "property";
    private static final String DESCRIPTION_ELEM = "description";
    private static final String TABLETYPES_ELEM = "tableTypes";
    private static final String SCHEMAPATH_ELEM = "schemapath";
    private static final String INCLUDE_ELEM = "include";
    private static final String EXCLUDE_ELEM = "exclude";
    private static final String TYPE_ATTR = "type";
    private static final String REQUIRED_ATTR = "required";
    private static final String NAME_ATTR = "name";
    private static final String MASKED_ATTR = "masked";
    private static final String DRIVER_NAME_ATTR = "driverName";
    private static final String CONNECTOR_NAME_ATTR = "connectorName";
    private File file;
    List types;

    public TypeMappingLoader(File file) {
        this.file = file;
        this.types = new ArrayList();
    }

    public void loadTypeMappingsFile() throws JDOMException, IOException {
        Document doc = new SAXBuilder().build(this.file);
        int sourceCounter = 0;
        Iterator procIter = doc.getRootElement().getChildren().iterator();
        while (procIter.hasNext()) {
            SourceType sourceType = new SourceType();
            Element elem = (Element)procIter.next();
            String type = elem.getAttributeValue(TYPE_ATTR);
            sourceType.setTypeName(type);
            Iterator driverIter = elem.getChildren().iterator();
            while (driverIter.hasNext()) {
                elem = (Element)driverIter.next();
                String name = elem.getName();
                if (DRIVER_ELEM.equals(name)) {
                    sourceType.setImportDriverName(elem.getAttributeValue(TYPE_ATTR));
                    continue;
                }
                if (CONNECTOR_ELEM.equals(name)) {
                    String connectorType = elem.getAttributeValue(TYPE_ATTR);
                    sourceType.setConnectorTypeName(connectorType);
                    continue;
                }
                if (PROPERTY_ELEM.equals(name)) {
                    String masked;
                    String propertyName = elem.getAttributeValue(NAME_ATTR);
                    TypeProperty property = new TypeProperty(propertyName);
                    String required = elem.getAttributeValue(REQUIRED_ATTR);
                    if (Boolean.valueOf(required).booleanValue()) {
                        property.setRequired(true);
                    }
                    if (Boolean.valueOf(masked = elem.getAttributeValue(MASKED_ATTR)).booleanValue()) {
                        property.setMasked(true);
                    }
                    property.setConnectorName(elem.getAttributeValue(CONNECTOR_NAME_ATTR));
                    property.setDriverName(elem.getAttributeValue(DRIVER_NAME_ATTR));
                    sourceType.addProperty(property);
                    continue;
                }
                if (DESCRIPTION_ELEM.equals(name)) {
                    String description = elem.getText();
                    sourceType.setDescription(description);
                    continue;
                }
                if (TABLETYPES_ELEM.equals(name)) {
                    String tableTypes = elem.getText();
                    sourceType.setTableTypes(tableTypes);
                    continue;
                }
                if (!SCHEMAPATH_ELEM.equals(name)) continue;
                Iterator pathIter = elem.getChildren().iterator();
                while (pathIter.hasNext()) {
                    Element pathelem = (Element)pathIter.next();
                    String pathname = pathelem.getName();
                    if (INCLUDE_ELEM.equals(pathname)) {
                        sourceType.addIncludePath(pathelem.getText());
                        continue;
                    }
                    if (!EXCLUDE_ELEM.equals(pathname)) continue;
                    sourceType.addExcludePath(pathelem.getText());
                }
            }
            sourceType.setLoadOrder(sourceCounter++);
            this.types.add(sourceType);
        }
    }

    public List getTypes() {
        return this.types;
    }
}

