/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.common.util.VDBNameValidator;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminContext;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.dqp.tools.mmshell.MMShell;
import com.metamatrix.dqp.tools.mmshell.VdbContextResourceFinder;
import com.metamatrix.dqp.tools.mmshell.config.SourceType;
import com.metamatrix.dqp.tools.mmshell.config.TypeManager;
import com.metamatrix.dqp.tools.mmshell.config.TypeMappingLoader;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.sdt.types.BuiltInTypesManager;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.JdbcSourceProperty;
import com.metamatrix.tools.toolshell.CommandContext;
import com.metamatrix.tools.toolshell.ToolShell;
import com.metamatrix.vdb.edit.VdbEditingContext;
import com.metamatrix.vdb.edit.loader.VDBReader;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.NonModelReference;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import com.metamatrix.vdb.internal.edit.VdbInputResourceFinder;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBDefn;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.jdom.JDOMException;

public class VDBContext
implements CommandContext {
    public static final String ADMIN_VDB_NAME = "Admin";
    public static final String CONFIG_DIR_NAME = "tools/config";
    public static final String WORKSPACE_DIR_NAME = "tools/workspace";
    private static final String CTNR = "MMShell Container";
    public static final String TYPE_MAPPINGS_FILE = "typeMappings.xml";
    private static final String CONFIG_FILE_NAME = "/mmquery/config/config.xml";
    public static final String SOURCE_TYPE_PROPERTY = "sourceType";
    private String vdbName = "";
    private File vdbFile;
    private ToolShell toolShell;
    private File workspaceDirectory;
    private File configDirectory;
    private VdbContextResourceFinder finder = new VdbContextResourceFinder();
    private VdbEditingContext editingContext;
    private Container ctnr;
    private TypeManager typeManager;
    private ConfigurationModelContainer configCtnr;
    private BasicVDBDefn vdbDef;
    static /* synthetic */ Class class$com$metamatrix$dqp$tools$mmshell$EmbeddedAdminContext;

    public static String cleanupVDBName(String vdbName) {
        int index = vdbName.toLowerCase().lastIndexOf(".vdb");
        if (index == -1) {
            return vdbName;
        }
        return vdbName.substring(0, index);
    }

    protected static boolean isVDBNameValid(String vdbName) {
        File vdb = new File(vdbName);
        String name = vdb.getName();
        return VDBNameValidator.isValid((String)VDBContext.cleanupVDBName(name));
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public Container getContainer() {
        return this.ctnr;
    }

    public VdbEditingContext getEditingContext() {
        return this.editingContext;
    }

    public ToolShell getToolShell() {
        return this.toolShell;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public File getVDBFile() {
        return this.vdbFile;
    }

    public String getVDBName() {
        return this.vdbName;
    }

    public File getWorkspaceDirectory() {
        return this.workspaceDirectory;
    }

    public void setToolShell(ToolShell toolShell) throws Exception {
        this.toolShell = toolShell;
        File folder = toolShell.getShellDirectory();
        this.workspaceDirectory = new File(folder, WORKSPACE_DIR_NAME);
        this.configDirectory = new File(folder, CONFIG_DIR_NAME);
        this.loadConfigurationFile();
        this.loadTypeMappingsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVDBName(String vdbName) throws Exception {
        block9: {
            ContainerImpl vdbCtnr;
            block8: {
                this.checkNoVDB(vdbName);
                this.vdbName = VDBContext.cleanupVDBName(vdbName);
                this.vdbFile = new File(this.getWorkspaceDirectory().getAbsolutePath() + File.separator + this.vdbName + ".vdb");
                this.vdbName = VDBContext.cleanupVDBName(this.vdbFile.getName());
                if (this.editingContext != null) {
                    return;
                }
                VdbEditingContextImpl editingContext = new VdbEditingContextImpl((IPath)new Path(this.vdbFile.getPath()), (VdbInputResourceFinder)this.finder);
                this.editingContext = editingContext;
                this.ctnr = ModelerCore.createContainer((String)CTNR);
                ContainerImpl ctnr = (ContainerImpl)this.ctnr;
                BuiltInTypesManager mgr = new BuiltInTypesManager();
                mgr.initialize((Container)ctnr);
                ctnr.setDatatypeManager((DatatypeManager)mgr);
                vdbCtnr = (ContainerImpl)editingContext.getVdbContainer();
                vdbCtnr.setDatatypeManager((DatatypeManager)mgr);
                if (this.vdbFile.exists()) break block8;
                this.createVDB(vdbName);
                break block9;
            }
            this.open();
            Iterator iter = vdbCtnr.getResources().iterator();
            while (iter.hasNext()) {
                FileInputStream in;
                Resource resrc;
                block7: {
                    Object var14_13;
                    Resource vdbResrc = (Resource)iter.next();
                    URI vdbUri = vdbResrc.getURI();
                    if (vdbUri.trimFileExtension().lastSegment().equals("MetaMatrix-VdbManifestModel")) continue;
                    URI uri = URI.createURI((String)vdbUri.toString().substring(vdbUri.trimSegments(2).toString().length()));
                    resrc = this.ctnr.createResource(uri);
                    this.finder.register(this.getResourcePath(resrc), resrc);
                    OutputStream out = null;
                    in = null;
                    try {
                        out = this.finder.getEmfResourceOutputStream(resrc);
                        vdbResrc.save(out, Collections.EMPTY_MAP);
                        in = new FileInputStream(vdbUri.toFileString());
                        resrc.load(in, this.ctnr.getLoadOptions());
                        var14_13 = null;
                        if (out == null) break block7;
                    }
                    catch (Throwable throwable) {
                        var14_13 = null;
                        if (out != null) {
                            out.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                this.resolveSourceType(resrc);
            }
            this.save();
            this.toolShell.printlnVerbose(DQPToolsPlugin.UTIL.getString("VDBContext.using_vdb", (Object)this.vdbFile.getCanonicalPath()));
        }
    }

    private void resolveSourceType(Resource resrc) throws Exception {
        ComponentType connectortype;
        String sourcetype;
        String srcType;
        JdbcSource src = JdbcManager.getJdbcSource(resrc, this.getToolShell());
        if (src != null && (srcType = JdbcManager.getJdbcSourceType(src)) == null && (sourcetype = this.typeManager.findByConnectorType((connectortype = this.getConnectorType(resrc.getURI().trimFileExtension().lastSegment())).getFullName())) != null) {
            EList sourceProps = src.getProperties();
            JdbcSourceProperty prop = JdbcFactory.eINSTANCE.createJdbcSourceProperty();
            prop.setSource(src);
            prop.setName(SOURCE_TYPE_PROPERTY);
            prop.setValue(sourcetype);
            sourceProps.add(prop);
        }
    }

    public void setWorkspaceDirectory(File workspaceDirectory) {
        this.workspaceDirectory = workspaceDirectory;
    }

    public void activate() throws Exception {
        this.save();
        this.undeployVDB();
        this.deployVDB();
    }

    private void addBindingToDEF(String bindingName, ComponentType compType, ConnectorBinding binding, boolean isReplace) throws Exception {
        VdbEditingContextImpl editingContext = (VdbEditingContextImpl)this.editingContext;
        this.vdbDef = (BasicVDBDefn)VDBReader.loadVDBDefn((VdbEditingContextImpl)editingContext);
        if (!isReplace && !LicenseChecker.hasValidProductLicense((String)"Sources", (String)"5.0", (int)(this.vdbDef.getConnectorBindings().size() + 1))) {
            throw new MetaMatrixComponentException(DQPToolsPlugin.UTIL.getString("VDBContext.bindings_exceeded_limit"));
        }
        this.vdbDef.addConnectorType(compType);
        this.vdbDef.addConnectorBinding(bindingName, binding);
        this.saveDEF();
    }

    private void saveDEF() throws Exception {
        VdbEditingContextImpl editingContext = (VdbEditingContextImpl)this.editingContext;
        InputStream defStream = VDBReader.createVDBDefnInputStream((VDBDefn)this.vdbDef, null);
        NonModelReference ref = editingContext.addConfigurationDefinition(null, defStream, (IPath)new Path("ConfigurationInfo.def"));
        if (ref == null) {
            throw new RuntimeException(DQPToolsPlugin.UTIL.getString("VDBContext.unableToAddVdbDefinition"));
        }
    }

    private void checkNoVDB(String vdbName) throws Exception {
        if (vdbName == null) {
            EmbeddedAdminContext adminContext = (EmbeddedAdminContext)this.toolShell.getContext((class$com$metamatrix$dqp$tools$mmshell$EmbeddedAdminContext == null ? (class$com$metamatrix$dqp$tools$mmshell$EmbeddedAdminContext = VDBContext.class$("com.metamatrix.dqp.tools.mmshell.EmbeddedAdminContext")) : class$com$metamatrix$dqp$tools$mmshell$EmbeddedAdminContext).getName());
            List vdbs = adminContext.getDeployedVDBs();
            StringBuffer str = new StringBuffer();
            str.append(DQPToolsPlugin.UTIL.getString("VDBContext.missing_vdb") + "  ");
            if (vdbs.size() > 0) {
                str.append(adminContext.getDeployedVDBsString());
            } else {
                str.append(DQPToolsPlugin.UTIL.getString("VDBContext.specify_vdb"));
            }
            throw new Exception(str.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block3: {
            try {
                this.save();
                Object var2_1 = null;
                if (this.editingContext == null) break block3;
                this.toolShell.getDatabaseConnectionContext().closeConnection();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.editingContext != null) {
                    this.toolShell.getDatabaseConnectionContext().closeConnection();
                    this.editingContext.close();
                    this.toolShell.printlnVerbose(DQPToolsPlugin.UTIL.getString("VDBContext.closed", (Object)this.vdbName));
                    this.editingContext = null;
                    this.vdbDef = null;
                    this.vdbName = null;
                    this.vdbFile = null;
                }
                throw throwable;
            }
            this.editingContext.close();
            this.toolShell.printlnVerbose(DQPToolsPlugin.UTIL.getString("VDBContext.closed", (Object)this.vdbName));
            this.editingContext = null;
            this.vdbDef = null;
            this.vdbName = null;
            this.vdbFile = null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmfResource createResource(String name, String metamodelUrl, String type, Properties properties) throws Exception {
        OutputStream out = null;
        try {
            JdbcSource[] currentSources = this.getJdbcSources();
            if (!LicenseChecker.hasValidProductLicense((String)"Sources", (String)"5.0", (int)(currentSources.length + 1))) {
                throw new MetaMatrixComponentException(DQPToolsPlugin.UTIL.getString("VDBContext.bindings_exceeded_limit"));
            }
            ComponentType compType = this.typeManager.getConnectorType(type);
            if (compType == null) {
                EmfResource emfResource = null;
                return emfResource;
            }
            EmfResource resrc = (EmfResource)this.ctnr.createResource(this.createResourceUri(name));
            ModelAnnotation annotation = resrc.getModelAnnotation();
            annotation.setModelType(ModelType.PHYSICAL_LITERAL);
            annotation.setPrimaryMetamodelUri(metamodelUrl);
            IPath path = this.getResourcePath((Resource)resrc);
            this.finder.register(path, (Resource)resrc);
            out = this.finder.getEmfResourceOutputStream((Resource)resrc);
            resrc.save(out, Collections.EMPTY_MAP);
            out.close();
            out = null;
            ModelReference[] refs = this.editingContext.addModel(null, path, false);
            if (refs.length == 0) {
                this.toolShell.printlnError(DQPToolsPlugin.UTIL.getString("VDBContext.unableToAddSource", (Object)name));
                EmfResource emfResource = null;
                return emfResource;
            }
            BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);
            ComponentTypeID componentTypeID = (ComponentTypeID)compType.getID();
            ConnectorBinding binding = editor.createConnectorComponent(Configuration.NEXT_STARTUP_ID, componentTypeID, name, null);
            Properties connectorProps = new Properties();
            connectorProps.putAll((Map<?, ?>)this.configCtnr.getDefaultPropertyValues(componentTypeID));
            Iterator<Map.Entry<Object, Object>> iter = properties.entrySet().iterator();
            block5: while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                Iterator iter2 = this.configCtnr.getAllComponentTypeDefinitions(componentTypeID).iterator();
                while (iter2.hasNext()) {
                    ComponentTypeDefn typeDef = (ComponentTypeDefn)iter2.next();
                    String defName = typeDef.getName();
                    if (!defName.equalsIgnoreCase(key)) continue;
                    if (typeDef.getPropertyDefinition().isMasked()) {
                        connectorProps.setProperty(defName, String.valueOf(CryptoUtil.stringEncrypt((char[])val.toCharArray())));
                        continue block5;
                    }
                    connectorProps.setProperty(defName, val);
                    continue block5;
                }
            }
            binding = (ConnectorBinding)editor.modifyProperties((ComponentObject)binding, connectorProps, 1);
            this.addBindingToDEF(name, compType, binding, false);
            this.toolShell.printlnVerbose(DQPToolsPlugin.UTIL.getString("VDBContext.createdSource", (Object)name));
            EmfResource emfResource = resrc;
            return emfResource;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmfResource createEmptyResource(String name) throws Exception {
        OutputStream out = null;
        try {
            EmfResource resrc = (EmfResource)this.ctnr.createResource(this.createResourceUri(name));
            ModelAnnotation annotation = resrc.getModelAnnotation();
            annotation.setModelType(ModelType.PHYSICAL_LITERAL);
            annotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            IPath path = this.getResourcePath((Resource)resrc);
            this.finder.register(path, (Resource)resrc);
            out = this.finder.getEmfResourceOutputStream((Resource)resrc);
            resrc.save(out, Collections.EMPTY_MAP);
            out.close();
            out = null;
            ModelReference[] refs = this.editingContext.addModel(null, path, false);
            if (refs.length == 0) {
                this.toolShell.printlnError(DQPToolsPlugin.UTIL.getString("VDBContext.unableToAddSource", (Object)name));
                EmfResource emfResource = null;
                return emfResource;
            }
            EmfResource emfResource = resrc;
            return emfResource;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private URI createResourceUri(String name) {
        String validName = new StringNameValidator().createValidName(name);
        if (validName != null) {
            name = validName;
        }
        if (!name.endsWith(".xmi")) {
            name = name + ".xmi";
        }
        return URI.createURI((String)new Path(this.vdbName).append(name).makeAbsolute().toString());
    }

    private void createVDB(String vdbName) throws Exception {
        boolean dirExists = this.workspaceDirectory.exists();
        if (!dirExists) {
            this.workspaceDirectory.mkdirs();
        }
        boolean succeeded = false;
        try {
            succeeded = this.vdbFile.createNewFile();
            if (!dirExists) {
                this.toolShell.printlnVerbose(DQPToolsPlugin.UTIL.getString("VDBContext.created_dir", (Object)this.workspaceDirectory.getCanonicalPath()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!succeeded) {
            this.vdbName = null;
            throw new RuntimeException(DQPToolsPlugin.UTIL.getString("VDBContext.unable_to_create_file", (Object)this.vdbFile));
        }
        this.open();
        EmfResource resrc = this.createEmptyResource("Empty");
        this.saveResource(resrc);
        this.deleteEmptyResource("Empty", resrc);
        this.save();
        this.toolShell.printlnVerbose(DQPToolsPlugin.UTIL.getString("VDBContext.created_vdb", (Object)this.vdbFile.getCanonicalPath()));
        this.toolShell.printHelp(DQPToolsPlugin.UTIL.getString("VDBContext.nextSteps"));
    }

    public boolean deleteVDB() throws Exception {
        EmbeddedAdminContext context = ((MMShell)this.toolShell).getDQPAdminContext();
        Collection vdbs = context.getAdmin().getVDBs(this.getVDBName());
        Iterator i = vdbs.iterator();
        while (i.hasNext()) {
            VDB vdb = (VDB)i.next();
            context.getAdmin().changeVDBStatus(vdb.getName(), vdb.getVDBVersion(), 4);
        }
        File vdbFile = this.getVDBFile();
        this.close();
        if (vdbFile.exists() && !vdbFile.delete()) {
            return false;
        }
        this.vdbFile = null;
        this.vdbName = null;
        return true;
    }

    public boolean deleteResource(String sourceName, EmfResource resource) {
        IPath path = this.getResourcePath((Resource)resource);
        if (resource.isLoaded()) {
            resource.unload();
        }
        this.ctnr.getResources().remove((Object)resource);
        IStatus status = this.editingContext.removeModel(path);
        if (status.isOK()) {
            this.finder.unregister((Resource)resource);
            this.removeBindingFromDEF(sourceName);
            return true;
        }
        this.printStatus(status);
        return false;
    }

    public boolean deleteEmptyResource(String sourceName, EmfResource resource) {
        IPath path = this.getResourcePath((Resource)resource);
        if (resource.isLoaded()) {
            resource.unload();
        }
        this.ctnr.getResources().remove((Object)resource);
        IStatus status = this.editingContext.removeModel(path);
        if (status.isOK()) {
            return true;
        }
        this.printStatus(status);
        return false;
    }

    public void deployVDB() throws Exception {
        EmbeddedAdminContext context = ((MMShell)this.toolShell).getDQPAdminContext();
        AdminOptions options = new AdminOptions(1);
        options.addOption(8);
        context.getAdmin().addVDB(this.getVDBName(), new FileUtil(this.getVDBFile().getAbsolutePath()).readBytes(), options);
    }

    public Resource findResource(String name) {
        Iterator iter = this.ctnr.getResources().iterator();
        while (iter.hasNext()) {
            Resource resrc = (Resource)iter.next();
            if (!resrc.getURI().trimFileExtension().lastSegment().equalsIgnoreCase(name)) continue;
            return resrc;
        }
        throw new RuntimeException(DQPToolsPlugin.UTIL.getString("VDBContext.noSource", (Object)name));
    }

    public String getBindingProperty(String sourceName, String propertyName) throws Exception {
        ConnectorBinding binding = this.getConnectorBinding(sourceName);
        if (binding != null) {
            ComponentType type = this.vdbDef.getConnectorType(binding.getComponentTypeID().getFullName());
            boolean masked = false;
            Iterator iter = type.getComponentTypeDefinitions().iterator();
            while (iter.hasNext()) {
                ComponentTypeDefn def = (ComponentTypeDefn)iter.next();
                String name = def.getName();
                if (!name.equalsIgnoreCase(propertyName)) continue;
                propertyName = name;
                masked = def.getPropertyDefinition().isMasked();
                break;
            }
            String val = binding.getProperty(propertyName);
            try {
                return val != null && masked ? String.valueOf(CryptoUtil.stringDecrypt((char[])val.toCharArray())) : val;
            }
            catch (CryptoException err) {
                this.toolShell.printlnException(err);
                return null;
            }
        }
        return null;
    }

    private ConnectorBinding getConnectorBinding(String sourceName) throws Exception {
        ConnectorBinding binding = this.vdbDef.getConnectorBindingByName(sourceName);
        if (binding == null) {
            List uuidList = null;
            Iterator iter = this.vdbDef.getModelToBindingMappings().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!sourceName.equalsIgnoreCase((String)entry.getKey())) continue;
                uuidList = (List)entry.getValue();
                break;
            }
            if (uuidList != null && !uuidList.isEmpty()) {
                binding = this.vdbDef.getConnectorBindingByRouting((String)uuidList.get(0));
            }
        }
        return binding;
    }

    private ComponentType getConnectorType(String sourceName) throws Exception {
        ConnectorBinding binding = this.getConnectorBinding(sourceName);
        if (binding != null) {
            return this.vdbDef.getConnectorType(binding.getComponentTypeID().getFullName());
        }
        return null;
    }

    private IPath getResourcePath(Resource resource) {
        return new Path(resource.getURI().toString());
    }

    public boolean isOpen() {
        return this.editingContext != null && this.editingContext.isOpen();
    }

    private void loadConfigurationFile() throws Exception {
        ConfigurationModelContainerAdapter adapter = new ConfigurationModelContainerAdapter();
        String file = new File(this.toolShell.getShellDirectory(), CONFIG_FILE_NAME).getCanonicalPath();
        this.configCtnr = adapter.readConfigurationModel(file, Configuration.NEXT_STARTUP_ID);
    }

    private void loadTypeMappingsFile() throws JDOMException, IOException {
        File typeFile = new File(this.configDirectory, TYPE_MAPPINGS_FILE);
        TypeMappingLoader loader = new TypeMappingLoader(typeFile);
        loader.loadTypeMappingsFile();
        this.typeManager = new TypeManager(this.configCtnr, loader.getTypes());
    }

    public void open() throws Exception {
        if (this.editingContext.isOpen()) {
            return;
        }
        VdbEditingContextImpl vdbContext = (VdbEditingContextImpl)this.editingContext;
        vdbContext.setLoadModelsOnOpen(true);
        vdbContext.open();
        this.vdbDef = (BasicVDBDefn)VDBReader.loadVDBDefn((VdbEditingContextImpl)vdbContext, (boolean)false);
        if (this.vdbDef.doesVDBHaveValidityError()) {
            String[] errors = this.vdbDef.getVDBValidityErrors();
            for (int i = 0; i < errors.length; ++i) {
                this.toolShell.printlnError(" - " + errors[i]);
            }
            String name = this.vdbName;
            this.close();
            throw new RuntimeException(DQPToolsPlugin.UTIL.getString("VDBContext.vdb_not_loaded", (Object)name));
        }
        if (!this.vdbDef.getName().equals(this.vdbName)) {
            this.vdbName = this.vdbDef.getName();
        }
    }

    public void printStatus(IStatus status) {
        if (status.isMultiStatus()) {
            this.toolShell.printlnError(status.getMessage() + ':');
            IStatus[] children = status.getChildren();
            int len = children.length;
            for (int ndx = 0; ndx < len; ++ndx) {
                this.toolShell.printlnError(children[ndx].getMessage());
            }
        } else {
            this.toolShell.printlnError(status.getMessage());
        }
    }

    private void removeBindingFromDEF(String bindingName) {
        try {
            VdbEditingContextImpl editingContext = (VdbEditingContextImpl)this.editingContext;
            this.vdbDef.removeModelInfo(bindingName);
            this.vdbDef.removeConnectorBinding(bindingName);
            InputStream defStream = VDBReader.createVDBDefnInputStream((VDBDefn)this.vdbDef, null);
            NonModelReference ref = editingContext.addConfigurationDefinition(null, defStream, (IPath)new Path("ConfigurationInfo.def"));
            if (ref == null) {
                throw new RuntimeException(DQPToolsPlugin.UTIL.getString("VDBContext.unableToAddVdbDefinition"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(DQPToolsPlugin.UTIL.getString("VDBContext.failed_to_delete_binding", (Object)bindingName));
        }
    }

    public boolean rename(String newVDBName) throws Exception {
        File renamedVdb = new File(this.getWorkspaceDirectory(), newVDBName + ".vdb");
        if (renamedVdb.exists()) {
            this.toolShell.printlnError(DQPToolsPlugin.UTIL.getString("VDBContext.vdb_exists_already", (Object)newVDBName));
            return false;
        }
        this.undeployVDB();
        String name = renamedVdb.getAbsolutePath();
        if (this.getEditingContext() != null) {
            ((VdbEditingContextImpl)this.getEditingContext()).rename(name);
        }
        this.setVDBName(newVDBName);
        this.updateManifest();
        this.vdbDef.setFileName(this.getVDBFile().getName());
        this.vdbDef.setName(this.getVDBName());
        this.vdbDef.setDescription(this.getVDBName());
        this.saveDEF();
        this.save();
        this.deployVDB();
        return true;
    }

    public void save() {
        if (this.editingContext != null && this.editingContext.isSaveRequired()) {
            this.editingContext.save(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveResource(EmfResource resource) {
        OutputStream out = null;
        out = this.finder.getEmfResourceOutputStream((Resource)resource);
        resource.save(out, Collections.EMPTY_MAP);
        out.close();
        out = null;
        ModelReference ref = this.editingContext.refreshModel(null, this.getResourcePath((Resource)resource));
        if (ref == null) {
            this.toolShell.printlnError(DQPToolsPlugin.UTIL.getString("VDBContext.unableToSaveSource", (Object)resource.getURI()));
        }
        boolean bl = true;
        Object var6_6 = null;
        if (out == null) return bl;
        try {
            out.close();
            return bl;
        }
        catch (IOException err2) {
            this.toolShell.printlnException(err2);
        }
        return bl;
        catch (Exception err) {
            try {
                this.toolShell.printlnException(err);
                Object var6_7 = null;
                if (out == null) return false;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException err2) {
                    this.toolShell.printlnException(err2);
                }
                throw throwable;
            }
            try {
                out.close();
                return false;
            }
            catch (IOException err2) {
                this.toolShell.printlnException(err2);
            }
            return false;
        }
    }

    public void setBindingProperty(String sourceName, Properties addProperties) throws Exception {
        Properties modified = new Properties();
        ConnectorBinding binding = this.getConnectorBinding(sourceName);
        ComponentType type = this.vdbDef.getConnectorType(binding.getComponentTypeID().getFullName());
        Iterator<Object> toadd = addProperties.keySet().iterator();
        block2: while (toadd.hasNext()) {
            String addName = (String)toadd.next();
            Iterator allowed = type.getComponentTypeDefinitions().iterator();
            while (allowed.hasNext()) {
                ComponentTypeDefn def = (ComponentTypeDefn)allowed.next();
                String allowedName = def.getName();
                if (!allowedName.equalsIgnoreCase(addName)) continue;
                String name = allowedName;
                String value = addProperties.getProperty(addName);
                if (def.getPropertyDefinition().isMasked()) {
                    try {
                        value = new String(CryptoUtil.stringEncrypt((char[])value.toCharArray()));
                    }
                    catch (CryptoException e) {
                        this.toolShell.printlnException(e);
                        return;
                    }
                }
                modified.setProperty(name, value);
                continue block2;
            }
        }
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor();
        Properties props = binding.getProperties();
        props.putAll((Map<?, ?>)modified);
        binding = (ConnectorBinding)editor.modifyProperties((ComponentObject)binding, props, 0);
        this.addBindingToDEF(binding.getName(), type, binding, true);
    }

    public void undeployVDB() throws Exception {
        this.toolShell.getDatabaseConnectionContext().closeConnection();
        EmbeddedAdminContext context = ((MMShell)this.toolShell).getDQPAdminContext();
        String vdbName = this.getVDBName();
        if (vdbName != null && vdbName.trim().length() > 0) {
            Collection vdbs = context.getAdmin().getVDBs(vdbName);
            Iterator i = vdbs.iterator();
            while (i.hasNext()) {
                VDB vdb = (VDB)i.next();
                context.getAdmin().changeVDBStatus(vdb.getName(), vdb.getVDBVersion(), 4);
            }
        }
    }

    public void updateManifest() throws Exception {
        this.open();
        VdbEditingContextImpl impl = (VdbEditingContextImpl)this.editingContext;
        impl.updateVdbXmiName();
        impl.save(null);
    }

    public Resource[] getResources() {
        ArrayList<Resource> list = new ArrayList<Resource>();
        Iterator iter = this.ctnr.getResources().iterator();
        while (iter.hasNext()) {
            Resource resrc = (Resource)iter.next();
            list.add(resrc);
        }
        return list.toArray(new Resource[list.size()]);
    }

    public JdbcSource[] getJdbcSources() {
        Resource[] resources = this.getResources();
        ArrayList<JdbcSource> list = new ArrayList<JdbcSource>();
        for (int i = 0; i < resources.length; ++i) {
            JdbcSource source = JdbcManager.getJdbcSource(resources[i], this.toolShell);
            if (source == null) continue;
            list.add(source);
        }
        return list.toArray(new JdbcSource[list.size()]);
    }

    public SourceType getSourceType(String srcName) throws Exception {
        Resource resource = this.findResource(srcName);
        JdbcSource src = null;
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof JdbcSource)) continue;
            src = (JdbcSource)obj;
            return this.typeManager.findByDriverType(src.getDriverName());
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

