/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.dqp.tools.mmshell.config.TypeProperty;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.tools.toolshell.ToolShell;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.ecore.resource.Resource;

public class SetJdbcSourcePropertiesCommand {
    public static boolean execute(String sourceName, Resource resource, Properties properties, ToolShell shell, VDBContext context) throws Exception {
        JdbcSource src = JdbcManager.getJdbcSource(resource, shell);
        if (src == null) {
            shell.printlnError(DQPToolsPlugin.UTIL.getString("noConnectionInfo", (Object)sourceName));
            return false;
        }
        String srcType = JdbcManager.getJdbcSourceType(src);
        if (srcType != null) {
            String user;
            List typeProps = context.getTypeManager().getProperties(srcType);
            Properties propertiesToAdd = new Properties();
            Iterator<Object> newList = properties.keySet().iterator();
            while (newList.hasNext()) {
                String newName = (String)newList.next();
                boolean added = false;
                Iterator allowedList = typeProps.iterator();
                while (allowedList.hasNext()) {
                    TypeProperty allowed = (TypeProperty)allowedList.next();
                    String allowedName = allowed.getName();
                    if (!newName.equalsIgnoreCase(allowedName)) continue;
                    propertiesToAdd.setProperty(allowedName, properties.getProperty(newName));
                    added = true;
                    break;
                }
                if (added) continue;
                shell.printlnError(newName + " " + DQPToolsPlugin.UTIL.getString("SetJdbcSourcePropertiesCommand.notallowed", (Object)sourceName, (Object)srcType));
                return false;
            }
            context.setBindingProperty(sourceName, propertiesToAdd);
            String url = propertiesToAdd.getProperty("URL");
            if (url != null) {
                src.setUrl(url);
            }
            if ((user = propertiesToAdd.getProperty("user")) != null) {
                src.setUsername(user);
            }
            shell.printlnError(DQPToolsPlugin.UTIL.getString("SetJdbcSourcePropertiesCommand.added"));
            Iterator<Object> i = propertiesToAdd.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                shell.printlnError("  " + key + "=" + propertiesToAdd.getProperty(key));
            }
        } else {
            shell.printlnError(DQPToolsPlugin.UTIL.getString("SetJdbcSourcePropertiesCommand.unknowntype", (Object)sourceName));
        }
        return true;
    }
}

