/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.common.util.VDBNameValidator;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.SetJdbcSourcePropertiesCommand;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.ecore.resource.Resource;

public class SetCommand
extends EmbeddedAdminCommandImpl {
    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("SetCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return DQPToolsPlugin.UTIL.getString("SetCommand.longHelp");
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("SetCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("SetCommand.argHelp");
    }

    public boolean executeCommand(Iterator iterator) throws Exception {
        if (!this.verifyOpen()) {
            return true;
        }
        iterator.next();
        String srcName = this.getSourceName(iterator);
        if (srcName == null) {
            return true;
        }
        if (VDBNameValidator.isSourceNameReserved((String)srcName)) {
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("SetCommand.reserved_source", (Object)srcName));
            return true;
        }
        if (!iterator.hasNext()) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("SetCommand.missingPropertyArgument"));
            return true;
        }
        Properties props = SetCommand.getPropertiesFromArguments(iterator);
        VDBContext context = this.getVDBContext();
        EmfResource resrc = (EmfResource)context.findResource(srcName);
        if (resrc == null) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("SetCommand.invalid_source", (Object)srcName));
            return true;
        }
        boolean success = false;
        if (this.isRelational(resrc)) {
            success = SetJdbcSourcePropertiesCommand.execute(srcName, (Resource)resrc, props, this.toolShell, context);
        } else {
            this.printlnError("Not yet implemented");
        }
        if (success) {
            context.save();
            context.activate();
        }
        return true;
    }
}

