/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.core.util.FileUtils;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.modeler.jdbc.JdbcSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class PackageCommand
extends EmbeddedAdminCommandImpl {
    static final String JAR = ".jar";
    static final String ZIP = ".zip";
    QueryPackager packager = new QueryPackager();

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("PackageCommand.commandName");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("PackageCommand.argHelp");
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("PackageCommand.shortHelp");
    }

    public String getLongHelp(List argList) {
        return DQPToolsPlugin.UTIL.getString("PackageCommand.longHelp");
    }

    public boolean executeCommand(Iterator argIter) throws Exception {
        File jarFile;
        File archiveFile;
        argIter.next();
        if (!this.verifyOpen()) {
            return true;
        }
        JdbcSource[] sources = this.getVDBContext().getJdbcSources();
        if (sources.length == 0) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("PackageCommand.no_sources"));
            return true;
        }
        String deployJarName = this.getVDBContext().getVDBName() + "-mmquery";
        if (argIter.hasNext()) {
            deployJarName = (String)argIter.next();
        }
        if ((deployJarName = this.fixJARFileName(deployJarName)) == null) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("PackageCommand.invalid_filename"));
            return true;
        }
        File querydir = new File(this.toolShell.getShellDirectory(), "mmquery");
        File deployFile = archiveFile = new File(deployJarName);
        if (archiveFile.getParentFile() == null) {
            deployFile = new File(this.getVDBContext().getWorkspaceDirectory(), archiveFile.getName());
        }
        if (deployFile.exists()) {
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("PackageCommand.file_exist", (Object)deployFile.getName()));
            deployFile.delete();
        }
        if ((jarFile = this.packager.buildArchive(this.getVDBContext().getVDBName(), deployFile, this.getVDBContext().getVDBFile(), querydir)).exists()) {
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("PackageCommand.wrote_file", (Object)jarFile.getCanonicalPath()));
            if (deployJarName.endsWith(JAR)) {
                this.printHelp(DQPToolsPlugin.UTIL.getString("PackageCommand.next_steps_jar", (Object)jarFile.getCanonicalPath(), (Object)this.getVDBContext().getVDBName()));
            } else {
                this.printHelp(DQPToolsPlugin.UTIL.getString("PackageCommand.next_steps_zip", (Object)this.getVDBContext().getVDBName()));
            }
        }
        return true;
    }

    String fixJARFileName(String file) {
        int extIndex = file.lastIndexOf(46);
        if (extIndex == -1) {
            return file + JAR;
        }
        String extension = file.substring(extIndex).toLowerCase();
        if (!extension.equals(JAR) && !extension.equals(ZIP)) {
            return file + JAR;
        }
        return file.substring(0, extIndex) + extension;
    }

    static class QueryPackager {
        QueryPackager() {
        }

        public File buildArchive(String vdbName, File deployFile, File vdbFile, File queryDirectory) throws IOException {
            if (deployFile.getName().endsWith(PackageCommand.JAR)) {
                return this.createJarArchive(vdbName, deployFile, vdbFile, queryDirectory);
            }
            if (deployFile.getName().endsWith(PackageCommand.ZIP)) {
                return this.createZipArchive(deployFile, vdbFile, queryDirectory);
            }
            throw new IOException(DQPToolsPlugin.UTIL.getString("PackageCommand.bad_extension", (Object)deployFile.getName()));
        }

        File createZipArchive(File deployFile, File vdbFile, File queryDirectory) throws IOException {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(deployFile));
            return this.createArchive(deployFile, vdbFile, queryDirectory, out);
        }

        File createArchive(File deployFile, File vdb, File queryDir, FilterOutputStream out) throws IOException {
            if (!queryDir.isDirectory()) {
                throw new IOException(DQPToolsPlugin.UTIL.getString("PackageCommand.invalid_query_directory"));
            }
            this.slurpDirectory(queryDir, new FileFilter(this){
                private final /* synthetic */ QueryPackager this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean accept(File pathname) {
                    if (pathname.isDirectory() && pathname.getName().equals("buffer")) {
                        return false;
                    }
                    return !pathname.getName().endsWith(".log");
                }
            }, out);
            this.writeFile(vdb, "config/" + vdb.getName(), out);
            out.close();
            return deployFile;
        }

        File createJarArchive(String vdbName, File deployFile, File vdb, File querydir) throws IOException {
            JarOutputStream out = new JarOutputStream(new FileOutputStream(deployFile));
            File propsFile = this.getPropertiesFile(vdbName, new File(querydir, "mm.properties"));
            this.writeFile(propsFile, vdbName + "/mm.properties", out);
            this.slurpDirectory(new File(querydir, "config"), null, vdbName + "/config", false, out);
            this.slurpDirectory(new File(querydir, "extensions"), null, vdbName + "/extensions", false, out);
            this.slurpDirectory(new File(querydir, "lib"), null, vdbName + "/lib", false, out);
            File licenseJar = this.createJarFromDirectory(new File(querydir, "license"));
            this.writeFile(licenseJar, vdbName + "/lib/license.jar", out);
            licenseJar.delete();
            this.writeFile(vdb, vdbName + "/config/" + vdb.getName(), out);
            FileFilter jdbcFilter = new FileFilter(this){
                private final /* synthetic */ QueryPackager this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean accept(File pathname) {
                    return !pathname.getName().startsWith("bcprov-");
                }
            };
            this.slurpDirectory(new File(querydir, "jdbc"), jdbcFilter, "", true, out);
            out.close();
            propsFile.delete();
            return deployFile;
        }

        private File getPropertiesFile(String vdbName, File propsFile) throws IOException {
            Properties p = new Properties();
            p.load(new FileInputStream(propsFile));
            p.remove("dqp.buffer.dir");
            String classpath = this.cleanClasspath(p.getProperty("dqp.classpath"));
            p.setProperty("vdb.definition", "./config/" + vdbName + ".vdb");
            p.setProperty("dqp.logFile", "${QueryLogFile}");
            p.setProperty("dqp.classpath", classpath + ";./lib/license.jar");
            p.setProperty("dqp.keystore", "./lib/metamatrixpki.keystore");
            File tempFile = File.createTempFile("metamatrix", "properties");
            FileOutputStream out = new FileOutputStream(tempFile);
            p.store(out, null);
            ((OutputStream)out).close();
            return tempFile;
        }

        private String cleanClasspath(String classPath) {
            Stack<String> stack = new Stack<String>();
            StringBuffer sb = new StringBuffer();
            if (classPath != null) {
                StringTokenizer st = new StringTokenizer(classPath, ";");
                while (st.hasMoreTokens()) {
                    String path = st.nextToken();
                    if ((path = path.trim()).length() <= 0 || !path.endsWith(PackageCommand.JAR)) continue;
                    stack.push(path);
                }
            }
            while (!stack.empty()) {
                String path = (String)stack.pop();
                sb.append(path).append(";");
            }
            return sb.toString();
        }

        File createJarFromDirectory(File dir) throws IOException {
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IOException();
            }
            File tempFile = File.createTempFile("mmlicense", "jar");
            JarOutputStream out = new JarOutputStream(new FileOutputStream(tempFile));
            this.slurpDirectory(dir, null, out);
            out.close();
            return tempFile;
        }

        void slurpJarFile(File jarFile, FilterOutputStream out) throws IOException {
            ZipFile jf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileUtils.write((InputStream)jf.getInputStream(ze), (OutputStream)baos, (int)2048);
                this.writeEntry(ze, baos.toByteArray(), out);
            }
        }

        void slurpDirectory(File dir, FileFilter filter, FilterOutputStream out) throws IOException {
            this.slurpDirectory(dir, filter, "", false, out);
        }

        void slurpDirectory(File dir, FileFilter filter, String prefix, boolean flatternArchives, FilterOutputStream out) throws IOException {
            File[] files = dir.listFiles(filter);
            Comparator comparator = new Comparator(this){
                private final /* synthetic */ QueryPackager this$0;
                {
                    this.this$0 = this$0;
                }

                public int compare(Object o1, Object o2) {
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    if (f1.lastModified() > f2.lastModified()) {
                        return -1;
                    }
                    if (f1.lastModified() < f2.lastModified()) {
                        return 1;
                    }
                    return 0;
                }
            };
            Arrays.sort(files, comparator);
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String entryName = prefix + "/" + file.getName();
                if (prefix.length() == 0) {
                    entryName = file.getName();
                }
                if (file.isDirectory()) {
                    this.slurpDirectory(file, filter, entryName, flatternArchives, out);
                    continue;
                }
                if (flatternArchives && (file.getName().toLowerCase().endsWith(PackageCommand.JAR) || file.getName().toLowerCase().endsWith(PackageCommand.ZIP))) {
                    this.slurpJarFile(file, out);
                    continue;
                }
                this.writeFile(file, entryName, out);
            }
        }

        void writeFile(File f, String entryName, FilterOutputStream out) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtils.write((File)f, (OutputStream)baos);
            if (!(out instanceof ZipOutputStream)) {
                throw new RuntimeException();
            }
            ZipEntry ze = new ZipEntry(entryName);
            this.writeEntry(ze, baos.toByteArray(), out);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void writeEntry(Object entry, byte[] data, FilterOutputStream out) throws IOException {
            if (!(out instanceof ZipOutputStream)) throw new RuntimeException();
            ZipOutputStream outStream = (ZipOutputStream)out;
            try {
                outStream.putNextEntry((ZipEntry)entry);
                outStream.write(data);
                outStream.closeEntry();
                return;
            }
            catch (ZipException e) {
                if (e.getMessage().startsWith("duplicate entry:")) return;
                throw e;
            }
        }
    }
}

