/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.modeler.internal.jdbc.JdbcManagerImpl;
import com.metamatrix.modeler.jdbc.JdbcDriver;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.JdbcSourceProperty;
import com.metamatrix.modeler.jdbc.custom.ExcelConnectionHandler;
import com.metamatrix.tools.toolshell.ToolShell;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class JdbcManager {
    public static final String PROCESSOR_FILE = "importProcessors.xml";
    private static final String DRIVER_ELEM = "driver";
    private static final String OPTION_ELEM = "option";
    private static final String CLASS_ATTR = "class";
    private static final String NAME_ATTR = "name";
    private static final String VAL_ATTR = "value";
    public static final String PWD = DQPToolsPlugin.UTIL.getString("JdbcManager.password");
    public static final String USER = DQPToolsPlugin.UTIL.getString("JdbcManager.user");
    public static final String URL = DQPToolsPlugin.UTIL.getString("JdbcManager.url");
    private static JdbcManager shared;
    private com.metamatrix.modeler.jdbc.JdbcManager mgr;
    private Map driverProcessorMap = new HashMap();
    private Map processorImportOptionsMap = new HashMap();
    static /* synthetic */ Class class$java$sql$Connection;

    public static JdbcManager create(File folder, Container container) throws IOException, JdbcException, JDOMException {
        if (shared == null) {
            shared = new JdbcManager(folder, container);
        }
        return shared;
    }

    public static JdbcManager get() {
        return shared;
    }

    public static JdbcSource getJdbcSource(Resource resource, ToolShell shell) {
        MtkXmiResourceImpl resrc;
        URI uri;
        if (resource instanceof MtkXmiResourceImpl && (uri = (resrc = (MtkXmiResourceImpl)resource).getPrimaryMetamodelUri()) != null && "http://www.metamatrix.com/metamodels/Relational".equals(uri.toString()) && resrc.getModelType() == ModelType.PHYSICAL_LITERAL) {
            Iterator iter = resource.getContents().iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof JdbcSource)) continue;
                return (JdbcSource)obj;
            }
            shell.printlnError(DQPToolsPlugin.UTIL.getString("JdbcManager.noJdbcSource"));
        }
        return null;
    }

    public static String getJdbcSourceType(JdbcSource source) {
        String srcType = null;
        Iterator i = source.getProperties().iterator();
        while (i.hasNext()) {
            JdbcSourceProperty prop = (JdbcSourceProperty)i.next();
            if (!prop.getName().equals("sourceType")) continue;
            srcType = prop.getValue();
        }
        return srcType;
    }

    private JdbcManager(File folder, Container container) throws IOException, JdbcException, JDOMException {
        this.mgr = JdbcManagerImpl.create("JDBC Manager", folder, container);
        Document doc = new SAXBuilder().build(new File(folder, PROCESSOR_FILE));
        Iterator procIter = doc.getRootElement().getChildren().iterator();
        while (procIter.hasNext()) {
            Element elem = (Element)procIter.next();
            String proc = elem.getAttributeValue(CLASS_ATTR);
            Iterator childIter = elem.getChildren().iterator();
            while (childIter.hasNext()) {
                elem = (Element)childIter.next();
                String name = elem.getName();
                if (DRIVER_ELEM.equals(name)) {
                    this.driverProcessorMap.put(elem.getAttributeValue(CLASS_ATTR), proc);
                    continue;
                }
                if (!OPTION_ELEM.equals(name)) continue;
                HashMap<String, String> importOptionsMap = (HashMap<String, String>)this.processorImportOptionsMap.get(proc);
                if (importOptionsMap == null) {
                    importOptionsMap = new HashMap<String, String>();
                    this.processorImportOptionsMap.put(proc, importOptionsMap);
                }
                importOptionsMap.put(elem.getAttributeValue(NAME_ATTR), elem.getAttributeValue(VAL_ATTR));
            }
        }
    }

    public Map getImportOptions(String className) {
        if (className == null || className.trim().length() == 0) {
            throw new IllegalArgumentException(DQPToolsPlugin.UTIL.getString("JdbcManager.nullClassName"));
        }
        return (Map)this.processorImportOptionsMap.get(className);
    }

    public String getProcessor(String className) {
        if (className == null || className.trim().length() == 0) {
            throw new IllegalArgumentException(DQPToolsPlugin.UTIL.getString("JdbcManager.nullClassName"));
        }
        return (String)this.driverProcessorMap.get(className);
    }

    public Connection createConnection(JdbcSource source, String password) throws JdbcException, SQLException {
        if (source == null) {
            throw new IllegalArgumentException(DQPToolsPlugin.UTIL.getString("JdbcManager.nullSource"));
        }
        JdbcDriver[] drivers = this.mgr.findDrivers(source);
        if (drivers == null || drivers.length == 0) {
            return null;
        }
        if (source.getDriverName().equalsIgnoreCase("Excel")) {
            return (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcManager.class$("java.sql.Connection")) : class$java$sql$Connection}, (InvocationHandler)new ExcelConnectionHandler(this.mgr.createConnection(source, drivers[0], password), source.getUrl()));
        }
        return this.mgr.createConnection(source, drivers[0], password);
    }

    public JdbcSource createSource(String driverName, Properties properties) {
        if (driverName == null || driverName.trim().length() == 0) {
            throw new IllegalArgumentException(DQPToolsPlugin.UTIL.getString("JdbcManager.nullDriver"));
        }
        JdbcSource src = this.mgr.getFactory().createJdbcSource();
        JdbcDriver[] drivers = this.mgr.findDrivers(driverName);
        if (drivers == null || drivers.length == 0) {
            return null;
        }
        JdbcDriver driver = drivers[0];
        String name = driver.getName();
        src.setName(DQPToolsPlugin.UTIL.getString("JdbcManager.connectionInfo", (Object)name));
        src.setDriverName(name);
        src.setDriverClass(driver.getPreferredDriverClassName());
        src.setUrl((String)properties.remove(URL));
        src.setUsername((String)properties.remove(USER));
        properties.remove(PWD);
        EList props = src.getProperties();
        if (properties != null) {
            Iterator<Map.Entry<Object, Object>> iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Object, Object> entry = iter.next();
                this.addProperty(src, (List)props, entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return src;
    }

    private void addProperty(JdbcSource source, List properties, String name, String value) {
        JdbcSourceProperty prop = JdbcFactory.eINSTANCE.createJdbcSourceProperty();
        prop.setSource(source);
        prop.setName(name);
        prop.setValue(value);
        properties.add(prop);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

