/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.ImportJdbcSourceCommand;
import com.metamatrix.dqp.tools.mmshell.ListCommand;
import com.metamatrix.dqp.tools.mmshell.MMShell;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.dqp.tools.mmshell.config.SourceType;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.tools.toolshell.ToolShell;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.ecore.resource.Resource;

public class ImportCommand
extends EmbeddedAdminCommandImpl {
    static final String PATH = DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.path");
    static final String EXCLUDE_PATH = DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.excludepath");
    private static ImportCommand shared;

    public static ImportCommand get() {
        if (shared == null) {
            shared = new ImportCommand();
        }
        return shared;
    }

    public static void saveAndListSource(String source, EmfResource resource, ToolShell shell, String completedMessage) throws Exception {
        VDBContext context = ((MMShell)shell).getVDBContext();
        if (context.saveResource(resource)) {
            context.activate();
            shell.printlnVerbose(DQPToolsPlugin.UTIL.getString(completedMessage, (Object)source));
            ListCommand.get().listAllTables(source);
            shell.printHelp(DQPToolsPlugin.UTIL.getString("ImportCommand.nextSteps", (Object)source));
        }
    }

    public boolean executeCommand(Iterator iterator) throws Exception {
        if (!this.verifyOpen()) {
            return true;
        }
        iterator.next();
        String srcName = this.getSourceName(iterator);
        if (srcName == null) {
            return true;
        }
        if (srcName.equalsIgnoreCase("System")) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("ImportCommand.systemNotImportable"));
            return true;
        }
        VDBContext context = this.getVDBContext();
        EmfResource resrc = (EmfResource)context.findResource(srcName);
        if (resrc == null) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("invalidSource", (Object)srcName));
            return true;
        }
        boolean success = false;
        if (this.isRelational(resrc)) {
            Properties props = ImportCommand.getPropertiesFromArguments(iterator);
            SourceType type = this.getVDBContext().getSourceType(srcName);
            String includePath = type.getIncludePath();
            String excludePath = type.getExcludePath();
            if (!props.containsKey(PATH) && includePath != null && includePath.length() > 0) {
                props.put(PATH, includePath);
            }
            if (!props.contains(EXCLUDE_PATH) && excludePath != null && excludePath.length() > 0) {
                props.put(EXCLUDE_PATH, excludePath);
            }
            success = new ImportJdbcSourceCommand(props, (MMShell)this.toolShell).execute(srcName, (Resource)resrc, context);
        } else {
            this.printlnError("Not yet implemented");
        }
        if (success) {
            ImportCommand.saveAndListSource(srcName, resrc, this.toolShell, "ImportCommand.imported");
        }
        return true;
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("ImportCommand.argHelp");
    }

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("ImportCommand.commandName");
    }

    public String getLongHelp(List argList) {
        StringBuffer sb = new StringBuffer();
        Map options = ImportJdbcSourceCommand.getOptions();
        Iterator iter = options.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            sb.append(DQPToolsPlugin.UTIL.getString("ImportCommand.longHelp.option", entry.getKey(), entry.getValue()));
        }
        return ImportCommand.formatDefinition(DQPToolsPlugin.UTIL.getString("ImportCommand.longHelp", (Object)sb.toString()));
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("ImportCommand.shortHelp");
    }
}

