/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.common.util.VDBNameValidator;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.GetJdbcSourcePropertiesCommand;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public class GetCommand
extends EmbeddedAdminCommandImpl {
    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("GetCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return DQPToolsPlugin.UTIL.getString("GetCommand.longHelp");
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("GetCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("GetCommand.argHelp");
    }

    public boolean executeCommand(Iterator iterator) throws Exception {
        if (!this.verifyOpen()) {
            return true;
        }
        iterator.next();
        String srcName = this.getSourceName(iterator);
        if (srcName == null) {
            return true;
        }
        if (VDBNameValidator.isSourceNameReserved((String)srcName)) {
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("GetCommand.reserved_source", (Object)srcName));
            return true;
        }
        VDBContext context = this.getVDBContext();
        EmfResource resrc = (EmfResource)context.findResource(srcName);
        if (resrc == null) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("GetCommand.invalid_source", (Object)srcName));
            return true;
        }
        if (this.isRelational(resrc)) {
            GetJdbcSourcePropertiesCommand.execute(srcName, (Resource)resrc, this.toolShell, context);
        } else {
            this.printlnError("Not yet implemented");
        }
        return true;
    }
}

