/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.modeler.core.ExternalResourceDescriptor;
import com.metamatrix.modeler.core.MetamodelRootClassDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.core.ExtensionDescriptorImpl;
import com.metamatrix.modeler.internal.core.ExternalResourceDescriptorImpl;
import com.metamatrix.modeler.internal.core.ExternalResourceSetDescriptorImpl;
import com.metamatrix.modeler.internal.core.MappingAdapterDescriptorImpl;
import com.metamatrix.modeler.internal.core.MetamodelDescriptorImpl;
import com.metamatrix.modeler.internal.core.MetamodelRootClassDescriptorImpl;
import com.metamatrix.modeler.internal.core.container.ResourceDescriptorImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class ConfigurationBuilder {
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String PLUGIN_PROPS = "plugin.properties";
    private static final String EXT_ELEM = "extension";
    private static final String ID_ATTR = "id";
    private static final String EXT_PT_ID_ATTR = "point";
    private static final String NAME_ATTR = "name";
    static /* synthetic */ Class class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder;

    private static void addAspect(String extensionPointId, Map extensionPoints, MetamodelDescriptorImpl descriptor, ClassLoader loader) {
        Map extPt = (Map)extensionPoints.get(extensionPointId);
        Iterator extPtIter = extPt.entrySet().iterator();
        while (extPtIter.hasNext()) {
            Element elem;
            Map.Entry entry = extPtIter.next();
            Element ext = (Element)entry.getValue();
            boolean applies = false;
            Iterator extIter = ext.getChildren().iterator();
            while (extIter.hasNext()) {
                elem = (Element)extIter.next();
                if (!"metamodelExtensionID".equals(elem.getName()) || !elem.getTextTrim().equals(descriptor.getExtensionID())) continue;
                applies = true;
                break;
            }
            if (!applies) continue;
            extIter = ext.getChildren().iterator();
            while (extIter.hasNext()) {
                elem = (Element)extIter.next();
                String name = elem.getName();
                if (!"factoryClass".equals(name)) continue;
                String className = elem.getAttributeValue(NAME_ATTR);
                descriptor.addMetamodelAspectClassLoader(extensionPointId, className, loader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void build(String path, boolean debug) throws IOException, JDOMException {
        File folder;
        if (path == null) {
            throw new IllegalArgumentException("The \"" + path + "\" argument must not be null.");
        }
        if (debug) {
            System.out.println("ConfigurationBuilder: path=" + path);
        }
        if (!(folder = new File(path)).exists()) {
            throw new IllegalArgumentException("The folder \"" + path + "\" does not exist.");
        }
        HashMap<String, HashMap<String, Element>> extPts = new HashMap<String, HashMap<String, Element>>();
        File[] folders = folder.listFiles();
        ClassLoader loader = (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder == null ? (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder = ConfigurationBuilder.class$("com.metamatrix.dqp.tools.mmshell.ConfigurationBuilder")) : class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder).getClassLoader();
        URL[] urls = ((URLClassLoader)loader).getURLs();
        boolean testCase = folder.getCanonicalFile().getName().equalsIgnoreCase("plugins");
        int len = folders.length;
        for (int folderNdx = 0; folderNdx < len; ++folderNdx) {
            File file;
            File plugin = folders[folderNdx];
            if (debug) {
                System.out.println("ConfigurationBuilder: plugin=" + plugin);
            }
            if (testCase) {
                boolean inClasspath = false;
                String pluginName = plugin.getName() + '/';
                int urlNdx = urls.length;
                while (--urlNdx >= 0) {
                    String classpath = urls[urlNdx].getPath();
                    if (classpath.indexOf(pluginName) < 0) continue;
                    inClasspath = true;
                    break;
                }
                if (!inClasspath) {
                    if (!debug) continue;
                    System.out.println("ConfigurationBuilder: plugin \"" + plugin + "\" skipped since not in classpath");
                    continue;
                }
            }
            if (!(file = new File(plugin, PLUGIN_XML)).exists()) {
                if (!debug) continue;
                System.out.println("ConfigurationBuilder: plugin \"" + plugin + "\" skipped since it contains no " + PLUGIN_XML);
                continue;
            }
            Properties props = new Properties();
            InputStream stream = null;
            try {
                stream = new FileInputStream(new File(plugin, PLUGIN_PROPS));
                props.load(stream);
            }
            catch (IOException err) {
                if (debug) {
                    System.out.println("ConfigurationBuilder: Error loading plugin.properties for plugin \"" + plugin + "\": " + err.getMessage());
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            try {
                Document doc = new SAXBuilder().build(file);
                Element pluginElem = doc.getRootElement();
                String pluginId = pluginElem.getAttributeValue(ID_ATTR);
                Iterator iter = pluginElem.getChildren(EXT_ELEM).iterator();
                while (iter.hasNext()) {
                    Element ext = (Element)iter.next();
                    String extPtId = ext.getAttributeValue(EXT_PT_ID_ATTR);
                    HashMap<String, Element> extPt = (HashMap<String, Element>)extPts.get(extPtId);
                    if (extPt == null) {
                        extPt = new HashMap<String, Element>();
                        extPts.put(extPtId, extPt);
                    }
                    extPt.put(pluginId + '.' + ext.getAttributeValue(ID_ATTR), ext);
                    if (debug) {
                        System.out.println("ConfigurationBuilder: Added extension \"" + pluginId + '.' + ext.getAttributeValue(ID_ATTR) + "\" to extension point \"" + extPtId + "\".");
                    }
                    if (props.isEmpty()) continue;
                    ConfigurationBuilder.resolveI18nValues(ext, props);
                }
                continue;
            }
            catch (IOException err) {
                throw err;
            }
            catch (Exception err) {
                throw new JDOMException(file + ": " + err.getMessage(), err.getCause());
            }
        }
        ConfigurationBuilder.buildMetamodelDescriptors(extPts);
        ConfigurationBuilder.buildResourceDescriptors(extPts);
        ConfigurationBuilder.buildDatatypeManagerDescriptors(extPts);
        ConfigurationBuilder.buildMappingAdapterDescriptors(extPts);
        ConfigurationBuilder.buildExternalResourceDescriptors(extPts);
        ConfigurationBuilder.buildExternalResourceSetDescriptors(extPts);
    }

    private static void buildDatatypeManagerDescriptors(Map extensionPoints) {
        List descriptors = ModelerCore.getConfiguration().getDatatypeManagerDescriptors();
        Map extPt = (Map)extensionPoints.get("com.metamatrix.modeler.core.datatypeManager");
        ClassLoader loader = (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder == null ? (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder = ConfigurationBuilder.class$("com.metamatrix.dqp.tools.mmshell.ConfigurationBuilder")) : class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder).getClassLoader();
        Iterator extPtIter = extPt.entrySet().iterator();
        block0: while (extPtIter.hasNext()) {
            Map.Entry entry = extPtIter.next();
            Element ext = (Element)entry.getValue();
            Iterator extIter = ext.getChildren().iterator();
            while (extIter.hasNext()) {
                Element elem = (Element)extIter.next();
                if (!"class".equals(elem.getName())) continue;
                String className = elem.getAttributeValue(NAME_ATTR);
                descriptors.add(new ExtensionDescriptorImpl((Object)ext.getAttributeValue(ID_ATTR), className, loader));
                continue block0;
            }
        }
    }

    private static void buildExternalResourceDescriptors(Map extensionPoints) {
        List descriptors = ModelerCore.getConfiguration().getExternalResourceDescriptors();
        Map extPt = (Map)extensionPoints.get("com.metamatrix.modeler.core.externalResource");
        Iterator extPtIter = extPt.entrySet().iterator();
        while (extPtIter.hasNext()) {
            Map.Entry entry = extPtIter.next();
            String pluginId = (String)entry.getKey();
            Element ext = (Element)entry.getValue();
            ExternalResourceDescriptorImpl descriptor = new ExternalResourceDescriptorImpl();
            descriptor.setPluginID(pluginId);
            descriptor.setExtensionID(ext.getAttributeValue(ID_ATTR));
            Iterator extIter = ext.getChildren().iterator();
            while (extIter.hasNext()) {
                Element elem = (Element)extIter.next();
                String name = elem.getName();
                String val = elem.getTextTrim();
                if (val.length() > 0) {
                    if ("resourceName".equals(name)) {
                        descriptor.setResourceName(val);
                        continue;
                    }
                    if ("resourceUrl".equals(name)) {
                        descriptor.setResourceUrl(val);
                        continue;
                    }
                    if ("internalUri".equals(name)) {
                        descriptor.setInternalUri(val);
                        continue;
                    }
                    if (!"priority".equals(name)) continue;
                    descriptor.setPriority(Integer.parseInt(val));
                    continue;
                }
                if (!"properties".equals(name)) continue;
                descriptor.setProperties(ConfigurationBuilder.createProperties(elem));
            }
            descriptors.add(descriptor);
        }
        Collections.sort(descriptors, new Comparator(){

            public int compare(Object object1, Object object2) {
                int priority2;
                int priority1 = ((ExternalResourceDescriptor)object1).getPriority();
                if (priority1 < (priority2 = ((ExternalResourceDescriptor)object2).getPriority())) {
                    return 1;
                }
                if (priority1 > priority2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private static void buildExternalResourceSetDescriptors(Map extensionPoints) {
        List descriptors = ModelerCore.getConfiguration().getExternalResourceSetDescriptors();
        Map extPt = (Map)extensionPoints.get("com.metamatrix.modeler.core.externalResourceSet");
        ClassLoader loader = (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder == null ? (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder = ConfigurationBuilder.class$("com.metamatrix.dqp.tools.mmshell.ConfigurationBuilder")) : class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder).getClassLoader();
        Iterator extPtIter = extPt.entrySet().iterator();
        while (extPtIter.hasNext()) {
            Map.Entry entry = extPtIter.next();
            Element ext = (Element)entry.getValue();
            Properties props = null;
            String className = null;
            Iterator extIter = ext.getChildren().iterator();
            while (extIter.hasNext()) {
                Element elem = (Element)extIter.next();
                String name = elem.getName();
                if ("class".equals(name)) {
                    className = elem.getAttributeValue(NAME_ATTR);
                    continue;
                }
                if (!"properties".equals(name)) continue;
                props = ConfigurationBuilder.createProperties(elem);
            }
            ExternalResourceSetDescriptorImpl descriptor = new ExternalResourceSetDescriptorImpl((Object)ext.getAttributeValue(ID_ATTR), className, loader);
            descriptor.setProperties(props);
            descriptors.add(descriptor);
        }
    }

    private static void buildMappingAdapterDescriptors(Map extensionPoints) {
        List descriptors = ModelerCore.getConfiguration().getMappingAdapterDescriptors();
        Map extPt = (Map)extensionPoints.get("com.metamatrix.modeler.core.eobjectMatcherFactory");
        ClassLoader loader = (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder == null ? (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder = ConfigurationBuilder.class$("com.metamatrix.dqp.tools.mmshell.ConfigurationBuilder")) : class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder).getClassLoader();
        Iterator extPtIter = extPt.entrySet().iterator();
        block0: while (extPtIter.hasNext()) {
            Map.Entry entry = extPtIter.next();
            Element ext = (Element)entry.getValue();
            Iterator extIter = ext.getChildren().iterator();
            while (extIter.hasNext()) {
                Element elem = (Element)extIter.next();
                if (!"class".equals(elem.getName())) continue;
                String className = elem.getAttributeValue(NAME_ATTR);
                descriptors.add(new MappingAdapterDescriptorImpl((Object)ext.getAttributeValue(ID_ATTR), className, loader));
                continue block0;
            }
        }
    }

    private static void buildMetamodelDescriptors(Map extensionPoints) {
        List descriptors = ModelerCore.getConfiguration().getMetamodelDescriptors();
        Map extPt = (Map)extensionPoints.get("com.metamatrix.modeler.core.metamodel");
        ClassLoader loader = (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder == null ? (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder = ConfigurationBuilder.class$("com.metamatrix.dqp.tools.mmshell.ConfigurationBuilder")) : class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder).getClassLoader();
        Iterator extPtIter = extPt.entrySet().iterator();
        while (extPtIter.hasNext()) {
            Map.Entry entry = extPtIter.next();
            String pluginId = (String)entry.getKey();
            Element ext = (Element)entry.getValue();
            MetamodelDescriptorImpl descriptor = new MetamodelDescriptorImpl();
            descriptor.setPluginID(pluginId);
            descriptor.setExtensionID(ext.getAttributeValue(ID_ATTR));
            descriptor.setName(ext.getAttributeValue(NAME_ATTR));
            Iterator extIter = ext.getChildren().iterator();
            while (extIter.hasNext()) {
                String className;
                Element elem = (Element)extIter.next();
                String name = elem.getName();
                String val = elem.getTextTrim();
                if (val.length() > 0) {
                    if ("uri".equals(name)) {
                        descriptor.setURI(val);
                        continue;
                    }
                    if ("alternateUri".equals(name)) {
                        descriptor.addAlternateURI(val);
                        continue;
                    }
                    if ("internalUri".equals(name)) {
                        descriptor.setInternalURI(val);
                        continue;
                    }
                    if ("namespacePrefix".equals(name)) {
                        descriptor.setNamespacePrefix(val);
                        continue;
                    }
                    if ("resource".equals(name)) {
                        descriptor.setResourceURL(val, loader);
                        continue;
                    }
                    if ("allowableModelType".equals(name)) {
                        descriptor.addAllowableModelType(val);
                        continue;
                    }
                    if (!"fileExtension".equals(name)) continue;
                    descriptor.setFileExtension(val);
                    continue;
                }
                if ("factoryClass".equals(name)) {
                    className = elem.getAttributeValue(NAME_ATTR);
                    descriptor.setEFactoryClassLoader(className, loader);
                    continue;
                }
                if ("packageClass".equals(name)) {
                    className = elem.getAttributeValue(NAME_ATTR);
                    descriptor.setEPackageClassLoader(className, loader);
                    continue;
                }
                if ("adapterClass".equals(name)) {
                    className = elem.getAttributeValue(NAME_ATTR);
                    descriptor.setAdapterFactoryClassLoader(className, loader);
                    continue;
                }
                if ("rootEntityClass".equals(name)) {
                    className = elem.getAttributeValue(NAME_ATTR);
                    String maxOccurs = elem.getAttributeValue("maxOccurs");
                    MetamodelRootClassDescriptorImpl rootDescriptor = new MetamodelRootClassDescriptorImpl((Object)"com.metamatrix.modeler.core.metamodel", className, loader);
                    rootDescriptor.setMaxOccurs(maxOccurs);
                    descriptor.addRootClassDescriptor((MetamodelRootClassDescriptor)rootDescriptor);
                    continue;
                }
                if ("properties".equals(name)) {
                    descriptor.setProperties(ConfigurationBuilder.createProperties(elem));
                    continue;
                }
                if (!"initializers".equals(name)) continue;
                Iterator iter = elem.getChildren("initializer").iterator();
                while (iter.hasNext()) {
                    Element initializer = (Element)iter.next();
                    String initializerName = initializer.getAttributeValue(NAME_ATTR);
                    String desc = initializer.getAttributeValue("description");
                    String className2 = initializer.getAttributeValue("class");
                    descriptor.addModelInitializer(initializerName, desc, className2, loader);
                }
            }
            ConfigurationBuilder.addAspect("com.metamatrix.modeler.core.validationAspect", extensionPoints, descriptor, loader);
            ConfigurationBuilder.addAspect("com.metamatrix.modeler.core.sqlAspect", extensionPoints, descriptor, loader);
            ConfigurationBuilder.addAspect("com.metamatrix.modeler.core.importAspect", extensionPoints, descriptor, loader);
            descriptors.add(descriptor);
        }
    }

    private static void buildResourceDescriptors(Map extensionPoints) {
        ClassLoader loader = (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder == null ? (class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder = ConfigurationBuilder.class$("com.metamatrix.dqp.tools.mmshell.ConfigurationBuilder")) : class$com$metamatrix$dqp$tools$mmshell$ConfigurationBuilder).getClassLoader();
        List descriptors = ModelerCore.getConfiguration().getResourceDescriptors();
        Map extPt = (Map)extensionPoints.get("com.metamatrix.modeler.core.resourceFactory");
        Iterator extPtIter = extPt.entrySet().iterator();
        while (extPtIter.hasNext()) {
            Map.Entry entry = extPtIter.next();
            String pluginId = (String)entry.getKey();
            Element ext = (Element)entry.getValue();
            ResourceDescriptorImpl descriptor = new ResourceDescriptorImpl(pluginId);
            List fileExts = descriptor.getExtensions();
            List protocols = descriptor.getProtocols();
            Iterator extIter = ext.getChildren().iterator();
            while (extIter.hasNext()) {
                Element elem = (Element)extIter.next();
                String name = elem.getName();
                String val = elem.getTextTrim();
                if (val.length() > 0) {
                    if ("fileExtension".equals(name)) {
                        fileExts.add(elem.getTextTrim());
                        continue;
                    }
                    if (!"protocol".equals(name)) continue;
                    protocols.add(elem.getTextTrim());
                    continue;
                }
                if (!"class".equals(name)) continue;
                String className = elem.getAttributeValue(NAME_ATTR);
                descriptor.setResourceFactoryClass(className, loader);
            }
            descriptors.add(descriptor);
        }
    }

    private static Properties createProperties(Element element) {
        Properties props = new Properties();
        Iterator iter = element.getAttributes().iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            props.setProperty(attr.getName(), attr.getValue());
        }
        return props;
    }

    private static void resolveI18nValues(Element element, Properties properties) {
        String i18nVal;
        Iterator iter = element.getAttributes().iterator();
        while (iter.hasNext()) {
            String i18nVal2;
            Attribute attr = (Attribute)iter.next();
            String val = attr.getValue();
            if (!val.startsWith("%") || (i18nVal2 = (String)properties.get(val.substring(1))) == null) continue;
            attr.setValue(i18nVal2);
        }
        String val = element.getTextTrim();
        if (val.startsWith("%") && (i18nVal = (String)properties.get(val.substring(1))) != null) {
            element.setText(i18nVal);
        }
        Iterator iter2 = element.getChildren().iterator();
        while (iter2.hasNext()) {
            ConfigurationBuilder.resolveI18nValues((Element)iter2.next(), properties);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

