/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.tools.toolshell.ToolShell;
import java.util.Arrays;
import java.util.LinkedList;

public class ArgReader {
    private static final char OPTION_PREFIX = '-';
    private static final String DEBUG = "-debug";
    private static final String QUIET = "-quiet";
    private static final String VERBOSE = "-verbose";
    private static final String SCRIPT = "-script";
    private static final String COMMAND = "-command";
    public static final int LOG_QUIET = 1;
    public static final int LOG_NORMAL = 0;
    public static final int LOG_VERBOSE = 2;
    public static final int LOG_DEBUG = 3;
    public static final int MODE_INTERACTIVE = 0;
    public static final int MODE_COMMAND_LINE = 1;
    public static final int MODE_SCRIPT_FILE = 2;
    private int logLevel = 0;
    private int mode = 0;
    private String vdb;
    private String scriptFile;
    private String[] command;
    private boolean requestedHelp;

    public ArgReader(String[] args) throws Exception {
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
        if (argList.size() == 0) {
            return;
        }
        if (this.inHelpMode(argList)) {
            this.requestedHelp = true;
            return;
        }
        this.vdb = argList.getFirst();
        if (this.vdb.charAt(0) == '-') {
            this.vdb = null;
        } else {
            argList.removeFirst();
        }
        while (argList.size() > 0) {
            String option = argList.getFirst();
            if (option.charAt(0) == '-') {
                if (option.equalsIgnoreCase(QUIET)) {
                    if (this.logLevel == 2 || this.logLevel == 3) {
                        throw new Exception(DQPToolsPlugin.UTIL.getString("ArgReader.quiet_or_verbose"));
                    }
                    this.logLevel = 1;
                    argList.removeFirst();
                    continue;
                }
                if (option.equalsIgnoreCase(VERBOSE)) {
                    if (this.logLevel == 1 || this.logLevel == 3) {
                        throw new Exception(DQPToolsPlugin.UTIL.getString("ArgReader.quiet_or_verbose"));
                    }
                    this.logLevel = 2;
                    argList.removeFirst();
                    continue;
                }
                if (option.equalsIgnoreCase(DEBUG)) {
                    if (this.logLevel == 1 || this.logLevel == 2) {
                        throw new Exception(DQPToolsPlugin.UTIL.getString("ArgReader.quiet_or_verbose"));
                    }
                    this.logLevel = 3;
                    argList.removeFirst();
                    continue;
                }
                if (option.equalsIgnoreCase(SCRIPT)) {
                    argList.removeFirst();
                    if (argList.size() == 0) {
                        throw new Exception(DQPToolsPlugin.UTIL.getString("ArgReader.script_requires_file"));
                    }
                    this.scriptFile = argList.removeFirst();
                    this.mode = 2;
                    continue;
                }
                if (option.equalsIgnoreCase(COMMAND)) {
                    argList.removeFirst();
                    if (argList.size() == 0) {
                        throw new Exception(DQPToolsPlugin.UTIL.getString("ArgReader.command_requires_command"));
                    }
                    this.command = argList.toArray(new String[argList.size()]);
                    this.mode = 1;
                    return;
                }
                throw new Exception(DQPToolsPlugin.UTIL.getString("ArgReader.invalid_option", (Object)option));
            }
            throw new Exception(DQPToolsPlugin.UTIL.getString("ArgReader.invalid_option", (Object)option));
        }
    }

    private boolean inHelpMode(LinkedList argList) {
        if (argList.size() == 1) {
            String possibleHelp = (String)argList.get(0);
            return ToolShell.isHelpSynonym(possibleHelp);
        }
        return false;
    }

    public String[] getCommand() {
        return this.command;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public boolean isDebug() {
        return this.logLevel == 3;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public int getMode() {
        return this.mode;
    }

    public String getVdb() {
        return this.vdb;
    }

    public boolean requestedHelp() {
        return this.requestedHelp;
    }
}

