/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.util.VDBNameValidator;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.dqp.tools.mmshell.config.TypeManager;
import com.metamatrix.dqp.tools.mmshell.config.TypeProperty;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.JdbcSourceProperty;
import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public final class AddCommand
extends EmbeddedAdminCommandImpl {
    private static final String TEXT_TYPE = "Text";
    private static AddCommand shared;

    public static AddCommand get() {
        if (shared == null) {
            shared = new AddCommand();
        }
        return shared;
    }

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("AddCommand.commandName");
    }

    public String getLongHelp(List argList) {
        StringBuffer help = new StringBuffer(DQPToolsPlugin.UTIL.getString("AddCommand.longHelp"));
        try {
            if (argList.size() <= 1) {
                help.append(DQPToolsPlugin.UTIL.getString("AddCommand.longHelpTypes"));
                help.append(this.getAvailableSourceTypes());
                help.append(DQPToolsPlugin.UTIL.getString("AddCommand.longHelpMore"));
            } else {
                String sourceType = (String)argList.get(1);
                TypeManager typeManager = this.getVDBContext().getTypeManager();
                ComponentType type = typeManager.getConnectorType(sourceType);
                Properties props = type.getDefaultPropertyValues();
                List sourceTypeProps = typeManager.getProperties(sourceType);
                help.append(DQPToolsPlugin.UTIL.getString("AddCommand.longHelpProperties", (Object)sourceType));
                help.append(this.formatProperties(sourceType, props, sourceTypeProps));
            }
        }
        catch (Exception e) {
            this.printlnError(e.getMessage() + this.toolShell.getSystemLineSeparator());
        }
        return help.toString();
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("AddCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("AddCommand.argHelp");
    }

    public boolean executeCommand(Iterator iterator) throws Exception {
        if (!this.verifyOpen()) {
            return true;
        }
        iterator.next();
        String srcName = this.getSourceName(iterator);
        if (srcName == null) {
            this.printlnError("\n" + DQPToolsPlugin.UTIL.getString("AddCommand.shortHelp"));
            this.printlnError(this.getLongHelp(Collections.EMPTY_LIST));
            return true;
        }
        if (!VDBNameValidator.isSourceValid((String)srcName)) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("AddCommand.invalid_source", (Object)srcName));
            return true;
        }
        if (!iterator.hasNext()) {
            this.printlnError("\n" + DQPToolsPlugin.UTIL.getString("AddCommand.error_missing_type"));
            this.printlnError(DQPToolsPlugin.UTIL.getString("AddCommand.shortHelp"));
            this.printlnError(this.getLongHelp(Collections.EMPTY_LIST));
            return true;
        }
        VDBContext context = this.getVDBContext();
        TypeManager typeManager = context.getTypeManager();
        String type = (String)iterator.next();
        ComponentType connectorType = null;
        try {
            connectorType = typeManager.getConnectorType(type);
        }
        catch (Exception e) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("AddCommand.invalid_type", (Object)type));
            this.printlnError(DQPToolsPlugin.UTIL.getString("AddCommand.shortHelp"));
            this.printlnError(this.getLongHelp(Collections.EMPTY_LIST));
            return true;
        }
        Properties props = AddCommand.getPropertiesFromArguments(iterator);
        List typeProperties = typeManager.getProperties(type);
        if (typeProperties != null) {
            Iterator propIter = typeProperties.iterator();
            while (propIter.hasNext()) {
                TypeProperty prop = (TypeProperty)propIter.next();
                if (!prop.isRequired() || props.containsKey(prop.getName().toLowerCase())) continue;
                this.printlnError(DQPToolsPlugin.UTIL.getString("AddCommand.required_prop", (Object)prop.getName(), (Object)type));
                this.printlnVerbose(DQPToolsPlugin.UTIL.getString("AddCommand.longHelpProperties", (Object)type));
                this.printlnVerbose(this.formatProperties(type, connectorType.getDefaultPropertyValues(), typeProperties));
                return true;
            }
        }
        try {
            context.findResource(srcName);
            this.printlnError(DQPToolsPlugin.UTIL.getString("AddCommand.sourceExists", (Object)srcName));
        }
        catch (Exception expected) {
            if (TEXT_TYPE.equalsIgnoreCase(type)) {
                this.printlnError("Not yet implemented");
            } else {
                JdbcManager mgr = JdbcManager.create(context.getConfigDirectory(), context.getContainer());
                JdbcSource src = mgr.createSource(typeManager.getDriverType(type), (Properties)props.clone());
                if (src == null) {
                    this.printlnError(DQPToolsPlugin.UTIL.getString("AddCommand.invalid_type", (Object)type));
                    this.printlnError(DQPToolsPlugin.UTIL.getString("AddCommand.shortHelp"));
                    this.printlnError(this.getLongHelp(Collections.EMPTY_LIST));
                    return true;
                }
                EList sourceProps = src.getProperties();
                JdbcSourceProperty prop = JdbcFactory.eINSTANCE.createJdbcSourceProperty();
                prop.setSource(src);
                prop.setName("sourceType");
                prop.setValue(type);
                sourceProps.add(prop);
                Connection conn = null;
                try {
                    conn = mgr.createConnection(src, props.getProperty(JdbcManager.PWD));
                }
                catch (Exception e) {
                    String LF = this.toolShell.getSystemLineSeparator();
                    StringBuffer error = new StringBuffer(DQPToolsPlugin.UTIL.getString("AddCommand.connect_fail", (Object)srcName) + LF);
                    error.append(e.getMessage() + LF);
                    error.append(LF);
                    ComponentType compType = typeManager.getConnectorType(type);
                    Properties compProps = compType.getDefaultPropertyValues();
                    List sourceTypeProps = typeManager.getProperties(type);
                    error.append(LF);
                    error.append(DQPToolsPlugin.UTIL.getString("AddCommand.longHelpProperties", (Object)type));
                    error.append(this.formatProperties(type, compProps, sourceTypeProps));
                    this.printlnError(error.toString());
                    return true;
                }
                try {
                    conn.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                props.setProperty("MaxResultRows", "0");
                EmfResource resrc = context.createResource(srcName, "http://www.metamatrix.com/metamodels/Relational", type, props);
                resrc.getContents().add((Object)src);
                context.saveResource(resrc);
            }
            context.save();
            this.printHelp(DQPToolsPlugin.UTIL.getString("AddCommand.next_steps", (Object)srcName));
        }
        return true;
    }

    private String getAvailableSourceTypes() {
        StringBuffer sb = new StringBuffer();
        VDBContext context = this.getVDBContext();
        String nl = System.getProperty("line.separator");
        try {
            TypeManager typeManager = context.getTypeManager();
            String[] types = typeManager.getSourceTypeNames();
            for (int i = 0; i < types.length; ++i) {
                sb.append("  - ");
                sb.append(StringUtil.toFixedLength((String)types[i], (int)15));
                sb.append("  ");
                sb.append(typeManager.getDescription(types[i]));
                sb.append(nl);
            }
        }
        catch (Exception e) {
            this.printlnException(e);
            return "";
        }
        return sb.toString();
    }

    private String formatProperties(String sourceType, Properties connectorProps, List sourceTypeProps) {
        StringBuffer example = new StringBuffer("ADD <source> ");
        example.append(sourceType);
        example.append(" ");
        StringBuffer output = new StringBuffer();
        Iterator iter = sourceTypeProps.iterator();
        String LF = this.toolShell.getSystemLineSeparator();
        while (iter.hasNext()) {
            TypeProperty prop = (TypeProperty)iter.next();
            String propName = prop.getName();
            output.append("  - ");
            output.append(propName);
            example.append(propName);
            String defaultValue = connectorProps.getProperty(propName);
            if (defaultValue == null) {
                defaultValue = "<value>";
            } else if (defaultValue.indexOf(32) >= 0) {
                defaultValue = "\"" + defaultValue + "\"";
            }
            output.append("=");
            output.append(defaultValue);
            example.append("=");
            example.append(defaultValue);
            if (prop.isRequired()) {
                output.append(" (required)");
            }
            output.append(LF);
            example.append(" ");
        }
        output.append(LF + DQPToolsPlugin.UTIL.getString("AddCommand.example") + example.toString());
        return output.toString();
    }
}

