/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.xslt;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.xslt.CoreXsltPlugin;
import com.metamatrix.core.xslt.Style;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;

public class XsltTransform {
    private final Style style;

    public XsltTransform(Style style) {
        ArgCheck.isNotNull((Object)style);
        this.style = style;
    }

    protected static Templates getTemplates(Style style) throws IOException, MetaMatrixCoreException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)style);
        StreamSource source = style.getStreamSource();
        Templates templates = CoreXsltPlugin.createFactory().newTemplates(source);
        if (templates == null) {
            throw new TransformerConfigurationException(CoreXsltPlugin.Util.getString("XsltTransform.TransformerFactory_created_a_null_Templates_object"));
        }
        return templates;
    }

    protected Transformer createTransformer() throws MetaMatrixCoreException, TransformerConfigurationException, IOException {
        Templates templates = XsltTransform.getTemplates(this.style);
        Transformer transformer = templates.newTransformer();
        return transformer;
    }

    public void transform(Document sourceDoc, OutputStream output) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        this.transform(sourceDoc, null, output);
    }

    public void transform(Document sourceDoc, Writer writer) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        this.transform(sourceDoc, null, writer);
    }

    public void transform(Document sourceDoc, File outputFile) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        this.transform(sourceDoc, null, outputFile);
    }

    public void transform(Document sourceDoc, String baseUriOfRootNode, OutputStream output) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)sourceDoc);
        ArgCheck.isNotNull((Object)output);
        Source source = CoreXsltPlugin.createSource(sourceDoc, baseUriOfRootNode);
        StreamResult result = new StreamResult(output);
        this.transform(source, result);
    }

    public void transform(Document sourceDoc, String baseUriOfRootNode, Writer writer) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)sourceDoc);
        ArgCheck.isNotNull((Object)writer);
        Source source = CoreXsltPlugin.createSource(sourceDoc, baseUriOfRootNode);
        StreamResult result = new StreamResult(writer);
        this.transform(source, result);
    }

    public void transform(Document sourceDoc, String baseUriOfRootNode, File outputFile) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)sourceDoc);
        ArgCheck.isNotNull((Object)outputFile);
        Source source = CoreXsltPlugin.createSource(sourceDoc, baseUriOfRootNode);
        StreamResult result = new StreamResult(outputFile);
        this.transform(source, result);
    }

    public void transform(File inputFile, OutputStream output) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)inputFile);
        ArgCheck.isNotNull((Object)output);
        StreamSource source = new StreamSource(inputFile);
        StreamResult result = new StreamResult(output);
        this.transform(source, result);
    }

    public void transform(File inputFile, Writer writer) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)inputFile);
        ArgCheck.isNotNull((Object)writer);
        StreamSource source = new StreamSource(inputFile);
        StreamResult result = new StreamResult(writer);
        this.transform(source, result);
    }

    public void transform(File inputFile, File outputFile) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)inputFile);
        ArgCheck.isNotNull((Object)outputFile);
        StreamSource source = new StreamSource(inputFile);
        StreamResult result = new StreamResult(outputFile);
        this.transform(source, result);
    }

    public void transform(InputStream inputStream, OutputStream output) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)inputStream);
        ArgCheck.isNotNull((Object)output);
        StreamSource source = new StreamSource(inputStream);
        StreamResult result = new StreamResult(output);
        this.transform(source, result);
    }

    public void transform(InputStream inputStream, Writer writer) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)inputStream);
        ArgCheck.isNotNull((Object)writer);
        StreamSource source = new StreamSource(inputStream);
        StreamResult result = new StreamResult(writer);
        this.transform(source, result);
    }

    public void transform(InputStream inputStream, File outputFile) throws IOException, MetaMatrixCoreException, TransformerException, TransformerConfigurationException {
        ArgCheck.isNotNull((Object)inputStream);
        ArgCheck.isNotNull((Object)outputFile);
        StreamSource source = new StreamSource(inputStream);
        StreamResult result = new StreamResult(outputFile);
        this.transform(source, result);
    }

    public void transform(Source source, Result result) throws TransformerException, MetaMatrixCoreException, TransformerConfigurationException, IOException {
        ArgCheck.isNotNull((Object)source);
        ArgCheck.isNotNull((Object)result);
        Transformer transformer = this.createTransformer();
        try {
            transformer.transform(source, result);
        }
        catch (Throwable e) {
            String msg = CoreXsltPlugin.Util.getString("XsltTransform.Error_applying_the_XSLT_transform");
            throw new MetaMatrixCoreException(e, msg);
        }
    }
}

