/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.xslt;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.PluginUtilImpl;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.jdom.DocumentWrapper;
import org.eclipse.core.runtime.Plugin;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;
import org.osgi.framework.BundleContext;

public class CoreXsltPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.metamatrix.core.xslt";
    private static final String BUNDLE_NAME = "com.metamatrix.core.xslt.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.core.xslt", "com.metamatrix.core.xslt.i18n", ResourceBundle.getBundle("com.metamatrix.core.xslt.i18n"));
    public static boolean DEBUG = false;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public static TransformerFactory createFactory() throws TransformerFactoryConfigurationError {
        TransformerFactoryImpl factory = new TransformerFactoryImpl();
        return factory;
    }

    public static Source createSource(Document sourceDoc, String baseUriOfRootNode) throws MetaMatrixCoreException {
        ArgCheck.isNotNull((Object)sourceDoc);
        Object source = null;
        if (baseUriOfRootNode == null) {
            StringReader transformSource = null;
            try {
                XMLOutputter xmlOutputter = new XMLOutputter();
                StringWriter sourceOut = new StringWriter();
                xmlOutputter.output(sourceDoc, (Writer)sourceOut);
                transformSource = new StringReader(sourceOut.toString());
                source = new StreamSource(transformSource);
            }
            catch (Throwable e) {
                String msg = Util.getString("CoreXsltPlugin.Error_loading_the_XSLT_transform");
                throw new MetaMatrixCoreException(e, msg);
            }
        } else {
            Configuration config = new Configuration();
            config.setRecoveryPolicy(0);
            source = new DocumentWrapper(sourceDoc, baseUriOfRootNode, config);
        }
        return source;
    }
}

