/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.util;

import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.connector.jdbc.extension.ValueTranslator;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;

public class ValueTranslatorAdaptor
implements ValueTranslator {
    private Transform transform;
    private ConnectorEnvironment env;

    public ValueTranslatorAdaptor(Transform transform) {
        this.transform = transform;
    }

    public void initialize(ConnectorEnvironment env) {
        this.env = env;
    }

    public Class getSourceType() {
        return this.transform.getSourceType();
    }

    public Class getTargetType() {
        return this.transform.getTargetType();
    }

    public Object translate(Object value, ExecutionContext context) throws ConnectorException {
        try {
            return this.transform.transform(value);
        }
        catch (TransformationException e) {
            if (this.env != null) {
                this.env.getLogger().logError(e.getMessage(), (Throwable)e);
            }
            throw new ConnectorException(e.getMessage());
        }
    }
}

