/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.util;

import com.metamatrix.connector.jdbc.extension.FunctionModifier;
import com.metamatrix.data.language.IAggregate;
import com.metamatrix.data.language.ICaseExpression;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IGroupBy;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ISearchedCaseExpression;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.language.ISubqueryInCriteria;
import com.metamatrix.data.visitor.framework.HierarchyVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FunctionReplacementVisitor
extends HierarchyVisitor {
    private Map functionModifiers;

    public FunctionReplacementVisitor(Map functionModifiers) {
        this.functionModifiers = functionModifiers;
    }

    public void visit(IAggregate obj) {
        super.visit(obj);
        obj.setExpression(this.replaceFunction(obj.getExpression()));
    }

    public void visit(ICaseExpression obj) {
        int i;
        super.visit(obj);
        obj.setExpression(this.replaceFunction(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        for (i = 0; i < whenCount; ++i) {
            obj.setWhenExpression(i, this.replaceFunction(obj.getWhenExpression(i)));
        }
        for (i = 0; i < whenCount; ++i) {
            obj.setThenExpression(i, this.replaceFunction(obj.getThenExpression(i)));
        }
        obj.setElseExpression(this.replaceFunction(obj.getElseExpression()));
    }

    public void visit(ICompareCriteria obj) {
        super.visit(obj);
        obj.setLeftExpression(this.replaceFunction(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceFunction(obj.getRightExpression()));
    }

    public void visit(IFunction obj) {
        super.visit(obj);
        IExpression[] args = obj.getParameters();
        IExpression[] newArgs = new IExpression[args.length];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = this.replaceFunction(args[i]);
        }
        obj.setParameters(newArgs);
    }

    public void visit(IGroupBy obj) {
        super.visit(obj);
        List expressions = obj.getElements();
        for (int i = 0; i < expressions.size(); ++i) {
            IExpression expression = (IExpression)expressions.get(i);
            expressions.set(i, this.replaceFunction(expression));
        }
        obj.setElements(expressions);
    }

    public void visit(IInCriteria obj) {
        super.visit(obj);
        obj.setLeftExpression(this.replaceFunction(obj.getLeftExpression()));
        List rightExprs = obj.getRightExpressions();
        ArrayList<IExpression> newRightExprs = new ArrayList<IExpression>(rightExprs.size());
        for (int i = 0; i < rightExprs.size(); ++i) {
            IExpression expr = (IExpression)rightExprs.get(i);
            newRightExprs.add(this.replaceFunction(expr));
        }
        obj.setRightExpressions(newRightExprs);
    }

    public void visit(IInsert obj) {
        super.visit(obj);
        List values = obj.getValues();
        ArrayList<IExpression> newValues = new ArrayList<IExpression>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            IExpression expr = (IExpression)values.get(i);
            newValues.add(this.replaceFunction(expr));
        }
        obj.setValues(newValues);
    }

    public void visit(IIsNullCriteria obj) {
        super.visit(obj);
        obj.setExpression(this.replaceFunction(obj.getExpression()));
    }

    public void visit(ILikeCriteria obj) {
        super.visit(obj);
        obj.setLeftExpression(this.replaceFunction(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceFunction(obj.getRightExpression()));
    }

    public void visit(ISearchedCaseExpression obj) {
        super.visit(obj);
        int whenCount = obj.getWhenCount();
        for (int i = 0; i < whenCount; ++i) {
            obj.setThenExpression(i, this.replaceFunction(obj.getThenExpression(i)));
        }
        obj.setElseExpression(this.replaceFunction(obj.getElseExpression()));
    }

    public void visit(ISelectSymbol obj) {
        super.visit(obj);
        obj.setExpression(this.replaceFunction(obj.getExpression()));
    }

    public void visit(ISubqueryCompareCriteria obj) {
        super.visit(obj);
        obj.setLeftExpression(this.replaceFunction(obj.getLeftExpression()));
    }

    public void visit(ISubqueryInCriteria obj) {
        super.visit(obj);
        obj.setLeftExpression(this.replaceFunction(obj.getLeftExpression()));
    }

    private IExpression replaceFunction(IExpression expression) {
        IFunction function;
        String key;
        if (this.functionModifiers != null && expression != null && expression instanceof IFunction && this.functionModifiers.containsKey(key = (function = (IFunction)expression).getName().toLowerCase())) {
            FunctionModifier modifier = (FunctionModifier)this.functionModifiers.get(key);
            return modifier.modify(function);
        }
        return expression;
    }
}

