/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.sybase;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.sybase.Sybase11JoinCriteriaCollectorVisitor;
import com.metamatrix.connector.jdbc.sybase.Sybase11JoinPatternCollapserVisitor;
import com.metamatrix.connector.jdbc.sybase.Sybase11SQLConversionVisitor;
import com.metamatrix.connector.jdbc.sybase.SybaseSQLTranslator;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IFromItem;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.LanguageUtil;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Sybase11SQLTranslator
extends SybaseSQLTranslator {
    public SQLConversionVisitor getTranslationVisitor() {
        Sybase11SQLConversionVisitor visitor = new Sybase11SQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.getFunctionModifiers());
        visitor.setProperties(this.getConnectorEnvironment().getProperties());
        visitor.setLanguageFactory(this.getConnectorEnvironment().getLanguageFactory());
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }

    public ICommand modifyCommand(ICommand command, ExecutionContext context) throws ConnectorException {
        if ((command = super.modifyCommand(command, context)) instanceof IQuery) {
            command = this.removeJoinPredicates(command);
        }
        return command;
    }

    private ICommand removeJoinPredicates(ICommand command) {
        Sybase11JoinCriteriaCollectorVisitor joinCriteriaCollectorVisitor = new Sybase11JoinCriteriaCollectorVisitor(this.getConnectorEnvironment().getLanguageFactory());
        LinkedList joinCriterias = this.collectJoinCriterias(command, joinCriteriaCollectorVisitor);
        command = this.copyGroupsFromJoinPredicatesToFromClause(command);
        IQuery query = (IQuery)command;
        IFrom from = query.getFrom();
        List clauses = from.getItems();
        Iterator i = clauses.iterator();
        ArrayList<IFromItem> newClauses = new ArrayList<IFromItem>(clauses.size());
        while (i.hasNext()) {
            IFromItem fromClause = (IFromItem)i.next();
            if (fromClause instanceof IJoin) continue;
            newClauses.add(fromClause);
        }
        IFrom replacementFrom = this.getConnectorEnvironment().getLanguageFactory().createFrom(newClauses);
        query.setFrom(replacementFrom);
        command = this.moveJoinCriteriaToWhereClause(joinCriterias, command);
        LinkedList innerGroupSymbols = joinCriteriaCollectorVisitor.getGroupSymbolsToDecorate();
        Sybase11JoinPatternCollapserVisitor sybase11JoinPatternCollapserVisitor = new Sybase11JoinPatternCollapserVisitor(innerGroupSymbols);
        command.acceptVisitor((LanguageObjectVisitor)sybase11JoinPatternCollapserVisitor);
        return command;
    }

    private LinkedList collectJoinCriterias(ICommand command, Sybase11JoinCriteriaCollectorVisitor joinCriteriaCollectorVisitor) {
        command.acceptVisitor((LanguageObjectVisitor)joinCriteriaCollectorVisitor);
        return joinCriteriaCollectorVisitor.getCriteriaList();
    }

    private ICommand copyGroupsFromJoinPredicatesToFromClause(ICommand command) {
        IQuery query = (IQuery)command;
        IFrom from = query.getFrom();
        List groups = from.getItems();
        LinkedList<IFromItem> queue = new LinkedList<IFromItem>();
        queue.addAll(groups);
        LinkedList additionalClauses = new LinkedList();
        while (!queue.isEmpty()) {
            Object fromItem = queue.removeFirst();
            if (fromItem instanceof IJoin) {
                IJoin join = (IJoin)fromItem;
                queue.add(join.getLeftItem());
                queue.add(join.getRightItem());
                continue;
            }
            additionalClauses.add(fromItem);
        }
        from.setItems(additionalClauses);
        return command;
    }

    private ICommand moveJoinCriteriaToWhereClause(LinkedList joinCriterias, ICommand command) {
        IQuery query = (IQuery)command;
        ICriteria criteria = query.getWhere();
        Iterator criterias = joinCriterias.iterator();
        while (criterias.hasNext()) {
            ICriteria nextCriteria = (ICriteria)criterias.next();
            criteria = LanguageUtil.combineCriteria((ICriteria)criteria, (ICriteria)nextCriteria, (ILanguageFactory)this.getConnectorEnvironment().getLanguageFactory());
        }
        query.setWhere(criteria);
        return command;
    }
}

