/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.sqlserver;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import java.sql.Time;

public class SqlServerSQLConversionVisitor
extends SQLConversionVisitor {
    private final int MAX_SELECT_ALIAS_LENGTH = 30;
    private final int MAX_TABLE_ALIAS_LENGTH = 128;
    private int limit = 0;

    public void visit(IFunction obj) {
        if (obj.getName().equals("%")) {
            String name = obj.getName();
            IExpression[] args = obj.getParameters();
            this.buffer.append("(");
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    this.append((ILanguageObject)args[i]);
                    if (i >= args.length - 1) continue;
                    this.buffer.append(" ");
                    this.buffer.append(name);
                    this.buffer.append(" ");
                }
            }
            this.buffer.append(")");
        } else {
            super.visit(obj);
        }
    }

    public void visit(ILimit obj) {
    }

    protected void appendQuery(IQuery obj) {
        if (obj.getLimit() != null) {
            this.limit = obj.getLimit().getRowLimit();
        }
        super.appendQuery(obj);
    }

    protected void visitSelect(ISelect obj) {
        this.buffer.append("SELECT").append(" ");
        if (this.limit > 0) {
            this.buffer.append("TOP").append(" ").append(this.limit).append(" ");
            this.limit = 0;
        }
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        this.append(obj.getSelectSymbols());
    }

    protected String translateLiteralTime(Time timeValue) {
        return "{ts'1900-01-01 " + this.formatDateValue(timeValue) + "'}";
    }

    protected int getMaxSelectAliasLength() {
        return 30;
    }

    protected int getMaxTableAliasLength() {
        return 128;
    }
}

