/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.postgresql;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.data.language.IAggregate;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILimit;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

class PostgreSQLConversionVisitor
extends SQLConversionVisitor {
    static /* synthetic */ Class class$java$lang$Boolean;

    PostgreSQLConversionVisitor() {
    }

    protected String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "TRUE";
        }
        return "FALSE";
    }

    protected String translateLiteralDate(Date dateValue) {
        return "DATE '" + dateValue.toString() + "'";
    }

    protected String translateLiteralTime(Time timeValue) {
        return "TIME '" + timeValue.toString() + "'";
    }

    protected String translateLiteralTimestamp(Timestamp timestampValue) {
        SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.getDatabaseTimeZone() != null) {
            timestampFormatter.setTimeZone(this.getDatabaseTimeZone());
        }
        int nanos = timestampValue.getNanos();
        int micros = nanos / 1000;
        String microsStr = "" + (1000000 + micros);
        return "to_timestamp('" + timestampFormatter.format(timestampValue) + "." + microsStr.substring(1) + "', 'YYYY-MM-DD HH24:MI:SS.UF')";
    }

    public void visit(IAggregate obj) {
        if ((obj.getName().equalsIgnoreCase("min") || obj.getName().equalsIgnoreCase("max")) && obj.getExpression().getType().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PostgreSQLConversionVisitor.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            this.buffer.append("CASE").append(" ").append(obj.getName()).append("(").append("CASE").append(" ");
            this.append((ILanguageObject)obj.getExpression());
            this.buffer.append(" ").append("WHEN").append(" ").append("TRUE").append(" ").append("THEN").append(" ").append(1).append(" ").append("ELSE").append(" ").append(0).append(" ").append("END").append(")").append(" ").append("WHEN").append(" ").append(1).append(" ").append("THEN").append(" ").append("TRUE").append(" ").append("ELSE").append(" ").append("FALSE").append(" ").append("END");
        } else {
            super.visit(obj);
        }
    }

    public void visit(ILimit obj) {
        if (obj.getRowLimit() > 0) {
            this.buffer.append("LIMIT").append(" ").append(obj.getRowLimit());
        }
        if (obj.getRowOffset() > 0) {
            if (obj.getRowLimit() > 0) {
                this.buffer.append(" ");
            }
            this.buffer.append("OFFSET").append(" ").append(obj.getRowOffset());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

