/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.connector.jdbc.oracle.Oracle8Element;
import com.metamatrix.data.language.ICaseExpression;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ISearchedCaseExpression;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.language.ISubqueryInCriteria;
import com.metamatrix.data.visitor.framework.AbstractLanguageVisitor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Oracle8ElementSymbolReplacementVisitor
extends AbstractLanguageVisitor {
    private List innerGroupSymbols;

    public Oracle8ElementSymbolReplacementVisitor(List innerGroupSymbols) {
        this.innerGroupSymbols = innerGroupSymbols;
    }

    public void visit(ICompareCriteria compareCriteria) {
        IExpression leftExpression = compareCriteria.getLeftExpression();
        boolean leftNeeds = this.needsConversion(leftExpression);
        IExpression rightExpression = compareCriteria.getRightExpression();
        boolean rightNeeds = this.needsConversion(rightExpression);
        if (leftNeeds) {
            if (rightNeeds) {
                compareCriteria.setRightExpression(this.convertExpression(rightExpression));
            } else {
                compareCriteria.setLeftExpression(this.convertExpression(leftExpression));
            }
        } else if (rightNeeds) {
            compareCriteria.setRightExpression(this.convertExpression(rightExpression));
        }
    }

    public void visit(IIsNullCriteria nullCriteria) {
        IExpression expression = nullCriteria.getExpression();
        if (this.needsConversion(expression)) {
            nullCriteria.setExpression(this.convertExpression(expression));
        }
    }

    public void visit(IFunction function) {
        IExpression[] expressions = function.getParameters();
        for (int i = 0; i < expressions.length; ++i) {
            if (!this.needsConversion(expressions[i])) continue;
            expressions[i] = this.convertExpression(expressions[i]);
        }
        function.setParameters(expressions);
    }

    public void visit(ILikeCriteria matchCriteria) {
        IExpression leftExpression = matchCriteria.getLeftExpression();
        boolean leftNeeds = this.needsConversion(leftExpression);
        IExpression rightExpression = matchCriteria.getRightExpression();
        boolean rightNeeds = this.needsConversion(rightExpression);
        if (leftNeeds) {
            if (rightNeeds) {
                matchCriteria.setRightExpression(this.convertExpression(rightExpression));
            } else {
                matchCriteria.setLeftExpression(this.convertExpression(leftExpression));
            }
        } else if (rightNeeds) {
            matchCriteria.setRightExpression(this.convertExpression(rightExpression));
        }
    }

    public void visit(IInCriteria setCriteria) {
        IExpression expression = setCriteria.getLeftExpression();
        if (this.needsConversion(expression)) {
            setCriteria.setLeftExpression(this.convertExpression(expression));
        }
        LinkedList<IExpression> values = new LinkedList<IExpression>();
        Iterator expressionsIterator = setCriteria.getRightExpressions().iterator();
        while (expressionsIterator.hasNext()) {
            IExpression setExpression = (IExpression)expressionsIterator.next();
            if (this.needsConversion(setExpression)) {
                setExpression = this.convertExpression(setExpression);
            }
            values.add(setExpression);
        }
        setCriteria.setRightExpressions(values);
    }

    public void visit(ICaseExpression obj) {
        int i;
        IExpression expr = obj.getExpression();
        if (this.needsConversion(expr)) {
            obj.setExpression(this.convertExpression(expr));
        }
        for (i = 0; i < obj.getWhenCount(); ++i) {
            IExpression whenExpr = obj.getWhenExpression(i);
            if (!this.needsConversion(whenExpr)) continue;
            obj.setWhenExpression(i, this.convertExpression(whenExpr));
        }
        for (i = 0; i < obj.getWhenCount(); ++i) {
            IExpression thenExpr = obj.getThenExpression(i);
            if (!this.needsConversion(thenExpr)) continue;
            obj.setThenExpression(i, this.convertExpression(thenExpr));
        }
        IExpression elseExpr = obj.getElseExpression();
        if (this.needsConversion(elseExpr)) {
            obj.setElseExpression(this.convertExpression(elseExpr));
        }
    }

    public void visit(ISearchedCaseExpression obj) {
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            IExpression thenExpr = obj.getThenExpression(i);
            if (!this.needsConversion(thenExpr)) continue;
            obj.setThenExpression(i, this.convertExpression(thenExpr));
        }
        IExpression elseExpr = obj.getElseExpression();
        if (this.needsConversion(elseExpr)) {
            obj.setElseExpression(this.convertExpression(elseExpr));
        }
    }

    public void visit(ISubqueryCompareCriteria obj) {
        IExpression expression = obj.getLeftExpression();
        if (this.needsConversion(expression)) {
            obj.setLeftExpression(this.convertExpression(expression));
        }
    }

    public void visit(ISubqueryInCriteria obj) {
        IExpression expression = obj.getLeftExpression();
        if (this.needsConversion(expression)) {
            obj.setLeftExpression(this.convertExpression(expression));
        }
    }

    private boolean needsConversion(IExpression expression) {
        return expression instanceof IElement && this.innerGroupSymbols.contains(((IElement)expression).getGroup());
    }

    private IExpression convertExpression(IExpression expression) {
        return new Oracle8Element((IElement)expression);
    }
}

