/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.connector.jdbc.oracle.Oracle8Element;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.INotCriteria;
import com.metamatrix.data.language.IPredicateCriteria;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.visitor.framework.AbstractLanguageVisitor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Oracle8CriteriaPatternReplacementVisitor
extends AbstractLanguageVisitor {
    private List innerGroupSymbols;

    public Oracle8CriteriaPatternReplacementVisitor(List innerGroupSymbols) {
        this.innerGroupSymbols = innerGroupSymbols;
    }

    public void visit(ICompoundCriteria compoundCriteria) {
        List criteriaList = compoundCriteria.getCriteria();
        Iterator criteriaIterator = criteriaList.iterator();
        LinkedList<ICriteria> replacementCriteria = new LinkedList<ICriteria>();
        while (criteriaIterator.hasNext()) {
            ICriteria criteria = (ICriteria)criteriaIterator.next();
            if (criteria instanceof ICompoundCriteria) {
                ICompoundCriteria crit = (ICompoundCriteria)criteria;
                replacementCriteria.add(this.convertOuterJoinPattern(crit));
                continue;
            }
            replacementCriteria.add(criteria);
        }
        compoundCriteria.setCriteria(replacementCriteria);
    }

    public void visit(INotCriteria notCriteria) {
        ICriteria criteria = notCriteria.getCriteria();
        if (criteria instanceof ICompoundCriteria) {
            notCriteria.setCriteria(this.convertOuterJoinPattern((ICompoundCriteria)criteria));
        }
    }

    public void visit(IQuery query) {
        ICriteria criteria = query.getWhere();
        if (criteria instanceof ICompoundCriteria) {
            query.setWhere(this.convertOuterJoinPattern((ICompoundCriteria)criteria));
        }
    }

    private ICriteria convertOuterJoinPattern(ICompoundCriteria compoundCriteria) {
        List criteria;
        ICompoundCriteria returnObject = compoundCriteria;
        if (compoundCriteria.getOperator() == 1 && (criteria = compoundCriteria.getCriteria()).get(0) instanceof IPredicateCriteria && criteria.get(1) instanceof IIsNullCriteria && ((IIsNullCriteria)criteria.get(1)).getExpression() instanceof IElement) {
            ILikeCriteria matchCriteria;
            IPredicateCriteria predicateCriteria = (IPredicateCriteria)criteria.get(0);
            IIsNullCriteria isNullCriteria = (IIsNullCriteria)criteria.get(1);
            IElement nullElementSymbol = (IElement)isNullCriteria.getExpression();
            IElement predicateElementSymbol = null;
            if (predicateCriteria instanceof ICompareCriteria && ((ICompareCriteria)predicateCriteria).getLeftExpression() instanceof IElement) {
                ICompareCriteria compareCriteria = (ICompareCriteria)predicateCriteria;
                predicateElementSymbol = (IElement)compareCriteria.getLeftExpression();
                if (nullElementSymbol.equals(predicateElementSymbol) && this.innerGroupSymbols.contains(nullElementSymbol.getGroup())) {
                    predicateElementSymbol = new Oracle8Element(predicateElementSymbol);
                    compareCriteria.setLeftExpression((IExpression)predicateElementSymbol);
                    returnObject = compareCriteria;
                }
            } else if (predicateCriteria instanceof IInCriteria && ((IInCriteria)predicateCriteria).getLeftExpression() instanceof IElement) {
                IInCriteria setCriteria = (IInCriteria)predicateCriteria;
                predicateElementSymbol = (IElement)setCriteria.getLeftExpression();
                if (nullElementSymbol.equals(predicateElementSymbol) && this.innerGroupSymbols.contains(nullElementSymbol.getGroup())) {
                    predicateElementSymbol = new Oracle8Element(predicateElementSymbol);
                    setCriteria.setLeftExpression((IExpression)predicateElementSymbol);
                    returnObject = setCriteria;
                }
            } else if (predicateCriteria instanceof ILikeCriteria && ((ILikeCriteria)predicateCriteria).getLeftExpression() instanceof IElement && nullElementSymbol.equals(predicateElementSymbol = (IElement)(matchCriteria = (ILikeCriteria)predicateCriteria).getLeftExpression()) && this.innerGroupSymbols.contains(nullElementSymbol.getGroup())) {
                predicateElementSymbol = new Oracle8Element(predicateElementSymbol);
                matchCriteria.setLeftExpression((IExpression)predicateElementSymbol);
                returnObject = matchCriteria;
            }
        }
        return returnObject;
    }
}

