/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.mysql;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IOrderByItem;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IUnion;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;

class MySQLConversionVisitor
extends SQLConversionVisitor {
    static final String NO_LIMIT = "18446744073709551615";

    MySQLConversionVisitor() {
    }

    protected String translateLiteralDate(Date dateValue) {
        return "DATE('" + this.formatDateValue(dateValue) + "')";
    }

    protected String translateLiteralTime(Time timeValue) {
        return "TIME('" + this.formatDateValue(timeValue) + "')";
    }

    protected String translateLiteralTimestamp(Timestamp timestampValue) {
        return "TIMESTAMP('" + this.formatDateValue(timestampValue) + "')";
    }

    protected String formatDateValue(Object dateObject) {
        if (dateObject instanceof Timestamp) {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (this.getDatabaseTimeZone() != null) {
                timestampFormatter.setTimeZone(this.getDatabaseTimeZone());
            }
            Timestamp ts = (Timestamp)dateObject;
            int nanos = ts.getNanos();
            int micros = nanos / 1000;
            String microsStr = "" + (1000000 + micros);
            return timestampFormatter.format(ts) + "." + microsStr.substring(1);
        }
        return super.formatDateValue(dateObject);
    }

    public void visit(IUnion obj) {
        boolean hasUnionOrderBy;
        IOrderBy orderBy = obj.getUnionOrderBy();
        boolean bl = hasUnionOrderBy = orderBy != null && orderBy.getItems() != null && !orderBy.getItems().isEmpty();
        if (hasUnionOrderBy) {
            this.buffer.append("(");
            this.appendQuery((IQuery)obj);
            this.buffer.append(")");
            Iterator queryIter = obj.getUnionQueries().iterator();
            Iterator allIter = obj.getUnionAllFlags().iterator();
            while (queryIter.hasNext()) {
                this.buffer.append(" ");
                this.buffer.append("UNION");
                Boolean allFlag = (Boolean)allIter.next();
                if (allFlag.equals(Boolean.TRUE)) {
                    this.buffer.append(" ");
                    this.buffer.append("ALL");
                }
                this.buffer.append(" ");
                IQuery query = (IQuery)queryIter.next();
                this.buffer.append("(");
                if (query instanceof IUnion) {
                    this.append((ILanguageObject)query);
                } else {
                    this.appendQuery(query);
                }
                this.buffer.append(")");
            }
            this.buffer.append(" ");
            this.appendUnionOrderBy(orderBy);
        } else {
            super.visit(obj);
        }
    }

    protected void appendUnionOrderBy(IOrderBy obj) {
        this.buffer.append("ORDER").append(" ").append("BY").append(" ");
        List items = obj.getItems();
        Iterator iter = items.iterator();
        IOrderByItem item = (IOrderByItem)iter.next();
        this.appendUnionOrderByItem(item);
        while (iter.hasNext()) {
            this.buffer.append(",");
            this.buffer.append(" ");
            this.appendUnionOrderByItem((IOrderByItem)iter.next());
        }
    }

    protected void appendUnionOrderByItem(IOrderByItem obj) {
        IElement element;
        String itemName = obj.getName();
        if (obj.getElement() != null && (element = obj.getElement()).getMetadataID() != null) {
            itemName = this.getName(element.getMetadataID());
        }
        this.buffer.append(this.getShortName(itemName));
        if (!obj.getDirection()) {
            this.buffer.append(" ").append("DESC");
        }
    }

    private String getShortName(String name) {
        int lastDot = name.lastIndexOf(".");
        if (lastDot >= 0) {
            return name.substring(lastDot + 1);
        }
        return name;
    }

    public void visit(ILimit obj) {
        this.buffer.append("LIMIT").append(" ");
        if (obj.getRowOffset() > 0) {
            this.buffer.append(obj.getRowOffset()).append(",").append(" ");
        }
        if (obj.getRowLimit() > 0) {
            this.buffer.append(obj.getRowLimit());
        } else {
            this.buffer.append(NO_LIMIT);
        }
    }
}

