/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension.impl;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.ClobValueReference;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ValueTranslator;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.exception.ConnectorException;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobValueTranslator
implements ValueTranslator {
    private int maxClobChars;
    private ConnectorEnvironment environment;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$com$metamatrix$common$types$ClobType;

    public void initialize(ConnectorEnvironment env) {
        this.environment = env;
        String propStr = env.getProperties().getProperty("MaxClobChars");
        if (propStr != null) {
            this.maxClobChars = Integer.parseInt(propStr);
        }
    }

    public Class getSourceType() {
        return class$java$sql$Clob == null ? (class$java$sql$Clob = ClobValueTranslator.class$("java.sql.Clob")) : class$java$sql$Clob;
    }

    public Class getTargetType() {
        return class$com$metamatrix$common$types$ClobType == null ? (class$com$metamatrix$common$types$ClobType = ClobValueTranslator.class$("com.metamatrix.common.types.ClobType")) : class$com$metamatrix$common$types$ClobType;
    }

    public Object translate(Object value, ExecutionContext context) throws ConnectorException {
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                if (this.maxClobChars != 0 && clob.length() > (long)this.maxClobChars) {
                    throw new ConnectorException(JDBCPlugin.Util.getString("JDBCTranslator.Retrieved_Clob_is_too_large__18", this.maxClobChars));
                }
                return this.environment.createValueReferenceReplacement((ValueReference)new ClobValueReference(clob, clob.length()), context);
            }
            catch (SQLException e) {
                throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e), JDBCPlugin.Util.getString("JDBCTranslator.Error_determining_clob_length___20", (Object)e.getMessage()));
            }
        }
        char[] chars = (char[])value;
        if (this.maxClobChars != 0 && chars.length > this.maxClobChars) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCTranslator.Retrieved_Clob_is_too_large__18", this.maxClobChars));
        }
        return this.environment.createValueReferenceReplacement((ValueReference)new ClobValueReference(chars, chars.length), context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

