/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension.impl;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ResultsTranslator;
import com.metamatrix.connector.jdbc.extension.TranslatedCommand;
import com.metamatrix.connector.jdbc.extension.ValueRetriever;
import com.metamatrix.connector.jdbc.extension.ValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.BasicValueRetriever;
import com.metamatrix.connector.jdbc.extension.impl.BlobValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.ClobToStringValueTranslator;
import com.metamatrix.connector.jdbc.extension.impl.ClobValueTranslator;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IParameter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class BasicResultsTranslator
implements ResultsTranslator {
    private static final TimeZone LOCAL_TIME_ZONE = TimeZone.getDefault();
    private List valueTranslators = new ArrayList();
    private ValueRetriever valueRetriever = new BasicValueRetriever();
    private TimeZone dbmsTimeZone = null;
    private int maxResultRows = 0;
    private int fetchSize = 0;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        String fetchSizeString;
        String maxResultRowsString = env.getProperties().getProperty("MaxResultRows");
        if (maxResultRowsString != null && maxResultRowsString.trim().length() > 0) {
            try {
                this.maxResultRows = Integer.parseInt(maxResultRowsString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((fetchSizeString = env.getProperties().getProperty("FetchSize")) != null && fetchSizeString.trim().length() > 0) {
            try {
                this.fetchSize = Integer.parseInt(fetchSizeString);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{"FetchSize"};
                String msg = JDBCPlugin.Util.getString("BasicResultsTranslator.Couldn__t_parse_property", params);
                env.getLogger().logWarning(msg);
            }
        }
        ValueTranslator valueTranslator = new BlobValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        valueTranslator = new ClobValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        valueTranslator = new ClobToStringValueTranslator();
        valueTranslator.initialize(env);
        this.valueTranslators.add(valueTranslator);
        String timeZone = env.getProperties().getProperty("DatabaseTimeZone");
        if (timeZone != null && timeZone.trim().length() > 0 && !LOCAL_TIME_ZONE.equals(timeZone)) {
            this.dbmsTimeZone = TimeZone.getTimeZone(timeZone);
        }
    }

    public ResultSet executeStoredProcedure(CallableStatement statement, TranslatedCommand command) throws SQLException {
        int update_count;
        List params = command.getPreparedValues();
        int index = 1;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            IParameter param = (IParameter)iter.next();
            if (param.getDirection() != 3) continue;
            this.registerSpecificTypeOfOutParameter(statement, param, index++);
        }
        Calendar cal = null;
        if (this.dbmsTimeZone != null) {
            cal = Calendar.getInstance(this.dbmsTimeZone);
        }
        iter = params.iterator();
        while (iter.hasNext()) {
            IParameter param = (IParameter)iter.next();
            if (param.getDirection() == 2) {
                this.registerSpecificTypeOfOutParameter(statement, param, index);
            } else if (param.getDirection() == 1) {
                this.registerSpecificTypeOfOutParameter(statement, param, index++);
            }
            Object value = param.getValue();
            if (param.getDirection() != 0 && param.getDirection() != 2) continue;
            if (value == null) {
                try {
                    statement.setNull(index++, MMJDBCSQLTypeInfo.getSQLTypeFromClass((String)param.getType().getName()));
                    continue;
                }
                catch (SQLException e) {
                    SQLException e2 = SQLExceptionUnroller.unRollException((SQLException)e);
                    throw e2;
                }
            }
            try {
                if (cal != null && (class$java$util$Date == null ? BasicResultsTranslator.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(param.getType())) {
                    if (param.getType().equals(DataTypeManager.DefaultDataClasses.DATE)) {
                        statement.setDate(index++, (Date)value, cal);
                        continue;
                    }
                    if (param.getType().equals(DataTypeManager.DefaultDataClasses.TIME)) {
                        statement.setTime(index++, (Time)value, cal);
                        continue;
                    }
                    if (param.getType().equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                        statement.setTimestamp(index++, (Timestamp)value, cal);
                        continue;
                    }
                    statement.setObject(index++, value);
                    continue;
                }
                statement.setObject(index++, value);
            }
            catch (SQLException e) {
                SQLException e2 = SQLExceptionUnroller.unRollException((SQLException)e);
                throw e2;
            }
        }
        if (this.maxResultRows > 0) {
            statement.setMaxRows(this.maxResultRows + 1);
        }
        if (this.fetchSize > 0) {
            if (this.maxResultRows > 0) {
                statement.setFetchSize(Math.min(this.fetchSize, this.maxResultRows + 1));
            } else {
                statement.setFetchSize(this.fetchSize);
            }
        }
        boolean resultSetNext = statement.execute();
        while (!resultSetNext && (update_count = statement.getUpdateCount()) != -1) {
            resultSetNext = statement.getMoreResults();
        }
        return statement.getResultSet();
    }

    public List getValueTranslators() {
        return this.valueTranslators;
    }

    public ValueRetriever getValueRetriever() {
        return this.valueRetriever;
    }

    protected void registerSpecificTypeOfOutParameter(CallableStatement statement, IParameter param, int index) throws SQLException {
        Class runtimeType = param.getType();
        int typeToSet = 12;
        typeToSet = runtimeType == null ? 0 : MMJDBCSQLTypeInfo.getSQLTypeFromClass((String)runtimeType.getName());
        try {
            statement.registerOutParameter(index, typeToSet);
        }
        catch (SQLException e) {
            SQLException e2 = SQLExceptionUnroller.unRollException((SQLException)e);
            throw e2;
        }
    }

    public int executeStatementForLargeObjects(Connection conn, PreparedStatement stmt, TranslatedCommand command) throws SQLException {
        List params = command.getPreparedValues();
        if (params.get(0) instanceof ICompareCriteria) {
            for (int i = 0; i < params.size(); ++i) {
                ICompareCriteria param;
                Object right;
                if ((class$java$sql$Blob == null ? BasicResultsTranslator.class$("java.sql.Blob") : class$java$sql$Blob).isAssignableFrom((right = ((ILiteral)(param = (ICompareCriteria)params.get(i)).getRightExpression()).getValue()).getClass())) {
                    this.setBlob(i + 1, right, conn, stmt);
                    continue;
                }
                if (!(class$java$sql$Clob == null ? BasicResultsTranslator.class$("java.sql.Clob") : class$java$sql$Clob).isAssignableFrom(right.getClass())) continue;
                this.setClob(i + 1, right, conn, stmt);
            }
        } else {
            for (int i = 0; i < params.size(); ++i) {
                Class<?> paramClass;
                ILiteral param = (ILiteral)params.get(i);
                Object o = param.getValue();
                if (o == null) continue;
                if ((class$java$sql$Blob == null ? BasicResultsTranslator.class$("java.sql.Blob") : class$java$sql$Blob).isAssignableFrom(paramClass = o.getClass())) {
                    this.setBlob(i + 1, param.getValue(), conn, stmt);
                    continue;
                }
                if (!(class$java$sql$Clob == null ? BasicResultsTranslator.class$("java.sql.Clob") : class$java$sql$Clob).isAssignableFrom(paramClass)) continue;
                this.setClob(i + 1, param.getValue(), conn, stmt);
            }
        }
        return stmt.executeUpdate();
    }

    public int executeStatementForBulkInsert(Connection conn, Statement stmt, TranslatedCommand command) throws SQLException {
        List rows = command.getPreparedValues();
        Iterator rowIter = rows.iterator();
        while (rowIter.hasNext()) {
            String values = (String)rowIter.next();
            stmt.addBatch(command.getSql() + values);
        }
        int[] results = stmt.executeBatch();
        int updateCount = 0;
        for (int i = 0; i < results.length; ++i) {
            updateCount += results[i];
        }
        return updateCount;
    }

    private void setClob(int index, Object value, Connection con, PreparedStatement statement) throws SQLException {
        try {
            statement.setClob(index, (Clob)value);
        }
        catch (SQLException ex) {
            Object[] params = new Object[]{ex.getMessage()};
            throw new SQLException(JDBCPlugin.Util.getString("JDBCTranslator._Unable_to_get_Clob_and_set_parameter._{0}", params));
        }
    }

    private void setBlob(int index, Object value, Connection con, PreparedStatement statement) throws SQLException {
        try {
            statement.setBlob(index, (Blob)value);
        }
        catch (SQLException ex) {
            Object[] params = new Object[]{ex.getMessage()};
            throw new SQLException(JDBCPlugin.Util.getString("JDBCTranslator._Unable_to_get_Blob_and_set_parameter._{0}", params));
        }
    }

    public TimeZone getDatabaseTimezone() {
        return this.dbmsTimeZone;
    }

    public Batch modifyBatch(Batch batch, ExecutionContext context, ICommand command) {
        return batch;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

