/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.connector.jdbc.extension.FunctionModifier;
import com.metamatrix.connector.jdbc.util.JDBCExecutionHelper;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.visitor.util.SQLStringVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class SQLConversionVisitor
extends SQLStringVisitor {
    private static final String UNDEFINED_PARAM = "?";
    private static DecimalFormat decimalFormatter = new DecimalFormat("#############################0.0#############################");
    private static double SCIENTIC_LOW = Math.pow(10.0, -3.0);
    private static double SCIENTIC_HIGH = Math.pow(10.0, 7.0);
    private Map modifiers;
    private ExecutionContext context;
    private ILanguageFactory languageFactory;
    private int setCriteriaBatchSize = -1;
    private TimeZone databaseTimeZone;
    private int execType;
    private int stmtType;
    private List preparedValues;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;

    public void reset() {
        this.execType = 0;
        this.stmtType = 0;
        this.preparedValues = null;
        super.reset();
    }

    public void visit(IInsert obj) {
        this.formatInsert(obj);
        boolean usePreparedStatement = false;
        this.buffer.append("(");
        List values = obj.getValues();
        for (int i = 0; i < values.size(); ++i) {
            Object literalValue;
            boolean isLargeObject = false;
            ILanguageObject value = (ILanguageObject)values.get(i);
            if (value instanceof ILiteral && (literalValue = ((ILiteral)value).getValue()) != null && ((class$java$sql$Blob == null ? SQLConversionVisitor.class$("java.sql.Blob") : class$java$sql$Blob).isAssignableFrom(literalValue.getClass()) || (class$java$sql$Clob == null ? SQLConversionVisitor.class$("java.sql.Clob") : class$java$sql$Clob).isAssignableFrom(literalValue.getClass()) || (class$java$util$List == null ? SQLConversionVisitor.class$("java.util.List") : class$java$util$List).isAssignableFrom(literalValue.getClass()))) {
                this.buffer.append(UNDEFINED_PARAM);
                usePreparedStatement = true;
                isLargeObject = true;
            }
            if (!isLargeObject) {
                this.append(value);
            }
            if (i == values.size() - 1) continue;
            this.buffer.append(",");
            this.buffer.append(" ");
        }
        this.buffer.append(")");
        if (usePreparedStatement) {
            this.stmtType = 1;
            this.preparedValues = JDBCExecutionHelper.setParametersForUpdateLOB((ICommand)obj);
        } else {
            this.stmtType = 0;
        }
        this.execType = 1;
    }

    private void formatInsert(IInsert obj) {
        this.buffer.append("INSERT").append(" ").append("INTO").append(" ");
        this.append((ILanguageObject)obj.getGroup());
        if (obj.getElements() != null && obj.getElements().size() != 0) {
            this.buffer.append(" ").append("(");
            this.append(obj.getElements());
            this.buffer.append(")");
        }
        this.buffer.append(" ").append("VALUES").append(" ");
    }

    public void visit(IBulkInsert obj) {
        this.formatInsert((IInsert)obj);
        List elements = obj.getElements();
        List rows = obj.getRows();
        ArrayList<String> modifiedRows = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            List row = (List)rows.get(rowIndex);
            StringBuffer valuesbuffer = new StringBuffer();
            valuesbuffer.append("(");
            int elementCount = row.size();
            for (int i = 0; i < elementCount; ++i) {
                IElement element = (IElement)elements.get(i);
                this.translateSQLType(element.getType(), row.get(i), valuesbuffer);
                if (i == elementCount - 1) continue;
                valuesbuffer.append(",");
            }
            valuesbuffer.append(")");
            modifiedRows.add(valuesbuffer.toString());
        }
        this.stmtType = 0;
        this.execType = 1;
        this.preparedValues = modifiedRows;
    }

    private void translateSQLType(Class type, Object obj, StringBuffer valuesbuffer) {
        if (obj == null) {
            valuesbuffer.append("NULL");
        } else if ((class$java$lang$Number == null ? (class$java$lang$Number = SQLConversionVisitor.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type)) {
            boolean useFormatting = false;
            if ((class$java$lang$Double == null ? (class$java$lang$Double = SQLConversionVisitor.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(type)) {
                double value = (Double)obj;
                useFormatting = value <= SCIENTIC_LOW || value >= SCIENTIC_HIGH;
            } else if ((class$java$lang$Float == null ? (class$java$lang$Float = SQLConversionVisitor.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(type)) {
                float value = ((Float)obj).floatValue();
                boolean bl = useFormatting = (double)value <= SCIENTIC_LOW || (double)value >= SCIENTIC_HIGH;
            }
            if (useFormatting) {
                valuesbuffer.append(decimalFormatter.format(obj));
            } else {
                valuesbuffer.append(obj);
            }
        } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            valuesbuffer.append(this.translateLiteralBoolean((Boolean)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            valuesbuffer.append(this.translateLiteralTimestamp((Timestamp)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            valuesbuffer.append(this.translateLiteralTime((Time)obj));
        } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            valuesbuffer.append(this.translateLiteralDate((Date)obj));
        } else {
            valuesbuffer.append("'").append(this.escapeString(obj.toString())).append("'");
        }
    }

    public void visit(IUpdate obj) {
        this.buffer.append("UPDATE").append(" ");
        this.append((ILanguageObject)obj.getGroup());
        this.buffer.append(" ").append("SET").append(" ");
        boolean isLargeObject = false;
        List values = obj.getChanges();
        for (int i = 0; i < values.size(); ++i) {
            ICompareCriteria original = (ICompareCriteria)values.get(i);
            IExpression rightExpr = original.getRightExpression();
            if (rightExpr instanceof ILiteral) {
                ILiteral right = (ILiteral)original.getRightExpression();
                if (right.getValue() != null && ((class$java$sql$Blob == null ? SQLConversionVisitor.class$("java.sql.Blob") : class$java$sql$Blob).isAssignableFrom(right.getValue().getClass()) || (class$java$sql$Clob == null ? SQLConversionVisitor.class$("java.sql.Clob") : class$java$sql$Clob).isAssignableFrom(right.getValue().getClass()) || (class$java$util$List == null ? SQLConversionVisitor.class$("java.util.List") : class$java$util$List).isAssignableFrom(right.getValue().getClass()))) {
                    this.append((ILanguageObject)original.getLeftExpression());
                    this.buffer.append(" ").append("=").append(" ").append(UNDEFINED_PARAM);
                    isLargeObject = true;
                } else {
                    this.append((ILanguageObject)original);
                }
            } else {
                this.append((ILanguageObject)original);
            }
            if (i == values.size() - 1) continue;
            this.buffer.append(",").append(" ");
        }
        if (obj.getCriteria() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((ILanguageObject)obj.getCriteria());
        }
        if (isLargeObject) {
            this.stmtType = 1;
            this.preparedValues = JDBCExecutionHelper.setParametersForUpdateLOB((ICommand)obj);
        } else {
            this.stmtType = 0;
        }
        this.execType = 1;
    }

    public void visit(IQuery obj) {
        this.execType = 0;
        this.stmtType = 0;
        super.visit(obj);
    }

    public void visit(IProcedure obj) {
        this.execType = 2;
        this.stmtType = 2;
        this.setPreparedValues(obj.getParameters());
        this.buffer.append(this.generateSqlForStoredProcedure(obj));
    }

    public void visit(IDelete obj) {
        this.execType = 1;
        this.stmtType = 0;
        super.visit(obj);
    }

    public void visit(IFunction obj) {
        List parts;
        FunctionModifier functionModifier;
        if (this.modifiers != null && (functionModifier = (FunctionModifier)this.modifiers.get(obj.getName().toLowerCase())) != null && (parts = functionModifier.translate(obj)) != null) {
            Iterator iter = parts.iterator();
            while (iter.hasNext()) {
                Object part = iter.next();
                if (part instanceof String) {
                    this.buffer.append(part);
                    continue;
                }
                this.append((ILanguageObject)part);
            }
            return;
        }
        super.visit(obj);
    }

    public void visit(ILiteral obj) {
        this.translateSQLType(obj.getType(), obj.getValue(), this.buffer);
    }

    protected String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "1";
        }
        return "0";
    }

    protected String translateLiteralDate(Date dateValue) {
        return "{d'" + this.formatDateValue(dateValue) + "'}";
    }

    protected String translateLiteralTime(Time timeValue) {
        return "{t'" + this.formatDateValue(timeValue) + "'}";
    }

    protected String translateLiteralTimestamp(Timestamp timestampValue) {
        return "{ts'" + this.formatDateValue(timestampValue) + "'}";
    }

    protected String formatDateValue(Object dateObject) {
        if (this.databaseTimeZone == null) {
            return dateObject.toString();
        }
        if (dateObject instanceof Timestamp) {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            timestampFormatter.setTimeZone(this.databaseTimeZone);
            Timestamp ts = (Timestamp)dateObject;
            String nanoStr = "" + (1000000000L + (long)ts.getNanos());
            while (nanoStr.length() > 2 && nanoStr.charAt(nanoStr.length() - 1) == '0') {
                nanoStr = nanoStr.substring(0, nanoStr.length() - 1);
            }
            String tsStr = timestampFormatter.format(ts) + "." + nanoStr.substring(1);
            return tsStr;
        }
        if (dateObject instanceof Date) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
            dateFormatter.setTimeZone(this.databaseTimeZone);
            return dateFormatter.format((Date)dateObject);
        }
        if (dateObject instanceof Time) {
            SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
            timeFormatter.setTimeZone(this.databaseTimeZone);
            return timeFormatter.format((Time)dateObject);
        }
        return dateObject.toString();
    }

    public void setFunctionModifiers(Map modifiers) {
        this.modifiers = modifiers;
    }

    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    protected ExecutionContext getExecutionContext() {
        return this.context;
    }

    public void setProperties(Properties props) {
        String propStr = props.getProperty("SetCriteriaBatchSize");
        if (propStr != null) {
            try {
                this.setCriteriaBatchSize = Integer.parseInt(propStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected String generateSqlForStoredProcedure(IProcedure exec) {
        StringBuffer prepareCallBuffer = new StringBuffer();
        prepareCallBuffer.append("{ ");
        List params = exec.getParameters();
        boolean needQuestionMark = false;
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            IParameter param = (IParameter)iter.next();
            if (param.getDirection() != 3) continue;
            needQuestionMark = true;
            break;
        }
        if (needQuestionMark) {
            prepareCallBuffer.append("?=");
        }
        prepareCallBuffer.append(" call ");
        prepareCallBuffer.append(exec.getMetadataID() != null ? this.getName(exec.getMetadataID()) : exec.getProcedureName());
        prepareCallBuffer.append("(");
        int numberOfParameters = 0;
        iter = params.iterator();
        while (iter.hasNext()) {
            IParameter param = (IParameter)iter.next();
            if (param.getDirection() != 0 && param.getDirection() != 1 && param.getDirection() != 2) continue;
            if (numberOfParameters > 0) {
                prepareCallBuffer.append(",");
            }
            prepareCallBuffer.append(UNDEFINED_PARAM);
            ++numberOfParameters;
        }
        prepareCallBuffer.append(")");
        prepareCallBuffer.append("}");
        return prepareCallBuffer.toString();
    }

    public void setLanguageFactory(ILanguageFactory factory) {
        this.languageFactory = factory;
    }

    public ILanguageFactory getLanguageFactory() {
        return this.languageFactory;
    }

    public void setDatabaseTimeZone(TimeZone zone) {
        this.databaseTimeZone = zone;
    }

    protected TimeZone getDatabaseTimeZone() {
        return this.databaseTimeZone;
    }

    int getSetCriteriaBatchSize() {
        return this.setCriteriaBatchSize;
    }

    int getExecType() {
        return this.execType;
    }

    List getPreparedValues() {
        return this.preparedValues;
    }

    int getStmtType() {
        return this.stmtType;
    }

    private void setPreparedValues(List parameters) {
        this.preparedValues = parameters;
        if (this.preparedValues != null) {
            Iterator i = this.preparedValues.iterator();
            while (i.hasNext()) {
                IParameter param = (IParameter)i.next();
                if (param == null || !(param.getValue() instanceof BigInteger)) continue;
                param.setValue((Object)new BigDecimal((BigInteger)param.getValue()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

