/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.derby;

import com.metamatrix.connector.jdbc.derby.DerbyConversionVisitor;
import com.metamatrix.connector.jdbc.derby.DerbyConvertModifier;
import com.metamatrix.connector.jdbc.derby.DerbyTimestampFunctionModifier;
import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.impl.AliasModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicSQLTranslator;
import com.metamatrix.connector.jdbc.extension.impl.Concat2FunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.EscapeSyntaxModifier;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DerbySQLTranslator
extends BasicSQLTranslator {
    private Map functionModifiers;
    private Properties connectorProperties;
    private ILanguageFactory languageFactory;

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        super.initialize(env, metadata);
        ConnectorEnvironment connEnv = this.getConnectorEnvironment();
        this.connectorProperties = connEnv.getProperties();
        this.languageFactory = connEnv.getLanguageFactory();
        this.initializeFunctionModifiers();
    }

    private void initializeFunctionModifiers() {
        this.functionModifiers = new HashMap();
        this.functionModifiers.putAll(super.getFunctionModifiers());
        this.functionModifiers.put("concat", new EscapeSyntaxModifier());
        this.functionModifiers.put("concat2", new Concat2FunctionModifier(this.languageFactory, "||", "coalesce"));
        this.functionModifiers.put("substring", new AliasModifier("substr"));
        this.functionModifiers.put("dayofmonth", new AliasModifier("day"));
        this.functionModifiers.put("timestampadd", new DerbyTimestampFunctionModifier());
        this.functionModifiers.put("timestampdiff", new DerbyTimestampFunctionModifier());
        this.functionModifiers.put("cast", new DerbyConvertModifier(this.languageFactory));
        this.functionModifiers.put("convert", new DerbyConvertModifier(this.languageFactory));
        this.functionModifiers.put("ifnull", new AliasModifier("coalesce"));
        this.functionModifiers.put("nvl", new AliasModifier("coalesce"));
    }

    public Map getFunctionModifiers() {
        return this.functionModifiers;
    }

    public SQLConversionVisitor getTranslationVisitor() {
        DerbyConversionVisitor visitor = new DerbyConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.functionModifiers);
        visitor.setProperties(this.connectorProperties);
        visitor.setLanguageFactory(this.languageFactory);
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }
}

