/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.db2;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IOrderByItem;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.IUnion;
import java.util.Iterator;
import java.util.List;

public class DB2SQLConversionVisitor
extends SQLConversionVisitor {
    private final int MAX_SELECT_ALIAS_LENGTH = 30;
    private final int MAX_TABLE_ALIAS_LENGTH = 128;

    public void visit(ILimit obj) {
        this.buffer.append("FETCH").append(" ").append("FIRST").append(" ").append(obj.getRowLimit()).append(" ").append("ROWS").append(" ").append("ONLY");
    }

    public void visit(IUnion obj) {
        this.appendQuery((IQuery)obj);
        List firstQuerySelectSymbols = obj.getSelect().getSelectSymbols();
        Iterator queryIter = obj.getUnionQueries().iterator();
        Iterator allIter = obj.getUnionAllFlags().iterator();
        while (queryIter.hasNext()) {
            this.buffer.append(" ");
            this.buffer.append("UNION");
            Boolean allFlag = (Boolean)allIter.next();
            if (allFlag.equals(Boolean.TRUE)) {
                this.buffer.append(" ");
                this.buffer.append("ALL");
            }
            this.buffer.append(" ");
            IQuery query = (IQuery)queryIter.next();
            List nextQuerySelectSymbols = query.getSelect().getSelectSymbols();
            for (int j = 0; j < firstQuerySelectSymbols.size(); ++j) {
                ISelectSymbol targetSymbol = (ISelectSymbol)firstQuerySelectSymbols.get(j);
                ISelectSymbol sourceSymbol = (ISelectSymbol)nextQuerySelectSymbols.get(j);
                if (targetSymbol.getOutputName().equals(sourceSymbol.getOutputName())) continue;
                String alias = null;
                alias = targetSymbol.hasAlias() ? targetSymbol.getOutputName() : this.getShortName(targetSymbol.getOutputName());
                sourceSymbol.setAlias(true);
                sourceSymbol.setOutputName(alias);
            }
            if (query instanceof IUnion) {
                this.buffer.append("(");
                this.append((ILanguageObject)query);
                this.buffer.append(")");
                continue;
            }
            this.appendQuery(query);
        }
        IOrderBy orderBy = obj.getUnionOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.appendUnionOrderBy(orderBy);
        }
    }

    protected void appendUnionOrderBy(IOrderBy obj) {
        this.buffer.append("ORDER").append(" ").append("BY").append(" ");
        List items = obj.getItems();
        Iterator iter = items.iterator();
        IOrderByItem item = (IOrderByItem)iter.next();
        this.appendUnionOrderByItem(item);
        while (iter.hasNext()) {
            this.buffer.append(",");
            this.buffer.append(" ");
            this.appendUnionOrderByItem((IOrderByItem)iter.next());
        }
    }

    protected void appendUnionOrderByItem(IOrderByItem obj) {
        IElement element;
        String itemName = obj.getName();
        if (obj.getElement() != null && (element = obj.getElement()).getMetadataID() != null) {
            itemName = this.getName(element.getMetadataID());
        }
        this.buffer.append(this.getShortName(itemName));
        if (!obj.getDirection()) {
            this.buffer.append(" ").append("DESC");
        }
    }

    private String getShortName(String name) {
        int lastDot = name.lastIndexOf(".");
        if (lastDot >= 0) {
            return name.substring(lastDot + 1);
        }
        return name;
    }

    protected int getMaxSelectAliasLength() {
        return 30;
    }

    protected int getMaxTableAliasLength() {
        return 128;
    }
}

