/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.access;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import java.sql.Time;

public class AccessSQLConversionVisitor
extends SQLConversionVisitor {
    private int limit = 0;

    protected String translateLiteralTime(Time timeValue) {
        return "{ts'1900-01-01 " + this.formatDateValue(timeValue) + "'}";
    }

    protected String translateLiteralBoolean(Boolean booleanValue) {
        if (booleanValue.booleanValue()) {
            return "-1";
        }
        return "0";
    }

    protected void appendQuery(IQuery obj) {
        if (obj.getLimit() != null) {
            this.limit = obj.getLimit().getRowLimit();
        }
        this.append((ILanguageObject)obj.getSelect());
        if (obj.getFrom() != null) {
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getFrom());
        }
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((ILanguageObject)obj.getWhere());
        }
        if (obj.getGroupBy() != null) {
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getGroupBy());
        }
        if (obj.getHaving() != null) {
            this.buffer.append(" ").append("HAVING").append(" ");
            this.append((ILanguageObject)obj.getHaving());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append((ILanguageObject)obj.getOrderBy());
        }
    }

    protected void visitSelect(ISelect obj) {
        this.buffer.append("SELECT").append(" ");
        if (this.limit > 0) {
            this.buffer.append("TOP").append(" ").append(this.limit).append(" ");
            this.limit = 0;
        }
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        this.append(obj.getSelectSymbols());
    }
}

