/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.JDBCSourceConnectionFactory;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.CredentialMap;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.data.pool.UserIdentity;
import java.io.Serializable;
import java.sql.Driver;
import java.util.Properties;

public class JDBCUserIdentityConnectionFactory
extends JDBCSourceConnectionFactory {
    private Driver driver;
    private String url;
    private int transIsoLevel;
    private String system;

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        super.initialize(env);
        this.system = this.getConnectorEnvironment().getConnectorName();
        this.verifyConnectionProperties(env.getProperties());
    }

    public boolean isSingleIdentity() {
        return false;
    }

    protected void verifyConnectionProperties(Properties connectionProps) throws ConnectorException {
        String driverClassName = connectionProps.getProperty("Driver");
        this.driver = this.createDriver(driverClassName);
        this.url = connectionProps.getProperty("URL");
        if (this.url != null && this.url.trim().length() > 0) {
            this.validateURL(this.driver, this.url);
        }
        this.transIsoLevel = this.interpretTransactionIsolationLevel(connectionProps.getProperty("TransactionIsolationLevel"));
    }

    protected String getUrl() {
        return this.url;
    }

    protected int getTransactionIsolationLevel() {
        return this.transIsoLevel;
    }

    public ConnectorIdentity createIdentity(SecurityContext context) throws ConnectorException {
        return new UserIdentity(context);
    }

    public SourceConnection createConnection(ConnectorIdentity id) throws ConnectorException {
        SecurityContext context = id.getSecurityContext();
        String[] userProperties = this.getUserProperties(context);
        Properties props = new Properties();
        props.put("user", userProperties[0]);
        props.put("password", userProperties[1]);
        return this.createJDBCConnection(this.driver, this.getUrl(), this.getTransactionIsolationLevel(), props);
    }

    protected String[] getUserProperties(SecurityContext context) throws ConnectorException {
        Serializable commandPayload = context.getExecutionPayload();
        if (commandPayload != null && commandPayload instanceof CredentialMap) {
            return this.extractPayload((CredentialMap)commandPayload);
        }
        Serializable trustedPayload = context.getTrustedPayload();
        if (trustedPayload != null && trustedPayload instanceof CredentialMap) {
            return this.extractPayload((CredentialMap)trustedPayload);
        }
        throw new ConnectorException(JDBCPlugin.Util.getString("JDBCUserIdentityConnectionFactory.Unable_to_get_credentials"));
    }

    private String[] extractPayload(CredentialMap credentials) throws ConnectorException {
        String user = credentials.getUser(this.system);
        this.validatePropertyExists(user, "user");
        String password = credentials.getPassword(this.system);
        this.validatePropertyExists(password, "password");
        return new String[]{user, password};
    }

    private void validatePropertyExists(String property, String propertyName) throws ConnectorException {
        if (property == null) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCUserIdentityConnectionFactory.Connection_property_missing", (Object)propertyName, (Object)this.system));
        }
    }
}

