/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.webservice.ui.editor;

import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.util.ArrayUtil;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.webservice.Interface;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.ui.editors.MultiPageModelEditor;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.webservice.ui.IInternalUiConstants;
import com.metamatrix.modeler.internal.webservice.ui.xpath.XPathBuilderPanel;
import com.metamatrix.modeler.transformation.ui.editors.TransformationObjectEditorPage;
import com.metamatrix.modeler.ui.editors.ModelObjectEditorPage;
import com.metamatrix.modeler.webservice.ui.WebServiceUiPlugin;
import com.metamatrix.modeler.webservice.ui.editor.ProcedureEditorPage;
import com.metamatrix.modeler.webservice.ui.util.WebServiceUiUtil;
import com.metamatrix.query.internal.ui.sqleditor.component.AssignmentStatementDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.BlockDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DeclareStatementDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNode;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.ui.sqleditor.SqlEditorEvent;
import com.metamatrix.query.ui.sqleditor.SqlEditorPanel;
import com.metamatrix.ui.internal.util.UiUtil;
import com.metamatrix.ui.internal.widget.DefaultContentProvider;
import com.metamatrix.ui.internal.widget.Dialog;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class ProcedureObjectEditorPage
extends TransformationObjectEditorPage
implements ArrayUtil.Constants,
IInternalUiConstants,
IInternalUiConstants.Images,
StringUtil.Constants {
    private static final String I18N_PFX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$webservice$ui$editor$ProcedureObjectEditorPage == null ? (class$com$metamatrix$modeler$webservice$ui$editor$ProcedureObjectEditorPage = ProcedureObjectEditorPage.class$("com.metamatrix.modeler.webservice.ui.editor.ProcedureObjectEditorPage")) : class$com$metamatrix$modeler$webservice$ui$editor$ProcedureObjectEditorPage));
    public static final String NAME = IInternalUiConstants.UTIL.getString(I18N_PFX + "name");
    public static final String OPS_TITLE = IInternalUiConstants.UTIL.getString(I18N_PFX + "operationsTitle");
    public static final String PROC_TITLE = IInternalUiConstants.UTIL.getString(I18N_PFX + "procedureTitle");
    public static final String VARS_TITLE = IInternalUiConstants.UTIL.getString(I18N_PFX + "variablesTitle");
    private static final String EDIT = IInternalUiConstants.UTIL.getString(I18N_PFX + "edit");
    private static final String EDIT_TOOLTIP = IInternalUiConstants.UTIL.getString(I18N_PFX + "editToolTip");
    private static final String EDIT_VAR_TOOLTIP = I18N_PFX + "editVariableToolTip";
    public static final String VAR_EDITOR_TITLE = IInternalUiConstants.UTIL.getString(I18N_PFX + "variableEditorTitle");
    private TreeViewer opViewer;
    private TableViewer varViewer;
    private Map declarationsToAssignments;
    private BlockDisplayNode blockNode;
    private Operation selectedOp;
    private Hyperlink desc;
    private Adapter adapter;
    private Resource resrc;
    static /* synthetic */ Class class$com$metamatrix$modeler$webservice$ui$editor$ProcedureObjectEditorPage;

    public static String getVariableLabel(DeclareStatement statement) {
        return statement.getVariable().getShortName() + " : " + statement.getVariableType();
    }

    public static String getXpath(AssignmentStatement statement) {
        Function function = ProcedureObjectEditorPage.getXpathFunction(statement);
        if (function != null && function.getArgs().length > 1) {
            return (String)((Constant)function.getArg(1)).getValue();
        }
        return "";
    }

    public static Function getXpathFunction(AssignmentStatement statement) {
        Function function;
        Expression expr;
        if (statement.hasExpression() && (expr = statement.getExpression()) instanceof Function && "xpathvalue".equalsIgnoreCase((function = (Function)expr).getName())) {
            return function;
        }
        return null;
    }

    public boolean canClose() {
        return false;
    }

    public boolean canEdit(Object object, IEditorPart editor) {
        return editor instanceof ProcedureEditorPage;
    }

    protected IAction contributeReconcileAction() {
        return null;
    }

    private void createEditVariablesPanel(Composite parent) {
        XPathBuilderPanel panel = new XPathBuilderPanel(parent, this.getCurrentMappingRoot(), this.declarationsToAssignments, this.blockNode, this.varViewer.getSelection());
        panel.addPropertyListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected SqlEditorPanel createSelectEditorForNoUpdate(Composite parent) {
        FillLayout fillLayout = new FillLayout();
        parent.setLayout((Layout)fillLayout);
        FormToolkit toolkit = WebServiceUiPlugin.getDefault().getFormToolkit(parent.getDisplay());
        Composite form = toolkit.createForm(parent).getBody();
        form.setLayout((Layout)fillLayout);
        SashForm hSplitter = new SashForm(form, 256);
        Section section = toolkit.createSection((Composite)hSplitter, 256);
        section.setText(OPS_TITLE);
        toolkit.paintBordersFor((Composite)section);
        this.opViewer = new TreeViewer((Composite)section, 768);
        section.setClient((Control)this.opViewer.getTree());
        this.opViewer.setContentProvider((IContentProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.opViewer.setLabelProvider((IBaseLabelProvider)ModelUtilities.getEMFLabelProvider());
        this.opViewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        SashForm vSplitter = new SashForm((Composite)hSplitter, 512);
        section = toolkit.createSection((Composite)vSplitter, 256);
        section.setText(VARS_TITLE);
        this.desc = toolkit.createHyperlink((Composite)section, EDIT, 64);
        this.desc.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        this.desc.setEnabled(false);
        section.setDescriptionControl((Control)this.desc);
        this.varViewer = new TableViewer((Composite)section, 768);
        Table table = this.varViewer.getTable();
        section.setClient((Control)table);
        this.varViewer.setContentProvider((IContentProvider)new DefaultContentProvider());
        this.varViewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        table.addMouseTrackListener((MouseTrackListener)new /* Unavailable Anonymous Inner Class!! */);
        section = toolkit.createSection((Composite)vSplitter, 256);
        section.setText(PROC_TITLE);
        SqlEditorPanel editor = super.createSelectEditorForNoUpdate((Composite)section);
        editor.getTextViewer().getTextWidget().setEnabled(false);
        section.setClient((Control)editor);
        editor.getQueryDisplayComponent().addPropertyListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        hSplitter.setWeights(new int[]{1, 3});
        vSplitter.setWeights(new int[]{1, 3});
        this.declarationsToAssignments = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
        this.varViewer.setInput((Object)this.declarationsToAssignments);
        this.adapter = new /* Unavailable Anonymous Inner Class!! */;
        return editor;
    }

    public void edit(Object object) {
        if (object == null) {
            return;
        }
        Resource resrc = ((EObject)object).eResource();
        if (resrc == null && object instanceof Diagram) {
            resrc = ((Diagram)object).getTarget().eResource();
        }
        if (this.resrc == resrc) {
            this.selectInterfaceOrOperation(object);
        } else {
            this.resrc = resrc;
            this.updateOperations(object);
            if (!resrc.eAdapters().contains((Object)this.adapter)) {
                resrc.eAdapters().add((Object)this.adapter);
            }
        }
    }

    private void editVariables() {
        Dialog dlg = new Dialog(this.varViewer.getTable().getShell(), VAR_EDITOR_TITLE){

            protected Control createContents(Composite parent) {
                Control ctrl = super.createContents(parent);
                Button button = this.getButton(1);
                --((GridLayout)button.getParent().getLayout()).numColumns;
                button.dispose();
                return ctrl;
            }

            protected Control createDialogArea(Composite parent) {
                parent = (Composite)super.createDialogArea(parent);
                ProcedureObjectEditorPage.this.createEditVariablesPanel(parent);
                return parent;
            }
        };
        dlg.setSizeRelativeToScreen(50, 50);
        dlg.setCenterOnDisplay(true);
        dlg.open();
    }

    private EObject getInterfaceOrOperation(Object object) {
        EObject eObj = WebServiceUiUtil.getInterfaceOrOperation((Object)object);
        if (eObj == null) {
            if (object instanceof List) {
                Iterator iter = ((List)object).iterator();
                while (iter.hasNext()) {
                    EObject obj = this.getInterfaceOrOperation(iter.next());
                    if (obj == null) continue;
                    return obj;
                }
            }
        } else {
            Interface interfaceObj;
            if (eObj instanceof Interface && !(interfaceObj = (Interface)eObj).eAdapters().contains((Object)this.adapter)) {
                interfaceObj.eAdapters().add((Object)this.adapter);
            }
            return eObj;
        }
        return null;
    }

    public String getTransformationName() {
        return NAME;
    }

    public void initialize(MultiPageModelEditor editor) {
        Iterator iter = editor.getObjectEditors().iterator();
        while (iter.hasNext()) {
            ModelObjectEditorPage objEditor = (ModelObjectEditorPage)iter.next();
            if (objEditor == this) continue;
            objEditor.setOverride((ModelObjectEditorPage)this);
        }
        if (editor.getActiveEditor() instanceof ProcedureEditorPage) {
            ((ProcedureEditorPage)editor.getActiveEditor()).addWorkspaceSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    ProcedureObjectEditorPage.this.workspaceSelectionChanged(selection);
                }
            });
        }
    }

    public boolean isResourceValid() {
        return true;
    }

    private void makeInputVariableStatementsInvisible(DisplayNode root) {
        root.setVisible(false, false);
        Iterator childIter = root.getChildren().iterator();
        while (childIter.hasNext()) {
            DisplayNode child = (DisplayNode)childIter.next();
            if (!(child instanceof BlockDisplayNode)) continue;
            this.blockNode = (BlockDisplayNode)child;
            child.setVisible(false, false);
            Iterator blockIter = child.getChildren().iterator();
            while (blockIter.hasNext()) {
                DeclareStatement statement;
                DisplayNode blockChild = (DisplayNode)blockIter.next();
                if (blockChild instanceof DeclareStatementDisplayNode) {
                    statement = (DeclareStatement)blockChild.getLanguageObject();
                    if (!statement.getVariable().getName().startsWith("VARIABLES.IN_")) continue;
                    blockChild.setVisible(false, true);
                    continue;
                }
                if (!(blockChild instanceof AssignmentStatementDisplayNode) || !(statement = (AssignmentStatement)blockChild.getLanguageObject()).getVariable().getName().startsWith("VARIABLES.IN_")) continue;
                blockChild.setVisible(false, true);
            }
            break block0;
        }
    }

    private void modelChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: 
            case 5: {
                this.updateOperations(notification.getNewValue());
                break;
            }
            case 4: 
            case 6: {
                this.updateOperations(notification.getOldValue());
            }
        }
    }

    private void operationSelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof Operation) {
            Operation op = (Operation)obj;
            if (op == this.selectedOp) {
                return;
            }
            ModelResource resrc = ModelUtilities.getModelResourceForModelObject((EObject)op);
            try {
                List transformations = resrc.getModelTransformations().getTransformations((EObject)op);
                if (!transformations.isEmpty()) {
                    WebServiceUiUtil.initializeProcedure((Operation)op, (Object)((Object)this), (boolean)false);
                    this.getTextWidget().setEnabled(true);
                    this.desc.setEnabled(true);
                    if (this.selectedOp != null) {
                        boolean dirty = this.isDirty();
                        this.doSave(false);
                        super.edit(transformations.get(0));
                        if (dirty && !this.isDirty()) {
                            this.setDirty(dirty);
                        }
                    } else {
                        super.edit(transformations.get(0));
                    }
                    this.selectedOp = op;
                    return;
                }
            }
            catch (ModelWorkspaceException err) {
                IInternalUiConstants.UTIL.log((Throwable)err);
            }
        } else {
            this.selectedOp = null;
        }
        this.declarationsToAssignments.clear();
        this.varViewer.refresh();
        boolean dirty = this.isDirty();
        this.getTextWidget().setText("");
        if (!dirty) {
            this.setDirty(false);
        }
        this.getTextWidget().setEnabled(false);
        this.desc.setEnabled(false);
    }

    public void processEvent(final EventObject event) {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            public void run() {
                ProcedureObjectEditorPage.this.processEventInSwtThread(event);
            }
        }, (boolean)true);
    }

    private void processEventInSwtThread(EventObject event) {
        if (event instanceof SqlEditorEvent) {
            SqlEditorEvent sqlEvent = (SqlEditorEvent)event;
            switch (sqlEvent.getType()) {
                case 0: 
                case 5: {
                    break;
                }
                default: {
                    Command cmd = sqlEvent.getCommand();
                    if (!(cmd instanceof CreateUpdateProcedureCommand)) {
                        return;
                    }
                    this.declarationsToAssignments.clear();
                    CreateUpdateProcedureCommand procCmd = (CreateUpdateProcedureCommand)cmd;
                    HashMap declarations = new HashMap();
                    Iterator iter = procCmd.getBlock().getStatements().iterator();
                    while (iter.hasNext()) {
                        Object declaration;
                        AssignmentStatement assignment;
                        Object statement = iter.next();
                        if (statement instanceof DeclareStatement) {
                            DeclareStatement declaration2 = (DeclareStatement)statement;
                            if (!declaration2.getVariable().getName().startsWith("VARIABLES.IN_")) continue;
                            declarations.put(declaration2.getVariable(), statement);
                            continue;
                        }
                        if (!(statement instanceof AssignmentStatement) || ProcedureObjectEditorPage.getXpathFunction(assignment = (AssignmentStatement)statement) == null || (declaration = declarations.get(assignment.getVariable())) == null) continue;
                        this.declarationsToAssignments.put(declaration, statement);
                    }
                    this.varViewer.refresh();
                }
            }
        }
        super.processEvent(event);
    }

    private void selectInterfaceOrOperation(Object object) {
        EObject obj = this.getInterfaceOrOperation(object);
        if (obj instanceof Operation && obj.eResource() == this.resrc) {
            this.opViewer.setSelection((ISelection)new StructuredSelection((Object)obj), true);
        }
    }

    private void setDescriptionToolTip(Hyperlink description) {
        IStructuredSelection selection = (IStructuredSelection)this.varViewer.getSelection();
        if (selection.isEmpty()) {
            description.setToolTipText(EDIT_TOOLTIP);
        } else {
            Map.Entry entry = (Map.Entry)selection.getFirstElement();
            String var = ((DeclareStatement)entry.getKey()).getVariable().getShortName();
            description.setToolTipText(IInternalUiConstants.UTIL.getString(EDIT_VAR_TOOLTIP, (Object)var));
        }
    }

    private void updateOperations(final Object object) {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            public void run() {
                ProcedureObjectEditorPage.this.updateOperationsInSwtThread(object);
            }
        }, (boolean)true);
    }

    private void updateOperationsInSwtThread(Object object) {
        if (this.opViewer.getTree().isDisposed()) {
            if (this.resrc != null && this.adapter != null) {
                this.resrc.eAdapters().remove((Object)this.adapter);
                Iterator iter = this.resrc.getContents().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof Interface)) continue;
                    ((Interface)obj).eAdapters().remove((Object)this.adapter);
                }
                this.adapter = null;
            }
        } else {
            this.opViewer.setInput((Object)this.resrc.getContents());
            this.opViewer.expandAll();
            this.selectInterfaceOrOperation(object);
        }
    }

    private void updateToolTip(MouseEvent event) {
        Table table = this.varViewer.getTable();
        TableItem item = table.getItem(new Point(event.x, event.y));
        if (item == null) {
            table.setToolTipText(null);
        } else {
            Map.Entry entry = (Map.Entry)item.getData();
            table.setToolTipText(ProcedureObjectEditorPage.getXpath((AssignmentStatement)entry.getValue()));
        }
    }

    private void updateVariables() {
        this.varViewer.refresh();
        this.getCurrentSqlEditor().setHasPendingChanges();
    }

    private void workspaceSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.selectInterfaceOrOperation(((IStructuredSelection)selection).getFirstElement());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$000(ProcedureObjectEditorPage x0) {
        x0.updateVariables();
    }

    static /* synthetic */ void access$100(ProcedureObjectEditorPage x0, SelectionChangedEvent x1) {
        x0.operationSelected(x1);
    }

    static /* synthetic */ void access$200(ProcedureObjectEditorPage x0) {
        x0.editVariables();
    }

    static /* synthetic */ void access$300(ProcedureObjectEditorPage x0, Hyperlink x1) {
        x0.setDescriptionToolTip(x1);
    }

    static /* synthetic */ void access$400(ProcedureObjectEditorPage x0, MouseEvent x1) {
        x0.updateToolTip(x1);
    }

    static /* synthetic */ void access$500(ProcedureObjectEditorPage x0, DisplayNode x1) {
        x0.makeInputVariableStatementsInvisible(x1);
    }

    static /* synthetic */ void access$600(ProcedureObjectEditorPage x0, Notification x1) {
        x0.modelChanged(x1);
    }
}

