/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xmlsource.soap;

import com.metamatrix.connector.xmlsource.XMLSourceExecution;
import com.metamatrix.connector.xmlsource.XMLSourcePlugin;
import com.metamatrix.connector.xmlsource.soap.ServiceOperation;
import com.metamatrix.connector.xmlsource.soap.SoapConnection;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.MetadataObject;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SoapExecution
extends XMLSourceExecution {
    SoapConnection connection;
    Map outputValues = null;
    Object returnValue = null;
    RuntimeMetadata metadata = null;

    public SoapExecution(ConnectorEnvironment env, RuntimeMetadata metadata, SoapConnection conn) {
        super(env);
        this.connection = conn;
        this.metadata = metadata;
    }

    public void execute(IProcedure procedure, int maxBatchSize) throws ConnectorException {
        ArrayList<Object> argsList = new ArrayList<Object>();
        MetadataObject metaObject = this.metadata.getObject(procedure.getMetadataID());
        String sourceProcedureName = metaObject.getNameInSource();
        if (sourceProcedureName == null || sourceProcedureName.length() == 0) {
            String msg = XMLSourcePlugin.Util.getString("source_name_not_supplied", new Object[]{procedure.getProcedureName()});
            XMLSourcePlugin.logError((ConnectorLogger)this.env.getLogger(), (String)msg);
            throw new ConnectorException(msg);
        }
        XMLSourcePlugin.logInfo((ConnectorLogger)this.env.getLogger(), (String)"exec_soap_procedure", (Object[])new Object[]{procedure.getProcedureName(), sourceProcedureName});
        Iterator i = procedure.getParameters().iterator();
        while (i.hasNext()) {
            IParameter param = (IParameter)i.next();
            if (param.getDirection() == 0) {
                argsList.add(param.getValue());
                continue;
            }
            if (param.getDirection() != 2) continue;
            argsList.add(param.getValue());
        }
        Object[] args = argsList.toArray(new Object[argsList.size()]);
        try {
            ServiceOperation operation = this.connection.findOperation(sourceProcedureName);
            XMLSourcePlugin.logDetail((ConnectorLogger)this.env.getLogger(), (String)"service_execute", (Object[])new Object[]{operation.name});
            for (int i2 = 0; i2 < args.length; ++i2) {
                XMLSourcePlugin.logDetail((ConnectorLogger)this.env.getLogger(), (String)"service_params", (Object[])new Object[]{args[i2]});
            }
            this.outputValues = new HashMap();
            this.returnValue = operation.execute(args, this.outputValues);
            XMLSourcePlugin.logDetail((ConnectorLogger)this.env.getLogger(), (String)"xml_contents", (Object[])new Object[]{this.returnValue});
        }
        catch (SoapConnection.OperationNotFoundException e) {
            XMLSourcePlugin.logError((ConnectorLogger)this.env.getLogger(), (String)"soap_procedure_not_found", (Object[])new Object[]{sourceProcedureName}, (Throwable)e);
            throw new ConnectorException((Throwable)e);
        }
        catch (ServiceOperation.ExcutionFailedException e) {
            XMLSourcePlugin.logError((ConnectorLogger)this.env.getLogger(), (String)"soap_procedure_failed_execute", (Object[])new Object[]{sourceProcedureName}, (Throwable)e);
            throw new ConnectorException((Throwable)e);
        }
    }

    public Batch nextBatch() throws ConnectorException {
        BasicBatch b = new BasicBatch();
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(this.returnValue);
        b.addRow(row);
        b.setLast();
        return b;
    }

    public Object getOutputValue(IParameter parameter) throws ConnectorException {
        throw new ConnectorException(XMLSourcePlugin.Util.getString("No_outputs_allowed"));
    }

    public void close() throws ConnectorException {
    }

    public void cancel() throws ConnectorException {
    }
}

