/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.ui.util;

import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.event.EventSourceException;
import com.metamatrix.metamodels.transformation.SqlAlias;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.notification.util.NotificationUtilities;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceNotification;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceNotificationListener;
import com.metamatrix.modeler.diagram.ui.util.DiagramUiUtilities;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.transformation.util.AttributeMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.internal.ui.editors.ModelEditor;
import com.metamatrix.modeler.internal.ui.refactor.actions.RenameRefactorAction;
import com.metamatrix.modeler.internal.ui.undo.ModelerUndoManager;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.transformation.ui.UiConstants;
import com.metamatrix.modeler.transformation.ui.UiPlugin;
import com.metamatrix.modeler.transformation.ui.editors.TransformationObjectEditorPage;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.modeler.ui.editors.ModelObjectEditorPage;
import com.metamatrix.modeler.ui.event.ModelResourceEvent;
import com.metamatrix.query.resolver.util.QueryValidationResult;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.ui.internal.dialog.RadioMessageDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;

public class TransformationNotificationListener
implements INotifyChangedListener,
EventObjectListener,
UiConstants {
    private static final String THIS_CLASS = "TransformationNotificationListener";
    private static final String ADD_SQL_ELEM_GRP_REFS_TITLE = UiConstants.Util.getString("TransformationNotificationListener.addSQLElemGrpAttrsTitle");
    private static final String REMOVE_SQL_ELEM_GRP_REFS_TITLE = UiConstants.Util.getString("TransformationNotificationListener.removeSQLElemGrpRefsTitle");
    private static final String REMOVE_SQL_ELEMS_TITLE = UiConstants.Util.getString("TransformationNotificationListener.removeSQLElemsTitle");
    private static final String REMOVE_SQL_ELEMS_MSG = UiConstants.Util.getString("TransformationNotificationListener.removeSQLElemsMsg");
    private static final String DEFAULT_REMOVED_SOURCE = UiConstants.Util.getString("TransformationNotificationListener.defaultRemovedSource");
    private static final String DEFAULT_ADDED_SOURCE = UiConstants.Util.getString("TransformationNotificationListener.defaultAddedSource");
    private static final String SAVE_BEFORE_CHANGE_TITLE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesTitle");
    private static final String SBC_GROUP_TITLE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesRadioTitle");
    private static final String SBC_RADIO_SAVE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesRadioButtonSave");
    private static final String SBC_RADIO_IGNORE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesRadioButtonIgnore");
    private static final String SBC_RADIO_HALT = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesRadioButtonHalt");
    private static final String SBC_NOTE = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesNote");
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UNDOABLE = true;
    private static final boolean NOT_UNDOABLE = false;
    private boolean ignoreNotifications = false;
    static /* synthetic */ Class class$com$metamatrix$modeler$ui$event$ModelResourceEvent;
    static /* synthetic */ Class class$com$metamatrix$metamodels$transformation$SqlTransformation;

    public TransformationNotificationListener() {
        WorkspaceNotificationListener listener = new WorkspaceNotificationListener();
        ModelWorkspaceManager.getModelWorkspaceManager().addNotificationListener((ModelWorkspaceNotificationListener)listener);
        try {
            com.metamatrix.modeler.ui.UiPlugin.getDefault().getEventBroker().addListener(class$com$metamatrix$modeler$ui$event$ModelResourceEvent == null ? (class$com$metamatrix$modeler$ui$event$ModelResourceEvent = TransformationNotificationListener.class$("com.metamatrix.modeler.ui.event.ModelResourceEvent")) : class$com$metamatrix$modeler$ui$event$ModelResourceEvent, (EventObjectListener)this);
        }
        catch (EventSourceException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    public void setIgnoreNotifications(boolean shouldIgnore) {
        this.ignoreNotifications = shouldIgnore;
    }

    public void notifyChanged(Notification notification) {
        if (this.ignoreNotifications) {
            return;
        }
        if (notification instanceof SourcedNotification) {
            if (this.sourceIsNotThis((SourcedNotification)notification) && this.sourceIsNotTransformationMappingHelper((SourcedNotification)notification)) {
                UiConstants.Util.start("TransformationNotificationListener.notifyChanged()", "metricsTimingNotifications");
                Object source = ((SourcedNotification)notification).getSource();
                if (source == null) {
                    source = notification.getNotifier();
                }
                if (source instanceof ModelerUndoManager) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    this.handleUndo(notifications, source);
                } else {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    this.handleNotifications(notifications, source);
                }
                UiConstants.Util.stop("TransformationNotificationListener.notifyChanged()", "metricsTimingNotifications");
            }
        } else {
            UiConstants.Util.start("TransformationNotificationListener.notifyChanged()", "metricsTimingNotifications");
            ArrayList<Notification> notifications = new ArrayList<Notification>(1);
            notifications.add(notification);
            this.handleNotifications(notifications, null);
            UiConstants.Util.stop("TransformationNotificationListener.notifyChanged()", "metricsTimingNotifications");
        }
    }

    private boolean sourceIsNotTransformationMappingHelper(SourcedNotification sn) {
        Object source = sn.getSource();
        return !(source instanceof TransformationMappingHelper);
    }

    private boolean sourceIsNotThis(SourcedNotification sn) {
        Object source = sn.getSource();
        if (source == null) {
            return true;
        }
        return !sn.getSource().equals(this);
    }

    private void handleNotifications(Collection notifications, Object source) {
        Collection validNotifications = this.filterNotifications(notifications);
        if (!validNotifications.isEmpty()) {
            Collection modelRenames;
            Collection columnAdds;
            Collection columnChanges;
            Collection virtualTableChanges;
            Collection tableOrColumnRemoves;
            Collection tableOrColumnRenames;
            Collection sqlUIDStatementChanges;
            Collection resultSetRemoves;
            Collection resultSetAdds;
            Collection resultSetColRemoves;
            Collection resultSetColAdds;
            Collection virtualTableColRemoves;
            Collection virtualTableColAdds;
            Collection sqlAliasChanges;
            Collection sqlAliasRemoves;
            Collection sqlAliasAdds = this.getSqlAliasAddNotifications(validNotifications);
            if (!sqlAliasAdds.isEmpty()) {
                this.handleSqlAliasAddNotifications(sqlAliasAdds, source);
            }
            if (!(sqlAliasRemoves = this.getSqlAliasRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleSqlAliasRemoveNotifications(sqlAliasRemoves, source);
            }
            if (!(sqlAliasChanges = this.getSqlAliasChangeNotifications(validNotifications)).isEmpty()) {
                this.handleSqlAliasChangeNotifications(sqlAliasChanges, source);
            }
            if (!(virtualTableColAdds = this.getTargetVirtualTableColumnAddNotifications(validNotifications)).isEmpty()) {
                this.handleTargetVirtualTableColumnAddNotifications(virtualTableColAdds, source);
            }
            if (!(virtualTableColRemoves = this.getTargetVirtualTableColumnRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleTargetVirtualTableColumnRemoveNotifications(virtualTableColRemoves, source);
            }
            if (!(resultSetColAdds = this.getTargetProcedureResultSetColumnAddNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureResultSetColumnAddNotifications(resultSetColAdds, source);
            }
            if (!(resultSetColRemoves = this.getTargetProcedureResultSetColumnRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureResultSetColumnRemoveNotifications(resultSetColRemoves, source);
            }
            if (!(resultSetAdds = this.getTargetProcedureResultSetOrParamAddNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureResultSetOrParamAddNotifications(resultSetAdds, source);
            }
            if (!(resultSetRemoves = this.getTargetProcedureResultSetOrParamRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleTargetProcedureResultSetOrParamRemoveNotifications(resultSetRemoves, source);
            }
            if (!(sqlUIDStatementChanges = this.getSqlSelectUIDStatementChangeNotifications(validNotifications)).isEmpty()) {
                this.handleSqlUIDStatementChangeNotifications(sqlUIDStatementChanges, source);
            }
            if (!(tableOrColumnRenames = this.getSqlTableAndColumnRenameNotifications(validNotifications)).isEmpty()) {
                this.handleSqlTableAndColumnRenameNotifications(tableOrColumnRenames, source);
            }
            if (!(tableOrColumnRemoves = this.getSqlTableAndColumnRemoveNotifications(validNotifications)).isEmpty()) {
                this.handleSqlTableAndColumnRemoveNotifications(tableOrColumnRemoves, source);
            }
            if (!(virtualTableChanges = this.getTargetVirtualTableChangeNotifications(validNotifications)).isEmpty()) {
                this.handleTargetVirtualTableChangeNotifications(virtualTableChanges, source);
            }
            if (!(columnChanges = this.getSqlColumnChangeNotifications(validNotifications)).isEmpty()) {
                this.handleSqlColumnChangeNotifications(columnChanges, source);
            }
            if (!(columnAdds = this.getSqlColumnAddNotifications(validNotifications)).isEmpty()) {
                this.handleSqlTableColumnAddNotifications(columnAdds, source);
            }
            if (!(modelRenames = this.getModelRenameNotifications(validNotifications, source)).isEmpty()) {
                this.handleModelRenameNotifications(modelRenames, source);
            }
        }
    }

    private Collection filterNotifications(Collection notifications) {
        ArrayList<Notification> goodNotifications = new ArrayList<Notification>(notifications.size());
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
            if (changedObj != null && changedObj instanceof EObject && !DiagramUiUtilities.isDiagramObject((EObject)((EObject)changedObj))) {
                if (changedObj instanceof SqlTransformation || changedObj instanceof SqlTransformationMappingRoot || TransformationHelper.isSqlTable((Object)changedObj) || TransformationHelper.isSqlColumn((Object)changedObj) || TransformationHelper.isSqlProcedure((Object)changedObj) || TransformationHelper.isSqlProcedureParameter((Object)changedObj) || TransformationHelper.isSqlColumnSet((Object)changedObj)) {
                    goodNotifications.add(notification);
                    if (!UiConstants.Util.isDebugEnabled("debugNotifications")) continue;
                    UiConstants.Util.debug("debugNotifications", "TransformationNotificationListener.removeUnwantedNotifications( ) Added Notification = " + NotificationUtilities.paramString((Notification)notification));
                    continue;
                }
                if (NotificationUtilities.isRemoved((Notification)notification)) {
                    Object removedObj = notification.getOldValue();
                    if (!TransformationHelper.isSqlTable((Object)removedObj)) continue;
                    goodNotifications.add(notification);
                    continue;
                }
                if (!UiConstants.Util.isDebugEnabled("debugNotifications")) continue;
                UiConstants.Util.debug("debugNotifications", "TransformationNotificationListener.removeUnwantedNotifications( ) Removed Notification = " + NotificationUtilities.paramString((Notification)notification));
                UiConstants.Util.debug("debugNotifications", "           ------ >>> ChangedObject = " + changedObj);
                continue;
            }
            if (!UiConstants.Util.isDebugEnabled("debugNotifications")) continue;
            UiConstants.Util.debug("debugNotifications", "TransformationNotificationListener.removeUnwantedNotifications( ) Removed Notification = " + NotificationUtilities.paramString((Notification)notification));
        }
        return goodNotifications;
    }

    private Collection getSqlAliasAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            EObject[] newChildren;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification) || !this.containsSqlAlias(newChildren = NotificationUtilities.getAddedChildren((Notification)notification))) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlAliasRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            EObject[] removedChildren;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !this.containsSqlAlias(removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification))) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlAliasChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !this.sqlAliasesChanged(notification)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlSelectUIDStatementChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !this.sqlSelectUIDStatementChanged(notification)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlSelectUserStatementChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !this.sqlSelectUserStatementChanged(notification)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlTableAndColumnRenameNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !TransformationHelper.isSqlColumn((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) && !TransformationHelper.isSqlTable((Object)changedObj) && !TransformationHelper.isSqlProcedure((Object)changedObj) && !TransformationHelper.isSqlProcedureParameter((Object)changedObj)) continue;
            EStructuralFeature nameFeature = ModelerCore.getModelEditor().getNameFeature((EObject)changedObj);
            Object feature = notification.getFeature();
            if (feature == null || !feature.equals(nameFeature)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlTableAndColumnRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object removedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isSqlTable((Object)(removedObj = notification.getOldValue())) && !TransformationHelper.isSqlColumn((Object)removedObj) && !TransformationHelper.isSqlProcedure((Object)removedObj) && !TransformationHelper.isSqlProcedureParameter((Object)removedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlColumnChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !TransformationHelper.isSqlColumn((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification)))) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getSqlColumnAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        block0: while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification)) continue;
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
            for (int i = 0; i < newChildren.length; ++i) {
                EObject child = newChildren[i];
                if (!TransformationHelper.isSqlColumn((Object)child)) continue;
                if (result == null) {
                    result = new ArrayList<Notification>(notifications.size());
                }
                result.add(notification);
                iter.remove();
                continue block0;
            }
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetVirtualTableChangeNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !TransformationHelper.isVirtualSqlTable((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj) || !this.isCriticalFeatureChange(notification)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private boolean isCriticalFeatureChange(Notification notification) {
        EStructuralFeature esf;
        return !(notification.getFeature() instanceof EStructuralFeature) || (esf = (EStructuralFeature)notification.getFeature()).getFeatureID() != 4;
    }

    private Collection getTargetVirtualTableColumnAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification) || !TransformationHelper.isVirtualSqlTable((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetVirtualTableColumnRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isVirtualSqlTable((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureResultSetColumnAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            EObject procedure;
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification) || !TransformationHelper.isSqlColumnSet((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isSqlVirtualProcedure((Object)(procedure = ((EObject)changedObj).eContainer())) || !TransformationHelper.isValidSqlTransformationTarget((Object)procedure)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureResultSetColumnRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            EObject procedure;
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isSqlColumnSet((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isSqlVirtualProcedure((Object)(procedure = ((EObject)changedObj).eContainer())) || !TransformationHelper.isValidSqlTransformationTarget((Object)procedure)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureResultSetOrParamAddNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isAdded((Notification)notification) || !TransformationHelper.isSqlVirtualProcedure((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getTargetProcedureResultSetOrParamRemoveNotifications(Collection notifications) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isRemoved((Notification)notification) || !TransformationHelper.isSqlVirtualProcedure((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !TransformationHelper.isValidSqlTransformationTarget((Object)changedObj)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private Collection getModelRenameNotifications(Collection notifications, Object source) {
        ArrayList<Notification> result = null;
        Iterator iter = notifications.iterator();
        while (iter.hasNext()) {
            Object changedObj;
            Notification notification = (Notification)iter.next();
            if (!NotificationUtilities.isChanged((Notification)notification) || !TransformationHelper.isTransformationMappingRoot((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification))) || !(source instanceof RenameRefactorAction)) continue;
            if (result == null) {
                result = new ArrayList<Notification>(notifications.size());
            }
            result.add(notification);
            iter.remove();
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSqlAliasAddNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List addedAliases = this.getSqlAliasesAdded(notifications);
            EObject mappingRoot = this.getMappingRootFromSqlAliasNotifications(notifications);
            if (!addedAliases.isEmpty()) {
                if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                    String debugStr = this.buildAddDebugStr("TransformationNotificationListener.handleSqlAliasesAdded()", mappingRoot, addedAliases, txnSource);
                    if (!(txnSource instanceof TransformationObjectEditorPage)) {
                        System.out.println(debugStr + " <update SQL and reconcile Target attrs>");
                    } else {
                        System.out.println(debugStr + " <reconcile Target attrs>");
                    }
                }
                boolean undoableAdd = false;
                EObject targetObj = TransformationHelper.getTransformationLinkTarget((EObject)mappingRoot);
                if (this.containsProcedure(addedAliases) && TransformationHelper.isSqlTable((Object)targetObj)) {
                    this.handleSqlAliasAddForSourceProcedure(mappingRoot, addedAliases, txnSource);
                } else {
                    boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)undoableAdd, (String)"Update for SqlAlias Add", (Object)this);
                    boolean succeeded = false;
                    try {
                        if (!(txnSource instanceof TransformationObjectEditorPage)) {
                            boolean addElemsToSelect = this.shouldAddElemsToSelect(mappingRoot);
                            TransformationSqlHelper.updateAllSqlOnSqlAliasGroupsAdded((EObject)mappingRoot, (List)addedAliases, (boolean)addElemsToSelect, (Object)txnSource);
                        }
                        succeeded = true;
                    }
                    finally {
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                    requiredStart = ModelerCore.startTxn((boolean)false, (boolean)undoableAdd, (String)"SqlAlias Add - reconcile target", (Object)txnSource);
                    succeeded = false;
                    try {
                        TransformationMappingHelper.reconcileTargetAttributes((EObject)mappingRoot, (Object)txnSource);
                        succeeded = true;
                    }
                    finally {
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                    SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    EObject target = TransformationHelper.getTransformationTarget((Object)mappingRoot);
                    if (TransformationHelper.isTableThatSupportsUpdate((EObject)target)) {
                        TransformationHelper.refreshUpdateStrings((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    }
                }
            }
        }
    }

    private boolean containsProcedure(List addedAliases) {
        ArrayList<Object> sources = new ArrayList<Object>(addedAliases.size());
        Iterator aIter = addedAliases.iterator();
        while (aIter.hasNext()) {
            Object obj = aIter.next();
            if (obj instanceof SqlAlias) {
                SqlAlias sqlAlias = (SqlAlias)obj;
                sources.add(sqlAlias.getAliasedObject());
                continue;
            }
            sources.add(obj);
        }
        return TransformationMappingHelper.hasProcedure(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSqlAliasAddForSourceProcedure(EObject mappingRoot, List addedAliases, Object txnSource) {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"SqlAlias Add - add input params", (Object)this);
        boolean succeeded = false;
        try {
            if (!TransformationHelper.isTargetGroupLocked((Object)mappingRoot)) {
                Iterator iter = addedAliases.iterator();
                ArrayList<Object> tSources = new ArrayList<Object>(addedAliases.size());
                while (iter.hasNext()) {
                    Object addedAlias = iter.next();
                    if (addedAlias instanceof SqlAlias) {
                        EObject aliasedObj = ((SqlAlias)addedAlias).getAliasedObject();
                        if (!TransformationHelper.isSqlProcedure((Object)aliasedObj)) continue;
                        tSources.add(aliasedObj);
                        continue;
                    }
                    if (!TransformationHelper.isSqlProcedure(addedAlias)) continue;
                    tSources.add(addedAlias);
                }
                EObject targetGroup = TransformationHelper.getTransformationTarget((Object)mappingRoot);
                TransformationMappingHelper.addTargetAttrsForProcedureInputParams((EObject)mappingRoot, (EObject)targetGroup, tSources, (Object)this);
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"SqlAlias Add - update SQL", (Object)txnSource);
        succeeded = false;
        try {
            if (!(txnSource instanceof TransformationObjectEditorPage)) {
                boolean addElemsToSelect = this.shouldAddElemsToSelect(mappingRoot);
                TransformationSqlHelper.updateAllSqlOnSqlAliasGroupsAdded((EObject)mappingRoot, (List)addedAliases, (boolean)addElemsToSelect, (Object)txnSource);
            }
            TransformationMappingHelper.reconcileTargetAttributes((EObject)mappingRoot, (Object)txnSource);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSqlAliasRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List removedAliases = this.getSqlAliasesRemoved(notifications);
            EObject mappingRoot = this.getMappingRootFromSqlAliasNotifications(notifications);
            if (!removedAliases.isEmpty()) {
                if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                    String debugStr = this.buildRemoveDebugStr("TransformationNotificationListener.handleSqlAliasesRemoved()", mappingRoot, removedAliases, txnSource);
                    if (!(txnSource instanceof TransformationObjectEditorPage)) {
                        System.out.println(debugStr + " <update SQL and reconcile Target attrs>");
                    } else {
                        System.out.println(debugStr + " <reconcile Target attrs>");
                    }
                }
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update for SqlAlias Remove", (Object)this);
                boolean succeeded = false;
                try {
                    if (!(txnSource instanceof TransformationObjectEditorPage)) {
                        boolean removeElemsFromSelect = this.shouldRemoveGroupElemsFromSelect(mappingRoot, removedAliases);
                        TransformationSqlHelper.updateAllSqlOnSqlAliasGroupsRemoved((EObject)mappingRoot, (List)removedAliases, (boolean)removeElemsFromSelect, (Object)txnSource);
                    }
                    SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    TransformationMappingHelper.reconcileTargetAttributes((EObject)mappingRoot, (Object)txnSource);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSqlAliasChangeNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List removedAliases = this.getSqlAliasesChanged(notifications);
            EObject mappingRoot = this.getMappingRootFromSqlAliasNotifications(notifications);
            if (!removedAliases.isEmpty()) {
                if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                    MappingHelper transEObj = TransformationHelper.getMappingHelper((Object)mappingRoot);
                    String debugStr = this.buildChangeDebugStr("TransformationNotificationListener.handleSqlAliasChanged()", (EObject)transEObj, txnSource);
                    if (!(txnSource instanceof TransformationObjectEditorPage)) {
                        System.out.println(debugStr + " <update SQL and reconcile Target attrs>");
                    } else {
                        System.out.println(debugStr + " <reconcile Target attrs>");
                    }
                }
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update for SqlAlias Change", (Object)this);
                boolean succeeded = false;
                try {
                    if (!(txnSource instanceof TransformationObjectEditorPage)) {
                        boolean removeElemsFromSelect = this.shouldRemoveGroupElemsFromSelect(mappingRoot, removedAliases);
                        TransformationSqlHelper.updateAllSqlOnSqlAliasGroupsRemoved((EObject)mappingRoot, (List)removedAliases, (boolean)removeElemsFromSelect, (Object)txnSource);
                    }
                    TransformationMappingHelper.reconcileTargetAttributes((EObject)mappingRoot, (Object)txnSource);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSqlUIDStatementChangeNotifications(Collection notifications, Object txnSource) {
        boolean sourceIsSqlHelper;
        if (!(notifications.isEmpty() || (sourceIsSqlHelper = this.isSqlHelperSource(txnSource)) || txnSource instanceof TransformationObjectEditorPage)) {
            EObject mappingRoot = this.getMappingRootFromSqlUIDStatementNotifications(notifications);
            if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                MappingHelper transEObj = TransformationHelper.getMappingHelper((Object)mappingRoot);
                String debugStr = this.buildChangeDebugStr("TransformationNotificationListener.handleSqlStatementChanged()", (EObject)transEObj, txnSource);
                System.out.println(debugStr + " <reconcile mappings>");
            }
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update for Sql Statment Change", (Object)this);
            boolean succeeded = false;
            try {
                TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)mappingRoot, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void handleSqlTableAndColumnRenameNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            HashSet<Object> groups = new HashSet<Object>();
            Iterator iter = notifications.iterator();
            while (iter.hasNext()) {
                Notification notification = (Notification)iter.next();
                Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
                if (TransformationHelper.isSqlTable((Object)changedObj)) {
                    groups.add(changedObj);
                    continue;
                }
                if (TransformationHelper.isSqlColumn((Object)changedObj)) {
                    EObject sourceGrp = ((EObject)changedObj).eContainer();
                    groups.add(sourceGrp);
                    continue;
                }
                if (TransformationHelper.isSqlProcedure((Object)changedObj)) {
                    groups.add(changedObj);
                    continue;
                }
                if (!TransformationHelper.isSqlProcedureParameter((Object)changedObj)) continue;
                EObject sourceProc = ((EObject)changedObj).eContainer();
                groups.add(sourceProc);
            }
            if (!groups.isEmpty()) {
                TransformationHelper.invalidateCachedRootsWithSourceGroups(groups);
                TransformationHelper.invalidateCachedRootsWithTargetGroups(groups);
            }
        }
    }

    private void handleSqlTableAndColumnRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            HashSet<Object> groups = new HashSet<Object>();
            Iterator iter = notifications.iterator();
            while (iter.hasNext()) {
                Notification notification = (Notification)iter.next();
                Object removedObj = notification.getOldValue();
                if (TransformationHelper.isSqlTable((Object)removedObj)) {
                    groups.add(removedObj);
                    continue;
                }
                if (TransformationHelper.isSqlColumn((Object)removedObj)) {
                    Object sourceGrp = ModelerCore.getModelEditor().getChangedObject(notification);
                    groups.add(sourceGrp);
                    continue;
                }
                if (TransformationHelper.isSqlProcedure((Object)removedObj)) {
                    groups.add(removedObj);
                    continue;
                }
                if (!TransformationHelper.isSqlProcedureParameter((Object)removedObj)) continue;
                Object sourceProc = ModelerCore.getModelEditor().getChangedObject(notification);
                groups.add(sourceProc);
            }
            if (!groups.isEmpty()) {
                TransformationHelper.invalidateCachedRootsWithSourceGroups(groups);
            }
        }
    }

    private void handleSqlColumnChangeNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            HashSet<EObject> groups = new HashSet<EObject>();
            Iterator iter = notifications.iterator();
            while (iter.hasNext()) {
                Notification notification = (Notification)iter.next();
                Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
                if (!TransformationHelper.isSqlColumn((Object)changedObj)) continue;
                EObject grp = ((EObject)changedObj).eContainer();
                groups.add(grp);
            }
            if (!groups.isEmpty()) {
                TransformationHelper.invalidateCachedRootsWithSourceGroups(groups);
                TransformationHelper.invalidateCachedRootsWithTargetGroups(groups);
            }
        }
    }

    private void handleSqlTableColumnAddNotifications(Collection notifications, Object txnSource) {
        Set tables;
        if (!notifications.isEmpty() && !(tables = this.getSqlTablesAddedTo(notifications)).isEmpty()) {
            SqlMappingRootCache.invalidateRootsWithSourceGroups((Set)tables);
        }
    }

    private void handleTargetVirtualTableChangeNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            SqlTableAspect tableAspect;
            EObject mappingRoot = this.getMappingRootFromVTableNotifications(notifications);
            if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                String debugStr = this.buildChangeDebugStr("TransformationNotificationListener.handleVTableChanged()", mappingRoot, txnSource);
                System.out.println(debugStr + " <invalidate sql cache>");
            }
            SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
            EObject target = TransformationHelper.getTransformationTarget((Object)mappingRoot);
            if (TransformationHelper.isVirtualSqlTable((Object)target) && (tableAspect = (SqlTableAspect)SqlAspectHelper.getSqlAspect((EObject)target)) != null && tableAspect.supportsUpdate(target)) {
                TransformationHelper.refreshUpdateStrings((Object)mappingRoot, (boolean)true, (Object)txnSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetVirtualTableColumnAddNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List addedColumns = this.getSqlColumnsAdded(notifications);
            EObject mappingRoot = this.getMappingRootFromVTableNotifications(notifications);
            if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                String debugStr = this.buildAddDebugStr("TransformationNotificationListener.handleVTableColumnsAdded()", mappingRoot, addedColumns, txnSource);
                System.out.println(debugStr + " <create attr mapping>");
            }
            if (!addedColumns.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create atttr mappings", (Object)this);
                boolean succeeded = false;
                try {
                    Iterator iter = addedColumns.iterator();
                    boolean colsAdded = false;
                    while (iter.hasNext()) {
                        Object column = iter.next();
                        if (!TransformationHelper.isSqlColumn(column) || TransformationHelper.isNonSelectableSqlColumn(column)) continue;
                        AttributeMappingHelper.createAttributeMapping((Object)mappingRoot, (EObject)((EObject)column), (Object)txnSource);
                        colsAdded = true;
                    }
                    if (colsAdded) {
                        SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetVirtualTableColumnRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List removedColumns = this.getSqlColumnsRemoved(notifications);
            EObject mappingRoot = this.getMappingRootFromVTableNotifications(notifications);
            if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                String debugStr = this.buildRemoveDebugStr("TransformationNotificationListener.handleVTableColumnsRemoved()", mappingRoot, removedColumns, txnSource);
                System.out.println(debugStr + " <remove attr mapping>");
            }
            if (!removedColumns.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Remove atttr mappings", (Object)this);
                boolean succeeded = false;
                try {
                    boolean overwriteDirty = false;
                    if (!(txnSource instanceof TransformationObjectEditorPage)) {
                        ModelObjectEditorPage moep;
                        TransformationObjectEditorPage transOEP = null;
                        boolean isDirty = false;
                        ModelResource mdlRsrc = ModelUtilities.getModelResourceForModelObject((EObject)mappingRoot);
                        IResource resource = mdlRsrc.getResource();
                        ModelEditor medit = ModelEditorManager.getModelEditorForFile((IFile)((IFile)resource), (boolean)false);
                        if (medit != null && (moep = medit.getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage && (transOEP = (TransformationObjectEditorPage)moep).hasPendingChanges()) {
                            isDirty = true;
                        }
                        if (isDirty) {
                            String dirtysql;
                            TransformationValidator qv;
                            QueryValidationResult qvr;
                            boolean dirtyValid;
                            String message = UiConstants.Util.getString("TransformationNotificationListener.saveBeforeChangesMsg", (Object)resource.getName());
                            String[] radioButtons = new String[]{SBC_RADIO_SAVE, SBC_RADIO_IGNORE, SBC_RADIO_HALT};
                            IStatus[] radioErrors = new IStatus[]{null, null, null};
                            boolean savedValid = TransformationHelper.isValid((Object)mappingRoot, (int)0);
                            if (!savedValid) {
                                radioErrors[1] = new Status(2, "com.metamatrix.modeler.transformation", -1, SBC_NOTE, null);
                            }
                            if (!(dirtyValid = (qvr = (qv = new TransformationValidator((SqlTransformationMappingRoot)mappingRoot, false)).validateSql(dirtysql = transOEP.getCurrentSqlEditor().getText(), 0, false, false)).isParsable())) {
                                radioErrors[0] = new Status(2, "com.metamatrix.modeler.transformation", -1, SBC_NOTE, null);
                            }
                            int result = RadioMessageDialog.openMulti(null, (int)4, (String)SAVE_BEFORE_CHANGE_TITLE, (String)message, (String)SBC_GROUP_TITLE, (String[])radioButtons, (IStatus[])radioErrors, (int)0);
                            switch (result) {
                                case 0: {
                                    TransformationHelper.setSelectSqlString((Object)mappingRoot, (String)dirtysql, (boolean)false, (Object)txnSource);
                                    TransformationSqlHelper.updateAllSqlOnElementsRemoved((EObject)mappingRoot, (List)removedColumns, (Object)txnSource);
                                    overwriteDirty = true;
                                    break;
                                }
                                case 1: {
                                    TransformationSqlHelper.updateAllSqlOnElementsRemoved((EObject)mappingRoot, (List)removedColumns, (Object)txnSource);
                                    overwriteDirty = true;
                                    break;
                                }
                                case 2: {
                                    overwriteDirty = false;
                                    break;
                                }
                            }
                        } else if (this.shouldRemoveElemsFromSelect(mappingRoot, removedColumns)) {
                            TransformationSqlHelper.updateAllSqlOnElementsRemoved((EObject)mappingRoot, (List)removedColumns, (Object)txnSource);
                            overwriteDirty = true;
                        }
                    }
                    Iterator iter = removedColumns.iterator();
                    boolean mappingRemoved = false;
                    while (iter.hasNext()) {
                        Object column = iter.next();
                        if (!TransformationHelper.isSqlColumn(column)) continue;
                        AttributeMappingHelper.removeAttributeMapping((Object)mappingRoot, (EObject)((EObject)column), (Object)txnSource);
                        mappingRemoved = true;
                    }
                    if (mappingRemoved) {
                        SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource, (boolean)overwriteDirty);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetProcedureResultSetColumnAddNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List addedColumns = this.getSqlColumnsAdded(notifications);
            EObject mappingRoot = this.getMappingRootFromProcResultSetColumnNotifications(notifications);
            if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                String debugStr = this.buildAddDebugStr("TransformationNotificationListener.handleResultSetColumnsAdded()", mappingRoot, addedColumns, txnSource);
                System.out.println(debugStr + " <create attr mapping>");
            }
            if (!addedColumns.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Add atttr mappings", (Object)this);
                boolean succeeded = false;
                try {
                    Iterator iter = addedColumns.iterator();
                    while (iter.hasNext()) {
                        Object column = iter.next();
                        if (!TransformationHelper.isSqlColumn(column) || TransformationHelper.isNonSelectableSqlColumn(column)) continue;
                        AttributeMappingHelper.createAttributeMapping((Object)mappingRoot, (EObject)((EObject)column), (Object)txnSource);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetProcedureResultSetColumnRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            List removedColumns = this.getSqlColumnsRemoved(notifications);
            EObject mappingRoot = this.getMappingRootFromProcResultSetColumnNotifications(notifications);
            if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                String debugStr = this.buildRemoveDebugStr("TransformationNotificationListener.handleResultSetColumnsRemoved()", mappingRoot, removedColumns, txnSource);
                System.out.println(debugStr + " <remove attr mapping>");
            }
            if (!removedColumns.isEmpty()) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Remove atttr mappings", (Object)this);
                boolean succeeded = false;
                try {
                    Iterator iter = removedColumns.iterator();
                    while (iter.hasNext()) {
                        Object column = iter.next();
                        if (!TransformationHelper.isSqlColumn(column)) continue;
                        AttributeMappingHelper.removeAttributeMapping((Object)mappingRoot, (EObject)((EObject)column), (Object)txnSource);
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetProcedureResultSetOrParamAddNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            EObject mappingRoot = this.getMappingRootFromProcResultSetOrParamNotifications(notifications);
            if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                System.out.println("TransformationNotificationListener.handleResultSetAdded() <update attr mappings>");
            }
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update attr mappings", (Object)this);
            boolean succeeded = false;
            try {
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                AttributeMappingHelper.updateAttributeMappings((Object)mappingRoot, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetProcedureResultSetOrParamRemoveNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            EObject mappingRoot = this.getMappingRootFromProcResultSetOrParamNotifications(notifications);
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Update attr mappings", (Object)this);
            boolean succeeded = false;
            try {
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                List targetAttrs = TransformationHelper.getTransformationTargetAttributes((EObject)mappingRoot);
                if (targetAttrs != null && !targetAttrs.isEmpty()) {
                    if (UiConstants.Util.isDebugEnabled("transformationSqlModification") && UiConstants.Util.isDebugEnabled("debugLevelTrace")) {
                        System.out.println("TransformationNotificationListener.handleResultSetRemoved() <update attr mappings>");
                    }
                    SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
                    AttributeMappingHelper.updateAttributeMappings((Object)mappingRoot, (Object)txnSource);
                    succeeded = true;
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void handleModelRenameNotifications(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            Iterator iter = notifications.iterator();
            while (iter.hasNext()) {
                Object changedObj;
                Notification notification = (Notification)iter.next();
                if (!NotificationUtilities.isChanged((Notification)notification) || !TransformationHelper.isTransformationMappingRoot((Object)(changedObj = ModelerCore.getModelEditor().getChangedObject(notification)))) continue;
                SqlMappingRootCache.invalidateSelectStatus((Object)changedObj, (boolean)true, (Object)txnSource);
            }
        }
    }

    private void handleUndo(Collection notifications, Object txnSource) {
        if (!notifications.isEmpty()) {
            Collection selectUserNotifications = this.getSqlSelectUserStatementChangeNotifications(notifications);
            Collection selectUIDNotifications = this.getSqlSelectUIDStatementChangeNotifications(notifications);
            if (!selectUIDNotifications.isEmpty()) {
                EObject mappingRoot = this.getMappingRootFromSqlUIDStatementNotifications(selectUIDNotifications);
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
            } else if (!selectUserNotifications.isEmpty()) {
                EObject mappingRoot = this.getMappingRootFromSqlUserStatementNotifications(selectUserNotifications);
                SqlMappingRootCache.invalidateSelectStatus((Object)mappingRoot, (boolean)true, (Object)txnSource);
            }
        }
    }

    private EObject getMappingRootFromSqlAliasNotifications(Collection sqlAliasNotifications) {
        Mapping mappingRoot = null;
        Iterator iter = sqlAliasNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null) {
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(firstNotification);
            mappingRoot = TransformationHelper.getMappingRoot((MappingHelper)((MappingHelper)changedObj));
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromVTableNotifications(Collection vTableNotifications) {
        EObject mappingRoot = null;
        Iterator iter = vTableNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null) {
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(firstNotification);
            mappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)((EObject)changedObj));
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromProcResultSetColumnNotifications(Collection resultSetNotifications) {
        Object resultSet;
        EObject mappingRoot = null;
        Iterator iter = resultSetNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null && TransformationHelper.isSqlColumnSet((Object)(resultSet = ModelerCore.getModelEditor().getChangedObject(firstNotification)))) {
            EObject procedure = ((EObject)resultSet).eContainer();
            mappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)procedure);
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromProcResultSetOrParamNotifications(Collection resultSetNotifications) {
        Object procedure;
        EObject mappingRoot = null;
        Iterator iter = resultSetNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null && TransformationHelper.isSqlProcedure((Object)(procedure = ModelerCore.getModelEditor().getChangedObject(firstNotification)))) {
            mappingRoot = TransformationHelper.getTransformationMappingRoot((EObject)((EObject)procedure));
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromSqlUIDStatementNotifications(Collection sqlNotifications) {
        Mapping mappingRoot = null;
        Iterator iter = sqlNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null) {
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(firstNotification);
            mappingRoot = TransformationHelper.getMappingRoot((MappingHelper)((MappingHelper)changedObj));
        }
        return mappingRoot;
    }

    private EObject getMappingRootFromSqlUserStatementNotifications(Collection sqlNotifications) {
        Mapping mappingRoot = null;
        Iterator iter = sqlNotifications.iterator();
        Notification firstNotification = (Notification)iter.next();
        if (firstNotification != null) {
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(firstNotification);
            EObject parentEObj = ((EObject)changedObj).eContainer();
            mappingRoot = TransformationHelper.getMappingRoot((MappingHelper)((MappingHelper)parentEObj));
        }
        return mappingRoot;
    }

    private List getSqlAliasesAdded(Collection addNotifications) {
        ArrayList<EObject> sqlAliasList = new ArrayList<EObject>();
        Iterator iter = addNotifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
            for (int i = 0; i < newChildren.length; ++i) {
                if (!(newChildren[i] instanceof SqlAlias) || sqlAliasList.contains(newChildren[i])) continue;
                sqlAliasList.add(newChildren[i]);
            }
        }
        return sqlAliasList;
    }

    private List getSqlAliasesRemoved(Collection removeNotifications) {
        ArrayList<EObject> sqlAliasList = new ArrayList<EObject>();
        Iterator iter = removeNotifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            EObject[] newChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            for (int i = 0; i < newChildren.length; ++i) {
                if (!(newChildren[i] instanceof SqlAlias) || sqlAliasList.contains(newChildren[i])) continue;
                sqlAliasList.add(newChildren[i]);
            }
        }
        return sqlAliasList;
    }

    private List getSqlAliasesChanged(Collection changeNotifications) {
        ArrayList<Object> sqlAliasList = new ArrayList<Object>();
        Iterator iter = changeNotifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            Object removedAlias = notification.getOldValue();
            if (removedAlias instanceof SqlAlias && !sqlAliasList.contains(removedAlias)) {
                sqlAliasList.add(removedAlias);
                continue;
            }
            if (!(removedAlias instanceof List)) continue;
            Iterator listIter = ((List)removedAlias).iterator();
            while (listIter.hasNext()) {
                Object nextObj = listIter.next();
                if (!(nextObj instanceof SqlAlias) || sqlAliasList.contains(nextObj)) continue;
                sqlAliasList.add(nextObj);
            }
        }
        return sqlAliasList;
    }

    private List getSqlColumnsAdded(Collection addNotifications) {
        ArrayList<EObject> tableColumnList = new ArrayList<EObject>();
        Iterator iter = addNotifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
            for (int i = 0; i < newChildren.length; ++i) {
                if (!TransformationHelper.isSqlColumn((Object)newChildren[i]) || tableColumnList.contains(newChildren[i])) continue;
                tableColumnList.add(newChildren[i]);
            }
        }
        return tableColumnList;
    }

    private List getSqlColumnsRemoved(Collection removeNotifications) {
        ArrayList<EObject> tableColumnList = new ArrayList<EObject>();
        Iterator iter = removeNotifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            for (int i = 0; i < removedChildren.length; ++i) {
                if (!TransformationHelper.isSqlColumn((Object)removedChildren[i]) || tableColumnList.contains(removedChildren[i])) continue;
                tableColumnList.add(removedChildren[i]);
            }
        }
        return tableColumnList;
    }

    private Set getSqlTablesAddedTo(Collection addNotifications) {
        HashSet<Object> tableSet = new HashSet<Object>();
        Iterator iter = addNotifications.iterator();
        while (iter.hasNext()) {
            Notification notification = (Notification)iter.next();
            Object table = ModelerCore.getModelEditor().getChangedObject(notification);
            tableSet.add(table);
        }
        return tableSet;
    }

    private boolean containsSqlAlias(EObject[] eObjects) {
        boolean hasSqlAlias = false;
        for (int i = 0; i < eObjects.length; ++i) {
            if (!(eObjects[i] instanceof SqlAlias)) continue;
            hasSqlAlias = true;
            break;
        }
        return hasSqlAlias;
    }

    private String getEObjectDesc(EObject eObj) {
        String desc = "";
        if (eObj != null) {
            desc = eObj.toString();
            if (eObj instanceof SqlTransformationMappingRoot) {
                desc = "SqlTransMappingRoot ";
            } else if (eObj instanceof SqlTransformation) {
                desc = "SqlTransformation ";
            } else if (eObj instanceof SqlAlias) {
                SqlAlias sqlAlias = (SqlAlias)eObj;
                String aliasedObjName = this.getEObjectDesc(sqlAlias.getAliasedObject());
                String alias = sqlAlias.getAlias();
                desc = !alias.equalsIgnoreCase(aliasedObjName) ? aliasedObjName + " AS " + alias : alias;
            } else if (TransformationHelper.isSqlTable((Object)eObj)) {
                desc = TransformationHelper.getSqlEObjectName((EObject)eObj);
            } else if (TransformationHelper.isSqlColumn((Object)eObj)) {
                desc = TransformationHelper.getSqlEObjectName((EObject)eObj);
            }
        }
        return desc;
    }

    private String getSourceDesc(Object source) {
        int index;
        String sourceStr = "NULL";
        if (source != null && (index = (sourceStr = source.getClass().getName()).lastIndexOf(46)) != -1) {
            sourceStr = sourceStr.substring(index + 1);
        }
        return sourceStr;
    }

    private String getEObjectDescs(List eObjs) {
        StringBuffer sb = new StringBuffer();
        if (eObjs != null) {
            Iterator iter = eObjs.iterator();
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                sb.append(this.getEObjectDesc(eObj));
                if (!iter.hasNext()) continue;
                sb.append(" ,");
            }
        }
        return sb.toString();
    }

    private String buildAddDebugStr(String prefixStr, EObject changedEObj, List addedEObjs, Object source) {
        StringBuffer sb = new StringBuffer(prefixStr);
        sb.append(", modifiedObject= " + this.getEObjectDesc(changedEObj));
        sb.append(", added Children= " + this.getEObjectDescs(addedEObjs));
        sb.append(", source= " + this.getSourceDesc(source));
        return sb.toString();
    }

    private String buildRemoveDebugStr(String prefixStr, EObject changedEObj, List addedEObjs, Object source) {
        StringBuffer sb = new StringBuffer(prefixStr);
        sb.append(", modifiedObject= " + this.getEObjectDesc(changedEObj));
        sb.append(", removed Children= " + this.getEObjectDescs(addedEObjs));
        sb.append(", source= " + this.getSourceDesc(source));
        return sb.toString();
    }

    private String buildChangeDebugStr(String prefixStr, EObject changedEObj, Object source) {
        StringBuffer sb = new StringBuffer(prefixStr);
        sb.append(", modifiedObject= " + this.getEObjectDesc(changedEObj));
        sb.append(", source= " + this.getSourceDesc(source));
        return sb.toString();
    }

    private boolean isSqlHelperSource(Object source) {
        boolean isSqlHelper = false;
        if (source != null && source.equals(TransformationSqlHelper.getInstance())) {
            isSqlHelper = true;
        }
        return isSqlHelper;
    }

    private boolean sqlAliasesChanged(Notification notification) {
        int changedFeature;
        boolean aliasesChanged = false;
        Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
        if (changedObj instanceof SqlTransformation && (changedFeature = notification.getFeatureID(class$com$metamatrix$metamodels$transformation$SqlTransformation == null ? (class$com$metamatrix$metamodels$transformation$SqlTransformation = TransformationNotificationListener.class$("com.metamatrix.metamodels.transformation.SqlTransformation")) : class$com$metamatrix$metamodels$transformation$SqlTransformation)) == 15) {
            aliasesChanged = true;
        }
        return aliasesChanged;
    }

    private boolean sqlSelectUIDStatementChanged(Notification notification) {
        EObject parent;
        Object changedObj;
        boolean selectUIDStatementChanged = false;
        int changedFeature = notification.getFeatureID(class$com$metamatrix$metamodels$transformation$SqlTransformation == null ? (class$com$metamatrix$metamodels$transformation$SqlTransformation = TransformationNotificationListener.class$("com.metamatrix.metamodels.transformation.SqlTransformation")) : class$com$metamatrix$metamodels$transformation$SqlTransformation);
        if (changedFeature == 4 && (changedObj = ModelerCore.getModelEditor().getChangedObject(notification)) != null && changedObj instanceof SqlTransformation && !TransformationHelper.isSqlTransformation((Object)(parent = ((EObject)changedObj).eContainer()))) {
            selectUIDStatementChanged = true;
        }
        return selectUIDStatementChanged;
    }

    private boolean sqlSelectUserStatementChanged(Notification notification) {
        EObject parent;
        Object changedObj;
        boolean selectUserStatementChanged = false;
        int changedFeature = notification.getFeatureID(class$com$metamatrix$metamodels$transformation$SqlTransformation == null ? (class$com$metamatrix$metamodels$transformation$SqlTransformation = TransformationNotificationListener.class$("com.metamatrix.metamodels.transformation.SqlTransformation")) : class$com$metamatrix$metamodels$transformation$SqlTransformation);
        if (changedFeature == 4 && (changedObj = ModelerCore.getModelEditor().getChangedObject(notification)) != null && changedObj instanceof SqlTransformation && TransformationHelper.isSqlTransformation((Object)(parent = ((EObject)changedObj).eContainer()))) {
            selectUserStatementChanged = true;
        }
        return selectUserStatementChanged;
    }

    private boolean shouldAddElemsToSelect(Object mappingRoot) {
        Command selectCommand;
        boolean addElemsToSelect = false;
        if (TransformationHelper.isValid((Object)mappingRoot, (int)0) && (selectCommand = SqlMappingRootCache.getSelectCommand((Object)mappingRoot)) instanceof Query) {
            IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
            boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
            Select querySelect = ((Query)selectCommand).getSelect();
            if (!TransformationSqlHelper.isSelectStar((Select)querySelect) && !disableCallbacks) {
                String message = UiConstants.Util.getString("TransformationNotificationListener.addSQLElemGrpAttrsMsg", (Object)DEFAULT_ADDED_SOURCE);
                addElemsToSelect = MessageDialog.openQuestion(null, (String)ADD_SQL_ELEM_GRP_REFS_TITLE, (String)message);
            } else {
                addElemsToSelect = true;
            }
        }
        return addElemsToSelect;
    }

    private boolean shouldRemoveGroupElemsFromSelect(Object mappingRoot, List sqlAliasGroups) {
        Command selectCommand;
        boolean removeElemsFromSelect = false;
        if (TransformationHelper.isValid((Object)mappingRoot, (int)0) && (selectCommand = SqlMappingRootCache.getSelectCommand((Object)mappingRoot)) instanceof Query) {
            IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
            boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
            Select querySelect = ((Query)selectCommand).getSelect();
            if (!TransformationSqlHelper.isSelectStar((Select)querySelect) && TransformationSqlHelper.hasSqlAliasGroupAttributes((Query)((Query)selectCommand), (List)sqlAliasGroups) && !disableCallbacks) {
                String message = UiConstants.Util.getString("TransformationNotificationListener.removeSQLElemGrpRefsMsg", (Object)DEFAULT_REMOVED_SOURCE);
                removeElemsFromSelect = MessageDialog.openQuestion(null, (String)REMOVE_SQL_ELEM_GRP_REFS_TITLE, (String)message);
            } else {
                removeElemsFromSelect = true;
            }
        }
        return removeElemsFromSelect;
    }

    private boolean shouldRemoveElemsFromSelect(Object mappingRoot, List sqlColumns) {
        boolean removeElemsFromSelect = false;
        if (TransformationHelper.isValid((Object)mappingRoot, (int)0)) {
            Object firstQuery;
            List queries;
            Command selectCommand = SqlMappingRootCache.getSelectCommand((Object)mappingRoot);
            Query selectQuery = null;
            if (selectCommand instanceof Query) {
                selectQuery = (Query)selectCommand;
            } else if (selectCommand instanceof SetQuery && (queries = ((SetQuery)selectCommand).getQueries()).size() > 0 && (firstQuery = queries.get(0)) instanceof Query) {
                selectQuery = (Query)firstQuery;
            }
            if (selectQuery != null) {
                IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
                boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
                removeElemsFromSelect = TransformationSqlHelper.hasSqlElemSymbols((Query)selectQuery, (List)sqlColumns) && !disableCallbacks ? MessageDialog.openQuestion(null, (String)REMOVE_SQL_ELEMS_TITLE, (String)REMOVE_SQL_ELEMS_MSG) : true;
            }
        }
        return removeElemsFromSelect;
    }

    public void processEvent(EventObject obj) {
        ModelResourceEvent event = (ModelResourceEvent)obj;
        if (event.getType() == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SqlMappingRootCache.invalidateRootsOnProjectOrModelRemove();
                }
            });
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WorkspaceNotificationListener
    implements ModelWorkspaceNotificationListener {
        public void notifyAdd(ModelWorkspaceNotification notification) {
        }

        public void notifyRemove(ModelWorkspaceNotification notification) {
            if (notification.isPostChange()) {
                IResource resource;
                if (notification.isProject()) {
                    Display.getDefault().asyncExec(new Runnable(this){
                        private final /* synthetic */ WorkspaceNotificationListener this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            SqlMappingRootCache.invalidateRootsOnProjectOrModelRemove();
                        }
                    });
                } else if (notification.isFile() && ModelUtil.isModelFile((IResource)(resource = (IResource)notification.getNotifier()))) {
                    Display.getDefault().asyncExec(new Runnable(this){
                        private final /* synthetic */ WorkspaceNotificationListener this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            SqlMappingRootCache.invalidateRootsOnProjectOrModelRemove();
                        }
                    });
                }
            }
        }

        public void notifyMove(ModelWorkspaceNotification notification) {
        }

        public void notifyRename(ModelWorkspaceNotification notification) {
        }

        public void notifyOpen(ModelWorkspaceNotification notification) {
        }

        public void notifyClosing(ModelWorkspaceNotification notification) {
        }

        public void notifyClosed(ModelWorkspaceNotification notification) {
        }

        public void notifyChanged(Notification theNotification) {
        }

        public void notifyChange(ModelWorkspaceNotification notification) {
        }

        public void notifyReloaded(ModelWorkspaceNotification notification) {
        }
    }
}

