/*
 [The "BSD licence"]
 Copyright (c) 2003-2004 Terence Parr
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package org.antlr.stringtemplate.test;

import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

/** Terence's own version of a test case.  Got sick of trying to figure out
 *  the quirks of junit...this is pretty much the same functionality and
 *  only took me a few minutes to write.  Only missing the gui I guess from junit.
 */
public abstract class TestSuite {
    public String testName = null;

    int failures = 0, successes=0;

    public void assertTrue(boolean test) throws FailedAssertionException {
        if ( !test ) {
            throw new FailedAssertionException();
        }
    }

	public void time(String name, int n) throws Throwable {
		System.gc();
		long start = System.currentTimeMillis();
		System.out.print("TIME: "+name);
		for (int i=1; i<=n; i++) {
			invokeTest(name);
		}
		long finish = System.currentTimeMillis();
		long t = (finish-start);
		System.out.println("; n="+n+" "+t+"ms ("+((((double)t)/n)*1000.0)+" microsec/eval)");
	}

	public void runTest(String name) {
		try {
			System.out.println("TEST: "+name);
			invokeTest(name);
			successes++;
		}
		catch (Throwable e) {
			failures++;
			System.err.println(name+" failed");
			e.printStackTrace();
		}
	}

	public void invokeTest(String name) throws Throwable {
        testName = name;
        try {
			Class c = this.getClass();
			Method m = c.getMethod(name,null);
            m.invoke(this,null);
        }
		catch (IllegalAccessException iae) {
            failures++;
			System.err.println("cannot exec test "+name);
		}
		catch (NoSuchMethodException nsme) {
            failures++;
			System.err.println("cannot exec test "+name);
		}
		catch (InvocationTargetException ite) {
            System.err.println("cannot exec test "+name);
            throw ite.getCause();
		}
    }

    public abstract void runTests() throws Throwable;

    public int getFailures() {
        return failures;
    }

    public int getSuccesses() {
        return successes;
    }

}
