/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.ui.sqleditor;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.query.internal.ui.builder.CriteriaBuilder;
import com.metamatrix.query.internal.ui.builder.ExpressionBuilder;
import com.metamatrix.query.internal.ui.builder.util.ElementViewerFactory;
import com.metamatrix.query.internal.ui.sqleditor.SqlEditorInternalEvent;
import com.metamatrix.query.internal.ui.sqleditor.SqlTextViewer;
import com.metamatrix.query.internal.ui.sqleditor.actions.DownFont;
import com.metamatrix.query.internal.ui.sqleditor.actions.ExpandSelect;
import com.metamatrix.query.internal.ui.sqleditor.actions.ExportToFile;
import com.metamatrix.query.internal.ui.sqleditor.actions.ImportFromFile;
import com.metamatrix.query.internal.ui.sqleditor.actions.LaunchCriteriaBuilder;
import com.metamatrix.query.internal.ui.sqleditor.actions.LaunchExpressionBuilder;
import com.metamatrix.query.internal.ui.sqleditor.actions.ToggleMessage;
import com.metamatrix.query.internal.ui.sqleditor.actions.ToggleOptimizer;
import com.metamatrix.query.internal.ui.sqleditor.actions.UpFont;
import com.metamatrix.query.internal.ui.sqleditor.actions.Validate;
import com.metamatrix.query.internal.ui.sqleditor.component.AliasSymbolDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.CriteriaDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DeleteDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeConstants;
import com.metamatrix.query.internal.ui.sqleditor.component.DisplayNodeUtils;
import com.metamatrix.query.internal.ui.sqleditor.component.ExpressionDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.FromDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.GroupSymbolFinder;
import com.metamatrix.query.internal.ui.sqleditor.component.QueryDisplayComponent;
import com.metamatrix.query.internal.ui.sqleditor.component.QueryDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.SelectDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.SetQueryDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.SqlIndexLocator;
import com.metamatrix.query.internal.ui.sqleditor.component.UpdateDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.component.WhereDisplayNode;
import com.metamatrix.query.internal.ui.sqleditor.sql.ColorManager;
import com.metamatrix.query.resolver.util.QueryValidator;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.util.ElementSymbolOptimizer;
import com.metamatrix.query.sql.visitor.CommandCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import com.metamatrix.query.sql.visitor.SubqueryFromClauseCollectorVisitor;
import com.metamatrix.query.ui.UiConstants;
import com.metamatrix.query.ui.UiPlugin;
import com.metamatrix.query.ui.sqleditor.SqlEditorEvent;
import com.metamatrix.ui.text.ScaledFontManager;
import com.metamatrix.ui.text.TextFontManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;

public class SqlEditorPanel
extends SashForm
implements UiConstants,
DisplayNodeConstants,
SelectionListener,
ISelectionChangedListener,
IPropertyChangeListener,
KeyListener,
MouseListener {
    private static final String QUERY_CHANGES_PENDING_MESSAGE = UiPlugin.getDefault().getPluginUtil().getString("SqlEditorPanel.changesPendingMsg");
    private static final String IMPORT_PROBLEM = "SqlEditorPanel.importProb";
    private static final String EXPORT_PROBLEM = "SqlEditorPanel.exportProb";
    private static final String EXPORT_SQL_DIALOG_TITLE = "SqlEditorPanel.exportSqlDialog.title";
    private static final String IMPORT_SQL_DIALOG_TITLE = "SqlEditorPanel.importSqlDialog.title";
    private static final String IMPORT_SQL_PROBLEM_DIALOG_TITLE = "SqlEditorPanel.importSqlProblemDialog.title";
    private static final String EXPORT_DEFAULT_FILENAME = "SqlEditorPanel.exportDefaultFile.text";
    private static final String EXPORT_DEFAULT_FILEEXT = "SqlEditorPanel.exportDefaultExtension.text";
    private ColorManager colorManager;
    private IVerticalRuler verticalRuler;
    private SqlTextViewer sqlTextViewer;
    private Document sqlDocument;
    private boolean messageShowing = true;
    private StyledText messageArea;
    private QueryDisplayComponent queryDisplayComponent;
    private ViewForm sqlViewForm;
    private String sqlText = null;
    private boolean validateSelected = false;
    private boolean hasPendingChanges = false;
    private boolean isCompleteRefresh = false;
    private boolean hasUserError = false;
    private boolean isEditable = true;
    private TextFontManager tfmManager;
    private boolean selectExpansionEnabled = true;
    private boolean selectDropsEnabled = true;
    private int caretOffset = -1;
    private int caretXPosition = 0;
    private int caretYPosition = 0;
    private List actionList = null;
    Validate validateAction;
    LaunchCriteriaBuilder launchCriteriaBuilderAction;
    LaunchExpressionBuilder launchExpressionBuilderAction;
    ExpandSelect expandSelectAction;
    ToggleMessage toggleMessageAction;
    ToggleOptimizer toggleOptimizerAction;
    UpFont upFontAction;
    DownFont downFontAction;
    ImportFromFile importFromFileAction;
    ExportToFile exportToFileAction;
    private Object eventSource;
    protected static final int VERTICAL_RULER_WIDTH = 0;
    private List eventListeners;
    private List internalEventListeners;
    private Collection externalBuilderGroups = null;
    private String savedSql = "";
    private String currentMessage = "";
    private List setQueryStates;

    public SqlEditorPanel(Composite parent, QueryValidator queryValidator, int queryType) {
        super(parent, 512);
        this.init(queryValidator, queryType);
    }

    private void init(QueryValidator queryValidator, int queryType) {
        this.queryDisplayComponent = new QueryDisplayComponent(queryValidator, queryType);
        this.colorManager = new ColorManager();
        this.sqlViewForm = new ViewForm((Composite)this, 2048);
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)this.sqlViewForm, this.verticalRuler, styles, this.colorManager);
        this.sqlViewForm.setContent(this.sqlTextViewer.getControl());
        this.sqlTextViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.character == '\u007f' || event.stateMask == 262144 && event.character == ' ') {
                    event.doit = false;
                    SqlEditorPanel.this.sqlTextViewer.showAssistance();
                }
            }
        });
        this.sqlTextViewer.getTextWidget().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent event) {
                SqlEditorPanel.this.sqlTextViewer.handleDoubleClick();
            }

            public void mouseUp(MouseEvent event) {
            }

            public void mouseDown(MouseEvent event) {
                SqlEditorPanel.this.captureCaretInfo();
            }
        });
        this.sqlTextViewer.getTextWidget().addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
            }
        });
        this.sqlDocument = new Document();
        this.sqlTextViewer.setDocument((IDocument)this.sqlDocument);
        this.sqlTextViewer.setEditable(true);
        this.isEditable = true;
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean optimizationOn = prefStore.getBoolean("query.ui.preference.sqlOptimizationOn");
        this.queryDisplayComponent.setOptimizerOn(optimizationOn);
        this.sqlTextViewer.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        Control control = this.sqlTextViewer.getControl();
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.setLayoutData(gridData);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gridData);
        ViewForm msgViewForm = new ViewForm((Composite)this, 2048);
        int messageAreaStyle = 584;
        this.messageArea = new StyledText((Composite)msgViewForm, messageAreaStyle);
        this.messageArea.setLayoutData((Object)gridData);
        this.messageArea.setBackground(this.getDisplay().getSystemColor(22));
        msgViewForm.setContent((Control)this.messageArea);
        this.sqlTextViewer.getTextWidget().addSelectionListener((SelectionListener)this);
        this.sqlTextViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.sqlTextViewer.getTextWidget().addKeyListener((KeyListener)this);
        this.sqlTextViewer.getTextWidget().addMouseListener((MouseListener)this);
        int[] wts = new int[]{4, 1};
        this.setWeights(wts);
        this.showMessageArea(false);
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.sqlDocument.addDocumentListener((IDocumentListener)new DocumentChangeListener());
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propStr = e.getProperty();
        if (propStr != null && (propStr.equals("query.ui.preference.startClausesOnNewLine") || propStr.equals("query.ui.preference.indentClauseContent")) && !this.isDisposed() && this.isVisible()) {
            this.setText(this.getText());
        }
    }

    public void setQueryValidator(QueryValidator validator) {
        this.queryDisplayComponent.setQueryValidator(validator);
    }

    public String getText() {
        return this.sqlDocument.get();
    }

    public void setText(String sql, Object source) {
        this.eventSource = source;
        String theSql = sql;
        if (sql == null) {
            theSql = "";
        }
        boolean setSqlText = false;
        if (this.sqlText == null || !this.sqlText.equalsIgnoreCase(sql)) {
            setSqlText = true;
        }
        if (setSqlText) {
            this.sqlText = sql;
            this.queryDisplayComponent.setText(theSql);
            this.refreshWithDisplayComponent();
            this.eventSource = this;
        }
    }

    public void setText(String sql) {
        this.eventSource = this;
        String theSql = sql;
        if (sql == null) {
            theSql = "";
        }
        this.queryDisplayComponent.setText(theSql);
        this.refreshWithDisplayComponent();
    }

    public void validate() {
        String panelText = this.getText();
        this.validateSelected = true;
        this.setText(panelText, (Object)this);
    }

    public boolean threadIsNotDisplayThread() {
        return this.getDisplay() != null && Thread.currentThread() != this.getDisplay().getThread();
    }

    private void refreshWithDisplayComponent() {
        this.hasPendingChanges = false;
        this.isCompleteRefresh = true;
        if (this.threadIsNotDisplayThread()) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SqlEditorPanel.this.setMessage(SqlEditorPanel.this.queryDisplayComponent);
                    SqlEditorPanel.this.sqlDocument.set(SqlEditorPanel.this.queryDisplayComponent.toDisplayString());
                    SqlEditorPanel.this.setQueryTextBackground();
                }
            });
        } else {
            this.setMessage(this.queryDisplayComponent);
            this.sqlDocument.set(this.queryDisplayComponent.toDisplayString());
            this.setQueryTextBackground();
        }
    }

    private void fireEditorEvent() {
        if (this.eventSource == null) {
            this.eventSource = this;
        }
        boolean isParsable = this.queryDisplayComponent.isParsable();
        boolean isResolvable = this.queryDisplayComponent.isResolvable();
        boolean isValidatable = this.queryDisplayComponent.isValidatable();
        SqlEditorEvent event = null;
        if (this.hasPendingChanges) {
            event = new SqlEditorEvent(this.eventSource, 0);
        } else if (!isParsable) {
            event = new SqlEditorEvent(this.eventSource, this.getText(), 1);
        } else if (!isResolvable) {
            event = new SqlEditorEvent(this.eventSource, this.getCommand(), 2);
        } else if (!isValidatable) {
            Command theCommand = (Command)this.getCommand().clone();
            if (this.isOptimizerOn()) {
                ElementSymbolOptimizer.fullyQualifyElements((Command)theCommand);
            }
            event = new SqlEditorEvent(this.eventSource, theCommand, 3);
        } else {
            Command theCommand = (Command)this.getCommand().clone();
            if (this.isOptimizerOn()) {
                ElementSymbolOptimizer.fullyQualifyElements((Command)theCommand);
            }
            event = new SqlEditorEvent(this.eventSource, theCommand, 4);
        }
        this.notifyEventListeners((EventObject)event);
    }

    private void notifyCaretChanged() {
        this.notifyEventListeners((EventObject)new SqlEditorEvent((Object)this, 5));
    }

    protected void fireEditorInternalEvent(int eventType) {
        SqlEditorInternalEvent event = new SqlEditorInternalEvent((Object)this, eventType);
        this.notifyInternalEventListeners((EventObject)event);
    }

    public void addEventListener(EventObjectListener listener) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList();
        }
        this.eventListeners.add(listener);
    }

    public void removeEventListener(EventObjectListener listener) {
        if (this.eventListeners != null) {
            this.eventListeners.remove(listener);
        }
    }

    private void notifyEventListeners(EventObject event) {
        if (this.eventListeners != null) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                EventObjectListener listener = (EventObjectListener)iterator.next();
                if (listener == null) continue;
                listener.processEvent(event);
            }
        }
    }

    public void addInternalEventListener(EventObjectListener listener) {
        if (this.internalEventListeners == null) {
            this.internalEventListeners = new ArrayList();
        }
        this.internalEventListeners.add(listener);
    }

    public void removeInternalEventListener(EventObjectListener listener) {
        if (this.internalEventListeners != null) {
            this.internalEventListeners.remove(listener);
        }
    }

    private void notifyInternalEventListeners(EventObject event) {
        if (this.internalEventListeners != null) {
            Iterator iterator = this.internalEventListeners.iterator();
            while (iterator.hasNext()) {
                EventObjectListener listener = (EventObjectListener)iterator.next();
                if (listener == null) continue;
                listener.processEvent(event);
            }
        }
    }

    public Command getCommand() {
        return this.queryDisplayComponent.getCommand();
    }

    public void showMessageArea(boolean show) {
        if (!this.isDisposed()) {
            if (show != this.messageShowing) {
                if (show) {
                    this.setMaximizedControl(null);
                    this.setMessage(this.currentMessage);
                } else {
                    this.setMaximizedControl((Control)this.sqlViewForm);
                }
                this.messageShowing = !this.messageShowing;
            }
            this.fireEditorInternalEvent(3);
        }
    }

    public boolean isMessageAreaVisible() {
        return this.messageShowing;
    }

    private void setMessage(QueryDisplayComponent displayComponent) {
        this.setMessage(this.queryDisplayComponent.getStatusMessage());
    }

    public void setMessage(String messageText) {
        this.currentMessage = messageText;
        if (!this.messageArea.isDisposed()) {
            if (this.threadIsNotDisplayThread()) {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (SqlEditorPanel.this.currentMessage != null) {
                            SqlEditorPanel.this.messageArea.setText(SqlEditorPanel.this.currentMessage);
                        } else {
                            SqlEditorPanel.this.messageArea.setText("");
                        }
                    }
                });
            } else if (this.currentMessage != null) {
                this.messageArea.setText(this.currentMessage);
            } else {
                this.messageArea.setText("");
            }
        }
    }

    public void setSelectDropsEnabled(boolean status) {
        this.selectDropsEnabled = status;
    }

    public void setSelectExpansionEnabled(boolean status) {
        this.selectExpansionEnabled = status;
    }

    public void setSetQueryReconciledStates(List reconciledStates) {
        this.setQueryStates = reconciledStates;
        this.setTextViewerBackgroundColors(this.getCaretOffset());
    }

    private void setQueryTextBackground() {
        StyledText sqlTextArea = this.sqlTextViewer.getTextWidget();
        if (sqlTextArea != null) {
            if (this.hasPendingChanges || this.hasUserError) {
                sqlTextArea.setBackground(this.colorManager.getColor(ColorManager.BACKGROUND_INVALID));
                return;
            }
            if (!this.isEditable) {
                sqlTextArea.setBackground(this.getBackground());
            } else if (this.queryDisplayComponent.isValidatable()) {
                sqlTextArea.setBackground(this.colorManager.getColor(ColorManager.BACKGROUND_VALID));
            } else {
                sqlTextArea.setBackground(this.colorManager.getColor(ColorManager.BACKGROUND_INVALID));
            }
        }
    }

    public void setEditable(final boolean status) {
        if (this.threadIsNotDisplayThread()) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    SqlEditorPanel.this.sqlTextViewer.setEditable(status);
                    SqlEditorPanel.this.setQueryTextBackground();
                }
            });
        } else {
            this.sqlTextViewer.setEditable(status);
            this.setQueryTextBackground();
        }
        this.isEditable = status;
        this.fireEditorInternalEvent(2);
    }

    public void setExternalBuilderGroups(Collection groups) {
        this.externalBuilderGroups = groups;
    }

    public void setOptimizerEnabled(boolean status) {
        boolean isEnabled = this.isOptimizerEnabled();
        if (status != isEnabled) {
            this.queryDisplayComponent.setOptimizerEnabled(status);
            this.fireEditorInternalEvent(6);
        }
    }

    public void setOptimizerOn(boolean status) {
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean currentValue = prefStore.getBoolean("query.ui.preference.sqlOptimizationOn");
        if (status != currentValue) {
            prefStore.setValue("query.ui.preference.sqlOptimizationOn", status);
        }
        boolean isEnabled = this.isOptimizerEnabled();
        boolean isOn = this.isOptimizerOn();
        if (isEnabled && status != isOn) {
            this.queryDisplayComponent.setOptimizerOn(status);
            if (!this.hasPendingChanges()) {
                this.refreshWithDisplayComponent();
            }
            this.fireEditorInternalEvent(6);
        }
    }

    public boolean isOptimizerEnabled() {
        return this.queryDisplayComponent.isOptimizerEnabled();
    }

    public boolean isOptimizerOn() {
        return this.queryDisplayComponent.isOptimizerOn();
    }

    public boolean canOptimize() {
        return this.queryDisplayComponent.canOptimize();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isParsable() {
        if (this.hasPendingChanges) {
            return false;
        }
        return this.queryDisplayComponent.isParsable();
    }

    public boolean isResolvable() {
        if (this.hasPendingChanges) {
            return false;
        }
        return this.queryDisplayComponent.isResolvable();
    }

    public boolean isValid() {
        if (this.hasPendingChanges) {
            return false;
        }
        return this.queryDisplayComponent.isValidatable();
    }

    public boolean isDefaultQuery() {
        return this.queryDisplayComponent.isDefaultQuery();
    }

    public void setHasError(boolean status) {
        this.hasUserError = status;
        this.setQueryTextBackground();
    }

    public boolean canUseExpressionBuilder() {
        if (!this.isEditable() || !this.isParsable()) {
            return false;
        }
        return this.isIndexWithin(this.caretOffset, 3) || this.isInsertAllowed(this.caretOffset, 3);
    }

    public boolean canUseCriteriaBuilder() {
        if (!this.isEditable() || !this.isParsable()) {
            return false;
        }
        return this.isIndexWithin(this.caretOffset, 14) || this.commandHasEditableCriteriaClause(this.caretOffset) || this.isInsertAllowed(this.caretOffset, 2);
    }

    private ExpressionBuilder getExpressionBuilder() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(shell);
        expressionBuilder.create();
        return expressionBuilder;
    }

    private CriteriaBuilder getCriteriaBuilder() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(shell);
        criteriaBuilder.create();
        return criteriaBuilder;
    }

    public void showExpressionBuilder() {
        int index = this.caretOffset;
        ExpressionDisplayNode expressionNode = this.getExpressionAtIndex(index);
        int startIndex = 0;
        int endIndex = 0;
        boolean replaceMode = false;
        if (expressionNode != null) {
            startIndex = expressionNode.getStartIndex();
            endIndex = expressionNode.getEndIndex();
            replaceMode = true;
        }
        List groups = this.getGroupsForBuilderTree(true);
        while (groups.contains(null) && groups.size() > 0) {
            groups.remove(null);
        }
        ElementViewerFactory.setViewerInput((Object)groups);
        ExpressionBuilder builder = this.getExpressionBuilder();
        builder.setLanguageObject(replaceMode ? (Expression)expressionNode.getLanguageObject() : null);
        int status = builder.open();
        if (status == 0) {
            LanguageObject langObj = builder.getLanguageObject();
            String langString = SQLStringVisitor.getSQLString((LanguageObject)langObj);
            if (replaceMode) {
                StringBuffer currentSQL = new StringBuffer(this.queryDisplayComponent.toString());
                currentSQL.replace(startIndex, endIndex + 1, langString);
                this.setText(currentSQL.toString(), (Object)this);
            } else {
                if (this.queryDisplayComponent.isIndexWithin(index, 6)) {
                    DisplayNode clauseNode = this.queryDisplayComponent.getQueryClauseAtIndex(index);
                    try {
                        LanguageObject selectObj = clauseNode.getLanguageObject();
                        if (selectObj != null && selectObj instanceof Select && ((Select)selectObj).isStar()) {
                            boolean isAtClauseEnd = DisplayNodeUtils.isIndexAtClauseEnd((DisplayNode)clauseNode, (int)index);
                            this.queryDisplayComponent.expandSelect(index);
                            if (isAtClauseEnd) {
                                DisplayNode newClauseNode = this.queryDisplayComponent.getQueryClauseAtIndex(index);
                                index = newClauseNode.getEndIndex();
                            }
                        }
                    }
                    catch (NullPointerException npe) {
                        UiPlugin.getDefault().getPluginUtil().log(4, (Throwable)npe, "Clause Node was null at index: " + index);
                        UiPlugin.getDefault().getPluginUtil().log(4, (Throwable)npe, "Text was: " + this.getText());
                    }
                }
                StringBuffer currentSQL = new StringBuffer(this.queryDisplayComponent.toString());
                int newIndex = this.adjustIndexForInsert(index);
                String newExpressionString = this.adjustStringForInsert(langString, newIndex);
                currentSQL.insert(newIndex, newExpressionString);
                this.setText(currentSQL.toString(), (Object)this);
            }
            this.setCaretOffset(0);
        }
    }

    public void showCriteriaBuilder() {
        int index = this.caretOffset;
        CriteriaDisplayNode criteriaNode = this.getCriteriaAtIndex(index, false);
        int startIndex = 0;
        int endIndex = 0;
        boolean replaceMode = false;
        if (criteriaNode != null) {
            startIndex = criteriaNode.getStartIndex();
            endIndex = criteriaNode.getEndIndex();
            replaceMode = true;
        }
        List groups = this.getGroupsForBuilderTree(true);
        while (groups.contains(null) && groups.size() > 0) {
            groups.remove(null);
        }
        ElementViewerFactory.setViewerInput((Object)groups);
        CriteriaBuilder builder = this.getCriteriaBuilder();
        builder.setLanguageObject(replaceMode ? (Criteria)criteriaNode.getLanguageObject() : null);
        int status = builder.open();
        if (status == 0) {
            LanguageObject newCriteria = builder.getLanguageObject();
            String criteriaString = SQLStringVisitor.getSQLString((LanguageObject)newCriteria);
            if (replaceMode) {
                StringBuffer currentSQL = new StringBuffer(this.queryDisplayComponent.toString());
                currentSQL.replace(startIndex, endIndex + 1, criteriaString);
                this.setText(currentSQL.toString(), (Object)this);
            } else {
                DisplayNode commandNode = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index);
                if (commandNode != null) {
                    DisplayNode optionNode;
                    if (commandNode instanceof QueryDisplayNode) {
                        DisplayNode whereNode = ((QueryDisplayNode)commandNode).getClauseDisplayNode(9);
                        DisplayNode fromNode = ((QueryDisplayNode)commandNode).getClauseDisplayNode(8);
                        if (fromNode != null && whereNode == null) {
                            index = fromNode.getEndIndex();
                        }
                    } else if (commandNode instanceof DeleteDisplayNode) {
                        optionNode = ((DeleteDisplayNode)commandNode).getClauseDisplayNode(13);
                        index = optionNode != null ? optionNode.getStartIndex() : commandNode.getEndIndex();
                    } else if (commandNode instanceof UpdateDisplayNode) {
                        optionNode = ((UpdateDisplayNode)commandNode).getClauseDisplayNode(13);
                        index = optionNode != null ? optionNode.getStartIndex() : commandNode.getEndIndex();
                    }
                }
                StringBuffer currentSQL = new StringBuffer(this.queryDisplayComponent.toString());
                while (currentSQL.charAt(index) == '\n' || currentSQL.charAt(index) == ';') {
                    --index;
                }
                currentSQL.insert(index + 1, " WHERE " + criteriaString);
                this.setText(currentSQL.toString(), (Object)this);
            }
            this.setCaretOffset(0);
        }
    }

    public List getGroupsForBuilderTree(boolean forExpression) {
        SqlIndexLocator indexLocator = new SqlIndexLocator(this.queryDisplayComponent, this.caretOffset);
        GroupSymbolFinder finder = new GroupSymbolFinder(indexLocator, this.externalBuilderGroups);
        return finder.find();
    }

    public List getGroupsForBuilderTree() {
        DisplayNode commandDisplayNode;
        int index;
        ArrayList<Object> treeGroups = new ArrayList<Object>();
        if (this.externalBuilderGroups != null && !this.externalBuilderGroups.isEmpty()) {
            treeGroups.addAll(this.externalBuilderGroups);
        }
        if ((index = this.caretOffset) < 0) {
            index = 0;
        }
        if ((commandDisplayNode = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index)) instanceof SetQueryDisplayNode) {
            if (--index < 0) {
                index = 0;
            }
            commandDisplayNode = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index);
        }
        if (commandDisplayNode != null) {
            if (DisplayNodeUtils.isWithinSubQueryNode((DisplayNode)commandDisplayNode)) {
                HashSet allGroups = new HashSet();
                LanguageObject langObj = commandDisplayNode.getLanguageObject();
                allGroups.addAll(GroupCollectorVisitor.getGroups((LanguageObject)langObj, (boolean)true));
                for (DisplayNode parentNode = commandDisplayNode.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
                    LanguageObject parentLangObj = parentNode.getLanguageObject();
                    if (!(parentLangObj instanceof Command)) continue;
                    allGroups.addAll(GroupCollectorVisitor.getGroups((LanguageObject)parentLangObj, (boolean)true));
                }
                treeGroups.addAll(new ArrayList(allGroups));
            } else {
                LanguageObject langObj = commandDisplayNode.getLanguageObject();
                if (langObj != null && langObj instanceof Command) {
                    Collection groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)langObj, (boolean)true);
                    ArrayList<Object> clonedGrps = new ArrayList<Object>(groups.size());
                    Iterator grpIter = groups.iterator();
                    while (grpIter.hasNext()) {
                        GroupSymbol gSymbol = (GroupSymbol)grpIter.next();
                        clonedGrps.add(gSymbol.clone());
                    }
                    ArrayList<Command> storedProcs = new ArrayList<Command>();
                    HashMap<GroupSymbol, Command> storedProcSymbolMap = new HashMap<GroupSymbol, Command>();
                    List commands = CommandCollectorVisitor.getCommands((LanguageObject)langObj);
                    List clauses = SubqueryFromClauseCollectorVisitor.getClauses((LanguageObject)langObj);
                    Iterator cIter = commands.iterator();
                    while (cIter.hasNext()) {
                        Command cmd = (Command)((Command)cIter.next()).clone();
                        if (!(cmd instanceof StoredProcedure)) continue;
                        GroupSymbol origGrp = (GroupSymbol)((StoredProcedure)cmd).getGroup().clone();
                        Iterator clauseIter = clauses.iterator();
                        while (clauseIter.hasNext()) {
                            SubqueryFromClause sfClause = (SubqueryFromClause)clauseIter.next();
                            if (!sfClause.getCommand().equals(cmd)) continue;
                            ((StoredProcedure)cmd).getGroup().setName(sfClause.getName());
                            break;
                        }
                        storedProcs.add(cmd);
                        storedProcSymbolMap.put(origGrp, cmd);
                    }
                    if (clonedGrps != null && !clonedGrps.isEmpty()) {
                        Iterator gIter = clonedGrps.iterator();
                        while (gIter.hasNext()) {
                            GroupSymbol gSym = (GroupSymbol)gIter.next();
                            if (!storedProcSymbolMap.containsKey(gSym)) {
                                treeGroups.add(gSym);
                                continue;
                            }
                            treeGroups.add(storedProcSymbolMap.get(gSym));
                        }
                    }
                }
            }
        }
        return treeGroups;
    }

    public boolean hasPendingChanges() {
        return this.hasPendingChanges;
    }

    public void insertDroppedGroup(String groupName, int index, Object source) {
        if (this.queryDisplayComponent.isParsable() && !this.hasPendingChanges()) {
            ArrayList<String> groupList = new ArrayList<String>(1);
            groupList.add(groupName);
            this.insertGroups(groupList, index, source);
        } else {
            StringBuffer sb = new StringBuffer(this.getText());
            sb.insert(index, " " + groupName + " ");
            this.setText(sb.toString(), source);
        }
    }

    public void insertGroup(String groupName, int index, Object source) {
        ArrayList<String> groupList = new ArrayList<String>(1);
        groupList.add(groupName);
        this.insertGroups(groupList, index, source);
    }

    public void insertGroups(List groupNames, int index, Object source) {
        this.eventSource = source;
        boolean okToInsert = this.isInsertOK(index);
        if (!okToInsert) {
            return;
        }
        this.queryDisplayComponent.insertGroups(groupNames, index);
        this.refreshWithDisplayComponent();
    }

    public void insertGroupsAtEndOfFrom(List groupNames, Object source) {
        FromDisplayNode fromNode = this.queryDisplayComponent.getFromDisplayNode();
        if (fromNode != null) {
            int fromEndIndex = fromNode.getEndIndex();
            this.insertGroups(groupNames, fromEndIndex - 1, source);
        } else if (this.isDefaultQuery()) {
            String currentQuery = this.getText();
            int insertIndex = currentQuery.toUpperCase().indexOf("FROM") + "FROM".length();
            this.insertGroups(groupNames, insertIndex, source);
        } else if (this.getText().trim().length() == 0) {
            StringBuffer sb = new StringBuffer("SELECT * FROM");
            Iterator iter = groupNames.iterator();
            while (iter.hasNext()) {
                String grpName = (String)iter.next();
                sb.append(" " + grpName);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            this.setText(sb.toString(), source);
        }
    }

    public void insertGroupAtEndOfFrom(String groupName, Object source) {
        FromDisplayNode fromNode = this.queryDisplayComponent.getFromDisplayNode();
        if (fromNode != null) {
            int fromEndIndex = fromNode.getEndIndex();
            this.insertGroup(groupName, fromEndIndex - 1, source);
        } else if (this.isDefaultQuery()) {
            String currentQuery = this.getText();
            int insertIndex = currentQuery.toUpperCase().indexOf("FROM") + "FROM".length();
            this.insertGroup(groupName, insertIndex, source);
        } else if (this.getText().trim().length() == 0) {
            this.setText("SELECT * FROM " + groupName, source);
        }
    }

    public void insertDroppedElement(String elementName, String parentName, int index, Object source) {
        if (this.queryDisplayComponent.isParsable() && !this.hasPendingChanges()) {
            ArrayList<String> elementList = new ArrayList<String>(1);
            ArrayList<String> parentList = new ArrayList<String>(1);
            elementList.add(elementName);
            parentList.add(parentName);
            this.insertElements(elementList, parentList, index, source);
        } else {
            StringBuffer sb = new StringBuffer(this.getText());
            sb.insert(index, " " + elementName + " ");
            this.setText(sb.toString(), source);
        }
    }

    public void insertElement(String elementName, String parentName, int index, Object source) {
        ArrayList<String> elementList = new ArrayList<String>(1);
        ArrayList<String> parentList = new ArrayList<String>(1);
        elementList.add(elementName);
        parentList.add(parentName);
        this.insertElements(elementList, parentList, index, source);
    }

    public void insertElements(List elementNames, List parentNames, int index, Object source) {
        this.eventSource = source;
        boolean okToInsert = this.isInsertOK(index);
        if (!okToInsert) {
            return;
        }
        this.queryDisplayComponent.insertElements(elementNames, parentNames, index);
        this.refreshWithDisplayComponent();
    }

    public void insertElementsAtEndOfSelect(List elementNames, List parentNames, Object source) {
        SelectDisplayNode selectNode = this.queryDisplayComponent.getSelectDisplayNode();
        if (selectNode != null) {
            int selectEndIndex = selectNode.getEndIndex();
            this.insertElements(elementNames, parentNames, selectEndIndex + 1, source);
        } else if (this.isDefaultQuery()) {
            String currentQuery = this.getText();
            int insertIndex = currentQuery.toUpperCase().indexOf("SELECT") + "SELECT".length();
            this.insertElements(elementNames, parentNames, insertIndex, source);
        } else if (this.getText().trim().length() == 0) {
            StringBuffer sb = new StringBuffer("SELECT");
            Iterator iter = elementNames.iterator();
            while (iter.hasNext()) {
                String elemName = (String)iter.next();
                sb.append(" " + elemName);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append(" FROM");
            HashSet uniqueNames = new HashSet();
            uniqueNames.addAll(parentNames);
            iter = uniqueNames.iterator();
            while (iter.hasNext()) {
                String grpName = (String)iter.next();
                sb.append(" " + grpName);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            this.setText(sb.toString(), source);
        }
    }

    public void insertElementAtEndOfSelect(String elementName, String parentName, Object source) {
        SelectDisplayNode selectNode = this.queryDisplayComponent.getSelectDisplayNode();
        if (selectNode != null) {
            int selectEndIndex = selectNode.getEndIndex();
            this.insertElement(elementName, parentName, selectEndIndex - 1, source);
        } else if (this.isDefaultQuery()) {
            String currentQuery = this.getText();
            int insertIndex = currentQuery.toUpperCase().indexOf("SELECT") + "SELECT".length();
            this.insertElement(elementName, parentName, insertIndex, source);
        } else if (this.getText().trim().length() == 0) {
            StringBuffer sb = new StringBuffer("SELECT");
            sb.append(elementName + " " + "FROM" + " " + parentName);
            this.setText(sb.toString(), source);
        }
    }

    public boolean isInsertOK(int index) {
        List nodes = this.queryDisplayComponent.getDisplayNodesAtIndex(index);
        if (nodes.size() == 1) {
            ExpressionDisplayNode expressionNode;
            DisplayNode node = (DisplayNode)nodes.get(0);
            if (DisplayNodeUtils.isWithinSelect((DisplayNode)node) && !this.selectDropsEnabled) {
                return false;
            }
            if (node.isInExpression() && (expressionNode = DisplayNodeUtils.getExpressionForNode((DisplayNode)node)) != null && !(expressionNode instanceof AliasSymbolDisplayNode)) {
                return false;
            }
        } else if (nodes.size() == 2) {
            ExpressionDisplayNode expressionNode;
            DisplayNode node1 = (DisplayNode)nodes.get(0);
            DisplayNode node2 = (DisplayNode)nodes.get(1);
            if ((DisplayNodeUtils.isWithinSelect((DisplayNode)node1) || DisplayNodeUtils.isWithinSelect((DisplayNode)node1)) && !this.selectDropsEnabled) {
                return false;
            }
            if (node1.isInExpression() && node2.isInExpression() && (expressionNode = DisplayNodeUtils.getExpressionForNode((DisplayNode)node1)) != null && !(expressionNode instanceof AliasSymbolDisplayNode)) {
                return false;
            }
        }
        return true;
    }

    public boolean isCurrentCaretWithinSelect() {
        return this.isIndexWithin(this.caretOffset, 6);
    }

    public boolean isCurrentCaretWithinFrom() {
        return this.isIndexWithin(this.caretOffset, 8);
    }

    public boolean isIndexWithin(int index, int nodeType) {
        if (!this.isParsable()) {
            return false;
        }
        return this.queryDisplayComponent.isIndexWithin(index, nodeType);
    }

    public boolean commandHasCriteriaClause(int index) {
        boolean result = false;
        if (this.isParsable()) {
            DisplayNode commandNode = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index);
            if (commandNode instanceof QueryDisplayNode) {
                if (((QueryDisplayNode)commandNode).getClauseDisplayNode(9) != null) {
                    result = true;
                }
            } else if (commandNode instanceof UpdateDisplayNode) {
                if (((UpdateDisplayNode)commandNode).getClauseDisplayNode(9) != null) {
                    result = true;
                }
            } else if (commandNode instanceof DeleteDisplayNode && ((DeleteDisplayNode)commandNode).getClauseDisplayNode(9) != null) {
                result = true;
            }
        }
        return result;
    }

    public boolean isCommandUnion() {
        Command command;
        boolean result = false;
        if (this.isParsable() && (command = this.queryDisplayComponent.getCommand()) instanceof SetQuery) {
            result = true;
        }
        return result;
    }

    public int getCurrentUnionCommandSegmentIndex() {
        DisplayNode currentCommandDN;
        int index = -1;
        if (this.isCommandUnion() && (currentCommandDN = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(this.getCaretOffset())) != null && currentCommandDN instanceof QueryDisplayNode) {
            QueryCommand query = (QueryCommand)currentCommandDN.getLanguageObject();
            SetQuery sQuery = (SetQuery)this.queryDisplayComponent.getCommand();
            List queries = sQuery.getQueries();
            Iterator iter = queries.iterator();
            int indx = 0;
            while (iter.hasNext()) {
                QueryCommand qc = (QueryCommand)iter.next();
                if (qc != null && qc.equals(query)) {
                    return indx;
                }
                ++indx;
            }
        }
        return index;
    }

    public boolean isSubQuerySelected() {
        block4: {
            Iterator iter;
            List queries;
            QueryCommand query;
            block5: {
                DisplayNode currentCommandDN = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(this.getCaretOffset());
                if (currentCommandDN == null || !(currentCommandDN instanceof QueryDisplayNode)) break block4;
                query = (QueryCommand)currentCommandDN.getLanguageObject();
                queries = null;
                iter = null;
                if (!(this.queryDisplayComponent.getCommand() instanceof SetQuery)) break block5;
                SetQuery sQuery = (SetQuery)this.queryDisplayComponent.getCommand();
                queries = sQuery.getQueries();
                iter = queries.iterator();
                while (iter.hasNext()) {
                    QueryCommand qc = (QueryCommand)iter.next();
                    if (qc != null && qc.equals(query)) {
                        return false;
                    }
                    if (!this.isSubQuery((Command)qc, query)) continue;
                    return true;
                }
                break block4;
            }
            if (!(this.queryDisplayComponent.getCommand() instanceof Query)) break block4;
            Query thisQuery = (Query)this.queryDisplayComponent.getCommand();
            queries = thisQuery.getSubCommands();
            iter = queries.iterator();
            while (iter.hasNext()) {
                Command nextComm = (Command)iter.next();
                if (nextComm != null && nextComm.equals(query)) {
                    return true;
                }
                if (!this.isSubQuery(nextComm, query)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSubQuery(Command displayCommand, QueryCommand targetCommand) {
        List<Command> queries = new ArrayList();
        if (displayCommand instanceof SetQuery) {
            SetQuery sQuery = (SetQuery)displayCommand;
            queries = sQuery.getQueries();
        } else if (displayCommand instanceof Query) {
            Command command;
            Criteria criteria;
            Query thisQuery = (Query)displayCommand;
            List sCommands = thisQuery.getSubCommands();
            if (sCommands != null && !sCommands.isEmpty()) {
                queries.addAll(sCommands);
            }
            if ((criteria = thisQuery.getCriteria()) instanceof ExistsCriteria && (command = ((ExistsCriteria)criteria).getCommand()) != null) {
                queries.add(command);
            }
        }
        Iterator iter = queries.iterator();
        while (iter.hasNext()) {
            QueryCommand qc = (QueryCommand)iter.next();
            if (qc != null && qc.equals(targetCommand)) {
                return true;
            }
            if (!this.isSubQuery((Command)qc, targetCommand)) continue;
            return true;
        }
        return false;
    }

    public boolean commandHasEditableCriteriaClause(int index) {
        return this.commandHasCriteriaClause(index) && this.isEditable();
    }

    public boolean isInsertAllowed(int index, int type) {
        if (!this.isParsable()) {
            return false;
        }
        return this.queryDisplayComponent.isInsertAllowed(index, type);
    }

    public ExpressionDisplayNode getExpressionAtIndex(int index) {
        List displayNodes;
        ExpressionDisplayNode result = null;
        if (this.isParsable() && (result = (ExpressionDisplayNode)DisplayNodeUtils.getNodeTypeAtIndex((List)(displayNodes = this.queryDisplayComponent.getDisplayNodeList()), (int)index, (int)3)) instanceof AliasSymbolDisplayNode) {
            result = (ExpressionDisplayNode)result.getChildren().get(0);
        }
        return result;
    }

    public CriteriaDisplayNode getCriteriaAtIndex(int index, boolean getOuterMost) {
        CriteriaDisplayNode result = null;
        if (this.isParsable()) {
            DisplayNode clauseNode;
            DisplayNode commandNode;
            List displayNodes = this.queryDisplayComponent.getDisplayNodeList();
            result = (CriteriaDisplayNode)DisplayNodeUtils.getNodeTypeAtIndex((List)displayNodes, (int)index, (int)2);
            if (getOuterMost) {
                DisplayNode parent;
                while (result != null && (parent = result.getParent()) != null && parent instanceof CriteriaDisplayNode) {
                    result = (CriteriaDisplayNode)parent;
                }
            }
            if (result == null && (commandNode = this.queryDisplayComponent.getCommandDisplayNodeAtIndex(index)) != null && commandNode instanceof QueryDisplayNode && (clauseNode = ((QueryDisplayNode)commandNode).getClauseDisplayNode(9)) != null && DisplayNodeUtils.isEditableCriteria((CriteriaDisplayNode)(result = ((WhereDisplayNode)clauseNode).getCriteria()))) {
                return result;
            }
        }
        return result;
    }

    public List getActions() {
        if (this.actionList == null) {
            this.actionList = new ArrayList(11);
            this.launchCriteriaBuilderAction = new LaunchCriteriaBuilder(this);
            this.launchExpressionBuilderAction = new LaunchExpressionBuilder(this);
            this.expandSelectAction = new ExpandSelect(this);
            this.toggleMessageAction = new ToggleMessage(this);
            this.toggleOptimizerAction = new ToggleOptimizer(this);
            this.validateAction = new Validate(this);
            this.upFontAction = new UpFont(this);
            this.downFontAction = new DownFont(this);
            this.importFromFileAction = new ImportFromFile(this);
            this.exportToFileAction = new ExportToFile(this);
            this.actionList.add(this.validateAction);
            this.actionList.add(this.launchCriteriaBuilderAction);
            this.actionList.add(this.launchExpressionBuilderAction);
            this.actionList.add(this.expandSelectAction);
            this.actionList.add(this.upFontAction);
            this.actionList.add(this.downFontAction);
            this.actionList.add(this.toggleMessageAction);
            this.actionList.add(this.toggleOptimizerAction);
            this.actionList.add(this.importFromFileAction);
            this.actionList.add(this.exportToFileAction);
        }
        return this.actionList;
    }

    public void dispose() {
        this.colorManager.dispose();
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public void setCaretOffset(int posn) {
        int textLength;
        if (posn < 0) {
            posn = 0;
        }
        if (posn > (textLength = this.getText().length())) {
            posn = textLength;
        }
        this.caretOffset = posn;
        this.sqlTextViewer.getTextWidget().setCaretOffset(posn);
        this.setTextViewerBackgroundColors(posn);
        this.fireEditorInternalEvent(5);
    }

    private void setTextViewerBackgroundColors(int caretPosn) {
        if (this.isIndexWithin(caretPosn, 4)) {
            int nAllLines;
            int wholeEndLine;
            int wholeStartLine;
            StyledText styledText = this.sqlTextViewer.getTextWidget();
            int textLength = styledText.getText().length();
            DisplayNode wholeCommandNode = this.getQueryDisplayComponent().getDisplayNode();
            DisplayNode commandNode = this.getQueryDisplayComponent().getCommandDisplayNodeAtIndex(caretPosn);
            if (!commandNode.equals(wholeCommandNode)) {
                wholeStartLine = 0;
                wholeEndLine = styledText.getLineAtOffset(textLength);
                nAllLines = wholeEndLine - wholeStartLine + 1;
                int startIndex = commandNode.getStartIndex();
                int endIndex = commandNode.getEndIndex();
                int startLine = wholeStartLine;
                int endLine = wholeEndLine;
                if (startIndex >= 0 && endIndex <= textLength) {
                    startLine = styledText.getLineAtOffset(startIndex);
                    endLine = styledText.getLineAtOffset(endIndex);
                }
                int nLines = endLine - startLine + 1;
                styledText.setBackground(this.colorManager.getColor(ColorManager.BACKGROUND_UNFOCUSED));
                styledText.setLineBackground(wholeStartLine, nAllLines, this.colorManager.getColor(ColorManager.BACKGROUND_UNFOCUSED));
                styledText.setLineBackground(startLine, nLines, this.colorManager.getColor(ColorManager.BACKGROUND_FOCUSED));
            } else {
                wholeStartLine = 0;
                wholeEndLine = styledText.getLineAtOffset(textLength);
                nAllLines = wholeEndLine - wholeStartLine + 1;
                styledText.setBackground(this.colorManager.getColor(ColorManager.BACKGROUND_FOCUSED));
                styledText.setLineBackground(wholeStartLine, nAllLines, this.colorManager.getColor(ColorManager.BACKGROUND_FOCUSED));
            }
            if (wholeCommandNode instanceof SetQueryDisplayNode) {
                List queryNodes = ((SetQueryDisplayNode)wholeCommandNode).getQueryDisplayNodes();
                if (this.setQueryStates != null && this.setQueryStates.size() == queryNodes.size()) {
                    for (int i = 0; i < queryNodes.size(); ++i) {
                        boolean isReconciled = (Boolean)this.setQueryStates.get(i);
                        if (isReconciled) continue;
                        DisplayNode node = (DisplayNode)queryNodes.get(i);
                        int startIndex = node.getStartIndex();
                        int endIndex = node.getEndIndex();
                        if (startIndex < 0 || endIndex > textLength) continue;
                        int startLine = styledText.getLineAtOffset(startIndex);
                        int endLine = styledText.getLineAtOffset(endIndex);
                        int nLines = endLine - startLine + 1;
                        if (node.equals(commandNode)) {
                            styledText.setLineBackground(startLine, nLines, this.colorManager.getColor(ColorManager.NON_RECD_UNION_QUERY_FOCUSED));
                            continue;
                        }
                        styledText.setLineBackground(startLine, nLines, this.colorManager.getColor(ColorManager.NON_RECD_UNION_QUERY_UNFOCUSED));
                    }
                }
            }
        }
    }

    private void captureCaretInfo() {
        this.caretOffset = this.sqlTextViewer.getTextWidget().getCaretOffset();
        this.caretYPosition = this.sqlTextViewer.getTextWidget().getLineAtOffset(this.caretOffset);
        this.caretXPosition = this.caretOffset - this.sqlTextViewer.getTextWidget().getOffsetAtLine(this.caretYPosition);
        this.setTextViewerBackgroundColors(this.caretOffset);
        this.fireEditorInternalEvent(5);
        this.notifyCaretChanged();
    }

    public TextViewer getTextViewer() {
        return this.sqlTextViewer;
    }

    public QueryDisplayComponent getQueryDisplayComponent() {
        return this.queryDisplayComponent;
    }

    public TextFontManager getFontManager() {
        if (this.tfmManager == null) {
            this.tfmManager = new TextFontManager((TextViewer)this.sqlTextViewer, new ScaledFontManager());
        }
        return this.tfmManager;
    }

    public void expandCurrentSelect() {
        if (this.canExpandCurrentSelect()) {
            this.eventSource = this;
            int index = this.getCaretOffset();
            this.queryDisplayComponent.expandSelect(index);
            this.refreshWithDisplayComponent();
        }
    }

    public boolean canExpandCurrentSelect() {
        if (this.hasPendingChanges || !this.selectExpansionEnabled) {
            return false;
        }
        int index = this.getCaretOffset();
        return this.queryDisplayComponent.canExpandSelect(index);
    }

    private int adjustIndexForInsert(int index) {
        if (this.hasPendingChanges || !this.queryDisplayComponent.isParsable()) {
            return index;
        }
        DisplayNode clauseNode = this.queryDisplayComponent.getQueryClauseAtIndex(index);
        if (clauseNode != null) {
            List nodesAtIndex = DisplayNodeUtils.getDisplayNodesAtIndex((List)clauseNode.getDisplayNodeList(), (int)index);
            int nNodes = nodesAtIndex.size();
            DisplayNode node = null;
            if (nNodes != 1 && nNodes != 2) {
                return index;
            }
            node = (DisplayNode)nodesAtIndex.get(0);
            if (node.getParent() != null && node.getParent() instanceof AliasSymbolDisplayNode) {
                node = node.getParent();
            }
            return node.getEndIndex() + 1;
        }
        return index;
    }

    private String adjustStringForInsert(String insertString, int index) {
        if (this.hasPendingChanges || !this.queryDisplayComponent.isParsable()) {
            return insertString;
        }
        DisplayNode clauseNode = this.queryDisplayComponent.getQueryClauseAtIndex(index);
        if (clauseNode != null) {
            List displayNodes = clauseNode.getDisplayNodeList();
            boolean isAtClauseStart = DisplayNodeUtils.isIndexAtClauseStart((DisplayNode)clauseNode, (int)index);
            boolean isAtClauseEnd = DisplayNodeUtils.isIndexAtClauseEnd((DisplayNode)clauseNode, (int)index);
            boolean isRightBeforeComma = DisplayNodeUtils.isIndexRightBeforeComma((List)displayNodes, (int)index);
            boolean isRightAfterComma = DisplayNodeUtils.isIndexRightAfterComma((List)displayNodes, (int)index);
            if (isAtClauseStart) {
                return " " + insertString + ",";
            }
            if (isRightAfterComma) {
                return insertString + ",";
            }
            if (isAtClauseEnd || isRightBeforeComma) {
                return "," + insertString;
            }
            return insertString;
        }
        return insertString;
    }

    public static int getVerticalRulerWidth() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void exportToFile() {
        block16: {
            Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFilterExtensions(new String[]{"*.*"});
            dlg.setText(UiConstants.Util.getString(EXPORT_SQL_DIALOG_TITLE));
            dlg.setFileName(UiConstants.Util.getString(EXPORT_DEFAULT_FILENAME));
            String fileStr = dlg.open();
            if (fileStr != null && fileStr.indexOf(46) == -1) {
                fileStr = fileStr + "." + UiConstants.Util.getString(EXPORT_DEFAULT_FILEEXT);
            }
            if (fileStr != null) {
                FileWriter fw = null;
                BufferedWriter out = null;
                PrintWriter pw = null;
                fw = new FileWriter(fileStr);
                out = new BufferedWriter(fw);
                pw = new PrintWriter(out);
                String sqlText = this.getText();
                pw.write(sqlText);
                Object var11_9 = null;
                pw.close();
                try {
                    out.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    fw.close();
                }
                catch (IOException e2) {}
                break block16;
                {
                    catch (Exception e) {
                        PluginUtil pluginUtil = UiPlugin.getDefault().getPluginUtil();
                        String msg = pluginUtil.getString(EXPORT_PROBLEM);
                        pluginUtil.log(4, (Throwable)e, msg);
                        Object var11_10 = null;
                        pw.close();
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            fw.close();
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    pw.close();
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        fw.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void importFromFile() {
        block21: {
            Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dlg = new FileDialog(shell, 4096);
            dlg.setFilterExtensions(new String[]{"*.sql;*.txt", "*.*"});
            dlg.setText(UiConstants.Util.getString(IMPORT_SQL_DIALOG_TITLE));
            String fileStr = dlg.open();
            if (fileStr != null) {
                String msg2;
                PluginUtil pluginUtil2;
                String str;
                FileReader fr = null;
                BufferedReader in = null;
                fr = new FileReader(fileStr);
                in = new BufferedReader(fr);
                StringBuffer all = new StringBuffer();
                String delimiter = this.sqlTextViewer.getTextWidget().getLineDelimiter();
                while ((str = in.readLine()) != null) {
                    all.append(str);
                    all.append(delimiter);
                }
                String sqlText = all.toString();
                this.setText(sqlText, (Object)this);
                Object var11_14 = null;
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException e2) {
                    pluginUtil2 = UiPlugin.getDefault().getPluginUtil();
                    msg2 = pluginUtil2.getString(IMPORT_PROBLEM);
                    pluginUtil2.log(4, (Throwable)e2, msg2);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block21;
                }
                catch (IOException e2) {
                    pluginUtil2 = UiPlugin.getDefault().getPluginUtil();
                    msg2 = pluginUtil2.getString(IMPORT_PROBLEM);
                    pluginUtil2.log(4, (Throwable)e2, msg2);
                }
                break block21;
                {
                    catch (Exception e) {
                        String msg2;
                        PluginUtil pluginUtil2;
                        PluginUtil pluginUtil3 = UiPlugin.getDefault().getPluginUtil();
                        String msg3 = pluginUtil3.getString(IMPORT_PROBLEM);
                        pluginUtil3.log(4, (Throwable)e, msg3);
                        String dialogMessage = msg3 + "\n" + e.getMessage();
                        this.displayError(shell, UiConstants.Util.getString(IMPORT_SQL_PROBLEM_DIALOG_TITLE), dialogMessage);
                        Object var11_15 = null;
                        try {
                            if (fr != null) {
                                fr.close();
                            }
                        }
                        catch (IOException e2) {
                            pluginUtil2 = UiPlugin.getDefault().getPluginUtil();
                            msg2 = pluginUtil2.getString(IMPORT_PROBLEM);
                            pluginUtil2.log(4, (Throwable)e2, msg2);
                        }
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block21;
                        }
                        catch (IOException e2) {
                            pluginUtil2 = UiPlugin.getDefault().getPluginUtil();
                            msg2 = pluginUtil2.getString(IMPORT_PROBLEM);
                            pluginUtil2.log(4, (Throwable)e2, msg2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    String msg2;
                    PluginUtil pluginUtil2;
                    Object var11_16 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException e2) {
                        pluginUtil2 = UiPlugin.getDefault().getPluginUtil();
                        msg2 = pluginUtil2.getString(IMPORT_PROBLEM);
                        pluginUtil2.log(4, (Throwable)e2, msg2);
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e2) {
                        pluginUtil2 = UiPlugin.getDefault().getPluginUtil();
                        msg2 = pluginUtil2.getString(IMPORT_PROBLEM);
                        pluginUtil2.log(4, (Throwable)e2, msg2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public StyledText getMessageArea() {
        return this.messageArea;
    }

    private void displayError(final Shell shell, final String dialogTitle, final String message) {
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)shell, (String)dialogTitle, (String)message);
            }
        });
    }

    public void widgetSelected(SelectionEvent e) {
        this.captureCaretInfo();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.captureCaretInfo();
    }

    public void selectionChanged(SelectionChangedEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.captureCaretInfo();
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.captureCaretInfo();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.captureCaretInfo();
    }

    public int getCaretYPosition() {
        return this.caretYPosition;
    }

    public int getCaretXPosition() {
        return this.caretXPosition;
    }

    public void setHasPendingChanges() {
        this.hasPendingChanges = true;
        this.setMessage(QUERY_CHANGES_PENDING_MESSAGE);
        this.fireEditorInternalEvent(1);
        this.fireEditorEvent();
    }

    class DocumentChangeListener
    implements IDocumentListener {
        DocumentChangeListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (SqlEditorPanel.this.validateSelected || SqlEditorPanel.this.isCompleteRefresh) {
                SqlEditorPanel.this.validateSelected = false;
                SqlEditorPanel.this.isCompleteRefresh = false;
                SqlEditorPanel.this.hasPendingChanges = false;
                SqlEditorPanel.this.savedSql = SqlEditorPanel.this.getText();
                SqlEditorPanel.this.fireEditorInternalEvent(0);
                SqlEditorPanel.this.fireEditorEvent();
            } else if (!SqlEditorPanel.this.hasPendingChanges) {
                String newSql = SqlEditorPanel.this.getText();
                boolean sqlChanged = this.hasSqlChanged(newSql.trim());
                SqlEditorPanel.this.savedSql = newSql;
                if (sqlChanged) {
                    SqlEditorPanel.this.setHasPendingChanges();
                }
            }
        }

        boolean hasSqlChanged(String newSql) {
            boolean hasChanged = false;
            if (!newSql.equalsIgnoreCase(SqlEditorPanel.this.savedSql.trim())) {
                hasChanged = true;
            }
            return hasChanged;
        }
    }
}

