#!/bin/ksh

#
# Copyright  2000-2005 MetaMatrix, Inc.  All rights reserved.
#

# This utility is used to assist in moving users from MetaMatrix System to another.
# This utility will import users from an xml formatted file.  
# --------------------------------------------------------------------
#  1rd argument - User Name to connecto to MetaMatrix
#  2nd argument - Password to connecto to MetaMatrix
#  3rd argument - File Name for the file that contains the users and/or groups to load
# --------------------------------------------------------------------

UNAME=$2
PW=$3
FN=$1

if [ "$FN" = "" ] 
	then
    
   	echo ""
    echo "Enter the File Name (may need full path) that contains"
    echo "the users and/or groups to be loaded"
    printf "Enter the File Name [x to Exit]: "
    read FN
    if [ "$FN" = "x" -o "$FN" = "X" ]
        then
            echo ""
            echo "Exit"
            exit                
    fi 
    
    if [ ! -f "${FN}" ]
        then
            echo ""
            echo "File $FN does not exists, please enter a different file name"
                    
        fi
fi


if [ "$UNAME" = "" ] 
	then
    
   	echo ""
    echo "Enter the User Name to connect to the MetaMatrix Server"
    printf "Enter User Name [x to Exit]:"
    read UNAME
    if [ "$UNAME" = "x" -o "$UNAME" = "X" ]
        then
            echo ""
            echo "Exit"
            exit                
    fi 
fi

if [ "$PW" = "" ] 
	then
    
   	echo ""
    echo "Enter the Password to connect to MetaMatrix Server"
    printf "Enter Password [x to Exit]: "
    read PW
    if [ "$PW" = "x" -o "$PW" = "X" ]
        then
            echo ""
            echo "Exit"
            exit                
    fi 
fi




. ../bin/mmenv.sh

cd ${MM_UTIL}


ANT_OPTS="-Xmx512m"; export ANT_OPTS
DEFAULTLOGGER="org.apache.tools.ant.DefaultLogger"
#XMLLOGGER=org.apache.tools.ant.XmlLogger; export XMLLOGGER
#MAILLOGGER=org.apache.tools.ant.listener.MailLogger; export MAILLOGGER
LOGLEVEL="info"; export LOGLEVEL
LOGFILE="-logfile importusers.log" 
LOGGER=$DEFAULTLOGGER; export LOGGER

JAVA_OPTS="-Dmetamatix.message.bus.type=noop.message.bus"
JAVA_OPTS="$JAVA_OPTS -Dimport.file=$FN"
JAVA_OPTS="$JAVA_OPTS -Duser.name=$UNAME"
JAVA_OPTS="$JAVA_OPTS -Duser.pw=$PW"
#JAVA_OPTS="$JAVA_OPTS -verbose"

echo LOGGER=$LOGFILE

${MM_ROOT}/config/ant.sh $JAVA_OPTS -propertyfile ${MM_ROOT}/config/mmconfig.properties -buildfile ${MM_ROOT}/util/config/import_users.xml -logger $LOGGER $LOGFILE


echo "Done."
