/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function;

import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.FunctionExecutionException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.util.CommandContext;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class FunctionMethods {
    private static final String DEFAULT_DECODE_STRING_DELIMITER = ",";
    private static final double log10baseE = Math.log(10.0);
    private static final String[] dayNames = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final char SPACE = ' ';
    public static final Character SPACE_CHAR = new Character(' ');
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public static Object plus(Object x, Object y) throws FunctionExecutionException {
        try {
            if (x == null || y == null) {
                return null;
            }
            if (x instanceof Integer) {
                if (y instanceof Integer) {
                    return new Integer((Integer)x + (Integer)y);
                }
            } else if (x instanceof Long) {
                if (y instanceof Long) {
                    return new Long((Long)x + (Long)y);
                }
            } else if (x instanceof Float) {
                if (y instanceof Float) {
                    return new Float(((Float)x).floatValue() + ((Float)y).floatValue());
                }
            } else if (x instanceof Double) {
                if (y instanceof Double) {
                    return new Double((Double)x + (Double)y);
                }
            } else if (x instanceof BigInteger) {
                if (y instanceof BigInteger) {
                    return ((BigInteger)x).add((BigInteger)y);
                }
            } else if (x instanceof BigDecimal && y instanceof BigDecimal) {
                return ((BigDecimal)x).add((BigDecimal)y);
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0006", QueryPlugin.Util.getString("ERR.015.001.0006", x, y));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"plus", x.getClass().getName(), y.getClass().getName()}));
    }

    public static Object minus(Object x, Object y) throws FunctionExecutionException {
        try {
            if (x == null || y == null) {
                return null;
            }
            if (x instanceof Integer) {
                if (y instanceof Integer) {
                    return new Integer((Integer)x - (Integer)y);
                }
            } else if (x instanceof Long) {
                if (y instanceof Long) {
                    return new Long((Long)x - (Long)y);
                }
            } else if (x instanceof Float) {
                if (y instanceof Float) {
                    return new Float(((Float)x).floatValue() - ((Float)y).floatValue());
                }
            } else if (x instanceof Double) {
                if (y instanceof Double) {
                    return new Double((Double)x - (Double)y);
                }
            } else if (x instanceof BigInteger) {
                if (y instanceof BigInteger) {
                    return ((BigInteger)x).subtract((BigInteger)y);
                }
            } else if (x instanceof BigDecimal && y instanceof BigDecimal) {
                return ((BigDecimal)x).subtract((BigDecimal)y);
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0008", QueryPlugin.Util.getString("ERR.015.001.0008", x, y));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"minus", x.getClass().getName(), y.getClass().getName()}));
    }

    public static Object multiply(Object x, Object y) throws FunctionExecutionException {
        try {
            if (x == null || y == null) {
                return null;
            }
            if (x instanceof Integer) {
                if (y instanceof Integer) {
                    return new Integer((Integer)x * (Integer)y);
                }
            } else if (x instanceof Long) {
                if (y instanceof Long) {
                    return new Long((Long)x * (Long)y);
                }
            } else if (x instanceof Float) {
                if (y instanceof Float) {
                    return new Float(((Float)x).floatValue() * ((Float)y).floatValue());
                }
            } else if (x instanceof Double) {
                if (y instanceof Double) {
                    return new Double((Double)x * (Double)y);
                }
            } else if (x instanceof BigInteger) {
                if (y instanceof BigInteger) {
                    return ((BigInteger)x).multiply((BigInteger)y);
                }
            } else if (x instanceof BigDecimal && y instanceof BigDecimal) {
                return ((BigDecimal)x).multiply((BigDecimal)y);
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0010", QueryPlugin.Util.getString("ERR.015.001.0010", x, y));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"multiply", x.getClass().getName(), y.getClass().getName()}));
    }

    public static Object divide(Object x, Object y) throws FunctionExecutionException {
        try {
            if (x == null || y == null) {
                return null;
            }
            if (x instanceof Integer) {
                if (y instanceof Integer) {
                    return new Integer((Integer)x / (Integer)y);
                }
            } else if (x instanceof Long) {
                if (y instanceof Long) {
                    return new Long((Long)x / (Long)y);
                }
            } else if (x instanceof Float) {
                if (y instanceof Float) {
                    return new Float(((Float)x).floatValue() / ((Float)y).floatValue());
                }
            } else if (x instanceof Double) {
                if (y instanceof Double) {
                    return new Double((Double)x / (Double)y);
                }
            } else if (x instanceof BigInteger) {
                if (y instanceof BigInteger) {
                    return ((BigInteger)x).divide((BigInteger)y);
                }
            } else if (x instanceof BigDecimal && y instanceof BigDecimal) {
                return ((BigDecimal)x).divide((BigDecimal)y, 4);
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0012", QueryPlugin.Util.getString("ERR.015.001.0012", x, y));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"divide", x.getClass().getName(), y.getClass().getName()}));
    }

    public static Object abs(Object x) throws FunctionExecutionException {
        try {
            if (x == null) {
                return null;
            }
            if (x instanceof Integer) {
                return new Integer(Math.abs((Integer)x));
            }
            if (x instanceof Long) {
                return new Long(Math.abs((Long)x));
            }
            if (x instanceof Float) {
                return new Float(Math.abs(((Float)x).floatValue()));
            }
            if (x instanceof Double) {
                return new Double(Math.abs((Double)x));
            }
            if (x instanceof BigInteger) {
                return ((BigInteger)x).abs();
            }
            if (x instanceof BigDecimal) {
                return ((BigDecimal)x).abs();
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0014", QueryPlugin.Util.getString("ERR.015.001.0014", x));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"abs", (Object)x.getClass().getName()));
    }

    public static Object ceiling(Object x) throws FunctionExecutionException {
        try {
            if (x == null) {
                return null;
            }
            if (x instanceof Float) {
                return new Double(Math.ceil(((Float)x).floatValue()));
            }
            if (x instanceof Double) {
                return new Double(Math.ceil((Double)x));
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0016", QueryPlugin.Util.getString("ERR.015.001.0016", x));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"ceiling", (Object)x.getClass().getName()));
    }

    public static Object exp(Object x) throws FunctionExecutionException {
        try {
            if (x == null) {
                return null;
            }
            if (x instanceof Float) {
                return new Double(Math.exp(((Float)x).floatValue()));
            }
            if (x instanceof Double) {
                return new Double(Math.exp((Double)x));
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0018", QueryPlugin.Util.getString("ERR.015.001.0018", x));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"exp", (Object)x.getClass().getName()));
    }

    public static Object floor(Object x) throws FunctionExecutionException {
        try {
            if (x == null) {
                return null;
            }
            if (x instanceof Float) {
                return new Double(Math.floor(((Float)x).floatValue()));
            }
            if (x instanceof Double) {
                return new Double(Math.floor((Double)x));
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0020", QueryPlugin.Util.getString("ERR.015.001.0020", x));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"floor", (Object)x.getClass().getName()));
    }

    public static Object log(Object x) throws FunctionExecutionException {
        try {
            if (x == null) {
                return null;
            }
            if (x instanceof Float) {
                return new Double(Math.log(((Float)x).floatValue()));
            }
            if (x instanceof Double) {
                return new Double(Math.log((Double)x));
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0022", QueryPlugin.Util.getString("ERR.015.001.0022", x));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"log", (Object)x.getClass().getName()));
    }

    public static Object log10(Object x) throws FunctionExecutionException {
        try {
            if (x == null) {
                return null;
            }
            if (x instanceof Float) {
                return new Double(Math.log(((Float)x).floatValue()) / log10baseE);
            }
            if (x instanceof Double) {
                return new Double(Math.log((Double)x) / log10baseE);
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0024", QueryPlugin.Util.getString("ERR.015.001.0024", x));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"log10", (Object)x.getClass().getName()));
    }

    public static Object rand(CommandContext context, Object seed) throws FunctionExecutionException {
        if (context != null) {
            if (seed == null) {
                return new Double(context.getNextRand());
            }
            if (seed instanceof Integer) {
                return new Double(context.getNextRand(((Integer)seed).longValue()));
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0069", QueryPlugin.Util.getString("ERR.015.001.0069", (Object)"rand", (Object)seed.getClass().getName()));
    }

    public static Object rand(CommandContext context) throws FunctionExecutionException {
        if (context != null) {
            return new Double(context.getNextRand());
        }
        throw new FunctionExecutionException("ERR.015.001.0069", QueryPlugin.Util.getString("ERR.015.001.0069", (Object)"rand"));
    }

    public static Object mod(Object x, Object y) throws FunctionExecutionException {
        try {
            if (x == null || y == null) {
                return null;
            }
            if (x instanceof Integer) {
                if (y instanceof Integer) {
                    return new Integer((Integer)x % (Integer)y);
                }
            } else if (x instanceof Long) {
                if (y instanceof Long) {
                    return new Long((Long)x % (Long)y);
                }
            } else if (x instanceof Float) {
                if (y instanceof Float) {
                    return new Float(((Float)x).floatValue() % ((Float)y).floatValue());
                }
            } else if (x instanceof Double) {
                if (y instanceof Double) {
                    return new Double((Double)x % (Double)y);
                }
            } else if (x instanceof BigInteger && y instanceof BigInteger) {
                return ((BigInteger)x).mod((BigInteger)y);
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0026", QueryPlugin.Util.getString("ERR.015.001.0026", x, y));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"mod", x.getClass().getName(), y.getClass().getName()}));
    }

    public static Object power(Object x, Object y) throws FunctionExecutionException {
        try {
            if (x == null || y == null) {
                return null;
            }
            if (x instanceof Integer) {
                if (y instanceof Integer) {
                    return new Double(Math.pow(((Integer)x).intValue(), ((Integer)y).intValue()));
                }
            } else if (x instanceof Long) {
                if (y instanceof Long) {
                    return new Double(Math.pow(((Long)x).longValue(), ((Long)y).longValue()));
                }
            } else if (x instanceof Float) {
                if (y instanceof Float) {
                    return new Double(Math.pow(((Float)x).floatValue(), ((Float)y).floatValue()));
                }
            } else if (x instanceof Double) {
                if (y instanceof Double) {
                    return new Double(Math.pow((Double)x, (Double)y));
                }
            } else if (x instanceof BigInteger && y instanceof Integer) {
                return ((BigInteger)x).pow((Integer)y);
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0028", QueryPlugin.Util.getString("ERR.015.001.0028", x, y));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"power", x.getClass().getName(), y.getClass().getName()}));
    }

    public static Object round(Object number, Object places) throws FunctionExecutionException {
        if (number == null || places == null) {
            return null;
        }
        int intValuePlaces = (Integer)places;
        double placeMultiplier = Math.pow(10.0, intValuePlaces);
        if (number instanceof Integer) {
            Integer integerNumber = (Integer)number;
            if (intValuePlaces <= 0) {
                return new Integer((int)((double)Math.round((double)integerNumber.intValue() * placeMultiplier) / placeMultiplier));
            }
            return number;
        }
        if (number instanceof Float) {
            Float floatNumber = (Float)number;
            return new Float((float)((double)Math.round((double)floatNumber.floatValue() * placeMultiplier) / placeMultiplier));
        }
        if (number instanceof Double) {
            Double doubleNumber = (Double)number;
            return new Double((double)Math.round(doubleNumber * placeMultiplier) / placeMultiplier);
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimalNumber = (BigDecimal)number;
            int scale = bigDecimalNumber.scale();
            bigDecimalNumber = bigDecimalNumber.multiply(new BigDecimal("" + placeMultiplier));
            bigDecimalNumber = bigDecimalNumber.setScale(0, 4);
            BigDecimal bigDecimalMultiplier = new BigDecimal("" + placeMultiplier);
            if (intValuePlaces > 0) {
                bigDecimalNumber = bigDecimalNumber.setScale(scale, 4);
                bigDecimalNumber = bigDecimalNumber.divide(bigDecimalMultiplier, 4);
            } else {
                bigDecimalNumber = bigDecimalNumber.divide(bigDecimalMultiplier, 4);
                bigDecimalNumber = bigDecimalNumber.setScale(scale, 4);
            }
            return bigDecimalNumber;
        }
        Object[] params = new Object[]{"round", number.getClass().getName(), places.getClass().getName()};
        throw new FunctionExecutionException("ERR.015.001.0065", QueryPlugin.Util.getString("ERR.015.001.0065", params));
    }

    public static Object sign(Object x) throws FunctionExecutionException {
        try {
            if (x == null) {
                return null;
            }
            if (x instanceof Integer) {
                int xVal = (Integer)x;
                if (xVal > 0) {
                    return new Integer(1);
                }
                if (xVal == 0) {
                    return new Integer(0);
                }
                return new Integer(-1);
            }
            if (x instanceof Long) {
                long xVal = (Long)x;
                if (xVal > 0L) {
                    return new Integer(1);
                }
                if (xVal == 0L) {
                    return new Integer(0);
                }
                return new Integer(-1);
            }
            if (x instanceof Float) {
                float xVal = ((Float)x).floatValue();
                if (xVal > 0.0f) {
                    return new Integer(1);
                }
                if (xVal == 0.0f) {
                    return new Integer(0);
                }
                return new Integer(-1);
            }
            if (x instanceof Double) {
                double xVal = (Double)x;
                if (xVal > 0.0) {
                    return new Integer(1);
                }
                if (xVal == 0.0) {
                    return new Integer(0);
                }
                return new Integer(-1);
            }
            if (x instanceof BigInteger) {
                return new Integer(((BigInteger)x).signum());
            }
            if (x instanceof BigDecimal) {
                return new Integer(((BigDecimal)x).signum());
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0030", QueryPlugin.Util.getString("ERR.015.001.0030", x));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"sign", (Object)x.getClass().getName()));
    }

    public static Object sqrt(Object x) throws FunctionExecutionException {
        try {
            if (x == null) {
                return null;
            }
            if (x instanceof Integer) {
                return new Double(Math.sqrt(((Integer)x).intValue()));
            }
            if (x instanceof Long) {
                return new Double(Math.sqrt(((Long)x).longValue()));
            }
            if (x instanceof Float) {
                return new Double(Math.sqrt(((Float)x).floatValue()));
            }
            if (x instanceof Double) {
                return new Double(Math.sqrt((Double)x));
            }
        }
        catch (Throwable e) {
            throw new FunctionExecutionException(e, "ERR.015.001.0032", QueryPlugin.Util.getString("ERR.015.001.0032", x));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"sqrt", (Object)x.getClass().getName()));
    }

    public static Object currentDate() {
        return TimestampWithTimezone.createDate((java.util.Date)new java.util.Date());
    }

    public static Object currentTime() {
        return TimestampWithTimezone.createTime((java.util.Date)new java.util.Date());
    }

    public static Object currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private static int getField(java.util.Date date, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(field);
    }

    public static Object dayName(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof java.util.Date) {
            return dayNames[FunctionMethods.getField((java.util.Date)x, 7) - 1];
        }
        if (x instanceof Timestamp) {
            return dayNames[FunctionMethods.getField((Timestamp)x, 7) - 1];
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"dayName", (Object)x.getClass().getName()));
    }

    public static Object dayOfMonth(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)x, 5));
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 5));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"dayOfMonth", (Object)x.getClass().getName()));
    }

    public static Object dayOfWeek(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)x, 7));
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 7));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"dayOfWeek", (Object)x.getClass().getName()));
    }

    public static Object dayOfYear(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)x, 6));
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 6));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"dayOfYear", (Object)x.getClass().getName()));
    }

    public static Object hour(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof Time) {
            return new Integer(FunctionMethods.getField((Time)x, 11));
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 11));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"hour", (Object)x.getClass().getName()));
    }

    public static Object minute(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof Time) {
            return new Integer(FunctionMethods.getField((Time)x, 12));
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 12));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"minute", (Object)x.getClass().getName()));
    }

    public static Object month(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)x, 2) + 1);
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 2) + 1);
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"month", (Object)x.getClass().getName()));
    }

    public static Object monthName(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof java.util.Date) {
            return monthNames[FunctionMethods.getField((java.util.Date)x, 2)];
        }
        if (x instanceof Timestamp) {
            return monthNames[FunctionMethods.getField((Timestamp)x, 2)];
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"monthName", (Object)x.getClass().getName()));
    }

    public static Object second(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof Time) {
            return new Integer(FunctionMethods.getField((Time)x, 13));
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 13));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"second", (Object)x.getClass().getName()));
    }

    public static Object week(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)x, 3));
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 3));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"week", (Object)x.getClass().getName()));
    }

    public static Object year(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (x instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)x, 1));
        }
        if (x instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)x, 1));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"year", (Object)x.getClass().getName()));
    }

    public static Object quarter(Object date) throws FunctionExecutionException {
        String month = null;
        if (date == null) {
            return null;
        }
        if (date instanceof java.util.Date) {
            month = monthNames[FunctionMethods.getField((java.util.Date)date, 2)];
        } else if (date instanceof Timestamp) {
            month = monthNames[FunctionMethods.getField((Timestamp)date, 2)];
        }
        if (month.equals("January") || month.equals("February") || month.equals("March")) {
            return new Integer(1);
        }
        if (month.equals("April") || month.equals("May") || month.equals("June")) {
            return new Integer(2);
        }
        if (month.equals("July") || month.equals("August") || month.equals("September")) {
            return new Integer(3);
        }
        if (month.equals("October") || month.equals("November") || month.equals("December")) {
            return new Integer(4);
        }
        throw new FunctionExecutionException("ERR.015.001.0066", QueryPlugin.Util.getString("ERR.015.001.0066", new Object[]{"quarter", date.getClass().getName()}));
    }

    public static Object timestampAdd(Object interval, Object count, Object timestamp) throws FunctionExecutionException {
        Calendar cal = Calendar.getInstance();
        if (interval == null || count == null || timestamp == null) {
            return null;
        }
        if (interval instanceof String && count instanceof Integer) {
            String intervalType = (String)interval;
            if (timestamp instanceof Timestamp) {
                int nanos = ((Timestamp)timestamp).getNanos();
                cal.setTime((Timestamp)timestamp);
                if (intervalType.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
                    int countValue = (Integer)count;
                    if ((nanos += countValue) > 999999999) {
                        int addSecond = nanos / 999999999;
                        int leftNanos = nanos % 999999999;
                        cal.add(13, addSecond);
                        Timestamp ts = new Timestamp(cal.getTime().getTime());
                        ts.setNanos(leftNanos);
                        return ts;
                    }
                    Timestamp ts = new Timestamp(cal.getTime().getTime());
                    ts.setNanos(nanos);
                    return ts;
                }
                FunctionMethods.addField(intervalType, (Integer)count, cal);
                Timestamp ts = new Timestamp(cal.getTime().getTime());
                ts.setNanos(nanos);
                return ts;
            }
            if (timestamp instanceof Time) {
                cal.setTime((Time)timestamp);
                FunctionMethods.addField(intervalType, (Integer)count, cal);
                return new Time(cal.getTime().getTime());
            }
            if (timestamp instanceof java.util.Date) {
                cal.setTime((java.util.Date)timestamp);
                FunctionMethods.addField(intervalType, (Integer)count, cal);
                return new Date(cal.getTime().getTime());
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0067", QueryPlugin.Util.getString("ERR.015.001.0067", new Object[]{"timestampAdd", interval.getClass().getName(), count.getClass().getName(), timestamp.getClass().getName()}));
    }

    private static void addField(String interval, Integer count, Calendar cal) {
        int countValue = count;
        if (!interval.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            if (interval.equalsIgnoreCase("SQL_TSI_SECOND")) {
                cal.add(13, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                cal.add(12, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_HOUR")) {
                cal.add(11, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_DAY")) {
                cal.add(6, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_WEEK")) {
                cal.add(3, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_MONTH")) {
                cal.add(2, countValue);
            } else if (interval.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                cal.add(2, countValue * 3);
            } else if (interval.equalsIgnoreCase("SQL_TSI_YEAR")) {
                cal.add(1, countValue);
            }
        }
    }

    public static Object timestampDiff(Object interval, Object timestamp1, Object timestamp2) throws FunctionExecutionException {
        if (interval == null || timestamp1 == null || timestamp2 == null) {
            return null;
        }
        if (interval instanceof String) {
            String intervalType = (String)interval;
            long ts1 = ((java.util.Date)timestamp1).getTime() / 1000L * 1000L;
            long ts2 = ((java.util.Date)timestamp2).getTime() / 1000L * 1000L;
            long tsDiff = ts2 - ts1;
            int nanoDiff = 0;
            if (timestamp1 instanceof Timestamp) {
                int nanoTs1 = ((Timestamp)timestamp1).getNanos();
                int nanoTs2 = ((Timestamp)timestamp2).getNanos();
                nanoDiff = nanoTs2 - nanoTs1;
                if (nanoDiff < 0 && tsDiff > 0L) {
                    --tsDiff;
                    nanoDiff += 1000000;
                } else if (tsDiff < 0L && nanoDiff > 0) {
                    ++tsDiff;
                    nanoDiff -= 1000000;
                }
            }
            long count = 0L;
            if (interval.equals("SQL_TSI_FRAC_SECOND")) {
                count = timestamp1 instanceof Timestamp ? tsDiff * 1000000L + (long)nanoDiff : tsDiff;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_SECOND")) {
                count = tsDiff / 1000L + (long)nanoDiff;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                count = tsDiff / 1000L / 60L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_HOUR")) {
                count = tsDiff / 1000L / 3600L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_DAY")) {
                count = tsDiff / 1000L / 86400L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_WEEK")) {
                count = tsDiff / 1000L / 604800L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_MONTH")) {
                count = tsDiff / 1000L / 2592000L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                count = tsDiff / 1000L / 7862400L;
            } else if (intervalType.equalsIgnoreCase("SQL_TSI_YEAR")) {
                count = tsDiff / 1000L / 31536000L;
            }
            return new Long(count);
        }
        throw new FunctionExecutionException("ERR.015.001.0067", QueryPlugin.Util.getString("ERR.015.001.0067", new Object[]{"timestampDiff", interval.getClass().getName(), timestamp1.getClass().getName(), timestamp2.getClass().getName()}));
    }

    public static Object timestampCreate(Object date, Object time) {
        if (date == null || time == null) {
            return null;
        }
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime((Time)time);
        Calendar tsCal = Calendar.getInstance();
        tsCal.setTime((Date)date);
        tsCal.set(11, timeCal.get(11));
        tsCal.set(12, timeCal.get(12));
        tsCal.set(13, timeCal.get(13));
        return new Timestamp(tsCal.getTime().getTime());
    }

    public static Object length(Object str) throws FunctionExecutionException {
        if (str == null) {
            return null;
        }
        if (str instanceof String) {
            return new Integer(((String)str).length());
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"length", (Object)str.getClass().getName()));
    }

    public static Object concat(Object str1, Object str2) throws FunctionExecutionException {
        if (str1 == null || str2 == null) {
            return null;
        }
        if (str1 instanceof String && str2 instanceof String) {
            return (String)str1 + (String)str2;
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"concat", str1.getClass().getName(), str2.getClass().getName()}));
    }

    public static Object concat2(Object str1, Object str2) throws FunctionExecutionException {
        if (str1 == null && str2 == null) {
            return null;
        }
        if (str1 != null && str2 == null) {
            return str1;
        }
        if (str1 == null && str2 != null) {
            return str2;
        }
        if (str1 instanceof String && str2 instanceof String) {
            return (String)str1 + (String)str2;
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"concat", str1.getClass().getName(), str2.getClass().getName()}));
    }

    public static Object substring(Object str, Object start, Object length) throws FunctionExecutionException {
        if (str == null || start == null || length == null) {
            return null;
        }
        if (str instanceof String && start instanceof Integer && length instanceof Integer) {
            String string = (String)str;
            int startVal = (Integer)start;
            int lengthVal = (Integer)length;
            return FunctionMethods.substring(string, startVal, lengthVal);
        }
        throw new FunctionExecutionException("ERR.015.001.0013", QueryPlugin.Util.getString("ERR.015.001.0013", new Object[]{"substring", str.getClass().getName(), start.getClass().getName(), length.getClass().getName()}));
    }

    private static Object substring(String string, int startVal, int lengthVal) {
        if (startVal < 0) {
            startVal = string.length() + startVal;
        } else if (startVal > 0) {
            --startVal;
        }
        if (startVal < 0 || startVal >= string.length()) {
            return null;
        }
        if (lengthVal < 0) {
            return null;
        }
        int endVal = Math.min(startVal + lengthVal, string.length());
        return string.substring(startVal, endVal);
    }

    public static Object substring(Object str, Object start) throws FunctionExecutionException {
        if (str == null || start == null) {
            return null;
        }
        if (str instanceof String && start instanceof Integer) {
            String string = (String)str;
            int startVal = (Integer)start;
            return FunctionMethods.substring(string, startVal, string.length());
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"substring", str.getClass().getName(), start.getClass().getName()}));
    }

    public static Object left(Object str, Object count) throws FunctionExecutionException {
        if (str == null || count == null) {
            return null;
        }
        if (str instanceof String && count instanceof Integer) {
            String string = (String)str;
            int countValue = (Integer)count;
            if (countValue < 0) {
                throw new FunctionExecutionException("ERR.015.001.0017", QueryPlugin.Util.getString("ERR.015.001.0017", countValue));
            }
            if (string.length() < countValue) {
                return string;
            }
            return string.substring(0, countValue);
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"left", str.getClass().getName(), count.getClass().getName()}));
    }

    public static Object right(Object str, Object count) throws FunctionExecutionException {
        if (str == null || count == null) {
            return null;
        }
        if (str instanceof String && count instanceof Integer) {
            String string = (String)str;
            int countValue = (Integer)count;
            if (countValue < 0) {
                throw new FunctionExecutionException("ERR.015.001.0017", QueryPlugin.Util.getString("ERR.015.001.0017", countValue));
            }
            if (string.length() < countValue) {
                return string;
            }
            return string.substring(string.length() - countValue);
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"right", str.getClass().getName(), count.getClass().getName()}));
    }

    public static Object lowerCase(Object str) throws FunctionExecutionException {
        if (str == null) {
            return null;
        }
        if (str instanceof String) {
            return ((String)str).toLowerCase();
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"lowerCase", (Object)str.getClass().getName()));
    }

    public static Object upperCase(Object str) throws FunctionExecutionException {
        if (str == null) {
            return null;
        }
        if (str instanceof String) {
            return ((String)str).toUpperCase();
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"upperCase", (Object)str.getClass().getName()));
    }

    public static Object locate(Object sub, Object str) throws FunctionExecutionException {
        if (str == null || sub == null) {
            return null;
        }
        if (sub instanceof String && str instanceof String) {
            return new Integer(((String)str).indexOf((String)sub) + 1);
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", new Object[]{"locate", sub.getClass().getName(), str.getClass().getName()}));
    }

    public static Object locate(Object sub, Object str, Object start) throws FunctionExecutionException {
        if (str == null || sub == null) {
            return null;
        }
        if (sub instanceof String && str instanceof String) {
            if (start == null) {
                return new Integer(((String)str).indexOf((String)sub) + 1);
            }
            if (start instanceof Integer) {
                return new Integer(((String)str).indexOf((String)sub, (Integer)start - 1) + 1);
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0013", QueryPlugin.Util.getString("ERR.015.001.0013", new Object[]{"locate", sub.getClass().getName(), str.getClass().getName(), start.getClass().getName()}));
    }

    public static Object leftTrim(Object str) throws FunctionExecutionException {
        if (str == null) {
            return null;
        }
        if (str instanceof String) {
            String string = (String)str;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ' ') continue;
                return string.substring(i);
            }
            return "";
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"leftTrim", (Object)str.getClass().getName()));
    }

    public static Object rightTrim(Object str) throws FunctionExecutionException {
        if (str == null) {
            return null;
        }
        if (str instanceof String) {
            String string = (String)str;
            for (int i = string.length() - 1; i >= 0; --i) {
                if (string.charAt(i) == ' ') continue;
                return string.substring(0, i + 1);
            }
            return "";
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"rightTrim", (Object)str.getClass().getName()));
    }

    public static Object replace(Object str, Object sub, Object replace) throws FunctionExecutionException {
        if (str == null || sub == null || replace == null) {
            return null;
        }
        if (str instanceof String && sub instanceof String && replace instanceof String) {
            String string = (String)str;
            String subString = (String)sub;
            String replaceString = (String)replace;
            if (subString.length() > string.length() || string.length() == 0 || subString.length() == 0) {
                return string;
            }
            StringBuffer result = new StringBuffer();
            int index = 0;
            while (true) {
                int newIndex;
                if ((newIndex = string.indexOf(subString, index)) < 0) break;
                result.append(string.substring(index, newIndex));
                result.append(replaceString);
                index = newIndex + subString.length();
            }
            result.append(string.substring(index));
            return result.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0013", QueryPlugin.Util.getString("ERR.015.001.0013", new Object[]{"replace", str.getClass().getName(), sub.getClass().getName(), replace.getClass().getName()}));
    }

    public static Object insert(Object str1, Object start, Object length, Object str2) throws FunctionExecutionException {
        if (str1 == null || start == null || length == null || str2 == null) {
            return null;
        }
        if (str1 instanceof String && str2 instanceof String && start instanceof Integer && length instanceof Integer) {
            String string1 = (String)str1;
            int startValue = (Integer)start;
            int len = (Integer)length;
            if (startValue < 1 || startValue - 1 > ((String)str1).length()) {
                throw new FunctionExecutionException("ERR.015.001.0061", QueryPlugin.Util.getString("ERR.015.001.0061", start, str1));
            }
            if (len < 0) {
                throw new FunctionExecutionException("ERR.015.001.0062", QueryPlugin.Util.getString("ERR.015.001.0062", len));
            }
            if (((String)str1).length() == 0 && (startValue > 1 || len > 0)) {
                throw new FunctionExecutionException("ERR.015.001.0063", QueryPlugin.Util.getString("ERR.015.001.0063"));
            }
            StringBuffer result = new StringBuffer();
            result.append(string1.substring(0, startValue - 1));
            int endValue = startValue + len - 1;
            if (endValue > ((String)str1).length()) {
                result.append((String)str2);
            } else {
                result.append((String)str2);
                result.append(string1.substring(endValue));
            }
            return result.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0064", QueryPlugin.Util.getString("ERR.015.001.0064", new Object[]{"insert", str1.getClass().getName(), start.getClass().getName(), length.getClass().getName(), str2.getClass().getName()}));
    }

    public static Object repeat(Object str, Object count) throws FunctionExecutionException {
        if (str == null || count == null) {
            return null;
        }
        if (str instanceof String && count instanceof Integer) {
            int repeatCount = (Integer)count;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < repeatCount; ++i) {
                result.append((String)str);
            }
            return result.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0065", QueryPlugin.Util.getString("ERR.015.001.0065", new Object[]{"repeat", str.getClass().getName(), count.getClass().getName()}));
    }

    public static Object space(Object count) throws FunctionExecutionException {
        if (count == null) {
            return null;
        }
        if (count instanceof Integer) {
            int repeatCount = (Integer)count;
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < repeatCount; ++i) {
                result.append(" ");
            }
            return result.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0066", QueryPlugin.Util.getString("ERR.015.001.0066", new Object[]{"space", count.getClass().getName()}));
    }

    public static Object ascii(Object ch) throws FunctionExecutionException {
        if (ch == null) {
            return null;
        }
        char c = '\u0000';
        if (ch instanceof Character) {
            c = ((Character)ch).charValue();
        } else if (ch instanceof String) {
            String s = (String)ch;
            if (s.length() >= 1) {
                c = s.charAt(0);
            } else if (s.length() == 0) {
                throw new FunctionExecutionException("ERR.015.001.0021", QueryPlugin.Util.getString("ERR.015.001.0021"));
            }
        } else {
            throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"ascii", (Object)ch.getClass().getName()));
        }
        return new Integer(c);
    }

    public static Object chr(Object intValue) {
        if (intValue == null) {
            return null;
        }
        Integer theInt = (Integer)intValue;
        return new Character((char)theInt.intValue());
    }

    public static Object initCap(Object str) throws FunctionExecutionException {
        if (str == null) {
            return null;
        }
        if (str instanceof String) {
            String s = (String)str;
            StringBuffer cap = new StringBuffer();
            boolean checkCap = true;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (checkCap) {
                    cap.append(Character.toUpperCase(c));
                } else {
                    cap.append(Character.toLowerCase(c));
                }
                checkCap = Character.isWhitespace(c);
            }
            return cap.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"initCap", (Object)str.getClass().getName()));
    }

    public static Object lpad(Object inputString, Object padLength, Object padChar) throws FunctionExecutionException {
        if (inputString == null || padLength == null || padChar == null) {
            return null;
        }
        String str = (String)inputString;
        int length = (Integer)padLength;
        if (length < 1) {
            throw new FunctionExecutionException("ERR.015.001.0025", QueryPlugin.Util.getString("ERR.015.001.0025"));
        }
        int numPadChar = length - str.length();
        if (numPadChar <= 0) {
            return str;
        }
        char ch = '\u0000';
        if (padChar instanceof String) {
            String charStr = (String)padChar;
            if (charStr.length() != 1) {
                throw new FunctionExecutionException("ERR.015.001.0027", QueryPlugin.Util.getString("ERR.015.001.0027"));
            }
            ch = charStr.charAt(0);
        } else {
            ch = ((Character)padChar).charValue();
        }
        StringBuffer outStr = new StringBuffer();
        for (int i = 0; i < numPadChar; ++i) {
            outStr.append(ch);
        }
        outStr.append(str);
        return outStr.toString();
    }

    public static Object lpad(Object inputString, Object padLength) throws FunctionExecutionException {
        return FunctionMethods.lpad(inputString, padLength, SPACE_CHAR);
    }

    public static Object rpad(Object inputString, Object padLength, Object padChar) throws FunctionExecutionException {
        if (inputString == null || padLength == null || padChar == null) {
            return null;
        }
        String str = (String)inputString;
        int length = (Integer)padLength;
        if (length < 1) {
            throw new FunctionExecutionException("ERR.015.001.0025", QueryPlugin.Util.getString("ERR.015.001.0025"));
        }
        int numPadChar = length - str.length();
        if (numPadChar <= 0) {
            return str;
        }
        char ch = '\u0000';
        if (padChar instanceof String) {
            String charStr = (String)padChar;
            if (charStr.length() != 1) {
                throw new FunctionExecutionException("ERR.015.001.0029", QueryPlugin.Util.getString("ERR.015.001.0029"));
            }
            ch = charStr.charAt(0);
        } else {
            ch = ((Character)padChar).charValue();
        }
        StringBuffer outStr = new StringBuffer();
        outStr.append(str);
        for (int i = 0; i < numPadChar; ++i) {
            outStr.append(ch);
        }
        return outStr.toString();
    }

    public static Object rpad(Object inputString, Object padLength) throws FunctionExecutionException {
        return FunctionMethods.rpad(inputString, padLength, SPACE_CHAR);
    }

    public static Object translate(Object inputString, Object srcChars, Object destChars) throws FunctionExecutionException {
        if (inputString == null || srcChars == null || destChars == null) {
            return null;
        }
        String str = (String)inputString;
        String in = (String)srcChars;
        String out = (String)destChars;
        if (in.length() != out.length()) {
            throw new FunctionExecutionException("ERR.015.001.0031", QueryPlugin.Util.getString("ERR.015.001.0031"));
        }
        if (in.length() == 0 || str.length() == 0) {
            return inputString;
        }
        StringBuffer translated = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean matched = false;
            for (int j = 0; j < in.length(); ++j) {
                char inChar = in.charAt(j);
                if (c != inChar) continue;
                translated.append(out.charAt(j));
                matched = true;
                break;
            }
            if (matched) continue;
            translated.append(c);
        }
        return translated.toString();
    }

    public static Object convert(Object src, Object type) throws FunctionExecutionException {
        String typeStr;
        Class typeClass;
        if (src == null) {
            return null;
        }
        if (type instanceof String && (typeClass = DataTypeManager.getDataTypeClass((String)(typeStr = (String)type))) != null) {
            if (typeClass.equals(src.getClass())) {
                return src;
            }
            try {
                Transform transform = DataTypeManager.getTransform(src.getClass(), (Class)typeClass);
                return transform.transform(src);
            }
            catch (Throwable e) {
                throw new FunctionExecutionException(e, "ERR.015.001.0033", QueryPlugin.Util.getString("ERR.015.001.0033", new Object[]{src, DataTypeManager.getDataTypeName(src.getClass()), typeStr}));
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0034", QueryPlugin.Util.getString("ERR.015.001.0034", type));
    }

    public static Object context(Object context, Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035", QueryPlugin.Util.getString("ERR.015.001.0035"));
    }

    public static Object relateSource(Object expr) throws FunctionExecutionException {
        throw new FunctionExecutionException(QueryPlugin.Util.getString("FunctionMethods.cant_execute_relateSource"));
    }

    public static Object relateTarget(Object expr) throws FunctionExecutionException {
        throw new FunctionExecutionException(QueryPlugin.Util.getString("FunctionMethods.cant_execute_relateTarget"));
    }

    public static Object relate(Object relationship, Object source, Object object) throws FunctionExecutionException {
        throw new FunctionExecutionException(QueryPlugin.Util.getString("FunctionMethods.cant_execute_relate"));
    }

    public static Object rowlimit(Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035a", QueryPlugin.Util.getString("ERR.015.001.0035a"));
    }

    public static Object rowlimitexception(Object expression) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035a", QueryPlugin.Util.getString("ERR.015.001.0035a"));
    }

    public static Object lookup(Object codeTable, Object returnElement, Object keyElement, Object keyValue) {
        throw new UnsupportedOperationException("This method should never be called.");
    }

    public static Object decodeInteger(Object columnValue, Object decodeObject) throws FunctionExecutionException {
        return FunctionMethods.decode(columnValue, decodeObject, DEFAULT_DECODE_STRING_DELIMITER, class$java$lang$Integer == null ? (class$java$lang$Integer = FunctionMethods.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public static Object decodeString(Object columnValue, Object decodeObject) throws FunctionExecutionException {
        return FunctionMethods.decode(columnValue, decodeObject, DEFAULT_DECODE_STRING_DELIMITER, class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String);
    }

    public static Object decodeInteger(Object columnValue, Object decodeObject, Object decodeDelimiter) throws FunctionExecutionException {
        return FunctionMethods.decode(columnValue, decodeObject, decodeDelimiter, class$java$lang$Integer == null ? (class$java$lang$Integer = FunctionMethods.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public static Object decodeString(Object columnValue, Object decodeObject, Object decodeDelimiter) throws FunctionExecutionException {
        return FunctionMethods.decode(columnValue, decodeObject, decodeDelimiter, class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String);
    }

    private static Object decode(Object columnValue, Object decodeObject, Object decodeDelimiter, Class returnType) throws FunctionExecutionException {
        Object returnObject = null;
        if (decodeObject == null) {
            throw new FunctionExecutionException("ERR.015.001.0036", QueryPlugin.Util.getString("ERR.015.001.0036"));
        }
        if (decodeDelimiter == null) {
            throw new FunctionExecutionException("ERR.015.001.0037", QueryPlugin.Util.getString("ERR.015.001.0037"));
        }
        if (decodeObject instanceof String && decodeDelimiter instanceof String) {
            String decodeDelimiterString = (String)decodeDelimiter;
            String decodeString = (String)decodeObject;
            StringTokenizer tokenizer = new StringTokenizer(decodeString, decodeDelimiterString);
            while (tokenizer.hasMoreTokens()) {
                String compareString = FunctionMethods.convertString(tokenizer.nextToken().trim());
                if (!tokenizer.hasMoreTokens()) {
                    try {
                        returnObject = FunctionMethods.convertType(returnType, compareString);
                        break;
                    }
                    catch (TransformationException e) {
                        throw new FunctionExecutionException((Throwable)e, "ERR.015.001.0038", QueryPlugin.Util.getString("ERR.015.001.0038", (Object)compareString, (Object)(returnType != null ? returnType.getName() : "null")));
                    }
                }
                String resultString = FunctionMethods.convertString(tokenizer.nextToken().trim());
                boolean match = FunctionMethods.areSemanticallyEqual(columnValue, compareString);
                if (match) {
                    try {
                        returnObject = FunctionMethods.convertType(returnType, resultString);
                        break;
                    }
                    catch (TransformationException e) {
                        throw new FunctionExecutionException((Throwable)e, "ERR.015.001.0038", QueryPlugin.Util.getString("ERR.015.001.0038", (Object)resultString, (Object)(returnType != null ? returnType.getName() : "null")));
                    }
                }
                if (tokenizer.hasMoreTokens()) continue;
                try {
                    returnObject = FunctionMethods.convertType(returnType, columnValue);
                }
                catch (TransformationException e) {
                    throw new FunctionExecutionException((Throwable)e, "ERR.015.001.0039", QueryPlugin.Util.getString("ERR.015.001.0039", columnValue));
                }
            }
            return returnObject;
        }
        throw new FunctionExecutionException("ERR.015.001.0040", QueryPlugin.Util.getString("ERR.015.001.0040"));
    }

    private static boolean areSemanticallyEqual(Object object1, String string) {
        Class<?> targetClass;
        if (object1 == null) {
            return string == null;
        }
        if (string == null) {
            return false;
        }
        if (object1.equals(string)) {
            return true;
        }
        if (DataTypeManager.isTransformable((Class)(class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String), targetClass = object1.getClass())) {
            Transform transform = DataTypeManager.getPreferredTransform((Class)(class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String), targetClass);
            Object result = null;
            try {
                result = transform.getSourceType().equals(class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String) ? transform.transform((Object)string) : transform.transform(object1);
            }
            catch (TransformationException e) {
                return false;
            }
            return result.equals(object1);
        }
        return false;
    }

    private static Object convertType(Class targetType, Object objectToConvert) throws TransformationException, FunctionExecutionException {
        if (objectToConvert == null) {
            return null;
        }
        if (targetType == objectToConvert.getClass()) {
            return objectToConvert;
        }
        Transform transform = null;
        if (!DataTypeManager.isTransformable((Class)targetType, objectToConvert.getClass())) {
            throw new FunctionExecutionException("ERR.015.001.0041", QueryPlugin.Util.getString("ERR.015.001.0041", new Object[]{objectToConvert, objectToConvert.getClass().getName(), targetType.getName()}));
        }
        transform = DataTypeManager.getTransform(objectToConvert.getClass(), (Class)targetType);
        return transform.transform(objectToConvert);
    }

    public static String convertString(String string) {
        if (string.equals("")) {
            return null;
        }
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            if (string.length() == 2) {
                string = "";
            } else if (!string.equalsIgnoreCase("'") && !string.equalsIgnoreCase("\"")) {
                string = string.substring(1);
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static Object nvl(Object value, Object valueIfNull) {
        if (value == null) {
            return valueIfNull;
        }
        return value;
    }

    public static Object formatDate(Object date, Object format) throws FunctionExecutionException {
        if (date == null || format == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat((String)format);
            return sdf.format((java.util.Date)date);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionExecutionException("ERR.015.001.0042", QueryPlugin.Util.getString("ERR.015.001.0042", (Object)iae.getMessage()));
        }
    }

    public static Object formatTime(Object time, Object format) throws FunctionExecutionException {
        if (time == null || format == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat((String)format);
            return sdf.format((Time)time);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionExecutionException("ERR.015.001.0042", QueryPlugin.Util.getString("ERR.015.001.0042", (Object)iae.getMessage()));
        }
    }

    public static Object formatTimestamp(Object timestamp, Object format) throws FunctionExecutionException {
        if (timestamp == null || format == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat((String)format);
            return sdf.format((Timestamp)timestamp);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionExecutionException("ERR.015.001.0042", QueryPlugin.Util.getString("ERR.015.001.0042", (Object)iae.getMessage()));
        }
    }

    public static Object parseDate(Object date, Object format) throws FunctionExecutionException {
        java.util.Date parsedDate = null;
        if (date == null || format == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat((String)format);
            parsedDate = df.parse((String)date);
            return new Date(parsedDate.getTime());
        }
        catch (ParseException pe) {
            throw new FunctionExecutionException("ERR.015.001.0043", QueryPlugin.Util.getString("ERR.015.001.0043", date, format));
        }
    }

    public static Object parseTime(Object time, Object format) throws FunctionExecutionException {
        java.util.Date date = null;
        if (time == null || format == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat((String)format);
            date = df.parse((String)time);
            return new Time(date.getTime());
        }
        catch (ParseException pe) {
            throw new FunctionExecutionException("ERR.015.001.0043", QueryPlugin.Util.getString("ERR.015.001.0043", time, format));
        }
    }

    public static Object parseTimestamp(Object timestamp, Object format) throws FunctionExecutionException {
        java.util.Date date = null;
        if (timestamp == null || format == null) {
            return null;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat((String)format);
            date = df.parse((String)timestamp);
            return new Timestamp(date.getTime());
        }
        catch (ParseException pe) {
            throw new FunctionExecutionException("ERR.015.001.0043", QueryPlugin.Util.getString("ERR.015.001.0043", timestamp, format));
        }
    }

    public static Object formatInteger(Object integerNum, Object format) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(integerNum, format);
    }

    public static Object formatLong(Object longNum, Object format) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(longNum, format);
    }

    public static Object formatDouble(Object doubleNum, Object format) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(doubleNum, format);
    }

    public static Object formatFloat(Object floatNum, Object format) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(floatNum, format);
    }

    public static Object formatBigInteger(Object bigIntegerNum, Object format) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(bigIntegerNum, format);
    }

    public static Object formatBigDecimal(Object bigDecimalNum, Object format) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(bigDecimalNum, format);
    }

    public static Object parseInteger(Object number, Object format) throws FunctionExecutionException {
        Number intNum = FunctionMethods.parseNumberHelper(number, format);
        return new Integer(intNum.intValue());
    }

    public static Object parseLong(Object number, Object format) throws FunctionExecutionException {
        Number longNum = FunctionMethods.parseNumberHelper(number, format);
        return new Long(longNum.longValue());
    }

    public static Object parseDouble(Object number, Object format) throws FunctionExecutionException {
        Number doubleNum = FunctionMethods.parseNumberHelper(number, format);
        return new Double(doubleNum.doubleValue());
    }

    public static Object parseFloat(Object number, Object format) throws FunctionExecutionException {
        Number longNum = FunctionMethods.parseNumberHelper(number, format);
        return new Float(longNum.floatValue());
    }

    public static Object parseBigInteger(Object number, Object format) throws FunctionExecutionException {
        Number bigIntegerNum = FunctionMethods.parseNumberHelper(number, format);
        return new BigInteger(bigIntegerNum.toString());
    }

    public static Object parseBigDecimal(Object number, Object format) throws FunctionExecutionException {
        Number bigDecimalNum = FunctionMethods.parseNumberHelper(number, format);
        return new BigDecimal(bigDecimalNum.toString());
    }

    public static String formatNumberHelper(Object number, Object format) throws FunctionExecutionException {
        if (number == null || format == null) {
            return null;
        }
        try {
            DecimalFormat df = new DecimalFormat((String)format);
            return df.format(number);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionExecutionException("ERR.015.001.0042", QueryPlugin.Util.getString("ERR.015.001.0042", (Object)iae.getMessage()));
        }
    }

    private static Number parseNumberHelper(Object number, Object format) throws FunctionExecutionException {
        Number num = null;
        if (number == null || format == null) {
            return null;
        }
        if (number instanceof String && format instanceof String) {
            try {
                DecimalFormat df = new DecimalFormat((String)format);
                num = df.parse((String)number);
            }
            catch (ParseException pe) {
                throw new FunctionExecutionException("ERR.015.001.0043", QueryPlugin.Util.getString("ERR.015.001.0043", number, format));
            }
        }
        return num;
    }

    public static Object acos(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(Math.acos((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"acos", (Object)number.getClass().getName()));
    }

    public static Object asin(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(Math.asin((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"asin", (Object)number.getClass().getName()));
    }

    public static Object atan(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(Math.atan((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"atan", (Object)number.getClass().getName()));
    }

    public static Object atan2(Object number1, Object number2) throws FunctionExecutionException {
        if (number1 == null || number2 == null) {
            return null;
        }
        if (number1 instanceof Double && number2 instanceof Double) {
            return new Double(Math.atan2((Double)number1, (Double)number2));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", QueryPlugin.Util.getString("ERR.015.001.0007", (Object)"atan2", (Object)number1.getClass().getName(), (Object)number2.getClass().getName()));
    }

    public static Object cos(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(Math.cos((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"cos", (Object)number.getClass().getName()));
    }

    public static Object cot(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(1.0 / Math.tan((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"cot", (Object)number.getClass().getName()));
    }

    public static Object degrees(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(Math.toDegrees((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"degrees", (Object)number.getClass().getName()));
    }

    public static Object pi() {
        return new Double(Math.PI);
    }

    public static Object radians(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(Math.toRadians((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"redians", (Object)number.getClass().getName()));
    }

    public static Object sin(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(Math.sin((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"sin", (Object)number.getClass().getName()));
    }

    public static Object tan(Object number) throws FunctionExecutionException {
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return new Double(Math.tan((Double)number));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"tan", (Object)number.getClass().getName()));
    }

    public static Object bitand(Object x, Object y) throws FunctionExecutionException {
        if (x == null || y == null) {
            return null;
        }
        if (!(x instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"bitand", (Object)x.getClass().getName()));
        }
        if (!(y instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"bitand", (Object)y.getClass().getName()));
        }
        return new Integer((Integer)x & (Integer)y);
    }

    public static Object bitor(Object x, Object y) throws FunctionExecutionException {
        if (x == null || y == null) {
            return null;
        }
        if (!(x instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"bitor", (Object)x.getClass().getName()));
        }
        if (!(y instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"bitor", (Object)y.getClass().getName()));
        }
        return new Integer((Integer)x | (Integer)y);
    }

    public static Object bitxor(Object x, Object y) throws FunctionExecutionException {
        if (x == null || y == null) {
            return null;
        }
        if (!(x instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"bitxor", (Object)x.getClass().getName()));
        }
        if (!(y instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"bitxor", (Object)y.getClass().getName()));
        }
        return new Integer((Integer)x ^ (Integer)y);
    }

    public static Object bitnot(Object x) throws FunctionExecutionException {
        if (x == null) {
            return null;
        }
        if (!(x instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", QueryPlugin.Util.getString("ERR.015.001.0015", (Object)"bitxor", (Object)x.getClass().getName()));
        }
        return new Integer(~((Integer)x).intValue());
    }

    public static Object user(CommandContext context) {
        return context.getUserName();
    }

    public static Object commandPayload(CommandContext context) {
        Serializable payload = context.getCommandPayload();
        if (payload == null) {
            return null;
        }
        return payload.toString();
    }

    public static Object commandPayload(CommandContext context, Object param) throws ExpressionEvaluationException, FunctionExecutionException {
        Serializable payload = context.getCommandPayload();
        if (payload == null || param == null) {
            return null;
        }
        if (param instanceof String) {
            if (payload instanceof Properties) {
                String property = (String)param;
                return ((Properties)payload).getProperty(property);
            }
            throw new ExpressionEvaluationException(QueryPlugin.Util.getString("ExpressionEvaluator.Expected_props_for_payload_function", (Object)"commandPayload", (Object)payload.getClass().getName()));
        }
        throw new FunctionExecutionException("ERR.015.001.0071", QueryPlugin.Util.getString("ERR.015.001.0070", (Object)"commandPayload", (Object)param.getClass().getName()));
    }

    public static Object env(CommandContext context, Object param) throws FunctionExecutionException {
        if (param == null) {
            return null;
        }
        if (param instanceof String) {
            String propertyName = ((String)param).toLowerCase();
            Properties envProps = context.getEnvironmentProperties();
            String rtn = null;
            if (envProps != null) {
                rtn = envProps.getProperty(propertyName);
            }
            if (rtn == null) {
                return System.getProperty((String)param);
            }
            return rtn;
        }
        throw new FunctionExecutionException("ERR.015.001.0070", QueryPlugin.Util.getString("ERR.015.001.0070", (Object)"env", (Object)param.getClass().getName()));
    }

    public static Object modifyTimeZone(Object value, Object originalTimezoneString, Object targetTimezoneString) {
        TimeZone dbmsTimeZone;
        if (value == null || originalTimezoneString == null || targetTimezoneString == null) {
            return null;
        }
        TimeZone originalTimeZone = TimeZone.getTimeZone((String)originalTimezoneString);
        if (originalTimeZone.equals(dbmsTimeZone = TimeZone.getTimeZone((String)targetTimezoneString))) {
            return value;
        }
        Timestamp in = (Timestamp)value;
        Calendar mod = FunctionMethods.changeTimeZone(in, originalTimeZone, dbmsTimeZone);
        Timestamp out = new Timestamp(mod.getTime().getTime());
        out.setNanos(in.getNanos());
        return out;
    }

    public static Object modifyTimeZone(Object value, Object targetTimezoneString) {
        if (value == null || targetTimezoneString == null) {
            return null;
        }
        TimeZone originalTimeZone = LOCAL_TZ;
        TimeZone dbmsTimeZone = TimeZone.getTimeZone((String)targetTimezoneString);
        if (originalTimeZone.equals(dbmsTimeZone)) {
            return value;
        }
        Timestamp in = (Timestamp)value;
        Calendar mod = FunctionMethods.changeTimeZone(in, originalTimeZone, dbmsTimeZone);
        Timestamp out = new Timestamp(mod.getTime().getTime());
        out.setNanos(in.getNanos());
        return out;
    }

    static Calendar changeTimeZone(Timestamp date, TimeZone originalTimeZone, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int era = cal.get(0);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int dayOfWeek = cal.get(7);
        int millis = cal.get(14);
        int localOffset = originalTimeZone.getOffset(era, year, month, day, dayOfWeek, millis);
        int zoneOffset = timeZone.getOffset(era, year, month, day, dayOfWeek, millis);
        int diff = zoneOffset - localOffset;
        cal.add(14, diff);
        return cal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

