/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.command;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.resolver.CommandResolver;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.command.InsertResolver;
import com.metamatrix.query.resolver.command.SimpleQueryResolver;
import com.metamatrix.query.resolver.command.UpdateProcedureResolver;
import com.metamatrix.query.resolver.util.ResolveCaseExpressionVisitor;
import com.metamatrix.query.resolver.util.ResolveElementsVisitor;
import com.metamatrix.query.resolver.util.ResolveFunctionsVisitor;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.resolver.util.ResolveVariablesVisitor;
import com.metamatrix.query.resolver.util.ResolveVirtualGroupCriteriaVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.DeclareStatement;
import com.metamatrix.query.sql.proc.IfStatement;
import com.metamatrix.query.sql.proc.LoopStatement;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.proc.WhileStatement;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.util.VariableContext;
import com.metamatrix.query.sql.visitor.DeclaredVariableCollector;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpdateProcedureResolver
implements CommandResolver {
    public void expandCommand(Command command, boolean useMetadataCommands, QueryMetadataInterface metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        1 visitor = new /* Unavailable Anonymous Inner Class!! */;
        PreOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)visitor);
    }

    public void resolveVirtualGroupElements(Command command, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        CreateUpdateProcedureCommand procCommand = (CreateUpdateProcedureCommand)command;
        GroupSymbol virtualGroup = procCommand.getVirtualGroup();
        if (virtualGroup == null) {
            Iterator groupIter = command.getExternalGroups().iterator();
            while (groupIter.hasNext()) {
                GroupSymbol groupSymbol = (GroupSymbol)groupIter.next();
                String groupName = groupSymbol.getName();
                if (groupName.equalsIgnoreCase("INPUT") || groupName.equalsIgnoreCase("CHANGING")) continue;
                ResolveGroupsVisitor.resolveGroups((LanguageObject)groupSymbol, (QueryMetadataInterface)metadata);
                procCommand.setVirtualGroup(groupSymbol);
                virtualGroup = groupSymbol;
                break;
            }
        }
        if (virtualGroup == null) {
            throw new QueryResolverException("ERR.015.008.0012", QueryPlugin.Util.getString("ERR.015.008.0012"));
        }
        ResolveVirtualGroupCriteriaVisitor.resolveCriteria((LanguageObject)command, (GroupSymbol)virtualGroup, (QueryMetadataInterface)metadata);
        if (useMetadataCommands) {
            Command transformCmd = this.getQueryTransformCmd(virtualGroup, metadata);
            Map symbolMap = this.createSymbolMap(virtualGroup, transformCmd);
            procCommand.setSymbolMap(symbolMap);
        }
    }

    private Command getQueryTransformCmd(GroupSymbol virtualGroup, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Command transformCmd = null;
        QueryNode queryNode = metadata.getVirtualPlan(virtualGroup.getMetadataID());
        String transformQuery = queryNode.getQuery();
        QueryParser parser = new QueryParser();
        try {
            transformCmd = parser.parseCommand(transformQuery);
        }
        catch (QueryParserException e) {
            throw new QueryResolverException((Throwable)e, "ERR.015.008.0013", QueryPlugin.Util.getString("ERR.015.008.0013", (Object)virtualGroup));
        }
        QueryResolver.resolveCommand((Command)transformCmd, (QueryMetadataInterface)metadata);
        return transformCmd;
    }

    private Map createSymbolMap(GroupSymbol virtualGroup, Command transformCmd) {
        String virtualGroupName = virtualGroup.getName();
        HashMap<ElementSymbol, SingleElementSymbol> symbolMap = new HashMap<ElementSymbol, SingleElementSymbol>();
        List projectCols = transformCmd.getProjectedSymbols();
        Iterator elementIter = projectCols.iterator();
        while (elementIter.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)elementIter.next();
            String shortName = symbol.getShortName();
            String virtualElementName = virtualGroupName + QueryPlugin.Util.getString("UpdateProcedureResolver.._1") + shortName;
            ElementSymbol virtualElement = new ElementSymbol(virtualElementName);
            virtualElement.setGroupSymbol(virtualGroup);
            SingleElementSymbol mappedExpr = symbol;
            if (symbol instanceof AliasSymbol) {
                mappedExpr = ((AliasSymbol)symbol).getSymbol();
            }
            if (symbol instanceof ExpressionSymbol) {
                mappedExpr = ((ExpressionSymbol)symbol).getExpression();
            }
            symbolMap.put(virtualElement, mappedExpr);
        }
        return symbolMap;
    }

    public void findChildCommandMetadata(Command command, TempMetadataStore childMetadata, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Map tempMetadata = command.getTemporaryMetadata();
        TempMetadataStore metadataStore = new TempMetadataStore();
        metadataStore.addTempGroups(tempMetadata);
        TempMetadataAdapter tempAdapter = new TempMetadataAdapter(metadata, metadataStore);
        ResolveCommandMetadataVisitor visitor2 = new ResolveCommandMetadataVisitor(metadata, tempAdapter, metadataStore, childMetadata);
        PreOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)visitor2);
        if (visitor2.getException() != null) {
            throw visitor2.getException();
        }
        ResolveGroupsVisitor.resolveGroups((LanguageObject)command, (QueryMetadataInterface)tempAdapter);
        if (((CreateUpdateProcedureCommand)command).isUpdateProcedure()) {
            this.resolveVirtualGroupElements(command, useMetadataCommands, metadata);
        }
        this.resolveProcedure(command, (QueryMetadataInterface)tempAdapter, true);
        this.resolveProcedure(command, metadata, false);
    }

    public void findCommandMetadata(Command command, final TempMetadataStore discoveredMetadata, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        LanguageVisitor visitor = new LanguageVisitor(){

            public void visit(LoopStatement obj) {
                List symbols = obj.getCommand().getProjectedSymbols();
                discoveredMetadata.addTempGroup(obj.getCursorName(), symbols);
            }

            public void visit(Query obj) {
                if (obj.getInto() != null && obj.getInto().getGroup().isTempGroupSymbol()) {
                    GroupSymbol tempGroup = obj.getInto().getGroup();
                    List symbols = obj.getSelect().getProjectedSymbols();
                    discoveredMetadata.addTempGroup(tempGroup.getName(), symbols);
                }
            }

            public void visit(Insert obj) {
                if (obj.getGroup().isTempGroupSymbol()) {
                    GroupSymbol tempGroup = obj.getGroup();
                    List symbols = obj.getVariables();
                    discoveredMetadata.addTempGroup(tempGroup.getName(), symbols);
                }
            }
        };
        PreOrderNavigator.doVisit((LanguageObject)command, (LanguageVisitor)visitor);
    }

    public void resolveCommand(Command command, boolean useMetadataCommands, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
    }

    public void resolveProcedure(Command command, QueryMetadataInterface metadata, boolean varResolve) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        CreateUpdateProcedureCommand procCommand = (CreateUpdateProcedureCommand)command;
        Collection externalGroups = command.getExternalGroups();
        this.resolveBlock(procCommand, procCommand.getBlock(), externalGroups, null, metadata, varResolve, procCommand.isUpdateProcedure());
    }

    private void resolveBlock(CreateUpdateProcedureCommand command, Block block, Collection externalGroups, VariableContext parentContext, QueryMetadataInterface metadata, boolean varResolve, boolean isUpdateProcedure) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        LogManager.logTrace((String)"QUERY_RESOLVER", (Object[])new Object[]{"Resolving block", block});
        VariableContext childContext = DeclaredVariableCollector.getVariableContext((LanguageObject)block);
        if (!isUpdateProcedure && externalGroups != null && !externalGroups.isEmpty()) {
            Iterator iter = externalGroups.iterator();
            while (iter.hasNext()) {
                Object groupID;
                String groupName = ((GroupSymbol)iter.next()).getName();
                try {
                    groupID = metadata.getGroupID(groupName);
                }
                catch (QueryMetadataException e) {
                    continue;
                }
                List elementIDs = metadata.getElementIDsInGroupID(groupID);
                GroupSymbol group = new GroupSymbol(groupName);
                group.setMetadataID(groupID);
                Iterator iter2 = elementIDs.iterator();
                while (iter2.hasNext()) {
                    Object elementID = iter2.next();
                    ElementSymbol eSymbol = new ElementSymbol(metadata.getFullName(elementID));
                    eSymbol.setMetadataID(elementID);
                    eSymbol.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(elementID)));
                    eSymbol.setGroupSymbol(group);
                    childContext.addVariable(eSymbol);
                }
            }
        }
        if (parentContext != null) {
            childContext.setParentContext(parentContext);
        }
        Iterator stmtIter = block.getStatements().iterator();
        while (stmtIter.hasNext()) {
            this.resolveStatement(command, (Statement)stmtIter.next(), externalGroups, childContext, metadata, varResolve, isUpdateProcedure);
        }
    }

    private void resolveStatement(CreateUpdateProcedureCommand command, Statement statement, Collection externalGroups, VariableContext context, QueryMetadataInterface metadata, boolean varResolve, boolean isUpdateProcedure) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        LogManager.logTrace((String)"QUERY_RESOLVER", (Object[])new Object[]{"Resolving statement", statement});
        switch (statement.getType()) {
            case 3: {
                if (!varResolve) break;
                DeclareStatement decStmt = (DeclareStatement)statement;
                ResolveVariablesVisitor.resolveVariables((LanguageObject)decStmt.getVariable(), (VariableContext)context, (QueryMetadataInterface)metadata, (boolean)true);
                break;
            }
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                if (varResolve) {
                    ResolveVariablesVisitor.resolveVariables((LanguageObject)ifCrit, (VariableContext)context, (QueryMetadataInterface)metadata, (boolean)false);
                } else {
                    ResolveVariablesVisitor.resolveVariables((LanguageObject)ifCrit, (VariableContext)context, (QueryMetadataInterface)metadata, (boolean)true);
                    QueryResolver.resolveCriteria((Criteria)ifCrit, (QueryMetadataInterface)metadata);
                }
                this.resolveBlock(command, ifStmt.getIfBlock(), externalGroups, context, metadata, varResolve, isUpdateProcedure);
                if (!ifStmt.hasElseBlock()) break;
                this.resolveBlock(command, ifStmt.getElseBlock(), externalGroups, context, metadata, varResolve, isUpdateProcedure);
                break;
            }
            case 2: {
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command subCommand = cmdStmt.getCommand();
                if (!varResolve) break;
                ResolveVariablesVisitor.resolveVariables((LanguageObject)cmdStmt, (VariableContext)context, (Collection)externalGroups, (QueryMetadataInterface)metadata, (boolean)false);
                this.resolveElementsInCommand(subCommand, metadata);
                if (command.isUpdateProcedure()) break;
                command.setResultsCommand(subCommand);
                break;
            }
            case 4: 
            case 5: {
                AssignmentStatement assStmt = (AssignmentStatement)statement;
                if (varResolve) {
                    ResolveVariablesVisitor.resolveVariables((LanguageObject)assStmt, (VariableContext)context, (Collection)externalGroups, (QueryMetadataInterface)metadata, (boolean)false);
                    if (!assStmt.hasCommand() || command.isUpdateProcedure()) break;
                    Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)assStmt.getCommand(), (boolean)false);
                    ResolveElementsVisitor.resolveElements((LanguageObject)assStmt, (Collection)groups, null, (QueryMetadataInterface)metadata);
                    break;
                }
                if (statement.getType() != 4) {
                    ResolveVariablesVisitor.resolveVariables((LanguageObject)assStmt.getVariable(), (VariableContext)context, (QueryMetadataInterface)metadata, (boolean)true);
                }
                if (assStmt.hasCommand()) {
                    if (!command.isUpdateProcedure()) break;
                    Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)assStmt.getCommand(), (boolean)false);
                    ResolveElementsVisitor.resolveElements((LanguageObject)assStmt, (Collection)groups, null, (QueryMetadataInterface)metadata);
                    break;
                }
                Expression expr = assStmt.getExpression();
                ResolveElementsVisitor.resolveElements((LanguageObject)expr, (QueryMetadataInterface)metadata);
                ResolveFunctionsVisitor.resolveFunctions((LanguageObject)expr, (QueryMetadataInterface)metadata);
                Class varType = assStmt.getVariable().getType();
                Class exprType = expr.getType();
                if (varType.equals(exprType)) break;
                String varTypeName = DataTypeManager.getDataTypeName((Class)varType);
                String exprTypeName = DataTypeManager.getDataTypeName((Class)exprType);
                List rightConv = DataTypeManager.getImplicitConversions((String)exprTypeName);
                if (rightConv.contains(varTypeName)) {
                    assStmt.setExpression((Expression)this.getConversion(exprTypeName, varTypeName, expr));
                    break;
                }
                throw new QueryResolverException("ERR.015.008.0014", QueryPlugin.Util.getString("ERR.015.008.0014", (Object)assStmt));
            }
            case 7: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Criteria whileCrit = whileStmt.getCondition();
                if (varResolve) {
                    ResolveVariablesVisitor.resolveVariables((LanguageObject)whileCrit, (VariableContext)context, (Collection)externalGroups, (QueryMetadataInterface)metadata, (boolean)false);
                } else {
                    ResolveVariablesVisitor.resolveVariables((LanguageObject)whileCrit, (VariableContext)context, (QueryMetadataInterface)metadata, (boolean)true);
                    QueryResolver.resolveCriteria((Criteria)whileCrit, (QueryMetadataInterface)metadata);
                }
                this.resolveBlock(command, whileStmt.getBlock(), externalGroups, context, metadata, varResolve, isUpdateProcedure);
                break;
            }
            case 6: {
                LoopStatement loopStmt = (LoopStatement)statement;
                if (GroupSymbol.isTempGroupName((String)loopStmt.getCursorName())) {
                    String errorMsg = QueryPlugin.Util.getString("ResolveVariablesVisitor.reserved_word_for_temporary_used", (Object)loopStmt.getCursorName());
                    throw new QueryResolverException(errorMsg);
                }
                if (varResolve) {
                    ResolveVariablesVisitor.resolveVariables((LanguageObject)loopStmt.getCommand(), (VariableContext)context, (Collection)externalGroups, (QueryMetadataInterface)metadata, (boolean)false);
                }
                this.resolveBlock(command, loopStmt.getBlock(), externalGroups, context, metadata, varResolve, isUpdateProcedure);
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new QueryResolverException("ERR.015.008.0015", QueryPlugin.Util.getString("ERR.015.008.0015", statement.getType()));
            }
        }
    }

    private void resolveElementsInCommand(Command command, QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException, QueryMetadataException {
        if (command instanceof Query) {
            this.resolveElementsInQuery((Query)command, metadata);
        } else if (command instanceof SetQuery) {
            this.resolveElementsInUnion((SetQuery)command, metadata);
        } else {
            Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)false);
            ResolveElementsVisitor.resolveElements((LanguageObject)command, (Collection)groups, (QueryMetadataInterface)metadata);
        }
    }

    private void resolveElementsInQuery(Query query, QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException, QueryMetadataException {
        GroupSymbol group;
        Object metadataID;
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)query, (boolean)false);
        boolean resolveElements = true;
        if (groups.size() == 1 && (metadataID = (group = (GroupSymbol)groups.iterator().next()).getMetadataID()) != null && metadata.isXMLGroup(metadataID)) {
            resolveElements = false;
        }
        if (resolveElements) {
            QueryMetadataInterface commandMetadata;
            if (query.getInto() != null) {
                groups = query.getFrom() != null ? GroupCollectorVisitor.getGroups((LanguageObject)query.getFrom(), (boolean)true) : Collections.EMPTY_SET;
            }
            if ((commandMetadata = metadata) instanceof TempMetadataAdapter && query.getTemporaryMetadata() != null) {
                TempMetadataAdapter adapter = (TempMetadataAdapter)metadata;
                QueryMetadataInterface actualMetadata = adapter.getMetadata();
                TempMetadataStore store = adapter.getMetadataStore();
                HashMap data = new HashMap(store.getData());
                data.putAll(query.getTemporaryMetadata());
                TempMetadataStore combinedStore = new TempMetadataStore(data);
                commandMetadata = new TempMetadataAdapter(actualMetadata, combinedStore);
            }
            ResolverUtil.resolveElementsInQueryWithoutOrderBy((Query)query, (Collection)groups, null, (QueryMetadataInterface)commandMetadata);
        }
    }

    private void resolveElementsInUnion(SetQuery union, QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException, QueryMetadataException {
        Iterator iter = union.getQueries().iterator();
        while (iter.hasNext()) {
            QueryCommand command = (QueryCommand)iter.next();
            this.resolveElementsInCommand((Command)command, metadata);
        }
    }

    private Function getConversion(String srcTypeName, String tgtTypeName, Expression expression) {
        Class srcType = DataTypeManager.getDataTypeClass((String)srcTypeName);
        FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
        FunctionDescriptor fd = library.findFunction("convert", new Class[]{srcType, DataTypeManager.DefaultDataClasses.STRING});
        Function conversion = new Function(fd.getName(), new Expression[]{expression, new Constant((Object)tgtTypeName)});
        conversion.setType(DataTypeManager.getDataTypeClass((String)tgtTypeName));
        conversion.setFunctionDescriptor(fd);
        conversion.makeImplicit();
        return conversion;
    }

    public Map getVariableValues(Command command, QueryMetadataInterface metadata) {
        return null;
    }

    private static final class ResolveCommandMetadataVisitor
    extends LanguageVisitor {
        private final QueryMetadataInterface metadata;
        private final TempMetadataAdapter adapter;
        private final TempMetadataStore commandMetadata;
        private final TempMetadataStore childMetadata;
        private MetaMatrixComponentException exception;
        private List externalGroups;

        private ResolveCommandMetadataVisitor(QueryMetadataInterface metadata, TempMetadataAdapter adapter, TempMetadataStore commandMetadata, TempMetadataStore childMetadata) {
            this.metadata = metadata;
            this.adapter = adapter;
            this.commandMetadata = commandMetadata;
            this.childMetadata = childMetadata;
            this.externalGroups = new ArrayList();
        }

        protected void handleException(MetaMatrixException e) {
            this.exception = e instanceof MetaMatrixComponentException ? (MetaMatrixComponentException)e : new MetaMatrixComponentException((Throwable)e);
            this.setAbort(true);
        }

        public MetaMatrixComponentException getException() {
            return this.exception;
        }

        public List getExternalGroups() {
            return this.externalGroups;
        }

        public void visit(LoopStatement obj) {
            Command loopCommand = obj.getCommand();
            try {
                TempMetadataStore loopStore = new TempMetadataStore(loopCommand.getTemporaryMetadata());
                loopStore.addTempGroups(this.childMetadata.getData());
                TempMetadataAdapter loopAdapter = new TempMetadataAdapter(this.metadata, loopStore);
                List symbols = new SimpleQueryResolver().resolveProjectedSymbols(loopCommand, loopAdapter);
                this.commandMetadata.addTempGroup(obj.getCursorName(), symbols);
                if (this.childMetadata != null) {
                    this.childMetadata.addTempGroup(obj.getCursorName(), symbols);
                }
                this.addExternalGroup(obj.getCursorName(), (QueryMetadataInterface)this.adapter);
            }
            catch (MetaMatrixException e) {
                this.handleException(e);
            }
        }

        private void addExternalGroup(String groupName, QueryMetadataInterface metadata) {
            try {
                GroupSymbol extGroup = new GroupSymbol(groupName);
                ResolveGroupsVisitor.resolveGroups((LanguageObject)extGroup, (QueryMetadataInterface)metadata);
                this.externalGroups.add(extGroup);
            }
            catch (MetaMatrixException e) {
                this.handleException(e);
            }
        }

        public void visit(Query obj) {
            this.updateExternalGroups((Command)obj);
            TempMetadataStore queryMetadata = new TempMetadataStore(obj.getTemporaryMetadata());
            queryMetadata.addTempGroups(this.commandMetadata.getData());
            TempMetadataAdapter adapterCopy = new TempMetadataAdapter(this.metadata, queryMetadata);
            try {
                SimpleQueryResolver simpleResolver = new SimpleQueryResolver();
                simpleResolver.preResolveReferences(obj, queryMetadata, (QueryMetadataInterface)adapterCopy);
                obj.setTemporaryMetadata(queryMetadata.getData());
            }
            catch (MetaMatrixException e) {
                this.handleException(e);
            }
            if (obj.getInto() != null && obj.getInto().getGroup().isTempGroupSymbol()) {
                try {
                    GroupSymbol tempGroup = obj.getInto().getGroup();
                    Set groups = (Set)GroupCollectorVisitor.getGroups((LanguageObject)obj, (boolean)true);
                    Iterator groupIter = groups.iterator();
                    while (groupIter.hasNext()) {
                        GroupSymbol grp = (GroupSymbol)groupIter.next();
                        ResolveGroupsVisitor.resolveGroups((LanguageObject)grp, (QueryMetadataInterface)this.adapter);
                    }
                    if (obj.getExternalGroups() != null) {
                        groupIter = obj.getExternalGroups().iterator();
                        while (groupIter.hasNext()) {
                            GroupSymbol externalGroup = (GroupSymbol)groupIter.next();
                            ResolveGroupsVisitor.resolveGroups((LanguageObject)externalGroup, (QueryMetadataInterface)this.adapter);
                        }
                    }
                    try {
                        ResolveElementsVisitor.resolveElements((LanguageObject)obj.getSelect(), (Collection)groups, (Collection)obj.getExternalGroups(), (QueryMetadataInterface)adapterCopy);
                    }
                    catch (MetaMatrixException e) {
                        // empty catch block
                    }
                    List symbols = obj.getSelect().getProjectedSymbols();
                    if (symbols.isEmpty()) {
                        SimpleQueryResolver.resolveSelect(obj.getSelect(), obj.getFrom(), groups, this.metadata);
                        symbols = obj.getSelect().getProjectedSymbols();
                    }
                    this.addTempGroup(tempGroup, symbols, 1);
                }
                catch (MetaMatrixException e) {
                    this.handleException(e);
                }
            }
        }

        private void updateExternalGroups(Command obj) {
            if (this.externalGroups.size() > 0) {
                Iterator groupIter = this.externalGroups.iterator();
                while (groupIter.hasNext()) {
                    GroupSymbol externalGroup = (GroupSymbol)groupIter.next();
                    if (obj.getExternalGroups().contains(externalGroup)) continue;
                    obj.addExternalGroup(externalGroup);
                }
            }
        }

        public void visit(Insert obj) {
            this.updateExternalGroups((Command)obj);
            if (obj.getGroup().isTempGroupSymbol()) {
                TempMetadataStore queryMetadata = new TempMetadataStore(obj.getTemporaryMetadata());
                queryMetadata.addTempGroups(this.commandMetadata.getData());
                TempMetadataAdapter adapterCopy = new TempMetadataAdapter(this.metadata, queryMetadata);
                InsertResolver resolver = new InsertResolver();
                try {
                    Iterator groupIter = obj.getExternalGroups().iterator();
                    while (groupIter.hasNext()) {
                        GroupSymbol externalGroup = (GroupSymbol)groupIter.next();
                        ResolveGroupsVisitor.resolveGroups((LanguageObject)externalGroup, (QueryMetadataInterface)this.adapter);
                    }
                    HashSet groups = new HashSet();
                    Iterator i = obj.getValues().iterator();
                    while (i.hasNext()) {
                        Expression expr = (Expression)i.next();
                        ResolveElementsVisitor.resolveElements((LanguageObject)expr, groups, (Collection)obj.getExternalGroups(), (QueryMetadataInterface)adapterCopy);
                        ResolveFunctionsVisitor.resolveFunctions((LanguageObject)expr, (QueryMetadataInterface)adapterCopy);
                        ResolveCaseExpressionVisitor.resolveCaseExpressions((LanguageObject)expr, (QueryMetadataInterface)adapterCopy);
                    }
                }
                catch (MetaMatrixException e) {
                    // empty catch block
                }
                try {
                    resolver.resolveTypes(obj);
                }
                catch (QueryResolverException err) {
                    // empty catch block
                }
                GroupSymbol tempGroup = obj.getGroup();
                List symbols = obj.getVariables();
                this.addTempGroup(tempGroup, symbols, 2);
            }
        }

        private void addTempGroup(GroupSymbol tempGroup, List symbols, int type) {
            this.commandMetadata.addTempGroup(tempGroup.getName(), symbols);
            if (this.childMetadata != null) {
                this.childMetadata.addTempGroup(tempGroup.getName(), symbols);
            }
            this.addExternalGroup(tempGroup.getName(), (QueryMetadataInterface)this.adapter);
        }
    }
}

