/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.event.IChangeNotifier;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.index.IDocument;
import com.metamatrix.core.index.IIndexer;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ChecksumUtil;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.EnhancedStringTokenizer;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.core.util.UriUtil;
import com.metamatrix.core.xslt.Style;
import com.metamatrix.core.xslt.StyleRegistry;
import com.metamatrix.internal.core.index.BlocksIndexInput;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.internal.core.xml.JdomHelper;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.wsdl.io.WsdlResourceFactoryImpl;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexingContext;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlModelSourceAspect;
import com.metamatrix.modeler.core.refactor.ExternalReferenceVisitor;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.ddl.DdlOptions;
import com.metamatrix.modeler.ddl.DdlPlugin;
import com.metamatrix.modeler.ddl.DdlWriter;
import com.metamatrix.modeler.internal.core.builder.ModelBuildUtil;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceFactory;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.vdb.edit.VdbArtifactGenerator;
import com.metamatrix.vdb.edit.VdbEditException;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.VdbEditingContext;
import com.metamatrix.vdb.edit.VdbGenerationContext;
import com.metamatrix.vdb.edit.VdbWsdlGenerationOptions;
import com.metamatrix.vdb.edit.loader.VDBWriter;
import com.metamatrix.vdb.edit.manifest.ManifestFactory;
import com.metamatrix.vdb.edit.manifest.ModelAccessibility;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.ModelSource;
import com.metamatrix.vdb.edit.manifest.ModelSourceProperty;
import com.metamatrix.vdb.edit.manifest.NonModelReference;
import com.metamatrix.vdb.edit.manifest.ProblemMarker;
import com.metamatrix.vdb.edit.manifest.ProblemMarkerContainer;
import com.metamatrix.vdb.edit.manifest.Severity;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.edit.manifest.WsdlOptions;
import com.metamatrix.vdb.edit.manifest.impl.ManifestPackageImpl;
import com.metamatrix.vdb.edit.materialization.DatabaseDialect;
import com.metamatrix.vdb.edit.materialization.ScriptDecorator;
import com.metamatrix.vdb.edit.materialization.ScriptType;
import com.metamatrix.vdb.edit.modelgen.MaterializedViewModelGenerator;
import com.metamatrix.vdb.internal.edit.InternalVdbEditingContext;
import com.metamatrix.vdb.internal.edit.VdbDocumentImpl;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImplValidationHelper;
import com.metamatrix.vdb.internal.edit.VdbFileWriter;
import com.metamatrix.vdb.internal.edit.VdbGenerationContextImpl;
import com.metamatrix.vdb.internal.edit.VdbIndexer;
import com.metamatrix.vdb.internal.edit.VdbInputResourceFinder;
import com.metamatrix.vdb.internal.edit.VdbUriConverter;
import com.metamatrix.vdb.internal.edit.VdbWsdlGenerationOptionsImpl;
import com.metamatrix.vdb.internal.edit.WsVdbInputResourceFinder;
import com.metamatrix.vdb.internal.edit.materialization.MaterializedViewScriptGeneratorImpl;
import com.metamatrix.vdb.internal.edit.materialization.template.engine.MaterializedViewData;
import com.metamatrix.vdb.internal.edit.materialization.template.engine.TemplateData;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.jdom.Document;

public class VdbEditingContextImpl
implements VdbEditingContext,
InternalVdbEditingContext {
    private static final boolean DEBUG_ON = ModelerCore.DEBUG_VDB_EDITING_CONTEXT;
    protected static final int AMOUNT_OF_WORK_FOR_MANIFEST_MODEL = 400;
    protected static final int AMOUNT_OF_WORK_FOR_GENERATING_INDEXES_PER_FILE = 400;
    protected static final int AMOUNT_OF_WORK_FOR_SAVING_ARCHIVE_PER_FILE = 100;
    protected static final int AMOUNT_OF_WORK_FOR_MANIFEST_MODEL_PROBLEMS = 50;
    protected static final int AMOUNT_OF_WORK_FOR_VALIDATING_RESOURCES = 1000;
    protected static final int AMOUNT_OF_WORK_FOR_WSDL = 400;
    protected static final int AMOUNT_OF_WORK_FOR_MATERIALIZED_VIEW = 400;
    public static final int PRODUCE_INDEX_WITH_NO_PROBLEMS = 3001;
    public static final int PRODUCE_INDEX_WITH_WARNINGS = 3002;
    public static final int PRODUCE_INDEX_WITH_ERRORS = 3003;
    public static final int PRODUCE_INDEX_WITH_WARNINGS_AND_ERRORS = 3004;
    public static final int PRODUCE_INDEX_WITH_NO_WARNINGS_AND_ERRORS = 3005;
    public static final int DEFAULT_VDB_FORM = 1;
    public static final String PATH_OF_INDEXES_IN_ARCHIVE = "runtime-inf/";
    protected static final String MODEL_FILE_PREFIX = "ManfiestModelFor";
    protected static final String MODEL_FILE_SUFFIX = ".xml";
    protected static final String MATERIALIZATION_MODEL_NAME = "MaterializationModel";
    protected static final String MATERIALIZATION_MODEL_FILE_SUFFIX = ".xmi";
    protected static final String MATERIALIZATION_DDL_FILE_PREFIX = "MaterializationModel";
    protected static final String MATERIALIZATION_DDL_FILE_SUFFIX = ".ddl";
    protected static final String WSDL_FILE_PREFIX = "WsdlModelFor";
    protected static final String WSDL_FILE_SUFFIX = ".wsdl";
    private static final ModelReference[] EMPTY_MODEL_REFERENCE_ARRAY = new ModelReference[0];
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private IPath vdbFilePath;
    private final IPath vdbWorkingPath;
    private final Container resourceSet;
    private final VdbInputResourceFinder vdbInputResourceFinder;
    private Map resourceOptions;
    private ZipFile vdbArchive;
    private TempDirectory tempDirectory;
    private int vdbArchiveForm;
    private Resource manifestResource;
    private Resource materializationModel;
    private Collection materializationModelDdlFiles;
    private Map materializedModelMap;
    private final VdbWsdlGenerationOptionsImpl wsdlOptions;
    private VirtualDatabase virtualDatabase;
    private Collection addedResourceUrisSinceOpen;
    private Map modelRefsByPath;
    private Map pathsByResourceUri;
    private boolean loadModelsOnOpen;
    private boolean performServerValidation;
    private final ListenerList changeListeners;
    private final ListenerList vetoListeners;

    public VdbEditingContextImpl(IPath vdbFilePath) throws CoreException {
        this(vdbFilePath, null, (VdbInputResourceFinder)new WsVdbInputResourceFinder());
    }

    public VdbEditingContextImpl(IPath vdbFilePath, VdbInputResourceFinder finder) throws CoreException {
        this(vdbFilePath, null, finder);
    }

    public VdbEditingContextImpl(IPath vdbFilePath, IPath vdbWorkingPath, VdbInputResourceFinder finder) throws CoreException {
        ArgCheck.isNotNull((Object)vdbFilePath);
        this.vdbFilePath = vdbFilePath;
        this.vdbWorkingPath = vdbWorkingPath;
        this.resourceSet = ModelerCore.createContainer((String)"VDB Container");
        this.addedResourceUrisSinceOpen = new ArrayList();
        this.pathsByResourceUri = new HashMap();
        this.vdbArchiveForm = 1;
        this.vdbInputResourceFinder = finder;
        this.wsdlOptions = new VdbWsdlGenerationOptionsImpl(this);
        this.materializationModel = null;
        this.materializedModelMap = null;
        this.materializationModelDdlFiles = null;
        this.loadModelsOnOpen = VdbEditPlugin.getInstance() != null;
        this.performServerValidation = true;
        this.changeListeners = new ListenerList();
        this.vetoListeners = new ListenerList();
        this.initialize();
    }

    public void setLoadModelsOnOpen(boolean b) {
        this.loadModelsOnOpen = b;
    }

    public int getVdbArchiveForm() {
        return this.vdbArchiveForm;
    }

    public void setVdbArchiveForm(int form) {
        VdbFileWriter.argCheckForm((int)form);
        this.vdbArchiveForm = form;
    }

    private void initialize() {
        Resource.Factory.Registry reg = this.getVdbContainer().getResourceFactoryRegistry();
        if (reg == null) {
            reg = new ResourceFactoryRegistryImpl();
            this.getVdbContainer().setResourceFactoryRegistry(reg);
        }
        Map extensionMap = reg.getExtensionToFactoryMap();
        Map protocolMap = reg.getProtocolToFactoryMap();
        MtkXmiResourceFactory factory = new MtkXmiResourceFactory();
        extensionMap.put("xmi", factory);
        extensionMap.put("xml", factory);
        extensionMap.put("ecore", factory);
        factory = new XSDResourceFactoryImpl();
        extensionMap.put("xsd", factory);
        factory = new WsdlResourceFactoryImpl();
        extensionMap.put("wsdl", factory);
        factory = new XMIResourceFactoryImpl();
        extensionMap.put("*", factory);
        protocolMap.put("*", factory);
        this.resourceSet.setURIConverter((URIConverter)new VdbUriConverter(this.getTempDirectory()));
    }

    public Map getOptions() {
        if (this.resourceOptions == null) {
            this.resourceOptions = this.createOptions();
        }
        return this.resourceOptions;
    }

    public ManifestFactory getManifestFactory() {
        return ManifestFactory.eINSTANCE;
    }

    public synchronized void open() throws VdbEditException, IOException {
        this.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized void open(boolean notify) throws VdbEditException, IOException {
        if (this.vdbArchive == null) {
            block53: {
                if (VdbEditingContextImpl.DEBUG_ON) {
                    VdbEditPlugin.Util.log((Object)("open(): Opening VdbEditingContextImpl - " + this.vdbFilePath));
                }
                if ((vdbFile = this.vdbFilePath.toFile()).exists() && vdbFile.length() > 0L) {
                    this.vdbArchive = new ZipFile(vdbFile);
                }
                manifestPath = new Path("MetaMatrix-VdbManifestModel.xmi");
                fakeUri = this.getInternalResourceUri((IPath)manifestPath);
                istream = null;
                try {
                    istream = this.getArchiveResourceStream("MetaMatrix-VdbManifestModel.xmi");
                    this.manifestResource = this.addToInternalResourceSet(istream, fakeUri, (IPath)manifestPath);
                    var8_6 = null;
                    ** if (istream == null) goto lbl-1000
                }
                catch (Throwable var7_13) {
                    var8_7 = null;
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (IOException theException) {
                            VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                        }
                    }
                    throw var7_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        istream.close();
                    }
                    catch (IOException theException) {
                        VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block53;
                    catch (Exception theException) {
                        this.manifestResource = null;
                        VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getLocalizedMessage());
                        var8_6 = null;
                        if (istream != null) {
                            try {
                                istream.close();
                            }
                            catch (IOException theException) {
                                VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                            }
                        }
                    }
                }
            }
            if (this.manifestResource == null) {
                params = new Object[]{"MetaMatrix-VdbManifestModel.xmi", this.vdbFilePath};
                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_load_manifest_file", params);
                throw new VdbEditException(msg);
            }
            if (!this.loadModelsOnOpen) {
                return;
            }
            virtualDatabase = this.getVirtualDatabase();
            if (virtualDatabase != null) {
                this.addToTempDirectory(this.manifestResource, "MetaMatrix-VdbManifestModel.xmi");
                this.addNoModelsWarning(virtualDatabase);
            }
            modelRefs = virtualDatabase.getModels();
            iter = modelRefs.iterator();
            while (iter.hasNext()) {
                block54: {
                    modelRef = (ModelReference)iter.next();
                    modelPath = modelRef.getModelLocation();
                    if (VdbEditingContextImpl.DEBUG_ON) {
                        VdbEditPlugin.Util.log((Object)("open(): Loading ModelReference " + modelPath));
                    }
                    istream = this.getArchiveResourceStream(modelPath);
                    modelFile = this.addToTempDirectory(istream, modelPath);
                    if (modelRef.getChecksum() != 0L) break block54;
                    checkSum = this.getCheckSum(modelFile);
                    modelRef.setChecksum(checkSum);
                }
                var16_29 = null;
                if (istream == null) continue;
                try {
                    istream.close();
                }
                catch (IOException theException) {
                    VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                }
                continue;
                {
                    catch (Exception theException) {
                        eMsg = theException.getLocalizedMessage();
                        if (eMsg == null || eMsg.length() == 0) {
                            eMsg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.noDetailErrorMsg");
                        }
                        params = new Object[]{modelPath, eMsg};
                        msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorLoadingReferencedModel", params);
                        this.createProblem((ProblemMarkerContainer)virtualDatabase, 4, msg, theException);
                        var16_29 = null;
                        if (istream == null) continue;
                        try {
                            istream.close();
                        }
                        catch (IOException theException) {
                            VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                        }
                        continue;
                    }
                }
                catch (Throwable var15_31) {
                    var16_29 = null;
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (IOException theException) {
                            VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                        }
                    }
                    throw var15_31;
                }
            }
            xsdResources = new ArrayList<Resource>(modelRefs.size());
            iter = modelRefs.iterator();
            while (iter.hasNext()) {
                block55: {
                    modelRef = (ModelReference)iter.next();
                    modelPath = modelRef.getModelLocation();
                    fakeUri = this.getInternalResourceUri((IPath)new Path(modelPath));
                    istream = this.getArchiveResourceStream(modelPath);
                    r = this.addToInternalResourceSet(istream, fakeUri, (IPath)new Path(modelPath));
                    if (!(r instanceof XSDResourceImpl)) break block55;
                    xsdResources.add(r);
                }
                var19_33 = null;
                if (istream == null) continue;
                try {
                    istream.close();
                }
                catch (IOException theException) {
                    VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                }
                continue;
                {
                    catch (Exception theException) {
                        eMsg = theException.getLocalizedMessage();
                        if (eMsg == null || eMsg.length() == 0) {
                            eMsg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.noDetailErrorMsg");
                        }
                        params = new Object[]{modelPath, eMsg};
                        msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorLoadingReferencedModel", params);
                        this.createProblem((ProblemMarkerContainer)virtualDatabase, 4, msg, theException);
                        var19_33 = null;
                        if (istream == null) continue;
                        try {
                            istream.close();
                        }
                        catch (IOException theException) {
                            VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                        }
                        continue;
                    }
                }
                catch (Throwable var18_35) {
                    var19_33 = null;
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (IOException theException) {
                            VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                        }
                    }
                    throw var18_35;
                }
            }
            iter = xsdResources.iterator();
            while (iter.hasNext()) {
                r = (Resource)iter.next();
                this.resetXsdResource(r);
            }
            nonModelRefs = virtualDatabase.getNonModels();
            iter = nonModelRefs.iterator();
            while (iter.hasNext()) {
                block56: {
                    nonModelRef = (NonModelReference)iter.next();
                    nonModelPath = nonModelRef.getPath();
                    istream = this.getArchiveResourceStream(nonModelPath);
                    modelFile = this.addToTempDirectory(istream, nonModelPath);
                    if (nonModelRef.getChecksum() != 0L) break block56;
                    checkSum = this.getCheckSum(modelFile);
                    nonModelRef.setChecksum(checkSum);
                }
                var22_36 = null;
                if (istream == null) continue;
                try {
                    istream.close();
                }
                catch (IOException theException) {
                    VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                }
                continue;
                {
                    catch (Exception theException) {
                        eMsg = theException.getLocalizedMessage();
                        if (eMsg == null || eMsg.length() == 0) {
                            eMsg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.noDetailErrorMsg");
                        }
                        params = new Object[]{nonModelPath, eMsg};
                        msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorLoadingReferencedNonModel", params);
                        this.createProblem((ProblemMarkerContainer)virtualDatabase, 4, msg, theException);
                        var22_36 = null;
                        if (istream == null) continue;
                        try {
                            istream.close();
                        }
                        catch (IOException theException) {
                            VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                        }
                        continue;
                    }
                }
                catch (Throwable var21_38) {
                    var22_36 = null;
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (IOException theException) {
                            VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                        }
                    }
                    throw var21_38;
                }
            }
            this.manifestResource.setModified(false);
            if (notify) {
                this.fireStateChanged();
            }
        }
    }

    private void resolveSchemaDirectives() {
        ArrayList resources = new ArrayList(this.getVdbContainer().getResources());
        ArrayList<Resource> xsdResources = new ArrayList<Resource>(resources.size());
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            if (!(resource instanceof XSDResourceImpl)) continue;
            xsdResources.add(resource);
        }
        boolean hasUnresolvedSchemaDirective = false;
        Iterator i2 = xsdResources.iterator();
        while (i2.hasNext()) {
            XSDResourceImpl xsdResource;
            block11: {
                xsdResource = (XSDResourceImpl)i2.next();
                try {
                    if (xsdResource.isLoaded()) break block11;
                    xsdResource.load(this.getOptions());
                }
                catch (IOException err) {
                    VdbEditPlugin.Util.log(4, (Throwable)err, err.getLocalizedMessage());
                    continue;
                }
            }
            Iterator j = xsdResource.getSchema().eContents().iterator();
            while (j.hasNext()) {
                XSDSchemaDirective directive;
                Object content = j.next();
                if (!(content instanceof XSDSchemaDirective) || (directive = (XSDSchemaDirective)content).getResolvedSchema() != null) continue;
                hasUnresolvedSchemaDirective = true;
                break;
            }
            if (!hasUnresolvedSchemaDirective) continue;
            break;
        }
        if (hasUnresolvedSchemaDirective) {
            Resource resource;
            i2 = xsdResources.iterator();
            while (i2.hasNext()) {
                resource = (Resource)i2.next();
                resource.unload();
            }
            i2 = xsdResources.iterator();
            while (i2.hasNext()) {
                resource = (Resource)i2.next();
                try {
                    if (resource.isLoaded()) continue;
                    resource.load(this.getOptions());
                }
                catch (IOException err) {
                    VdbEditPlugin.Util.log(4, (Throwable)err, err.getLocalizedMessage());
                }
            }
            i2 = xsdResources.iterator();
            while (i2.hasNext()) {
                resource = (Resource)i2.next();
                resource.setModified(false);
            }
        }
    }

    public boolean isOpen() {
        return this.manifestResource != null;
    }

    public IStatus save(IProgressMonitor monitor) {
        return this.save(monitor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IStatus save(IProgressMonitor progressMonitor, boolean minimal) {
        block93: {
            this.assertIsOpen();
            this.assertModelsLoaded();
            if (!this.isSaveRequired() && (minimal || !this.isSaveRequiredForValidVdb())) break block93;
            IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
            try {
                Status errStatus;
                String msg;
                String desc;
                IStatus writeStatus;
                Object[] params;
                boolean hasFatalProblems;
                LinkedList<Object> problems;
                block94: {
                    Iterator iter2;
                    String modelPath;
                    Resource eResource;
                    Iterator iter;
                    int numModels = this.getVirtualDatabase().getModels().size();
                    int totalWork = 850 + 100 * (numModels + 1) + 400 * numModels + 1000;
                    String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Saving", (Object)this.vdbFilePath);
                    monitor.beginTask(taskName, totalWork);
                    this.manifestResource.getErrors().clear();
                    this.manifestResource.getWarnings().clear();
                    problems = new LinkedList<Object>();
                    hasFatalProblems = false;
                    this.addGlobalResourcesToInternalResourceSet();
                    this.resolveSchemaDirectives();
                    List eResources = new ArrayList(this.getVdbContainer().getResources());
                    this.clearProblemMarkers((ProblemMarkerContainer)this.getVirtualDatabase());
                    Collection modelRefsToValidate1 = this.getModelReferences(this.getInternalResourcesToValidate(problems), problems);
                    Iterator iter3 = modelRefsToValidate1.iterator();
                    while (iter3.hasNext()) {
                        ModelReference modelRef = (ModelReference)iter3.next();
                        this.clearProblemMarkers((ProblemMarkerContainer)modelRef);
                        if (!DEBUG_ON) continue;
                        VdbEditPlugin.Util.log((Object)("save(): Clearing problem markers on " + modelRef.getModelLocation()));
                    }
                    IStatus validateStatus = this.validateVdb(eResources, true);
                    if (validateStatus != null && validateStatus.getSeverity() == 4) {
                        hasFatalProblems = true;
                    }
                    if (!hasFatalProblems) {
                        String modelPath2 = this.getMaterializedViewModelName(true);
                        ModelReference modelRef = this.getModelReferenceByPath((IPath)new Path(modelPath2));
                        if (modelRef != null) {
                            this.removeFromInternalResourceSet(modelRef);
                            this.getVirtualDatabase().getModels().remove((Object)modelRef);
                        }
                        eResources = new ArrayList(this.getVdbContainer().getResources());
                        this.materializedModelMap = new HashMap();
                        this.materializationModel = this.createMaterialization(eResources, this.materializedModelMap, problems, monitor);
                        this.addMaterializationToVdb(this.materializationModel, this.getVirtualDatabase(), problems, monitor);
                        this.materializationModelDdlFiles = this.generateDdlsForMaterialization(this.materializationModel, problems, monitor);
                        if (this.materializationModel != null && !eResources.contains(this.materializationModel)) {
                            this.addToInternalResourceSet(this.materializationModel, (IPath)new Path(modelPath2));
                        }
                    }
                    monitor.worked(400);
                    Collection scriptFiles = Collections.EMPTY_LIST;
                    if (!hasFatalProblems && this.materializationModel != null) {
                        scriptFiles = this.generateMateriailizedViewLoadRefreshScripts(this.getVdbName(), this.materializedModelMap, problems, monitor);
                    }
                    File wsdlFile = null;
                    if (!hasFatalProblems && this.wsdlOptions.canWsdlBeGenerated()) {
                        IStatus genStatus;
                        block90: {
                            String msg22222;
                            Object[] params22222;
                            IOException e22222;
                            Object var20_21;
                            OutputStream wsdlStream;
                            block89: {
                                wsdlStream = null;
                                genStatus = null;
                                wsdlFile = this.getTempDirectoryFile("MetaMatrixDataServices.wsdl");
                                wsdlStream = new FileOutputStream(wsdlFile);
                                wsdlStream = new BufferedOutputStream(wsdlStream);
                                WsdlOptions theWsdlOptions = this.wsdlOptions.getWsdlOptions(false);
                                if (theWsdlOptions == null) {
                                    theWsdlOptions = ManifestFactory.eINSTANCE.createWsdlOptions();
                                    theWsdlOptions.setTargetNamespaceUri("http://com.metamatrix/" + this.getVirtualDatabase().getName());
                                    theWsdlOptions.setDefaultNamespaceUri("http://schemas.xmlsoap.org/wsdl/");
                                    this.getVirtualDatabase().setWsdlOptions(theWsdlOptions);
                                }
                                genStatus = this.wsdlOptions.generateWsdl(monitor, wsdlStream);
                                var20_21 = null;
                                if (wsdlStream == null) break block89;
                                try {
                                    wsdlStream.close();
                                }
                                catch (IOException e22222) {
                                    params22222 = new Object[]{wsdlFile.getAbsolutePath(), this.vdbFilePath};
                                    msg22222 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params22222);
                                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg22222, (Throwable)e22222));
                                }
                            }
                            monitor.worked(400);
                            {
                                break block90;
                                catch (IOException e) {
                                    Object[] params3 = new Object[]{wsdlFile.getAbsolutePath(), this.vdbFilePath};
                                    String msg3 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorWritingTemporaryFileForWsdl", params3);
                                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg3, (Throwable)e));
                                    hasFatalProblems = true;
                                    var20_21 = null;
                                    if (wsdlStream != null) {
                                        try {
                                            wsdlStream.close();
                                        }
                                        catch (IOException e22222) {
                                            params22222 = new Object[]{wsdlFile.getAbsolutePath(), this.vdbFilePath};
                                            msg22222 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params22222);
                                            problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg22222, (Throwable)e22222));
                                        }
                                    }
                                    monitor.worked(400);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var20_22 = null;
                                if (wsdlStream != null) {
                                    try {
                                        wsdlStream.close();
                                    }
                                    catch (IOException e22222) {
                                        Object[] params22222 = new Object[]{wsdlFile.getAbsolutePath(), this.vdbFilePath};
                                        String msg22222 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params22222);
                                        problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg22222, (Throwable)e22222));
                                    }
                                }
                                monitor.worked(400);
                                throw throwable;
                            }
                        }
                        if (!genStatus.isOK()) {
                            if (genStatus instanceof MultiStatus) {
                                IStatus[] children = ((MultiStatus)genStatus).getChildren();
                                for (int i = 0; i < children.length; ++i) {
                                    problems.add(children[i]);
                                }
                            } else {
                                problems.add(genStatus);
                            }
                        }
                    } else {
                        monitor.worked(400);
                    }
                    LinkedList indexFiles = new LinkedList();
                    LinkedList indexFilenames = new LinkedList();
                    if (!hasFatalProblems) {
                        EList modelWarnings;
                        EList modelErrors = this.manifestResource.getErrors();
                        IStatus modelStatus = this.createModelStatus(problems, (List)modelErrors, (List)(modelWarnings = this.manifestResource.getWarnings()));
                        if (modelStatus.getSeverity() == 4) {
                            problems.add(modelStatus);
                            hasFatalProblems = true;
                        }
                        Container container = this.getVdbContainer();
                        eResources = new ArrayList(container.getResources());
                        if (DEBUG_ON) {
                            iter = eResources.iterator();
                            while (iter.hasNext()) {
                                eResource = (Resource)iter.next();
                                VdbEditPlugin.Util.log((Object)("save(): Indexing " + eResource.getURI().lastSegment()));
                            }
                        }
                        IStatus productionStatus = null;
                        if (!minimal && !(productionStatus = this.produce(modelStatus, indexFiles, indexFilenames, eResources, container, monitor)).isOK()) {
                            problems.add(productionStatus);
                            hasFatalProblems = true;
                        }
                        if ((modelStatus = this.createModelStatus(problems, (List)(modelErrors = this.manifestResource.getErrors()), (List)(modelWarnings = this.manifestResource.getWarnings()))).getSeverity() == 4) {
                            problems.add(modelStatus);
                            hasFatalProblems = true;
                        }
                    }
                    if (!hasFatalProblems) {
                        taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.validating_the_resources");
                        monitor.setTaskName(taskName);
                        ValidationContext context = this.performServerValidation ? new ValidationContext() : ModelBuildUtil.createValidationContext();
                        eResources = this.getInternalResourcesToValidate(problems);
                        this.clearProblemMarkers((ProblemMarkerContainer)this.getVirtualDatabase());
                        Collection modelRefsToValidate = this.getModelReferences(eResources, problems);
                        Iterator iter4 = modelRefsToValidate.iterator();
                        while (iter4.hasNext()) {
                            ModelReference modelRef = (ModelReference)iter4.next();
                            this.clearProblemMarkers((ProblemMarkerContainer)modelRef);
                            if (!DEBUG_ON) continue;
                            VdbEditPlugin.Util.log((Object)("save(): Clearing problem markers on " + modelRef.getModelLocation()));
                        }
                        context.setResourceContainer(this.getVdbContainer());
                        Resource[] resourcesToValidate = new Resource[eResources.size()];
                        eResources.toArray(resourcesToValidate);
                        context.setResourcesToValidate(resourcesToValidate);
                        Object[] resourcesInScope = new Resource[this.getVdbContainer().getResources().size()];
                        this.getVdbContainer().getResources().toArray(resourcesInScope);
                        context.setResourcesInScope((Resource[])resourcesInScope);
                        context.setIndexLocation(this.getTempDirectory().getPath());
                        context.setUseServerIndexes(true);
                        context.setUseIndexesToResolve(true);
                        context.setCacheMappingRootResults(false);
                        validateStatus = this.validateVdb(eResources, false);
                        if (validateStatus != null && validateStatus.getSeverity() == 4) {
                            hasFatalProblems = true;
                        }
                        iter = eResources.iterator();
                        while (iter.hasNext()) {
                            ModelReference modelRef;
                            eResource = (Resource)iter.next();
                            if (DEBUG_ON) {
                                VdbEditPlugin.Util.log((Object)("save(): Validating " + eResource.getURI().lastSegment()));
                            }
                            eResource.setModified(false);
                            ModelBuildUtil.validateResource((IProgressMonitor)monitor, (Resource)eResource, (ValidationContext)context);
                            modelPath = this.getResourcePath(eResource);
                            if ("MetaMatrix-VdbManifestModel.xmi".equals(modelPath) || "MetaMatrixDataServices.wsdl".equals(modelPath)) {
                                this.setContainerProblems((ProblemMarkerContainer)this.getVirtualDatabase(), context);
                            } else if (modelPath != null && (modelRef = this.getModelReferenceByPath((IPath)new Path(modelPath))) != null) {
                                this.setModelReferenceProblems(modelRef, context);
                            }
                            context.clearResults();
                        }
                        context.clearState();
                    }
                    monitor.worked(1000);
                    if (!hasFatalProblems) {
                        eResources = new ArrayList(this.getVdbContainer().getResources());
                        Iterator iter5 = eResources.iterator();
                        while (iter5.hasNext()) {
                            Resource eResource2 = (Resource)iter5.next();
                            this.updateXsdResource(eResource2);
                        }
                    }
                    ArrayList<Artifact> artifactsToWrite = new ArrayList<Artifact>();
                    eResources = new ArrayList(this.getVdbContainer().getResources());
                    Iterator resourceIter = eResources.iterator();
                    while (resourceIter.hasNext()) {
                        Resource eResource3 = (Resource)resourceIter.next();
                        String fileName = this.getResourcePath(eResource3);
                        if (fileName == null) continue;
                        File tempFile = this.getTempDirectoryFile(fileName);
                        Path modelPath3 = new Path(fileName);
                        artifactsToWrite.add(new Artifact(this, (IPath)modelPath3, tempFile, 100));
                    }
                    Iterator nonModelIter = this.getVirtualDatabase().getNonModels().iterator();
                    while (nonModelIter.hasNext()) {
                        NonModelReference nonModelRef = (NonModelReference)nonModelIter.next();
                        File tempFile = this.getTempDirectoryFile(nonModelRef);
                        if (nonModelRef.getName().equals("ConfigurationInfo.def")) {
                            try {
                                VDBWriter.updateConfigDefFile((File)tempFile, (String)this.getVdbName());
                            }
                            catch (Exception theException) {
                                String msg4 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorUpdatingDefFileName", (Object)this.vdbFilePath);
                                problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg4, (Throwable)theException));
                            }
                        }
                        Path modelPath4 = new Path(nonModelRef.getPath());
                        artifactsToWrite.add(new Artifact(this, (IPath)modelPath4, tempFile, 100));
                    }
                    Path indexPath = new Path(PATH_OF_INDEXES_IN_ARCHIVE);
                    Iterator indexIter = indexFiles.iterator();
                    Iterator nameIter = indexFilenames.iterator();
                    while (indexIter.hasNext()) {
                        File indexFile = (File)indexIter.next();
                        String indexFilename = (String)nameIter.next();
                        if (indexFile == null) continue;
                        IPath indexFilePath = indexPath.append(indexFilename);
                        artifactsToWrite.add(new Artifact(this, indexFilePath, indexFile, 100));
                    }
                    if (wsdlFile != null) {
                        artifactsToWrite.add(new Artifact(this, (IPath)new Path(wsdlFile.getName()), wsdlFile, 0));
                    }
                    if (this.materializationModelDdlFiles != null && !this.materializationModelDdlFiles.isEmpty()) {
                        iter2 = this.materializationModelDdlFiles.iterator();
                        while (iter2.hasNext()) {
                            File ddlFile = (File)iter2.next();
                            artifactsToWrite.add(new Artifact(this, (IPath)new Path(ddlFile.getName()), ddlFile, 0));
                        }
                    }
                    if (scriptFiles.size() > 0) {
                        iter2 = scriptFiles.iterator();
                        while (iter2.hasNext()) {
                            File scriptFile = (File)iter2.next();
                            artifactsToWrite.add(new Artifact(this, (IPath)new Path(scriptFile.getName()), scriptFile, 0));
                        }
                    }
                    if (!hasFatalProblems) {
                        taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.executingArtifactGenerators");
                        monitor.setTaskName(taskName);
                        hasFatalProblems = this.doGenerateAdditionalArtifacts(monitor, problems, artifactsToWrite);
                    }
                    this.setVdbProblems(this.getVirtualDatabase(), problems);
                    this.updateVirtualDatabase(this.getVirtualDatabase());
                    problems.clear();
                    taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.writing_the_resources");
                    monitor.setTaskName(taskName);
                    eResources = new ArrayList(this.getVdbContainer().getResources());
                    iter = eResources.iterator();
                    while (iter.hasNext()) {
                        String msg5;
                        eResource = (Resource)iter.next();
                        modelPath = this.getResourcePath(eResource);
                        if (modelPath == null) continue;
                        try {
                            this.addToTempDirectory(eResource, modelPath);
                        }
                        catch (FileNotFoundException e) {
                            params = new Object[]{modelPath, this.vdbFilePath};
                            msg5 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_creating_temporary_file_for_model", params);
                            problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg5, (Throwable)e));
                        }
                        catch (IOException e) {
                            params = new Object[]{modelPath, this.vdbFilePath};
                            msg5 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_writing_temporary_file_for_model", params);
                            problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg5, (Throwable)e));
                        }
                        catch (Throwable e) {
                            params = new Object[]{modelPath, this.vdbFilePath};
                            msg5 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unexpected_error_writing_temporary_file_for_model", params);
                            problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg5, e));
                        }
                        finally {
                            monitor.worked(400);
                        }
                    }
                    VdbFileWriter writer = new VdbFileWriter(this.vdbFilePath, this.getVdbArchiveForm());
                    Iterator artifactIter = artifactsToWrite.iterator();
                    while (artifactIter.hasNext()) {
                        Artifact artifact = (Artifact)artifactIter.next();
                        IPath path = artifact.path;
                        File content = artifact.content;
                        int work = artifact.workToWrite;
                        try {
                            writer.addEntry(path, content);
                        }
                        catch (IOException e2) {
                            String msg6 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.adding_to_archive", (Object)path);
                            problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg6, (Throwable)e2));
                        }
                        finally {
                            monitor.worked(work);
                        }
                    }
                    if (this.vdbArchive != null) {
                        try {
                            this.vdbArchive.close();
                        }
                        catch (Throwable e1) {
                            Object[] params4 = new Object[]{this.vdbFilePath};
                            String msg7 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_closing_vdb_archive_file_before_saving", params4);
                            problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg7, e1));
                        }
                        finally {
                            this.vdbArchive = null;
                        }
                    }
                    writeStatus = null;
                    desc = VdbEditPlugin.Util.getString("VdbEditingContextImpl.writing_archive");
                    writer.open();
                    writeStatus = writer.write(monitor);
                    Object var31_55 = null;
                    try {
                        writer.close();
                    }
                    catch (Throwable e3) {
                        Object[] params5 = new Object[]{this.vdbFilePath};
                        String msg8 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_closing_archive_writer", params5);
                        Status errStatus2 = new Status(4, "com.metamatrix.vdb.edit", 0, msg8, null);
                        writeStatus = this.merge((IStatus)errStatus2, writeStatus, desc);
                    }
                    break block94;
                    {
                        catch (Throwable e2) {
                            Object[] params6 = new Object[]{this.vdbFilePath};
                            msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_writing_archive", params6);
                            errStatus = new Status(4, "com.metamatrix.vdb.edit", 1003, msg, e2);
                            writeStatus = this.merge((IStatus)errStatus, writeStatus, desc);
                            Object var31_56 = null;
                            try {
                                writer.close();
                            }
                            catch (Throwable e3) {
                                Object[] params5 = new Object[]{this.vdbFilePath};
                                String msg8 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_closing_archive_writer", params5);
                                Status errStatus2 = new Status(4, "com.metamatrix.vdb.edit", 0, msg8, null);
                                writeStatus = this.merge((IStatus)errStatus2, writeStatus, desc);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var31_57 = null;
                        try {
                            writer.close();
                        }
                        catch (Throwable e3) {
                            Object[] params5 = new Object[]{this.vdbFilePath};
                            String msg8 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_closing_archive_writer", params5);
                            Status errStatus2 = new Status(4, "com.metamatrix.vdb.edit", 0, msg8, null);
                            writeStatus = this.merge((IStatus)errStatus2, writeStatus, desc);
                        }
                        throw throwable;
                    }
                }
                try {
                    this.close(true, false, false);
                    this.setLoadModelsOnOpen(true);
                    this.open(false);
                }
                catch (Throwable e3) {
                    Object[] params7 = new Object[]{this.vdbFilePath};
                    msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_reopening_archive_writer_after_save", params7);
                    errStatus = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
                    writeStatus = this.merge((IStatus)errStatus, writeStatus, desc);
                }
                if (!hasFatalProblems) {
                    this.addedResourceUrisSinceOpen.clear();
                    if (DEBUG_ON) {
                        VdbEditPlugin.Util.log((Object)"save(): Clearing addedResourceUrisSinceOpen collection");
                    }
                }
                if (writeStatus.getSeverity() == 4) {
                    params = new Object[]{this.vdbFilePath};
                    String msg9 = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Errors_were_encountered_writing_the_VDB_definition_file_0_-_see_the_error_log_for_details_1", params);
                    this.createProblem((ProblemMarkerContainer)this.getVirtualDatabase(), 4, msg9, null);
                    this.setModified();
                }
                problems.add(writeStatus);
                IStatus allStatus = this.createSingleIStatus(problems, desc);
                this.fireStateChanged();
                IStatus iStatus = allStatus;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
        Object[] params = new Object[]{this.vdbFilePath};
        String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.save_not_required", params);
        Status status = new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean doGenerateAdditionalArtifacts(IProgressMonitor monitor, List problems, List artifactsToWrite) {
        hasFatalProblems = false;
        artifactGenerators = VdbEditPlugin.getVdbArtifactGenerators();
        if (artifactGenerators.size() == 0) {
            return hasFatalProblems;
        }
        modelList = this.getVdbContainer().getResources();
        models = modelList.toArray(new Resource[modelList.size()]);
        modelNamesByResource = new HashMap<Resource, String>();
        modelPathsByResource = new HashMap<Resource, String>();
        modelVisibilityByResource = new HashMap<Resource, Boolean>();
        problemsByObjectId = new HashMap<ObjectID, ArrayList<ProblemMarker>>();
        modelIter = modelList.iterator();
        while (modelIter.hasNext()) {
            eResource = (Resource)modelIter.next();
            modelPathString = this.getResourcePath(eResource);
            modelPathsByResource.put(eResource, modelPathString);
            path = new Path(modelPathString);
            model = this.getModelReferenceByPath((IPath)path);
            if (model != null) {
                modelName = model.getName();
                modelNamesByResource.put(eResource, modelName);
            }
            if ((modelRef = this.getModelReference(eResource)) == null) continue;
            isVisible = modelRef.isVisible() != false ? Boolean.TRUE : Boolean.FALSE;
            modelVisibilityByResource.put(eResource, isVisible);
            iter = modelRef.getMarkers().iterator();
            while (iter.hasNext()) {
                marker = (ProblemMarker)iter.next();
                target = this.getProblemMarkerEObject(marker);
                if (target == null) continue;
                targetId = target.getObjectId();
                targetProblems = (ArrayList<ProblemMarker>)problemsByObjectId.get(targetId);
                if (targetProblems == null) {
                    targetProblems = new ArrayList<ProblemMarker>(7);
                    problemsByObjectId.put(targetId, targetProblems);
                }
                targetProblems.add(marker);
            }
        }
        paths = new ArrayList<IPath>();
        artifactIter = artifactsToWrite.iterator();
        while (artifactIter.hasNext()) {
            artifact = (Artifact)artifactIter.next();
            path = artifact.path;
            paths.add(path);
        }
        existingArtifactPaths = paths.toArray(new IPath[paths.size()]);
        tempDir = this.getTempDirectory();
        tempDirFile = new File(tempDir.getPath());
        tempDtcFolder = new File(tempDirFile, "" + System.currentTimeMillis() + "Dtc");
        tempDtcFolder.mkdir();
        genContext = new VdbGenerationContextImpl(models, monitor, existingArtifactPaths, modelNamesByResource, modelPathsByResource, modelVisibilityByResource, problemsByObjectId, tempDtcFolder.getAbsolutePath());
        genIter = artifactGenerators.iterator();
        while (genIter.hasNext()) {
            if (monitor.isCanceled()) {
                return hasFatalProblems;
            }
            generator = (VdbArtifactGenerator)genIter.next();
            thread = new ArtifactGeneratorThread(this, (VdbGenerationContext)genContext, generator);
            thread.start();
            try {
                while ((monitor == null || !monitor.isCanceled()) && thread.isAlive()) {
                    displayMessage = genContext.getProgressMessage();
                    monitor.setTaskName(displayMessage);
                    Thread.sleep(100L);
                }
                if (monitor != null && monitor.isCanceled() && thread.isAlive()) {
                    try {
                        thread.stop();
                    }
                    catch (Throwable t) {
                    }
                }
                var25_26 = null;
            }
            catch (Throwable var24_32) {
                var25_26 = null;
                error = thread.getThrowable();
                if (error != null) {
                    if (error instanceof InterruptedException) {
                        params = new Object[]{generator.getClass().getName()};
                        msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.generatorCancelled", params);
                        status = new Status(2, "com.metamatrix.vdb.edit", 0, msg, error);
                        problems.add(status);
                    } else {
                        params = new Object[]{generator.getClass().getName()};
                        msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorExecutingGenerator", params);
                        status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, error);
                        problems.add(status);
                        VdbEditPlugin.Util.log((IStatus)status);
                    }
                }
                throw var24_32;
            }
            error = thread.getThrowable();
            if (error == null) continue;
            if (error instanceof InterruptedException) {
                params = new Object[]{generator.getClass().getName()};
                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.generatorCancelled", params);
                status = new Status(2, "com.metamatrix.vdb.edit", 0, msg, error);
                problems.add(status);
                continue;
            }
            params = new Object[]{generator.getClass().getName()};
            msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorExecutingGenerator", params);
            status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, error);
            problems.add(status);
            VdbEditPlugin.Util.log((IStatus)status);
            {
                continue;
                catch (InterruptedException e) {
                    var25_26 = null;
                    error = thread.getThrowable();
                    if (error == null) continue;
                    if (error instanceof InterruptedException) {
                        params = new Object[]{generator.getClass().getName()};
                        msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.generatorCancelled", params);
                        status = new Status(2, "com.metamatrix.vdb.edit", 0, msg, error);
                        problems.add(status);
                        continue;
                    }
                    params = new Object[]{generator.getClass().getName()};
                    msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorExecutingGenerator", params);
                    status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, error);
                    problems.add(status);
                    VdbEditPlugin.Util.log((IStatus)status);
                }
            }
        }
        problems.addAll(genContext.getProblems());
        newArtifactsByPath = genContext.getGeneratedArtifactsByPath();
        iter = newArtifactsByPath.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            tempFile = null;
            try {
                block49: {
                    path = new Path((String)entry.getKey());
                    content = entry.getValue();
                    tempFile = this.getTempDirectoryFile(path.makeAbsolute().toString());
                    if (content instanceof String) {
                        stream = null;
                        try {
                            stream = new ByteArrayInputStream(((String)content).getBytes());
                            FileUtils.write((InputStream)stream, (File)tempFile);
                            var31_34 = null;
                            ** if (stream == null) goto lbl-1000
                        }
                        catch (Throwable var30_46) {
                            var31_34 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e2) {
                                    params = new Object[]{tempFile.getAbsolutePath(), this.vdbFilePath};
                                    msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params);
                                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)e2));
                                }
                            }
                            throw var30_46;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException e2) {
                                params = new Object[]{tempFile.getAbsolutePath(), this.vdbFilePath};
                                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params);
                                problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)e2));
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block49;
                        }
                    }
                    if (content instanceof Document) {
                        fileStream = new FileOutputStream(tempFile);
                        try {
                            JdomHelper.write((Document)((Document)content), (OutputStream)fileStream);
                            var36_38 = null;
                            ** if (fileStream == null) goto lbl-1000
                        }
                        catch (Throwable var35_47) {
                            var36_38 = null;
                            if (fileStream != null) {
                                try {
                                    fileStream.close();
                                }
                                catch (IOException err) {
                                    params = new Object[]{tempFile.getAbsolutePath(), this.vdbFilePath};
                                    msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params);
                                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)err));
                                }
                            }
                            throw var35_47;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                fileStream.close();
                            }
                            catch (IOException err) {
                                params = new Object[]{tempFile.getAbsolutePath(), this.vdbFilePath};
                                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params);
                                problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)err));
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block49;
                        }
                    }
                    if (content instanceof InputStream) {
                        stream = (InputStream)content;
                        try {
                            FileUtils.write((InputStream)stream, (File)tempFile);
                            var41_42 = null;
                            ** if (stream == null) goto lbl-1000
                        }
                        catch (Throwable var40_48) {
                            var41_42 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e2) {
                                    params = new Object[]{tempFile.getAbsolutePath(), this.vdbFilePath};
                                    msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params);
                                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)e2));
                                }
                            }
                            throw var40_48;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException e2) {
                                params = new Object[]{tempFile.getAbsolutePath(), this.vdbFilePath};
                                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.ErrorClosingTemporaryWsdlFile", params);
                                problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)e2));
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block49;
                        }
                    }
                    if (content instanceof File) {
                        tempFile = (File)content;
                    }
                }
                if (!(tempFile != null & tempFile.exists())) continue;
                artifactsToWrite.add(new Artifact(this, (IPath)path, tempFile, 0));
            }
            catch (Throwable e) {
                params = new Object[]{tempFile.getName(), this.vdbFilePath, e.getMessage()};
                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_writing_artifact_file_for_vdb", params);
                problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg, e));
                hasFatalProblems = true;
            }
        }
        return hasFatalProblems;
    }

    protected URI getEscapedURI(Resource resource) {
        String modelPath = this.getResourcePath(resource);
        if (modelPath == null) {
            URI resourceURI = resource.getURI();
            Object[] params = new Object[]{resourceURI};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.finding_model_path_for_resource", params);
            VdbEditPlugin.Util.log(4, msg);
            return resourceURI;
        }
        modelPath = this.encodePathForUseInUri(modelPath);
        String updatedLocation = "http://vdb.metamatrix.com" + modelPath + "?vdbToken=true";
        URI result = URI.createURI((String)updatedLocation);
        return result;
    }

    private void updateXsdResource(Resource eResource) {
        if (eResource instanceof XSDResourceImpl) {
            boolean saveRequired = false;
            if (!eResource.isLoaded()) {
                try {
                    eResource.load(this.getOptions());
                }
                catch (IOException e) {
                    VdbEditPlugin.Util.log((Throwable)e);
                }
            }
            XSDSchema schema = ((XSDResourceImpl)eResource).getSchema();
            Iterator iter = schema.eContents().iterator();
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                if (!(eObj instanceof XSDSchemaDirective)) continue;
                XSDSchemaDirective directive = (XSDSchemaDirective)eObj;
                XSDSchema resolvedSchema = directive.getResolvedSchema();
                XSDResourceImpl refdResource = null;
                if (resolvedSchema == null) {
                    URI schemaLocationURI;
                    String schemaLocation = directive.getSchemaLocation();
                    URI baseLocationURI = eResource.getURI();
                    URI uRI = schemaLocationURI = baseLocationURI.isFile() ? URI.createURI((String)schemaLocation, (boolean)false) : URI.createURI((String)schemaLocation);
                    if (baseLocationURI.isHierarchical() && !baseLocationURI.isRelative() && schemaLocationURI.isRelative()) {
                        schemaLocationURI = schemaLocationURI.resolve(baseLocationURI);
                    }
                    refdResource = (XSDResourceImpl)this.getVdbContainer().getResource(schemaLocationURI, false);
                } else {
                    if (resolvedSchema.eIsProxy()) {
                        resolvedSchema = (XSDSchema)EcoreUtil.resolve((EObject)resolvedSchema, (ResourceSet)this.getVdbContainer());
                    }
                    refdResource = (XSDResourceImpl)resolvedSchema.eResource();
                }
                if (refdResource != null) {
                    URI escapedURI;
                    String updatedLocation;
                    Container cntr = ModelerCore.getContainer((Resource)refdResource);
                    if (cntr != null && cntr.getResourceFinder().isBuiltInResource((Resource)refdResource) || (updatedLocation = (escapedURI = this.getEscapedURI((Resource)refdResource)).toString()) == null || updatedLocation.equals(directive.getSchemaLocation())) continue;
                    directive.setSchemaLocation(updatedLocation);
                    saveRequired = true;
                    continue;
                }
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_resolve_schemaLocation", (Object)directive.getSchemaLocation());
                VdbEditPlugin.Util.log(4, msg);
            }
            if (saveRequired) {
                File xsdResourceFile = new File(eResource.getURI().toFileString());
                if (xsdResourceFile.exists() && !xsdResourceFile.canWrite()) {
                    xsdResourceFile.delete();
                }
                try {
                    eResource.save(this.getOptions());
                }
                catch (Throwable e) {
                    VdbEditPlugin.Util.log(4, e, VdbEditPlugin.Util.getString("VdbEditingContextImpl.1", (Object)this.getResourcePath(eResource)));
                }
            }
        }
    }

    private void resetXsdResource(Resource eResource) {
        if (eResource instanceof XSDResourceImpl) {
            boolean saveRequired = false;
            if (!eResource.isLoaded()) {
                try {
                    eResource.load(this.getOptions());
                }
                catch (IOException e) {
                    VdbEditPlugin.Util.log((Throwable)e);
                }
            }
            XSDSchema schema = ((XSDResourceImpl)eResource).getSchema();
            Iterator iter = schema.eContents().iterator();
            while (iter.hasNext()) {
                URI deresolvedURI;
                boolean deresolve;
                EObject eObj = (EObject)iter.next();
                if (!(eObj instanceof XSDSchemaDirective)) continue;
                XSDSchemaDirective directive = (XSDSchemaDirective)eObj;
                String location = directive.getSchemaLocation();
                int endIndex = location.lastIndexOf("?vdbToken=true");
                int beginIndex = "http://vdb.metamatrix.com".length();
                if (endIndex <= 0 || beginIndex >= endIndex) continue;
                URI locationURI = URI.createURI((String)location);
                XSDResourceImpl refdResource = (XSDResourceImpl)this.getVdbContainer().getResource(locationURI, false);
                if (refdResource == null) {
                    Path modelPath = new Path(location.substring("http://vdb.metamatrix.com".length(), endIndex));
                    locationURI = this.getInternalResourceUri((IPath)modelPath);
                    refdResource = (XSDResourceImpl)this.getVdbContainer().getResource(locationURI, true);
                    if (refdResource == null) {
                        VdbEditPlugin.Util.log(4, VdbEditPlugin.Util.getString("VdbEditingContextImpl.cannotLoadResource", (Object)locationURI.lastSegment()));
                    }
                }
                if (refdResource == null) continue;
                URI resourceURI = eResource.getURI();
                URI importURI = refdResource.getURI();
                if (!importURI.isFile()) continue;
                boolean bl = deresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                directive.setSchemaLocation(importURI.toString());
                saveRequired = true;
            }
            if (saveRequired) {
                try {
                    eResource.save(this.getOptions());
                }
                catch (Throwable e) {
                    VdbEditPlugin.Util.log(4, e, VdbEditPlugin.Util.getString("VdbEditingContextImpl.1", (Object)this.getResourcePath(eResource)));
                }
            }
        }
    }

    public boolean isSaveRequired() {
        return this.isOpen() && this.manifestResource.isModified();
    }

    public boolean isSaveRequiredForValidVdb() {
        if (!this.isOpen()) {
            return false;
        }
        if (this.manifestResource.isModified()) {
            return true;
        }
        if (this.vdbArchive != null) {
            int minNum;
            int n = minNum = this.getVdbArchiveForm() == 1 ? 2 : 1;
            if (this.vdbArchive.size() <= minNum) {
                return true;
            }
        }
        return false;
    }

    public void setModified() {
        if (this.isOpen()) {
            this.manifestResource.setModified(true);
            this.fireStateChanged();
        }
    }

    public String[] getIndexNames() {
        this.assertIsOpen();
        return IndexConstants.INDEX_NAME.INDEX_NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public String getIndexContent(String indexName) {
        void var4_10;
        String contents;
        block19: {
            BlocksIndexInput input;
            File tmpFile;
            block18: {
                this.assertIsOpen();
                if (this.vdbArchive == null) {
                    return VdbEditPlugin.Util.getString("VdbEditingContextImpl.No_content_found_for_index", (Object)indexName);
                }
                ZipEntry entry = null;
                Enumeration<? extends ZipEntry> iter = this.vdbArchive.entries();
                while (iter.hasMoreElements() && !(entry = iter.nextElement()).getName().endsWith(indexName)) {
                    entry = null;
                }
                if (entry == null) {
                    return VdbEditPlugin.Util.getString("VdbEditingContextImpl.No_content_found_for_index", (Object)indexName);
                }
                tmpFile = null;
                input = null;
                try {
                    String prefix = Long.toString(System.currentTimeMillis());
                    tmpFile = this.getTempDirectoryFile(prefix + this.getVdbName() + indexName);
                    InputStream stream = this.vdbArchive.getInputStream(entry);
                    FileUtils.write((InputStream)stream, (File)tmpFile);
                    stream.close();
                    input = new BlocksIndexInput(tmpFile);
                    input.open();
                    StringBuffer buffer = new StringBuffer();
                    while (input.hasMoreWords()) {
                        buffer.append(input.getCurrentWordEntry().getWord());
                        buffer.append(StringUtil.LINE_SEPARATOR);
                        input.moveToNextWordEntry();
                    }
                    contents = buffer.toString();
                    Object var11_11 = null;
                    if (tmpFile == null) break block18;
                    tmpFile.delete();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (tmpFile != null) {
                        tmpFile.delete();
                        tmpFile = null;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                tmpFile = null;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            break block19;
            {
                catch (Throwable t) {
                    contents = StringUtil.getStackTrace((Throwable)t);
                    Object var11_12 = null;
                    if (tmpFile != null) {
                        tmpFile.delete();
                        tmpFile = null;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        if (contents.length() == 0) {
            contents = VdbEditPlugin.Util.getString("VdbEditingContextImpl.No_content_found_for_index", (Object)indexName);
        }
        return var4_10;
    }

    public VdbWsdlGenerationOptions getVdbWsdlGenerationOptions() {
        return this.wsdlOptions;
    }

    public ModelReference getModelReference(String pathInVdb) {
        return this.getModelReferenceByPath((IPath)new Path(pathInVdb));
    }

    public synchronized void close() throws IOException {
        this.close(false, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean reuseTempDir, boolean fireStateChangedEvent, boolean allowVeto) throws IOException {
        if (this.isOpen() && (!allowVeto || this.fireVetoableChange("closing", "opened", "closed"))) {
            if (DEBUG_ON) {
                VdbEditPlugin.Util.log((Object)("close(): Closing VdbEditingContextImpl - " + this.vdbFilePath));
            }
            try {
                ArrayList resources = new ArrayList(this.getVdbContainer().getResources());
                Iterator iter = resources.iterator();
                while (iter.hasNext()) {
                    Resource eResource = (Resource)iter.next();
                    this.removeFromInternalResourceSet(eResource.getURI());
                }
                Container cntr = this.getVdbContainer();
                if (cntr instanceof ContainerImpl) {
                    ((ContainerImpl)cntr).getObjectManager().clear();
                }
                if (this.vdbArchive != null) {
                    this.vdbArchive.close();
                }
                if (!reuseTempDir) {
                    this.getTempDirectory().remove();
                }
                if (this.materializedModelMap != null) {
                    this.materializedModelMap.clear();
                }
                if (this.modelRefsByPath != null) {
                    this.modelRefsByPath.clear();
                }
                if (this.pathsByResourceUri != null) {
                    this.pathsByResourceUri.clear();
                }
                Object var8_7 = null;
                this.vdbArchive = null;
                this.virtualDatabase = null;
                this.manifestResource = null;
                if (!reuseTempDir) {
                    this.tempDirectory = null;
                }
                this.materializationModel = null;
                this.materializationModelDdlFiles = null;
                if (fireStateChangedEvent) {
                    this.fireStateChanged();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.vdbArchive = null;
                this.virtualDatabase = null;
                this.manifestResource = null;
                if (!reuseTempDir) {
                    this.tempDirectory = null;
                }
                this.materializationModel = null;
                this.materializationModelDdlFiles = null;
                if (fireStateChangedEvent) {
                    this.fireStateChanged();
                }
                throw throwable;
            }
        }
    }

    public VirtualDatabase getVirtualDatabase() {
        this.assertIsOpen();
        if (this.virtualDatabase == null) {
            EList roots = this.manifestResource.getContents();
            if (roots.isEmpty()) {
                this.virtualDatabase = this.getManifestFactory().createVirtualDatabase();
                this.manifestResource.getContents().add((Object)this.virtualDatabase);
                ModelAnnotation annotation = CoreFactory.eINSTANCE.createModelAnnotation();
                annotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/VirtualDatabase");
                roots.add(annotation);
                this.setModified();
                this.updateVirtualDatabase(this.virtualDatabase);
            } else {
                ModelAnnotation modelAnnotation = null;
                Iterator iter = roots.iterator();
                while (iter.hasNext()) {
                    Object rootObject = iter.next();
                    if (rootObject instanceof VirtualDatabase) {
                        this.virtualDatabase = (VirtualDatabase)rootObject;
                    }
                    if (!(rootObject instanceof ModelAnnotation)) continue;
                    modelAnnotation = (ModelAnnotation)rootObject;
                }
                boolean updated = false;
                if (this.virtualDatabase == null) {
                    this.virtualDatabase = this.getManifestFactory().createVirtualDatabase();
                    this.manifestResource.getContents().add((Object)this.virtualDatabase);
                    updated = true;
                }
                if (modelAnnotation == null) {
                    modelAnnotation = CoreFactory.eINSTANCE.createModelAnnotation();
                    modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/VirtualDatabase");
                    this.manifestResource.getContents().add(0, (Object)modelAnnotation);
                    updated = true;
                } else {
                    modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/VirtualDatabase");
                }
                if (updated) {
                    this.setModified();
                    this.updateVirtualDatabase(this.virtualDatabase);
                }
            }
        }
        return this.virtualDatabase;
    }

    public Container getVdbContainer() {
        return this.resourceSet;
    }

    public NonModelReference refreshNonModel(IProgressMonitor theMonitor, File theNonModel, IPath theArchivePath) throws VdbEditException {
        NonModelReference result = null;
        IPath path = theArchivePath.makeAbsolute();
        String fileName = path.lastSegment();
        NonModelReference existing = this.getNonModelReferenceByFileName(fileName);
        try {
            IStatus status;
            if (existing != null && (status = this.removeNonModel(theArchivePath)).getSeverity() == 4) {
                throw new VdbEditException(VdbEditPlugin.Util.getString("VdbEditingContextImpl.refreshNonModelRemoveError", (Object)theNonModel.getAbsolutePath()));
            }
            result = this.addNonModel(theMonitor, theNonModel, theArchivePath);
        }
        catch (Exception theException) {
            VdbEditException e = null;
            e = theException instanceof VdbEditException ? (VdbEditException)theException : new VdbEditException((CoreException)e);
            throw e;
        }
        return result;
    }

    public NonModelReference addNonModel(IProgressMonitor monitor, File nonModel, IPath pathInArchive) throws VdbEditException {
        ArgCheck.isNotNull((Object)nonModel);
        ArgCheck.isNotNull((Object)pathInArchive);
        this.assertIsOpen();
        this.assertModelsLoaded();
        if (monitor != null) {
            String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Adding_model_to_vdb", (Object)nonModel.getName());
            monitor.setTaskName(taskName);
            monitor.worked(1);
        }
        IPath path = pathInArchive.segmentCount() > 1 ? pathInArchive.makeAbsolute() : pathInArchive;
        String pathString = path.toString();
        String fileName = path.lastSegment();
        NonModelReference existing = this.getNonModelReferenceByFileName(fileName);
        if (existing != null) {
            return existing;
        }
        String filePath = nonModel.getAbsolutePath();
        if (!nonModel.exists()) {
            Object[] params = new Object[]{filePath};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.unable_to_locate_nonModel_file", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
            throw new VdbEditException((IStatus)status);
        }
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(nonModel);
        }
        catch (IOException theException) {
            Object[] params = new Object[]{filePath};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_getting_an_inputstream_to_model", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)theException);
            throw new VdbEditException((IStatus)status);
        }
        try {
            this.addToTempDirectory(istream, pathString);
        }
        catch (IOException theException) {
            Object[] params = new Object[]{fileName};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorAddingResourceToTempDirectory", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)theException);
            throw new VdbEditException((IStatus)status);
        }
        NonModelReference nonModelRef = this.getManifestFactory().createNonModelReference();
        nonModelRef.setPath(pathString);
        nonModelRef.setName(path.lastSegment());
        nonModelRef.setChecksum(this.getCheckSum(nonModel));
        nonModelRef.setVirtualDatabase(this.getVirtualDatabase());
        this.fireStateChanged();
        return nonModelRef;
    }

    public NonModelReference addConfigurationDefinition(IProgressMonitor monitor, InputStream vdbDefInputStream, IPath pathInArchive) throws VdbEditException {
        IStatus status;
        NonModelReference existing;
        ArgCheck.isNotNull((Object)vdbDefInputStream);
        ArgCheck.isNotNull((Object)pathInArchive);
        this.assertIsOpen();
        this.assertModelsLoaded();
        IPath path = pathInArchive.segmentCount() > 1 ? pathInArchive.makeAbsolute() : pathInArchive;
        String pathString = path.toString();
        String fileName = path.lastSegment();
        if (monitor != null) {
            String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Adding_model_to_vdb", (Object)fileName);
            monitor.setTaskName(taskName);
            monitor.worked(1);
        }
        if ((existing = this.getNonModelReferenceByFileName(fileName)) != null && (status = this.removeNonModel(pathInArchive)).getSeverity() == 4) {
            throw new VdbEditException(VdbEditPlugin.Util.getString("VdbEditingContextImpl.nonModel_with_path_not_removed=Non-model file with path {0} couldn't be removedr", (Object)pathInArchive.makeAbsolute().toFile().getAbsolutePath()));
        }
        try {
            this.addToTempDirectory(vdbDefInputStream, pathString);
        }
        catch (IOException theException) {
            Object[] params = new Object[]{fileName};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorAddingResourceToTempDirectory", params);
            Status estatus = new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)theException);
            throw new VdbEditException((IStatus)estatus);
        }
        NonModelReference nonModelRef = this.getManifestFactory().createNonModelReference();
        nonModelRef.setPath(pathString);
        nonModelRef.setName(path.lastSegment());
        nonModelRef.setChecksum(this.getCheckSum(vdbDefInputStream));
        nonModelRef.setVirtualDatabase(this.getVirtualDatabase());
        return nonModelRef;
    }

    public ModelReference[] addModel(IProgressMonitor monitor, IPath pathInWorkspace, boolean addDependentModels) throws VdbEditException {
        ArrayList eResourcesToBeAdded = new ArrayList();
        return this.addModel(monitor, pathInWorkspace, addDependentModels, eResourcesToBeAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModelReference[] addModel(IProgressMonitor monitor, IPath pathInWorkspace, boolean addDependentModels, List eResourcesToBeAdded) throws VdbEditException {
        Resource internalResource;
        Object[] params;
        ObjectVector tmp;
        URI eResourceURI;
        Resource eResource;
        IPath absoluteModelPath;
        Object[] result;
        block48: {
            ModelReference existingUuid;
            void var10_20;
            Status status2;
            ModelReference existing;
            block46: {
                void var10_14;
                String errorMessage2;
                block47: {
                    Resource.Diagnostic diagnostic2;
                    int i2;
                    int size2;
                    EList errors2;
                    ArgCheck.isNotNull((Object)pathInWorkspace);
                    this.assertIsOpen();
                    this.assertModelsLoaded();
                    if (monitor != null) {
                        String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Adding_model_to_vdb", (Object)pathInWorkspace);
                        monitor.setTaskName(taskName);
                        monitor.worked(1);
                    }
                    result = EMPTY_MODEL_REFERENCE_ARRAY;
                    absoluteModelPath = pathInWorkspace.makeAbsolute();
                    existing = this.getModelReferenceByPath(absoluteModelPath);
                    if (existing != null) {
                        return result;
                    }
                    ModelReference existingWithSameName = this.getModelReferenceByFileName(absoluteModelPath.lastSegment());
                    if (existingWithSameName != null && !ModelUtil.isXsdFile((IPath)new Path(absoluteModelPath.toString().toLowerCase()))) {
                        Object[] params2 = new Object[]{absoluteModelPath, existingWithSameName.getModelLocation()};
                        String string = VdbEditPlugin.Util.getString("VdbEditingContextImpl.model_has_same_name_as_existing", params2);
                        this.createProblem((ProblemMarkerContainer)this.getVirtualDatabase(), 4, string, null);
                        throw new VdbEditException(string);
                    }
                    eResource = null;
                    Object var10_12 = null;
                    try {
                        Object var13_21;
                        block45: {
                            try {
                                eResource = this.vdbInputResourceFinder.getEmfResource(pathInWorkspace);
                                if (eResourcesToBeAdded.contains(eResource)) break block45;
                                eResourcesToBeAdded.add(eResource);
                            }
                            catch (Exception theException) {
                                void var10_17;
                                Exception exception = theException;
                                var13_21 = null;
                                errorMessage2 = null;
                                if (exception == null && eResource != null && (errors2 = eResource.getErrors()) != null && !errors2.isEmpty()) {
                                    size2 = errors2.size();
                                    for (i2 = 0; i2 < size2; ++i2) {
                                        if (errors2.get(i2) instanceof Throwable) {
                                            Throwable throwable = (Throwable)errors2.get(i2);
                                            break;
                                        }
                                        if (!(errors2.get(i2) instanceof Resource.Diagnostic)) continue;
                                        diagnostic2 = (Resource.Diagnostic)errors2.get(i2);
                                        errorMessage2 = diagnostic2.getMessage();
                                        break;
                                    }
                                }
                                if (var10_17 != null) {
                                    if (errorMessage2 == null) {
                                        errorMessage2 = var10_17.toString();
                                    }
                                    status2 = new Status(4, "com.metamatrix.vdb.edit", 0, errorMessage2, (Throwable)var10_17);
                                    throw new VdbEditException((IStatus)status2);
                                }
                                if (errorMessage2 != null) {
                                    status2 = new Status(4, "com.metamatrix.vdb.edit", 0, errorMessage2, null);
                                    throw new VdbEditException((IStatus)status2);
                                }
                                break block46;
                            }
                        }
                        var13_21 = null;
                        errorMessage2 = null;
                        if (var10_12 != null || eResource == null) break block47;
                    }
                    catch (Throwable throwable) {
                        Status status2;
                        void var10_19;
                        EList errors2;
                        Object var13_22 = null;
                        String errorMessage2 = null;
                        if (var10_12 == null && eResource != null && (errors2 = eResource.getErrors()) != null && !errors2.isEmpty()) {
                            int size2 = errors2.size();
                            for (int i2 = 0; i2 < size2; ++i2) {
                                if (errors2.get(i2) instanceof Throwable) {
                                    Throwable throwable2 = (Throwable)errors2.get(i2);
                                    break;
                                }
                                if (!(errors2.get(i2) instanceof Resource.Diagnostic)) continue;
                                Resource.Diagnostic diagnostic2 = (Resource.Diagnostic)errors2.get(i2);
                                errorMessage2 = diagnostic2.getMessage();
                                break;
                            }
                        }
                        if (var10_19 == null) {
                            if (errorMessage2 == null) throw throwable;
                            status2 = new Status(4, "com.metamatrix.vdb.edit", 0, errorMessage2, null);
                            throw new VdbEditException((IStatus)status2);
                        }
                        if (errorMessage2 == null) {
                            errorMessage2 = var10_19.toString();
                        }
                        status2 = new Status(4, "com.metamatrix.vdb.edit", 0, errorMessage2, (Throwable)var10_19);
                        throw new VdbEditException((IStatus)status2);
                    }
                    errors2 = eResource.getErrors();
                    if (errors2 != null && !errors2.isEmpty()) {
                        size2 = errors2.size();
                        for (i2 = 0; i2 < size2; ++i2) {
                            if (errors2.get(i2) instanceof Throwable) {
                                Throwable throwable = (Throwable)errors2.get(i2);
                                break;
                            }
                            if (!(errors2.get(i2) instanceof Resource.Diagnostic)) continue;
                            diagnostic2 = (Resource.Diagnostic)errors2.get(i2);
                            errorMessage2 = diagnostic2.getMessage();
                            break;
                        }
                    }
                }
                if (var10_14 != null) {
                    if (errorMessage2 == null) {
                        errorMessage2 = var10_14.toString();
                    }
                    status2 = new Status(4, "com.metamatrix.vdb.edit", 0, errorMessage2, (Throwable)var10_14);
                    throw new VdbEditException((IStatus)status2);
                }
                if (errorMessage2 != null) {
                    status2 = new Status(4, "com.metamatrix.vdb.edit", 0, errorMessage2, null);
                    throw new VdbEditException((IStatus)status2);
                }
            }
            if (eResource == null) {
                Object[] params3 = new Object[]{absoluteModelPath};
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.5", params3);
                this.createProblem((ProblemMarkerContainer)this.getVirtualDatabase(), 4, msg, (Throwable)var10_20);
                throw new VdbEditException(msg);
            }
            Container cntr = ModelerCore.getContainer((Resource)eResource);
            if (cntr != null && cntr.getResourceFinder().isBuiltInResource(eResource)) {
                Object[] params4 = new Object[]{absoluteModelPath};
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.6", params4);
                this.createProblem((ProblemMarkerContainer)this.getVirtualDatabase(), 4, msg, null);
                throw new VdbEditException(msg);
            }
            eResourceURI = eResource.getURI();
            if (!eResourceURI.isFile()) {
                Object[] params5 = new Object[]{eResourceURI};
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.2", params5);
                status2 = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
                throw new VdbEditException((IStatus)status2);
            }
            tmp = new ObjectVector();
            if (addDependentModels) {
                try {
                    Resource[] importedResources = cntr.getResourceFinder().findReferencesFrom(eResource, false, false);
                    for (int i = 0; i != importedResources.length; ++i) {
                        Object[] modelRefs;
                        Resource importResource = importedResources[i];
                        if (importResource == null) {
                            Object[] params6 = new Object[]{absoluteModelPath};
                            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.9", params6);
                            this.createProblem((ProblemMarkerContainer)this.getVirtualDatabase(), 2, msg, (Throwable)var10_20);
                            continue;
                        }
                        if (eResourcesToBeAdded.contains(importResource)) continue;
                        eResourcesToBeAdded.add(importResource);
                        IPath importPath = this.vdbInputResourceFinder.getEmfResourcePath(importResource);
                        if (this.getModelReferenceByPath(importPath) != null || (modelRefs = this.addModel(monitor, importPath, addDependentModels, eResourcesToBeAdded)) == null || modelRefs.length <= 0) continue;
                        tmp.addAll(modelRefs);
                    }
                }
                catch (Exception e) {
                    Object[] params7 = new Object[]{absoluteModelPath};
                    String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_retrieve_model_dependency_information_from_0_2", params7);
                    this.createProblem((ProblemMarkerContainer)existing, 4, msg, e);
                }
            }
            if (eResource instanceof EmfResource && (existingUuid = this.getModelReferenceByUuid(((EmfResource)eResource).getUuid())) != null) {
                Object[] objectArray;
                boolean code = false;
                String uri = existingUuid.getUri();
                String path = existingUuid.getModelLocation();
                if (uri != null) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = absoluteModelPath;
                    objectArray = objectArray2;
                    objectArray2[1] = uri;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = absoluteModelPath;
                    objectArray = objectArray3;
                    objectArray3[1] = path;
                }
                params = objectArray;
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Model_already_exists_with_uuid", params);
                Status status3 = new Status(1, "com.metamatrix.vdb.edit", 0, msg, null);
                throw new VdbEditException((IStatus)status3);
            }
            InputStream istream = this.vdbInputResourceFinder.getEmfResourceStream(eResource);
            URI internalUri = this.getInternalResourceUri(absoluteModelPath);
            internalResource = null;
            try {
                try {
                    internalResource = this.addToInternalResourceSet(istream, internalUri, absoluteModelPath);
                }
                catch (Exception theException) {
                    this.removeFromInternalResourceSet(this.getInternalResourceUri(absoluteModelPath));
                    params = new Object[]{absoluteModelPath};
                    String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorAddingToInternalResourceSet", params);
                    Status status4 = new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)theException);
                    throw new VdbEditException((IStatus)status4);
                }
                Object var22_60 = null;
                if (istream == null) break block48;
            }
            catch (Throwable throwable) {
                Object var22_61 = null;
                if (istream == null) throw throwable;
                try {
                    istream.close();
                    throw throwable;
                }
                catch (IOException theCloseStreamException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException theCloseStreamException) {}
            istream.close();
        }
        try {
            String modelPath = absoluteModelPath.toString();
            File outputTempDirFile = this.getTempDirectoryFile(modelPath);
            File inputResourceFile = new File(eResourceURI.toFileString());
            if (!inputResourceFile.canWrite() || inputResourceFile.exists() && !inputResourceFile.equals(outputTempDirFile)) {
                this.addToTempDirectory(internalResource, modelPath);
            }
        }
        catch (IOException theException) {
            this.removeFromInternalResourceSet(this.getInternalResourceUri(absoluteModelPath));
            params = new Object[]{absoluteModelPath};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.errorAddingResourceToTempDirectory", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)theException);
            throw new VdbEditException((IStatus)status);
        }
        ModelReference modelReference = this.createModelReference(eResource, absoluteModelPath);
        this.setModelReferenceForPath(absoluteModelPath, modelReference);
        this.addModelToValidate(internalResource);
        tmp.add((Object)modelReference);
        result = new ModelReference[tmp.size()];
        tmp.copyInto(result);
        this.setModified();
        this.fireStateChanged();
        return result;
    }

    protected ModelReference createModelReference(Resource eResource, IPath pathInWorkspace) {
        ArgCheck.isNotNull((Object)eResource);
        ArgCheck.isNotNull((Object)pathInWorkspace);
        ModelReference modelReference = this.getManifestFactory().createModelReference();
        modelReference.setModelLocation(pathInWorkspace.toString());
        modelReference.setUri(null);
        modelReference.setVirtualDatabase(this.getVirtualDatabase());
        modelReference.setVisible(true);
        Date currentDate = DateUtil.getCurrentDate();
        modelReference.setTimeLastSynchronizedAsDate(currentDate);
        File resourceFile = new File(eResource.getURI().toFileString());
        String modelName = eResource.getURI().lastSegment();
        ModelType modelType = null;
        String modelUuid = null;
        boolean isVisible = true;
        String primaryMetamodelUri = null;
        Properties modelSourceProps = null;
        try {
            String msg;
            Object[] params;
            boolean isXsd = false;
            if (eResource instanceof EmfResource) {
                EmfResource resrc = (EmfResource)eResource;
                if (resrc.isLoaded()) {
                    modelType = resrc.getModelType();
                    modelUuid = resrc.getUuid().toString();
                    primaryMetamodelUri = resrc.getPrimaryMetamodelUri().toString();
                } else {
                    XMIHeader header = XMIHeaderReader.readHeader((File)resourceFile);
                    modelType = ModelType.get((String)header.getModelType());
                    modelUuid = header.getUUID();
                    isVisible = header.isVisible();
                    primaryMetamodelUri = header.getPrimaryMetamodelURI();
                }
                modelSourceProps = this.getModelSourceProperties(eResource);
                if (modelSourceProps != null) {
                    ModelSource modelSource = this.getManifestFactory().createModelSource();
                    modelReference.setModelSource(modelSource);
                    Iterator<Map.Entry<Object, Object>> iter = modelSourceProps.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<Object, Object> entry = iter.next();
                        String name = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (name == null || value == null) continue;
                        ModelSourceProperty srcProp = this.getManifestFactory().createModelSourceProperty();
                        srcProp.setName(name);
                        srcProp.setValue(value);
                        srcProp.setSource(modelSource);
                    }
                }
            } else if (eResource instanceof XSDResourceImpl) {
                isXsd = true;
                modelType = ModelType.TYPE_LITERAL;
                primaryMetamodelUri = "http://www.eclipse.org/xsd/2002/XSD";
            } else {
                modelReference.setModelType(ModelType.UNKNOWN_LITERAL);
                modelReference.setName(pathInWorkspace.lastSegment());
            }
            if (modelName != null) {
                modelReference.setName(modelName);
            } else {
                params = new Object[]{pathInWorkspace};
                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_determine_model_name", params);
                this.createProblem((ProblemMarkerContainer)modelReference, 2, msg, null);
            }
            if (modelType != null) {
                modelReference.setModelType(modelType);
            } else {
                params = new Object[]{pathInWorkspace};
                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_determine_model_type", params);
                this.createProblem((ProblemMarkerContainer)modelReference, 2, msg, null);
            }
            if (primaryMetamodelUri != null) {
                modelReference.setPrimaryMetamodelUri(primaryMetamodelUri);
            } else {
                params = new Object[]{pathInWorkspace};
                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_determine_primary_metamodel", params);
                this.createProblem((ProblemMarkerContainer)modelReference, 2, msg, null);
            }
            if (modelUuid != null) {
                modelReference.setUuid(modelUuid);
            } else if (!isXsd) {
                params = new Object[]{pathInWorkspace};
                msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_determine_model_UUID", params);
                this.createProblem((ProblemMarkerContainer)modelReference, 2, msg, null);
            }
            modelReference.setVisible(isVisible);
            File modelFile = new File(resourceFile.getAbsolutePath());
            if (modelFile.exists()) {
                long checkSum = this.getCheckSum(modelFile);
                modelReference.setChecksum(checkSum);
            }
        }
        catch (Exception e) {
            this.removeFromInternalResourceSet(this.getInternalResourceUri(pathInWorkspace));
            try {
                if (modelReference != null) {
                    modelReference.setVirtualDatabase(null);
                }
            }
            catch (Exception e2) {
                VdbEditPlugin.Util.log((Throwable)e2);
            }
            Object[] params = new Object[]{pathInWorkspace};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.4", params);
            this.createProblem((ProblemMarkerContainer)modelReference, 2, msg, e);
            this.manifestResource.setModified(false);
        }
        return modelReference;
    }

    public ModelReference refreshModel(IProgressMonitor monitor, IPath pathInWorkspace) throws VdbEditException {
        ModelReference existing;
        ArgCheck.isNotNull((Object)pathInWorkspace);
        this.assertIsOpen();
        this.assertModelsLoaded();
        if (monitor != null) {
            String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Refreshing_model_in_vdb", (Object)pathInWorkspace);
            monitor.setTaskName(taskName);
            monitor.worked(1);
        }
        if ((existing = this.getModelReferenceByPath(pathInWorkspace)) == null) {
            ModelReference[] result = this.addModel(monitor, pathInWorkspace, false);
            return result.length > 0 ? result[0] : null;
        }
        Resource eResource = null;
        try {
            eResource = this.vdbInputResourceFinder.getEmfResource(pathInWorkspace);
        }
        catch (Exception theException) {
            throw new VdbEditException((Throwable)theException);
        }
        if (eResource == null) {
            Object[] params = new Object[]{pathInWorkspace};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.5", params);
            this.createProblem((ProblemMarkerContainer)this.getVirtualDatabase(), 4, msg, null);
            throw new VdbEditException(msg);
        }
        URI eResourceURI = eResource.getURI();
        if (!eResourceURI.isFile()) {
            Object[] params = new Object[]{eResourceURI};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.2", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
            throw new VdbEditException((IStatus)status);
        }
        URI existingUri = this.getInternalResourceUri(pathInWorkspace);
        boolean deleteLocal = !eResourceURI.equals((Object)existingUri);
        this.removeModel(pathInWorkspace, deleteLocal);
        ModelReference[] result = this.addModel(monitor, pathInWorkspace, false);
        return result.length > 0 ? result[0] : null;
    }

    public void createProblem(ProblemMarkerContainer marked, int severity, String msg, Throwable t) {
        ProblemMarker marker = this.getManifestFactory().createProblemMarker();
        switch (severity) {
            case 4: {
                marker.setSeverity(Severity.ERROR_LITERAL);
                break;
            }
            case 2: {
                marker.setSeverity(Severity.WARNING_LITERAL);
                break;
            }
            case 1: {
                marker.setSeverity(Severity.INFO_LITERAL);
                break;
            }
            case 0: {
                marker.setSeverity(Severity.OK_LITERAL);
            }
        }
        if (marked instanceof VirtualDatabase && ((VirtualDatabase)marked).getName() != null) {
            marker.setTarget(((VirtualDatabase)marked).getName());
        } else if (marked instanceof ModelReference && ((ModelReference)marked).getModelLocation() != null) {
            marker.setTarget(((ModelReference)marked).getModelLocation());
        }
        marker.setMessage(msg);
        if (t != null) {
            String trace = StringUtil.getStackTrace((Throwable)t);
            marker.setStackTrace(trace);
        }
        marker.setMarked(marked);
    }

    public IStatus removeModel(IPath pathInWorkspace) {
        return this.removeModel(pathInWorkspace, true);
    }

    public IStatus removeModel(IPath pathInWorkspace, boolean deleteLocal) {
        this.assertIsOpen();
        this.assertModelsLoaded();
        ModelReference existing = this.getModelReferenceByPath(pathInWorkspace);
        if (existing == null) {
            boolean code = false;
            Object[] params = new Object[]{pathInWorkspace};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Model_with_path_doesnt_exist", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
            return status;
        }
        VirtualDatabase vdb = this.getVirtualDatabase();
        boolean removed = vdb.getModels().remove((Object)existing);
        if (!removed) {
            boolean code = false;
            Object[] params = new Object[]{pathInWorkspace};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Model_with_path_couldnt_be_removed", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
            return status;
        }
        this.removeModelReferenceForPath(pathInWorkspace);
        URI uri = this.getInternalResourceUri(pathInWorkspace);
        Resource eResource = this.getVdbContainer().getResource(uri, false);
        if (eResource != null) {
            this.removeModelFromValidate(eResource);
        }
        this.removeFromInternalResourceSet(existing);
        if (deleteLocal) {
            File tempDirFile = this.getTempDirectoryFile(existing);
            tempDirFile.delete();
        }
        this.setModified();
        this.fireStateChanged();
        boolean code = false;
        Object[] params = new Object[]{pathInWorkspace};
        String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Removed_model", params);
        return new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
    }

    public IStatus removeNonModel(IPath pathInArchive) {
        ArgCheck.isNotNull((Object)pathInArchive);
        this.assertIsOpen();
        this.assertModelsLoaded();
        IPath path = pathInArchive.makeAbsolute();
        String fileName = path.lastSegment();
        NonModelReference existing = this.getNonModelReferenceByFileName(fileName);
        if (existing == null) {
            boolean code = false;
            Object[] params = new Object[]{pathInArchive};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.no_nonModel_file_with_path_found", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
            return status;
        }
        VirtualDatabase vdb = this.getVirtualDatabase();
        boolean removed = vdb.getNonModels().remove((Object)existing);
        if (!removed) {
            boolean code = false;
            Object[] params = new Object[]{pathInArchive};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.nonModel_with_path_not_removed", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
            return status;
        }
        File tempDirFile = this.getTempDirectoryFile(existing);
        tempDirFile.delete();
        boolean code = false;
        Object[] params = new Object[]{pathInArchive};
        String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.removed_nonModel_with_path", params);
        Status status = new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
        this.fireStateChanged();
        return status;
    }

    public boolean isVisible(ModelReference model) {
        ArgCheck.isNotNull((Object)model);
        return model.isVisible();
    }

    public boolean isVisible(String pathInVdb) {
        ArgCheck.isNotNull((Object)pathInVdb);
        this.assertIsOpen();
        Path path = new Path(pathInVdb);
        ModelReference model = this.getModelReferenceByPath((IPath)path);
        if (model != null) {
            return this.isVisible(model);
        }
        String newPath = pathInVdb.substring(1);
        model = this.getModelReferenceByPath((IPath)new Path(newPath));
        if (model != null) {
            return this.isVisible(model);
        }
        if (this.vdbArchive != null) {
            ZipEntry vdbEntry = this.vdbArchive.getEntry(pathInVdb);
            if (vdbEntry == null && (vdbEntry = this.vdbArchive.getEntry(newPath)) == null) {
                return false;
            }
            String fileName = path.lastSegment();
            if (fileName != null) {
                if (IndexUtil.isIndexFile((String)fileName)) {
                    return false;
                }
                if (fileName.equalsIgnoreCase("MetaMatrix-VdbManifestModel.xmi")) {
                    return false;
                }
                if (StringUtil.startsWithIgnoreCase((String)fileName, (String)"MaterializationModel") && StringUtil.endsWithIgnoreCase((String)fileName, (String)MATERIALIZATION_MODEL_FILE_SUFFIX)) {
                    return false;
                }
                if (this.isInternalDDLFile(fileName)) {
                    return false;
                }
                if (fileName.equalsIgnoreCase("MetaMatrixDataServices.wsdl")) {
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public IPath getPathToVdb() {
        return this.vdbFilePath;
    }

    public boolean isReadOnly() {
        return !this.vdbFilePath.toFile().canWrite();
    }

    public boolean isInternalDDL(String pathInVdb) {
        ArgCheck.isNotNull((Object)pathInVdb);
        this.assertIsOpen();
        if (this.vdbArchive != null && this.vdbArchive.getEntry(pathInVdb) != null) {
            Path path = new Path(pathInVdb);
            String fileName = path.lastSegment();
            return this.isInternalDDLFile(fileName);
        }
        return false;
    }

    private boolean isInternalDDLFile(String fileName) {
        ArgCheck.isNotNull((Object)fileName);
        return ScriptType.isDDLScript((String)fileName) && (ScriptType.isMaterializationScript((String)fileName) || ScriptType.isCreateScript((String)fileName) || ScriptType.isSwapScript((String)fileName) || ScriptType.isTruncateScript((String)fileName) || ScriptType.isLoadScript((String)fileName));
    }

    public boolean hasWsdl() {
        this.assertIsOpen();
        return this.vdbArchive != null && this.vdbArchive.getEntry("MetaMatrixDataServices.wsdl") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File getVdbDefinitionFile() {
        this.assertIsOpen();
        String[] paths = this.getResourcePaths();
        if (paths != null) {
            TempDirectory directory = this.getTempDirectory();
            File tmpDir = new File(directory.getPath());
            for (int i = 0; i < paths.length; ++i) {
                IOException e22;
                Object var10_10;
                File file;
                InputStream istream;
                block12: {
                    String defPath = paths[i];
                    if (!defPath.toUpperCase().equalsIgnoreCase("ConfigurationInfo.def")) continue;
                    File defFile = new File(tmpDir.getAbsolutePath() + File.separator + defPath);
                    if (defFile.exists()) {
                        return defFile;
                    }
                    istream = null;
                    istream = this.getArchiveResourceStream(defPath);
                    file = this.addToTempDirectory(istream, defPath);
                    var10_10 = null;
                    if (istream == null) break block12;
                    try {
                        istream.close();
                    }
                    catch (IOException e22) {
                        VdbEditPlugin.Util.log(4, (Throwable)e22, e22.getMessage());
                    }
                }
                return file;
                catch (Exception e3) {
                    try {
                        VdbEditPlugin.Util.log(4, (Throwable)e3, e3.getMessage());
                        var10_10 = null;
                        if (istream == null) continue;
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        if (istream != null) {
                            try {
                                istream.close();
                            }
                            catch (IOException e22) {
                                VdbEditPlugin.Util.log(4, (Throwable)e22, e22.getMessage());
                            }
                        }
                        throw throwable;
                    }
                    try {
                        istream.close();
                    }
                    catch (IOException e22) {
                        VdbEditPlugin.Util.log(4, (Throwable)e22, e22.getMessage());
                    }
                    continue;
                }
            }
        }
        return null;
    }

    public File getVdbContentsFolder() {
        this.assertIsOpen();
        TempDirectory tempDir = this.getTempDirectory();
        return new File(tempDir.getPath());
    }

    public boolean isStale() {
        this.assertIsOpen();
        Iterator iter = this.getVirtualDatabase().getModels().iterator();
        while (iter.hasNext()) {
            ModelReference model = (ModelReference)iter.next();
            if (!this.isStale(model)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStale(ModelReference modelRef) {
        Resource eResource;
        InputStream istream;
        block19: {
            IPath pathInWorkspace;
            block18: {
                block17: {
                    ArgCheck.isNotNull((Object)modelRef);
                    this.assertIsOpen();
                    if (modelRef.getAccessibility() == ModelAccessibility.PRIVATE_LITERAL) {
                        return false;
                    }
                    istream = null;
                    eResource = this.vdbInputResourceFinder.getEmfResource(modelRef);
                    if (eResource != null) break block17;
                    boolean bl = false;
                    Object var13_7 = null;
                    if (istream == null) return bl;
                    try {
                        istream.close();
                        return bl;
                    }
                    catch (IOException err1) {
                        // empty catch block
                    }
                    return bl;
                }
                pathInWorkspace = this.vdbInputResourceFinder.getEmfResourcePath(eResource);
                if (pathInWorkspace != null) break block18;
                boolean bl = false;
                Object var13_8 = null;
                if (istream == null) return bl;
                try {
                    istream.close();
                    return bl;
                }
                catch (IOException err1) {
                    // empty catch block
                }
                return bl;
            }
            String modelReferencePath = modelRef.getModelLocation();
            String modelResourcePath = pathInWorkspace.makeAbsolute().toString();
            if (modelReferencePath.equals(modelResourcePath)) break block19;
            boolean bl = true;
            Object var13_9 = null;
            if (istream == null) return bl;
            try {
                istream.close();
                return bl;
            }
            catch (IOException err1) {
                // empty catch block
            }
            return bl;
        }
        long wsModCrc = 0L;
        istream = this.vdbInputResourceFinder.getEmfResourceStream(eResource);
        if (istream != null) {
            wsModCrc = ChecksumUtil.computeChecksum((InputStream)istream).getValue();
        } else {
            Object[] params = new Object[]{modelRef.getModelLocation()};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_getting_an_inputstream_to_model", params);
            VdbEditPlugin.Util.log(4, msg);
        }
        long vdbModCrc = modelRef.getChecksum();
        boolean bl = vdbModCrc != wsModCrc;
        Object var13_10 = null;
        if (istream == null) return bl;
        try {
            istream.close();
            return bl;
        }
        catch (IOException err1) {
            // empty catch block
        }
        return bl;
        catch (Exception err) {
            try {
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.unexpectedException", (Object)modelRef.getName());
                VdbEditPlugin.Util.log(4, (Throwable)err, msg);
                Object var13_11 = null;
                if (istream == null) return false;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                if (istream == null) throw throwable;
                try {
                    istream.close();
                    throw throwable;
                }
                catch (IOException err1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                istream.close();
                return false;
            }
            catch (IOException err1) {}
            return false;
        }
    }

    public void setVisible(ModelReference model, boolean isVisible) {
        ArgCheck.isNotNull((Object)model);
        model.setVisible(isVisible);
    }

    public void setPerformServerValidation(boolean serverValidation) {
        this.performServerValidation = serverValidation;
    }

    public Resource getInternalResource(ModelReference modelRef) {
        ArgCheck.isNotNull((Object)modelRef);
        return this.findInternalResource(modelRef.getModelLocation());
    }

    public ModelReference getModelReference(Resource internalResource) {
        ArgCheck.isNotNull((Object)internalResource);
        String modelPath = (String)this.pathsByResourceUri.get(internalResource.getURI());
        if (modelPath != null) {
            return this.getModelReference(modelPath);
        }
        return null;
    }

    public InputStream getResource(String pathInVdb) {
        ArgCheck.isNotNull((Object)pathInVdb);
        if (this.vdbArchive != null) {
            try {
                Enumeration<? extends ZipEntry> e = this.vdbArchive.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (entry == null || !entry.getName().equals(pathInVdb)) continue;
                    return this.vdbArchive.getInputStream(entry);
                }
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, VdbEditPlugin.Util.getString("VdbEditingContextImpl.0", (Object)pathInVdb, (Object)this.vdbArchive.getName()));
            }
        }
        return null;
    }

    public String[] getResourcePaths() {
        if (this.vdbArchive != null) {
            HashSet<String> resourcePaths = new HashSet<String>();
            Enumeration<? extends ZipEntry> e = this.vdbArchive.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry == null) continue;
                String path = entry.getName();
                resourcePaths.add(path);
            }
            return resourcePaths.toArray(new String[0]);
        }
        return new String[0];
    }

    protected String getResourcePath(Resource resource) {
        String modelPath = (String)this.pathsByResourceUri.get(resource.getURI());
        if (modelPath == null) {
            String uriString = resource.getURI().toString();
            int endIndex = uriString.lastIndexOf("?vdbToken=true");
            int beginIndex = "http://vdb.metamatrix.com".length();
            if (endIndex > 0 && beginIndex < endIndex) {
                modelPath = uriString.substring("http://vdb.metamatrix.com".length(), endIndex);
            }
        }
        return modelPath;
    }

    protected ModelReference getModelReferenceByUuid(ObjectID uuid) {
        if (uuid != null) {
            String uuidString = uuid.toString();
            Iterator iter = this.getVirtualDatabase().getModels().iterator();
            while (iter.hasNext()) {
                ModelReference modelRef = (ModelReference)iter.next();
                if (modelRef == null || !uuidString.equals(modelRef.getUuid())) continue;
                return modelRef;
            }
        }
        return null;
    }

    protected Map getModelReferencesByPath() {
        if (this.modelRefsByPath == null) {
            this.modelRefsByPath = new HashMap();
        } else {
            this.modelRefsByPath.clear();
        }
        Iterator iter = this.getVirtualDatabase().getModels().iterator();
        while (iter.hasNext()) {
            ModelReference modelRef = (ModelReference)iter.next();
            Path path = new Path(modelRef.getModelLocation());
            String key = path.makeAbsolute().toString().toUpperCase();
            this.modelRefsByPath.put(key, modelRef);
        }
        return this.modelRefsByPath;
    }

    public ModelReference getModelReferenceByPath(IPath path) {
        return this.getModelReferenceByPath(path, this.getModelReferencesByPath());
    }

    protected ModelReference getModelReferenceByPath(IPath path, Map modelRefPaths) {
        String key = path.makeAbsolute().toString().toUpperCase();
        return (ModelReference)modelRefPaths.get(key);
    }

    protected ModelReference getModelReferenceByFileName(String modelFileName) {
        Iterator iter = this.getVirtualDatabase().getModels().iterator();
        while (iter.hasNext()) {
            ModelReference modelRef = (ModelReference)iter.next();
            if (modelFileName == null || modelRef == null || !modelFileName.equalsIgnoreCase(modelRef.getName())) continue;
            return modelRef;
        }
        return null;
    }

    protected NonModelReference getNonModelReferenceByFileName(String nonModelFileName) {
        Iterator iter = this.getVirtualDatabase().getNonModels().iterator();
        while (iter.hasNext()) {
            NonModelReference nonModelRef = (NonModelReference)iter.next();
            if (nonModelFileName == null || nonModelRef == null || !nonModelFileName.equalsIgnoreCase(nonModelRef.getName())) continue;
            return nonModelRef;
        }
        return null;
    }

    protected ModelReference getModelReferenceByPartialPath(IPath path) {
        ModelReference modelRef = this.getModelReferenceByPath(path, this.getModelReferencesByPath());
        if (modelRef != null) {
            return modelRef;
        }
        String pathToMatch = path.toString().toUpperCase();
        if (pathToMatch != null && pathToMatch.length() != 0) {
            Iterator iter = this.getVirtualDatabase().getModels().iterator();
            while (iter.hasNext()) {
                modelRef = (ModelReference)iter.next();
                String modelRefPath = modelRef.getModelLocation().toUpperCase();
                if (pathToMatch.indexOf(modelRefPath) == -1) continue;
                return modelRef;
            }
        }
        return null;
    }

    protected void setModelReferenceForPath(IPath path, ModelReference modelRef) {
        String key = path.makeAbsolute().toString().toUpperCase();
        this.getModelReferencesByPath().put(key, modelRef);
    }

    protected Object removeModelReferenceForPath(IPath path) {
        String key = path.makeAbsolute().toString().toUpperCase();
        return this.getModelReferencesByPath().remove(key);
    }

    protected IStatus merge(IStatus status1, IStatus status2, String desc) {
        if (status2 == null) {
            return status1;
        }
        if (status2 instanceof Status && status2.isOK()) {
            return status1;
        }
        LinkedList<IStatus> statuses = new LinkedList<IStatus>();
        for (int i = 0; i != 2; ++i) {
            IStatus xstatus;
            IStatus iStatus = xstatus = i == 0 ? status2 : status1;
            if (xstatus instanceof MultiStatus) {
                IStatus[] xStatuses = ((MultiStatus)xstatus).getChildren();
                for (int j = 0; j < xStatuses.length; ++j) {
                    IStatus status = xStatuses[j];
                    statuses.add(status);
                }
                continue;
            }
            statuses.add(status2);
        }
        IStatus results = this.createSingleIStatus(statuses, desc);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus produce(IStatus modelStatus, List indexFiles, List indexFilenames, Collection eResources, Container container, IProgressMonitor monitor) {
        LinkedList<Object> problems;
        block11: {
            this.assertIsOpen();
            this.assertModelsLoaded();
            problems = new LinkedList<Object>();
            ArrayList resourcesToIndex = new ArrayList(eResources);
            if (modelStatus != null && modelStatus instanceof MultiStatus) {
                IStatus[] modelStatuses = ((MultiStatus)modelStatus).getChildren();
                for (int i = 0; i < modelStatuses.length; ++i) {
                    IStatus status = modelStatuses[i];
                    problems.add(status);
                }
            }
            String[] indexNames = this.getIndexNames();
            File[] indexFilesArray = new File[indexNames.length];
            boolean produceIndexes = true;
            try {
                for (int i = 0; i < indexNames.length; ++i) {
                    String indexName = indexNames[i];
                    File indexFile = this.getTempDirectoryFile(indexName);
                    indexFiles.add(indexFile);
                    indexFilesArray[i] = indexFile;
                    indexFilenames.add(indexName);
                }
            }
            catch (Throwable e) {
                Object[] params = new Object[]{this.vdbFilePath};
                boolean code = false;
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_while_generating_index_files", params);
                Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, e);
                problems.add(status);
                produceIndexes = false;
            }
            if (produceIndexes) {
                try {
                    try {
                        String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Generating_index", (Object)this.vdbFilePath);
                        monitor.setTaskName(taskName);
                        this.addGlobalResourcesForIndexing(resourcesToIndex);
                        IndexingContext context = this.getContextForIndexer(eResources, container);
                        VdbIndexer runtimeIndexer = context != null ? new VdbIndexer(context) : new VdbIndexer();
                        for (int i = 0; i < indexFilesArray.length; ++i) {
                            File indexFile = indexFilesArray[i];
                            monitor.setTaskName(VdbEditPlugin.Util.getString("VdbEditingContextImpl.Indexing_Resources_1"));
                            monitor.subTask(null);
                            this.produceIndex((IIndexer)runtimeIndexer, resourcesToIndex, indexFile);
                        }
                        context.clearState();
                    }
                    catch (Throwable e) {
                        boolean code = false;
                        String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_while_generating_index", (Object)this.vdbFilePath);
                        Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, e);
                        problems.add(status);
                        Object var18_30 = null;
                        int numModels = this.getVirtualDatabase().getModels().size();
                        monitor.worked(numModels * 400);
                        break block11;
                    }
                    Object var18_29 = null;
                }
                catch (Throwable throwable) {
                    Object var18_31 = null;
                    int numModels = this.getVirtualDatabase().getModels().size();
                    monitor.worked(numModels * 400);
                    throw throwable;
                }
                int numModels = this.getVirtualDatabase().getModels().size();
                monitor.worked(numModels * 400);
            }
        }
        this.getVirtualDatabase().setProducerName("MetaMatrix");
        this.getVirtualDatabase().setProducerVersion("5.0");
        String desc = VdbEditPlugin.Util.getString("VdbEditingContextImpl.production_of_indexes");
        return this.createSingleIStatus(problems, desc);
    }

    private IStatus validateVdb(Collection eResources, boolean partialValidation) {
        VdbEditingContextImplValidationHelper vdbEditingContextImplValidationHelper = new VdbEditingContextImplValidationHelper(this, eResources, partialValidation);
        IStatus status = vdbEditingContextImplValidationHelper.getVdbStatus();
        vdbEditingContextImplValidationHelper.markProblems();
        return status;
    }

    protected Collection getUnresolvedExternalReferencePaths(Resource eResource) {
        ArrayList<String> result = new ArrayList<String>();
        ExternalReferenceVisitor visitor = new ExternalReferenceVisitor(eResource);
        visitor.setIncludeDiagramReferences(false);
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
        try {
            processor.walk(eResource, 2);
        }
        catch (Throwable t) {
            Object[] params = new Object[]{eResource.getURI()};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_processing_external_references_for_resource", params);
            VdbEditPlugin.Util.log(4, t, msg);
        }
        Collection externalReferences = visitor.getExternalReferences();
        if (externalReferences == null) {
            externalReferences = Collections.EMPTY_LIST;
        }
        Iterator iter = externalReferences.iterator();
        while (iter.hasNext()) {
            String tempDirPath;
            Container cntr;
            ExternalReferenceVisitor.ExternalReferences externalRefs = (ExternalReferenceVisitor.ExternalReferences)iter.next();
            Resource theResource = externalRefs.getResource();
            URI resourceUri = externalRefs.getResourceUri();
            if (theResource != null) {
                resourceUri = theResource.getURI();
            }
            if ((cntr = ModelerCore.getContainer((Resource)eResource)) != null && cntr.getResourceFinder().isBuiltInResource(resourceUri) || this.getVdbContainer().getResource(resourceUri, false) != null) continue;
            String resourcePath = URI.decode((String)resourceUri.toString());
            int index = resourcePath.indexOf(tempDirPath = new Path(this.getTempDirectory().getPath()).toString());
            if (index != -1) {
                resourcePath = resourcePath.substring(index + tempDirPath.length());
            }
            result.add(resourcePath);
        }
        return result;
    }

    private IStatus addGlobalResourcesForIndexing(Collection eResources) {
        this.assertIsOpen();
        this.assertModelsLoaded();
        LinkedList problems = new LinkedList();
        URI builtInDatatypesURI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
        Resource builtInDatatypes = this.getVdbContainer().getResource(builtInDatatypesURI, false);
        if (builtInDatatypes != null && !eResources.contains(builtInDatatypes)) {
            eResources.add(builtInDatatypes);
        }
        String desc = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Adding_in_global_resources_into_the_list_of_resources_for_indexing_2");
        IStatus results = this.createSingleIStatus(problems, desc);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void addGlobalResourcesToInternalResourceSet() {
        block27: {
            this.assertIsOpen();
            this.assertModelsLoaded();
            eResources = new ArrayList<E>(this.getVdbContainer().getResources());
            try {
                block29: {
                    xsdDirectives = new ArrayList<XSDSchemaDirective>();
                    modelImports = new ArrayList<ModelImport>();
                    i = eResources.iterator();
                    while (i.hasNext()) {
                        eResource = (Resource)i.next();
                        if (!eResource.isLoaded()) {
                            eResource.load(this.getOptions());
                        }
                        if (eResource instanceof XSDResourceImpl) {
                            xsdResource = (XSDResourceImpl)eResource;
                            j = xsdResource.getSchema().eContents().iterator();
                            while (j.hasNext()) {
                                eObj = (EObject)j.next();
                                if (!(eObj instanceof XSDSchemaDirective) || !(directive = (XSDSchemaDirective)eObj).getSchemaLocation().equalsIgnoreCase("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) continue;
                                xsdDirectives.add(directive);
                            }
                            continue;
                        }
                        if (!(eResource instanceof EmfResource)) continue;
                        emfResource = (EmfResource)eResource;
                        j = emfResource.getModelAnnotation().getModelImports().iterator();
                        while (j.hasNext()) {
                            modelImport = (ModelImport)j.next();
                            if (!modelImport.getModelLocation().equalsIgnoreCase("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) continue;
                            modelImports.add(modelImport);
                        }
                    }
                    if (xsdDirectives.isEmpty() && modelImports.isEmpty()) break block27;
                    builtInDatatypesURI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
                    builtInDatatypes = this.getVdbContainer().getResource(builtInDatatypesURI, false);
                    builtInDatatypesName = "builtInDataTypes.xsd";
                    builtInDatatypesPath = new Path(builtInDatatypesName);
                    internalResourceUri = this.getInternalResourceUri((IPath)builtInDatatypesPath);
                    if (builtInDatatypes != null && !this.getVdbContainer().getResources().contains((Object)builtInDatatypes)) {
                        tempDirFile = null;
                        istream = null;
                        try {
                            tempDirFile = this.addToTempDirectory(builtInDatatypes, builtInDatatypesName);
                        }
                        catch (Exception theException) {
                            VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getLocalizedMessage());
                        }
                        try {
                            block28: {
                                if (tempDirFile == null || !tempDirFile.exists()) break block28;
                                istream = new FileInputStream(tempDirFile);
                                r = this.addToInternalResourceSet(istream, internalResourceUri, (IPath)builtInDatatypesPath);
                                modelReference = this.createModelReference(r, (IPath)builtInDatatypesPath);
                                modelReference.setAccessibility(ModelAccessibility.PRIVATE_LITERAL);
                                this.setModelReferenceForPath((IPath)builtInDatatypesPath, modelReference);
                            }
                            var14_16 = null;
                            ** if (istream == null) goto lbl-1000
                        }
                        catch (Throwable var13_20) {
                            var14_17 = null;
                            if (istream != null) {
                                try {
                                    istream.close();
                                }
                                catch (IOException theException) {
                                    VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                                }
                            }
                            throw var13_20;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                istream.close();
                            }
                            catch (IOException theException) {
                                VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block29;
                            catch (Exception theException) {
                                VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getLocalizedMessage());
                                var14_16 = null;
                                if (istream != null) {
                                    try {
                                        istream.close();
                                    }
                                    catch (IOException theException) {
                                        VdbEditPlugin.Util.log(4, (Throwable)theException, theException.getMessage());
                                    }
                                }
                            }
                        }
                    }
                }
                i = xsdDirectives.iterator();
                while (i.hasNext()) {
                    directive = (XSDSchemaDirective)i.next();
                    eResource = directive.eResource();
                    deresolvedURI = this.getRelativeLocation(eResource.getURI(), internalResourceUri);
                    directive.setSchemaLocation(deresolvedURI.toString());
                    try {
                        eResource.save(Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        VdbEditPlugin.Util.log(4, (Throwable)e, VdbEditPlugin.Util.getString("VdbEditingContextImpl.1", (Object)this.getResourcePath(eResource)));
                    }
                }
                i = modelImports.iterator();
                while (i.hasNext()) {
                    modelImport = (ModelImport)i.next();
                    eResource = modelImport.eResource();
                    deresolvedURI = this.getRelativeLocation(eResource.getURI(), internalResourceUri);
                    modelImport.setModelLocation(URI.decode((String)deresolvedURI.toString()));
                    try {
                        eResource.save(Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        VdbEditPlugin.Util.log(4, (Throwable)e, VdbEditPlugin.Util.getString("VdbEditingContextImpl.1", (Object)this.getResourcePath(eResource)));
                    }
                }
            }
            catch (Exception e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
        }
    }

    private URI getRelativeLocation(URI baseURI, URI importURI) {
        URI uri = importURI;
        if (importURI.isFile()) {
            URI deresolvedURI;
            boolean deresolve;
            boolean bl = deresolve = baseURI != null && !baseURI.isRelative() && baseURI.isHierarchical();
            if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(baseURI, true, true, false)).hasRelativePath()) {
                uri = deresolvedURI;
            }
        }
        return uri;
    }

    protected Resource createMaterialization(Collection eResources, Map virtToPhysMappings, List problems, IProgressMonitor monitor) {
        ArgCheck.isNotNull((Object)eResources);
        ArgCheck.isNotNull((Object)virtToPhysMappings);
        if (monitor != null) {
            String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.generating_materialization_model");
            monitor.setTaskName(taskName);
        }
        try {
            MaterializedViewModelGenerator mvmg = new MaterializedViewModelGenerator();
            String modelName = this.getMaterializedViewModelName(false);
            URI folderUri = URI.createFileURI((String)this.getTempDirectory().getPath());
            Iterator iter = eResources.iterator();
            while (iter.hasNext()) {
                EmfResource emfResource;
                Resource eResource = (Resource)iter.next();
                if (!(eResource instanceof EmfResource) || (emfResource = (EmfResource)eResource).getModelAnnotation().getModelType() != ModelType.VIRTUAL_LITERAL) continue;
                mvmg.execute((Resource)emfResource, true, modelName, folderUri);
            }
            Resource materialization = mvmg.getMaterializedViewModel();
            if (materialization != null && mvmg.getVirtToPhysMappings() != null) {
                Iterator iter2 = mvmg.getVirtToPhysMappings().entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry entry = iter2.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    virtToPhysMappings.put(key, value);
                }
            }
            return materialization;
        }
        catch (Throwable t) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_creating_materialized_view");
            Status status = new Status(0, "com.metamatrix.vdb.edit", 0, msg, t);
            if (problems != null) {
                problems.add(status);
            }
            return null;
        }
    }

    protected void addMaterializationToVdb(Resource materialization, VirtualDatabase vdb, List problems, IProgressMonitor monitor) {
        ArgCheck.isNotNull((Object)vdb);
        try {
            if (monitor != null) {
                String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.adding_materialization_model_to_vdb");
                monitor.setTaskName(taskName);
            }
            if (materialization != null) {
                String modelName = this.getMaterializedViewModelName(false);
                String modelPath = this.getMaterializedViewModelName(true);
                ModelReference modelReference = this.getManifestFactory().createModelReference();
                URI uri = materialization.getURI();
                modelReference.setModelLocation(modelPath);
                modelReference.setUri(uri.toString());
                modelReference.setVirtualDatabase(vdb);
                modelReference.setVisible(true);
                modelReference.setName(modelName);
                modelReference.setModelType(ModelType.MATERIALIZATION_LITERAL);
                modelReference.setAccessibility(ModelAccessibility.PRIVATE_LITERAL);
                ModelAnnotation modelAnnotation = ((EmfResource)materialization).getModelAnnotation();
                if (modelAnnotation != null) {
                    modelReference.setPrimaryMetamodelUri(modelAnnotation.getPrimaryMetamodelUri());
                    modelReference.setVisible(modelAnnotation.isVisible());
                    ObjectID uuid = modelAnnotation.getObjectId();
                    if (uuid != null) {
                        modelReference.setUuid(uuid.toString());
                    }
                }
                vdb.getModels().add((Object)modelReference);
            }
        }
        catch (Throwable t) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_adding_materialization_model_to_vdb");
            Status status = new Status(0, "com.metamatrix.vdb.edit", 0, msg, t);
            problems.add(status);
        }
    }

    protected Collection generateDdlsForMaterialization(Resource materialization, List problems, IProgressMonitor monitor) {
        ArrayList<File> result = Collections.EMPTY_LIST;
        if (materialization != null) {
            if (monitor != null) {
                String taskName = VdbEditPlugin.Util.getString("VdbEditingContextImpl.creating_ddl_scripts");
                monitor.setTaskName(taskName);
            }
            StyleRegistry registry = DdlPlugin.getStyleRegistry();
            Collection styles = registry.getStyles();
            result = new ArrayList<File>(styles.size());
            Iterator iter = styles.iterator();
            while (iter.hasNext()) {
                Style ddlType = (Style)iter.next();
                File ddlFile = this.generateDdlFile(materialization, ddlType, problems, monitor);
                result.add(ddlFile);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected File generateDdlFile(Resource resource, Style ddlType, List problems, IProgressMonitor monitor) {
        block15: {
            File ddlFile;
            block14: {
                if (resource == null || ddlType == null) break block15;
                String modelName = resource.getURI().lastSegment();
                String typeName = ddlType.getName();
                String modelFileName = this.createValidFileName("MaterializationModel" + typeName) + MATERIALIZATION_DDL_FILE_SUFFIX;
                DdlWriter writer = DdlPlugin.createDdlWriter();
                DdlOptions ddlOptions = writer.getOptions();
                ddlOptions.setGenerateComments(false);
                ddlOptions.setGenerateDropStatements(true);
                ddlOptions.setNativeTypeUsed(true);
                ddlOptions.setStyle(ddlType);
                ddlFile = null;
                FileOutputStream stream = null;
                ByteArrayOutputStream tempStream = null;
                ddlFile = this.getTempDirectoryFile(modelFileName);
                stream = new FileOutputStream(ddlFile);
                tempStream = new ByteArrayOutputStream(5120);
                writer.write(resource, modelName, modelFileName, (OutputStream)tempStream, monitor);
                byte[] orginalDDL = tempStream.toByteArray();
                ScriptDecorator scriptDecorator = new ScriptDecorator();
                byte[] modifiedDDL = scriptDecorator.modifyDDL(ddlType, orginalDDL);
                stream.write(modifiedDDL);
                Object var18_19 = null;
                try {
                    if (tempStream != null) {
                        tempStream.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    break block14;
                }
                catch (IOException err) {}
                break block14;
                {
                    catch (Throwable t) {
                        Object[] params = new Object[]{typeName, modelName};
                        String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.error_creating_ddl_scripts", params);
                        Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, t);
                        problems.add(status);
                        Object var18_20 = null;
                        try {
                            if (tempStream != null) {
                                tempStream.close();
                            }
                            if (stream != null) {
                                stream.close();
                            }
                            break block14;
                        }
                        catch (IOException err) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var18_21 = null;
                    try {
                        if (tempStream != null) {
                            tempStream.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException err) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return ddlFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Collection generateMateriailizedViewLoadRefreshScripts(String vdbName, Map virtualToPhysicalTableMappings, List problems, IProgressMonitor monitor) {
        result = new ArrayList<File>();
        templateData = this.createMaterializedViewTemplateData(virtualToPhysicalTableMappings);
        databaseItr = DatabaseDialect.getAllDialects().iterator();
        while (databaseItr.hasNext()) {
            block35: {
                aDialect = (DatabaseDialect)databaseItr.next();
                truncFileName = ScriptType.truncateScriptFileName((DatabaseDialect)aDialect, (String)vdbName);
                truncFile = this.getTempDirectoryFile(truncFileName);
                truncStream = null;
                try {
                    truncStream = new FileOutputStream(truncFile);
                }
                catch (FileNotFoundException e) {
                    params = new Object[]{vdbName};
                    msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_creating_turncate_scripts", params);
                    status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)e);
                    problems.add(status);
                }
                swapFileName = ScriptType.swapScriptFileName((DatabaseDialect)aDialect, (String)vdbName);
                swapFile = this.getTempDirectoryFile(swapFileName);
                swapStream = null;
                try {
                    swapStream = new FileOutputStream(swapFile);
                }
                catch (FileNotFoundException e) {
                    params = new Object[]{vdbName};
                    msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_creating_swap_scripts", params);
                    status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)e);
                    problems.add(status);
                }
                try {
                    materializationDataItr = templateData.iterator();
                    while (materializationDataItr.hasNext()) {
                        scriptGen = new MaterializedViewScriptGeneratorImpl((TemplateData)materializationDataItr.next());
                        try {
                            scriptGen.generateMaterializationTruncateScript((OutputStream)truncStream, aDialect);
                        }
                        catch (Throwable t) {
                            params = new Object[]{vdbName};
                            msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_creating_turncate_scripts", params);
                            status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, t);
                            problems.add(status);
                        }
                        try {
                            scriptGen.generateMaterializationSwapScript((OutputStream)swapStream, aDialect);
                        }
                        catch (Throwable t) {
                            params = new Object[]{vdbName};
                            msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_creating_swap_scrips", params);
                            status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, t);
                            problems.add(status);
                        }
                    }
                    var22_27 = null;
                    if (truncStream == null) break block35;
                }
                catch (Throwable var21_29) {
                    var22_27 = null;
                    if (truncStream != null) {
                        try {
                            truncStream.close();
                        }
                        catch (IOException err) {
                            // empty catch block
                        }
                    }
                    if (swapStream != null) {
                        try {
                            swapStream.close();
                        }
                        catch (IOException err) {
                            // empty catch block
                        }
                    }
                    throw var21_29;
                }
                try {
                    truncStream.close();
                }
                catch (IOException err) {
                    // empty catch block
                }
            }
            if (swapStream != null) {
                try {
                    swapStream.close();
                }
                catch (IOException err) {}
            }
            if (truncFile.length() > 0L) {
                result.add(truncFile);
            }
            if (swapFile.length() <= 0L) continue;
            result.add(swapFile);
        }
        loadFileName = ScriptType.loadScriptFileName((DatabaseDialect)DatabaseDialect.METAMATRIX, (String)vdbName);
        loadFile = this.getTempDirectoryFile(loadFileName);
        loadStream = null;
        try {
            loadStream = new FileOutputStream(loadFile);
        }
        catch (FileNotFoundException e) {
            params = new Object[]{vdbName};
            msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_creating_load_scripts", params);
            status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, (Throwable)e);
            problems.add(status);
        }
        try {
            materializationDataItr = templateData.iterator();
            while (materializationDataItr.hasNext()) {
                template = (TemplateData)materializationDataItr.next();
                scriptGen = new MaterializedViewScriptGeneratorImpl(template);
                try {
                    scriptGen.generateMaterializationLoadScript((OutputStream)loadStream);
                }
                catch (Throwable t) {
                    params = new Object[]{vdbName};
                    msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Error_creating_load_scripts", params);
                    status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, t);
                    problems.add(status);
                }
            }
            var25_30 = null;
            ** if (loadStream == null) goto lbl-1000
        }
        catch (Throwable var24_34) {
            var25_31 = null;
            if (loadStream != null) {
                try {
                    loadStream.close();
                }
                catch (IOException err) {
                    // empty catch block
                }
            }
            throw var24_34;
        }
lbl-1000:
        // 1 sources

        {
            try {
                loadStream.close();
            }
            catch (IOException err) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        if (loadFile.length() > 0L) {
            result.add(loadFile);
        }
        return result;
    }

    protected String createValidFileName(String fileName) {
        StringBuffer sb = new StringBuffer(100);
        StringCharacterIterator charIter = new StringCharacterIterator(fileName);
        char c = charIter.first();
        while (c != '\uffff') {
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
            } else {
                sb.append('_');
            }
            c = charIter.next();
        }
        return sb.toString();
    }

    protected IndexingContext getContextForIndexer(Collection eResources, Container container) {
        IndexingContext context = new IndexingContext();
        if (eResources != null) {
            ArrayList resourcesInScope = new ArrayList(eResources);
            this.updateResource(resourcesInScope, container);
            context.setResourcesInContext(resourcesInScope);
        }
        if (this.materializedModelMap != null && !this.materializedModelMap.isEmpty()) {
            Iterator iter = this.materializedModelMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                EObject virtualTable = (EObject)entry.getKey();
                Collection physicalTables = (Collection)entry.getValue();
                context.addMaterializedTables(virtualTable, physicalTables);
            }
        }
        return context;
    }

    private void updateResource(Collection resourcesInScope, Container container) {
        Resource[] systemVdbResources = ModelerCore.getSystemVdbResources();
        for (int idx = 0; idx < systemVdbResources.length; ++idx) {
            ObjectID objectID = ((EmfResource)systemVdbResources[idx]).getUuid();
            Resource resrc = container.getResourceFinder().findByUUID(objectID, false);
            if (resrc == null || resourcesInScope.contains(resrc)) continue;
            resourcesInScope.add(resrc);
        }
    }

    protected void produceIndex(IIndexer indexer, List eResources, File indexFile) throws IOException {
        Index runtimeIndex = null;
        runtimeIndex = IndexUtil.indexFileExists((String)indexFile.getAbsolutePath()) ? new Index(indexFile.getAbsolutePath(), true) : new Index(indexFile.getAbsolutePath(), false);
        VdbDocumentImpl document = new VdbDocumentImpl(indexFile.getName(), (Collection)eResources, Collections.unmodifiableMap(this.pathsByResourceUri));
        runtimeIndex.add((IDocument)document, indexer);
        runtimeIndex.save();
    }

    protected String getVdbName() {
        String filename = this.vdbFilePath.lastSegment();
        String vdbName = FileUtils.getFilenameWithoutExtension((String)filename);
        return vdbName;
    }

    protected String getMaterializedViewModelName(boolean includeExtension) {
        String mvModelName = "MaterializationModel";
        if (includeExtension) {
            mvModelName = mvModelName + MATERIALIZATION_MODEL_FILE_SUFFIX;
        }
        return mvModelName;
    }

    protected IStatus createSingleIStatus(List problems, String desc) {
        String PLUGINID = "com.metamatrix.vdb.edit";
        IStatus resultStatus = null;
        if (problems.isEmpty()) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.completed", (Object)desc);
            Status status = new Status(0, "com.metamatrix.vdb.edit", 3001, msg, null);
            resultStatus = status;
        } else if (problems.size() == 1) {
            resultStatus = (IStatus)problems.get(0);
        } else {
            int numErrors = 0;
            int numWarnings = 0;
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                IStatus aStatus = (IStatus)iter.next();
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                Object[] params = new Object[]{desc, new Integer(numWarnings)};
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.completed_with_warnings", params);
                resultStatus = new MultiStatus("com.metamatrix.vdb.edit", 0, statusArray, msg, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                Object[] params = new Object[]{desc, new Integer(numErrors)};
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.resulted_in_errors", params);
                resultStatus = new MultiStatus("com.metamatrix.vdb.edit", 0, statusArray, msg, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                Object[] params = new Object[]{desc, new Integer(numWarnings), new Integer(numErrors)};
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.resulted_in_warnings_and_errors", params);
                resultStatus = new MultiStatus("com.metamatrix.vdb.edit", 0, statusArray, msg, null);
            } else {
                String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.completed_with_no_warnings_or_errors", (Object)desc);
                resultStatus = new MultiStatus("com.metamatrix.vdb.edit", 0, statusArray, msg, null);
            }
        }
        return resultStatus;
    }

    private IStatus createModelStatus(List problemStatuses, List modelErrors, List modelWarnings) {
        int numProblems = problemStatuses.size();
        int numErrors = modelErrors.size();
        int numWarnings = modelWarnings.size();
        if (numProblems == 0 && numErrors == 0 && numWarnings == 0) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Saving_manifest_model_completed");
            Status status = new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
            return status;
        }
        ArrayList<Status> statuses = new ArrayList<Status>(problemStatuses);
        Iterator iter = modelErrors.iterator();
        while (iter.hasNext()) {
            Resource.Diagnostic diag = (Resource.Diagnostic)iter.next();
            String msg = diag.getMessage();
            Object[] params = new Object[]{new Integer(diag.getLine()), new Integer(diag.getColumn()), diag.getLocation()};
            msg = msg + VdbEditPlugin.Util.getString("VdbEditingContextImpl.LineSuffix", params);
            Status status = new Status(4, "com.metamatrix.vdb.edit", 0, msg, null);
            statuses.add(status);
        }
        Iterator iter2 = modelWarnings.iterator();
        while (iter2.hasNext()) {
            Resource.Diagnostic diag = (Resource.Diagnostic)iter2.next();
            String msg = diag.getMessage();
            Object[] params = new Object[]{new Integer(diag.getLine()), new Integer(diag.getColumn()), diag.getLocation()};
            msg = msg + VdbEditPlugin.Util.getString("VdbEditingContextImpl.LineSuffix", params);
            Status status = new Status(2, "com.metamatrix.vdb.edit", 0, msg, null);
            statuses.add(status);
        }
        String desc = VdbEditPlugin.Util.getString("VdbEditingContextImpl.saving_manifest_model");
        return this.createSingleIStatus(statuses, desc);
    }

    protected void assertIsOpen() {
        if (!this.isOpen()) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.must_be_open");
            throw new IllegalStateException(msg);
        }
    }

    protected void assertModelsLoaded() {
        if (!this.loadModelsOnOpen) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.the_models_files_within_the_vdb_must_be_loaded");
            throw new IllegalStateException(msg);
        }
    }

    protected Map createOptions() {
        return this.getVdbContainer().getLoadOptions();
    }

    protected void updateVirtualDatabase(VirtualDatabase vdbObj) {
        vdbObj.setName(this.getVdbName());
        if (vdbObj.getUuid() == null) {
            ObjectID id = IDGenerator.getInstance().getFactory("mmuuid").create();
            vdbObj.setUuid(id.toString());
        }
        Date currentDate = DateUtil.getCurrentDate();
        vdbObj.setTimeLastChangedAsDate(currentDate);
        vdbObj.setTimeLastProducedAsDate(currentDate);
    }

    public void updateVdbXmiName() {
        if (this.manifestResource != null) {
            this.getVirtualDatabase().setName(this.getVdbName());
            this.manifestResource.setModified(true);
        }
    }

    private void addNoModelsWarning(VirtualDatabase vdbObj) {
        if (vdbObj.getModels().isEmpty()) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.The_VDB_has_no_models_1");
            boolean foundNoModelsWarning = false;
            Iterator iter = vdbObj.getMarkers().iterator();
            while (iter.hasNext()) {
                ProblemMarker marker = (ProblemMarker)iter.next();
                if (!marker.getMessage().equals(msg)) continue;
                foundNoModelsWarning = true;
                break;
            }
            if (!foundNoModelsWarning) {
                this.createProblem((ProblemMarkerContainer)vdbObj, 2, msg, null);
            }
        }
    }

    private Properties getModelSourceProperties(Resource eResource) {
        ArgCheck.isNotNull((Object)eResource);
        Iterator iter = eResource.getContents().iterator();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            SqlAspect aspect = AspectManager.getSqlAspect((EObject)eObject);
            if (aspect == null || !(aspect instanceof SqlModelSourceAspect)) continue;
            return ((SqlModelSourceAspect)aspect).getProperties(eObject);
        }
        return null;
    }

    private void setVdbProblems(VirtualDatabase vdb, List statuses) {
        Iterator iter = statuses.iterator();
        while (iter.hasNext()) {
            IStatus status = (IStatus)iter.next();
            this.addVdbStatus(vdb, status);
        }
        if (vdb.getModels().isEmpty()) {
            this.addNoModelsWarning(vdb);
        }
    }

    private void addVdbStatus(VirtualDatabase vdb, IStatus status) {
        if (status == null) {
            return;
        }
        if (status.isMultiStatus()) {
            IStatus[] statuses = status.getChildren();
            for (int i = 0; i < statuses.length; ++i) {
                this.addVdbStatus(vdb, statuses[i]);
            }
        } else if (status.getSeverity() == 2) {
            this.createProblem((ProblemMarkerContainer)vdb, status.getSeverity(), status.getMessage(), status.getException());
        } else if (status.getSeverity() == 4) {
            this.createProblem((ProblemMarkerContainer)vdb, status.getSeverity(), status.getMessage(), status.getException());
        }
    }

    private void setModelReferenceProblems(ModelReference modelRef, ValidationContext context) {
        ArgCheck.isNotNull((Object)modelRef);
        ArgCheck.isNotNull((Object)context);
        if (modelRef.getAccessibility() == ModelAccessibility.PRIVATE_LITERAL) {
            return;
        }
        this.setContainerProblems((ProblemMarkerContainer)modelRef, context);
    }

    private void setContainerProblems(ProblemMarkerContainer container, ValidationContext context) {
        ArgCheck.isNotNull((Object)container);
        ArgCheck.isNotNull((Object)context);
        if (context.hasResults()) {
            List results = context.getValidationResults();
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                EObject eObject;
                ValidationResult result = (ValidationResult)iter.next();
                String eObjectUri = result.getLocationUri() != null ? result.getLocationUri() : result.getTargetUri();
                EObject eObject2 = eObject = eObjectUri != null ? this.getVdbContainer().getEObject(URI.createURI((String)eObjectUri), false) : null;
                if (result == null || !result.hasProblems()) continue;
                ValidationProblem[] problems = result.getProblems();
                for (int probCnt = 0; probCnt < problems.length; ++probCnt) {
                    this.addProblemMarker(container, eObject, problems[probCnt]);
                }
            }
        }
    }

    private void addProblemMarker(ProblemMarkerContainer container, EObject targetObject, ValidationProblem problem) {
        if (problem != null) {
            ProblemMarker marker = this.getManifestFactory().createProblemMarker();
            marker.setCode(problem.getCode());
            marker.setMessage(problem.getMessage());
            if (targetObject != null) {
                marker.setTargetUri(targetObject.getObjectId().toString());
            }
            String target = null;
            if (container instanceof VirtualDatabase) {
                target = ((VirtualDatabase)container).getName();
            } else if (container instanceof ModelReference) {
                target = ((ModelReference)container).getModelLocation();
            }
            marker.setTarget(target);
            switch (problem.getSeverity()) {
                case 4: {
                    marker.setSeverity(Severity.ERROR_LITERAL);
                    break;
                }
                case 2: {
                    marker.setSeverity(Severity.WARNING_LITERAL);
                    break;
                }
                case 1: {
                    marker.setSeverity(Severity.INFO_LITERAL);
                    break;
                }
                default: {
                    marker.setSeverity(Severity.OK_LITERAL);
                }
            }
            marker.setMarked(container);
        }
    }

    private EObject getProblemMarkerEObject(ProblemMarker marker) {
        if (marker != null && marker.getTargetUri() != null && marker.getTargetUri().startsWith("mmuuid")) {
            return (EObject)this.getVdbContainer().getEObjectFinder().find((Object)marker.getTargetUri());
        }
        return null;
    }

    private void clearProblemMarkers(ProblemMarkerContainer container) {
        container.getMarkers().clear();
    }

    protected InputStream getArchiveResourceStream(ModelReference modelReference) throws IOException {
        ArgCheck.isNotNull((Object)modelReference);
        return this.getArchiveResourceStream(modelReference.getModelLocation());
    }

    protected InputStream getArchiveResourceStream(String entryName) throws IOException {
        ZipEntry zipEntry;
        File vdbFile;
        ArgCheck.isNotNull((Object)entryName);
        ArgCheck.isNotZeroLength((String)entryName);
        if (this.vdbArchive == null && (vdbFile = this.vdbFilePath.toFile()).exists() && vdbFile.length() > 0L) {
            this.vdbArchive = new ZipFile(vdbFile);
        }
        InputStream istream = null;
        if (this.vdbArchive != null && (zipEntry = this.vdbArchive.getEntry(entryName)) != null && (istream = this.vdbArchive.getInputStream(zipEntry)) == null) {
            Object[] params = new Object[]{entryName, this.vdbFilePath};
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_obtain_input_stream", params);
            throw new IOException(msg);
        }
        return istream;
    }

    protected URI getInternalResourceUri(IPath modelPath) {
        ArgCheck.isNotNull((Object)modelPath);
        TempDirectory tempDir = this.getTempDirectory();
        Path tempDirPath = new Path(tempDir.getPath());
        IPath tempDirFilePath = tempDirPath.append(modelPath);
        return URI.createFileURI((String)tempDirFilePath.toString());
    }

    protected void addToInternalResourceSet(Resource resource, IPath modelPath) {
        ArgCheck.isNotNull((Object)resource);
        ArgCheck.isNotNull((Object)modelPath);
        this.removeFromInternalResourceSet(resource.getURI());
        this.getVdbContainer().getResources().add((Object)resource);
        try {
            String modelPathString = null;
            if (modelPath.segmentCount() == 1 && modelPath.lastSegment().equals("MetaMatrix-VdbManifestModel.xmi")) {
                modelPathString = "MetaMatrix-VdbManifestModel.xmi";
            } else if (modelPath.segmentCount() == 1 && modelPath.lastSegment().equals("MaterializationModel.xmi")) {
                modelPathString = "MaterializationModel.xmi";
            }
            if (modelPathString == null) {
                modelPathString = modelPath.makeAbsolute().toString();
            }
            this.pathsByResourceUri.put(resource.getURI(), modelPathString);
            URIConverter converter = this.getVdbContainer().getURIConverter();
            if (converter != null) {
                URI actualUri = resource.getURI();
                URI modelPathUri = URI.createURI((String)modelPathString);
                converter.getURIMap().put(modelPathUri, actualUri);
                if (resource instanceof XSDResourceImpl) {
                    URI escapedUri = this.getEscapedURI(resource);
                    converter.getURIMap().put(escapedUri, actualUri);
                }
            }
        }
        catch (RuntimeException theException) {
            this.removeFromInternalResourceSet(resource.getURI());
            throw theException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource addToInternalResourceSet(InputStream istream, URI uri, IPath modelPath) throws IOException {
        ArgCheck.isNotNull((Object)uri);
        Resource eResource = null;
        try {
            eResource = this.getVdbContainer().getResource(uri, false);
            if (eResource != null && !eResource.isLoaded()) {
                this.removeFromInternalResourceSet(uri);
                eResource = null;
            }
            if (DEBUG_ON) {
                VdbEditPlugin.Util.log((Object)("addToInternalResourceSet(): Adding " + uri.lastSegment()));
            }
            if (eResource == null) {
                eResource = this.getVdbContainer().createResource(uri);
                if (istream != null) {
                    try {
                        eResource.load(istream, this.getOptions());
                        Object var6_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        try {
                            istream.close();
                        }
                        catch (IOException e) {
                            VdbEditPlugin.Util.log(4, (Throwable)e, e.getMessage());
                        }
                        throw throwable;
                    }
                    try {
                        istream.close();
                    }
                    catch (IOException e) {
                        VdbEditPlugin.Util.log(4, (Throwable)e, e.getMessage());
                    }
                }
            }
            String modelPathString = modelPath.toString();
            this.pathsByResourceUri.put(eResource.getURI(), modelPathString);
            URIConverter converter = this.getVdbContainer().getURIConverter();
            if (converter != null) {
                URI actualUri = eResource.getURI();
                URI modelPathUri = URI.createURI((String)modelPathString);
                converter.getURIMap().put(modelPathUri, actualUri);
                if (eResource instanceof XSDResourceImpl) {
                    String namespace;
                    URI escapedUri = this.getEscapedURI(eResource);
                    converter.getURIMap().put(escapedUri, actualUri);
                    if (DEBUG_ON) {
                        VdbEditPlugin.Util.log((Object)("addToInternalResourceSet(): Adding URI mapping from " + escapedUri + " -> " + actualUri));
                    }
                    if ((namespace = ((XSDResourceImpl)eResource).getSchema().getTargetNamespace()) != null) {
                        converter.getURIMap().put(URI.createURI((String)namespace), actualUri);
                        if (DEBUG_ON) {
                            VdbEditPlugin.Util.log((Object)("addToInternalResourceSet(): Adding URI mapping from " + URI.createURI((String)namespace) + " -> " + actualUri));
                        }
                    }
                }
            }
        }
        catch (IOException theException) {
            this.removeFromInternalResourceSet(uri);
            throw theException;
        }
        catch (RuntimeException theException) {
            this.removeFromInternalResourceSet(uri);
            throw theException;
        }
        return eResource;
    }

    protected Resource findInternalResource(String modelPath) {
        URI uri = this.getInternalResourceUri((IPath)new Path(modelPath));
        return this.getVdbContainer().getResource(uri, false);
    }

    protected void removeFromInternalResourceSet(ModelReference modelReference) {
        ArgCheck.isNotNull((Object)modelReference);
        URI uri = this.getInternalResourceUri((IPath)new Path(modelReference.getModelLocation()));
        this.removeFromInternalResourceSet(uri);
    }

    protected void removeFromInternalResourceSet(URI uri) {
        ArgCheck.isNotNull((Object)uri);
        Resource eResource = this.getVdbContainer().getResource(uri, false);
        if (eResource != null) {
            String modelPath = (String)this.pathsByResourceUri.get(eResource.getURI());
            if (eResource.isLoaded()) {
                if (DEBUG_ON) {
                    VdbEditPlugin.Util.log((Object)("removeFromInternalResourceSet(): Unloading " + eResource.getURI().lastSegment()));
                }
                eResource.unload();
            }
            if (DEBUG_ON) {
                VdbEditPlugin.Util.log((Object)("removeFromInternalResourceSet(): Removing " + eResource.getURI().lastSegment()));
            }
            this.getVdbContainer().getResources().remove((Object)eResource);
            URIConverter converter = this.getVdbContainer().getURIConverter();
            if (converter != null) {
                if (modelPath != null) {
                    URI modelPathUri = URI.createURI((String)modelPath);
                    converter.getURIMap().remove(modelPathUri);
                }
                if (eResource instanceof XSDResourceImpl) {
                    URI escapedUri = this.getEscapedURI(eResource);
                    converter.getURIMap().remove(escapedUri);
                }
            }
            this.pathsByResourceUri.remove(eResource.getURI());
        }
    }

    protected synchronized TempDirectory getTempDirectory() {
        if (this.tempDirectory == null) {
            String absolutePath;
            File vdbWorkingFolder;
            VdbEditPlugin plugin = VdbEditPlugin.getInstance();
            if (this.vdbWorkingPath != null) {
                vdbWorkingFolder = new File(this.vdbWorkingPath.toOSString());
                if (!vdbWorkingFolder.exists()) {
                    vdbWorkingFolder.mkdir();
                }
                absolutePath = vdbWorkingFolder.getAbsolutePath();
            } else if (plugin != null) {
                vdbWorkingFolder = VdbEditPlugin.getVdbWorkingDirectory();
                if (!vdbWorkingFolder.exists()) {
                    vdbWorkingFolder.mkdir();
                }
                absolutePath = vdbWorkingFolder.getAbsolutePath();
            } else {
                absolutePath = FileUtils.TEMP_DIRECTORY;
            }
            this.tempDirectory = new TempDirectory(absolutePath, System.currentTimeMillis(), RANDOM.nextLong());
            while (new File(this.tempDirectory.getPath()).exists()) {
                VdbEditPlugin.Util.log(2, "Temporary Folder " + this.tempDirectory.getPath() + " already exists; Creating new folder...");
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.tempDirectory = new TempDirectory(absolutePath, System.currentTimeMillis(), RANDOM.nextLong());
            }
            this.tempDirectory.create();
        }
        return this.tempDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File addToTempDirectory(InputStream istream, String fileName) throws IOException {
        IOException err22;
        ArgCheck.isNotNull((Object)istream);
        if (DEBUG_ON) {
            VdbEditPlugin.Util.log((Object)("addToTempDirectory(): Adding " + fileName));
        }
        FileOutputStream fos = null;
        OutputStream bos = null;
        File tempDirFile = null;
        try {
            int bytesRead;
            tempDirFile = this.getTempDirectoryFile(fileName);
            if (tempDirFile.exists()) {
                tempDirFile.delete();
            }
            fos = new FileOutputStream(tempDirFile);
            bos = new BufferedOutputStream(fos);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = istream.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            bos.flush();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            IOException err22;
            Object var9_9 = null;
            try {
                istream.close();
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getMessage());
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException err22) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    ((OutputStream)fos).close();
                }
                catch (IOException err22) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        try {
            istream.close();
        }
        catch (IOException e) {
            VdbEditPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException err22) {
                // empty catch block
            }
        }
        if (fos != null) {
            try {
                ((OutputStream)fos).close();
            }
            catch (IOException err22) {}
        }
        return tempDirFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected File addToTempDirectory(Resource eResource, String fileName) throws IOException {
        File tempDirFile;
        block21: {
            IOException err222;
            OutputStream bos;
            OutputStream fos;
            block19: {
                ArgCheck.isNotNull((Object)eResource);
                ArgCheck.isNotNull((Object)fileName);
                ArgCheck.isNotZeroLength((String)fileName);
                if (DEBUG_ON) {
                    VdbEditPlugin.Util.log((Object)("addToTempDirectory(): Adding " + eResource.getURI().lastSegment()));
                }
                fos = null;
                bos = null;
                tempDirFile = null;
                tempDirFile = this.getTempDirectoryFile(fileName);
                if (tempDirFile.exists()) {
                    tempDirFile.delete();
                }
                fos = new FileOutputStream(tempDirFile);
                bos = new BufferedOutputStream(fos);
                eResource.save(bos, this.getOptions());
                Object var8_6 = null;
                if (bos == null) break block19;
                try {
                    bos.close();
                }
                catch (IOException err222) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException err222) {}
            }
            break block21;
            {
                catch (FileNotFoundException e) {
                    IOException err222;
                    e.printStackTrace();
                    Object var8_7 = null;
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException err222) {
                            // empty catch block
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException err222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException err222;
                Object var8_8 = null;
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException err222) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException err222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return tempDirFile;
    }

    protected InputStream getTempDirectoryResourceStream(ModelReference modelReference) throws IOException {
        ArgCheck.isNotNull((Object)modelReference);
        File tempDirFile = this.getTempDirectoryFile(modelReference);
        if (tempDirFile != null && tempDirFile.exists()) {
            return new FileInputStream(tempDirFile);
        }
        return null;
    }

    protected File getTempDirectoryFile(ModelReference modelReference) {
        ArgCheck.isNotNull((Object)modelReference);
        return this.getTempDirectoryFile(modelReference.getModelLocation());
    }

    protected File getTempDirectoryFile(NonModelReference nonModelReference) {
        ArgCheck.isNotNull((Object)nonModelReference);
        return this.getTempDirectoryFile(nonModelReference.getPath());
    }

    protected File getTempDirectoryFile(String fileName) {
        Path pathToFile;
        ArgCheck.isNotNull((Object)fileName);
        ArgCheck.isNotZeroLength((String)fileName);
        TempDirectory tempDir = this.getTempDirectory();
        Path tempDirPath = new Path(tempDir.getPath());
        String tempDirName = tempDirPath.lastSegment();
        String tempFileName = fileName;
        int tempDirNameIndex = tempFileName.indexOf(tempDirName);
        if (tempDirNameIndex != -1 && (tempDirNameIndex += tempDirName.length()) < tempFileName.length()) {
            tempFileName = tempFileName.substring(tempDirNameIndex);
        }
        if ((pathToFile = new Path(tempFileName)).segmentCount() > 1) {
            File baseFile = tempDirPath.toFile();
            String[] segments = pathToFile.segments();
            for (int i = 0; i != segments.length - 1; ++i) {
                String folderName = segments[i];
                File folder = new File(baseFile, folderName);
                if (!folder.exists()) {
                    folder.mkdir();
                }
                baseFile = folder;
            }
        }
        IPath tempDirFilePath = tempDirPath.append((IPath)new Path(tempFileName));
        return tempDirFilePath.toFile();
    }

    private Collection createMaterializedViewTemplateData(Map virtualToPhysicalTableMappings) {
        int size = virtualToPhysicalTableMappings.size();
        ArrayList dataObjs = new ArrayList(size);
        ArrayList created = new ArrayList(size);
        Iterator iter = virtualToPhysicalTableMappings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.createMaterializedViewTemplateData(virtualToPhysicalTableMappings, (Table)entry.getKey(), created, dataObjs);
        }
        return dataObjs;
    }

    private void createMaterializedViewTemplateData(Map virtualToPhysicalTableMappings, Table virtTable, List created, List dataObjs) {
        if (created.contains(virtTable)) {
            return;
        }
        MtkXmiResourceImpl resrc = (MtkXmiResourceImpl)virtTable.eResource();
        Iterator xformIter = resrc.getModelContents().getTransformations((EObject)virtTable).iterator();
        while (xformIter.hasNext()) {
            TransformationMappingRoot root = (TransformationMappingRoot)xformIter.next();
            Iterator inputIter = root.getInputs().iterator();
            while (inputIter.hasNext()) {
                Table table;
                Object input = inputIter.next();
                if (!(input instanceof Table) || !(table = (Table)input).isMaterialized()) continue;
                this.createMaterializedViewTemplateData(virtualToPhysicalTableMappings, table, created, dataObjs);
            }
        }
        String virtTableFullName = null;
        SqlAspect sqlAspect = (SqlAspect)ModelerCore.getMetamodels().getMetamodelAspect((EObject)virtTable, "sqlAspect");
        if (sqlAspect != null) {
            virtTableFullName = sqlAspect.getFullName((EObject)virtTable);
        } else {
            Object[] params = new Object[]{virtTable};
            VdbEditPlugin.Util.log(4, VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_get_sql_aspect.", params));
        }
        String virtTableName = virtTable.getName();
        EList columns = virtTable.getColumns();
        Iterator columnItr = columns.iterator();
        String[] columnNames = new String[columns.size()];
        int i = 0;
        while (columnItr.hasNext()) {
            Column aColumn = (Column)columnItr.next();
            columnNames[i] = aColumn.getName();
            ++i;
        }
        String physTableFullName = null;
        String physTableNameInSrc = null;
        String physStageTableFullName = null;
        String physStageTableNameInSrc = null;
        Iterator physTablesItr = ((Collection)virtualToPhysicalTableMappings.get(virtTable)).iterator();
        while (physTablesItr.hasNext()) {
            Table aTable = (Table)physTablesItr.next();
            String aTableNameInSrc = aTable.getNameInSource();
            String aTableFullName = null;
            sqlAspect = (SqlAspect)ModelerCore.getMetamodels().getMetamodelAspect((EObject)aTable, "sqlAspect");
            if (sqlAspect != null) {
                aTableFullName = sqlAspect.getFullName((EObject)aTable);
            } else {
                Object[] params = new Object[]{aTable};
                VdbEditPlugin.Util.log(4, VdbEditPlugin.Util.getString("VdbEditingContextImpl.Unable_to_get_sql_aspect.", params));
            }
            if (aTableNameInSrc.endsWith("ST")) {
                physStageTableNameInSrc = aTableNameInSrc;
                physStageTableFullName = aTableFullName;
                continue;
            }
            physTableNameInSrc = aTableNameInSrc;
            physTableFullName = aTableFullName;
        }
        dataObjs.add(new MaterializedViewData(virtTableName, columnNames, virtTableFullName, physTableNameInSrc, physTableFullName, physStageTableNameInSrc, physStageTableFullName));
        created.add(virtTable);
    }

    private long getCheckSum(File f) {
        ArgCheck.isNotNull((Object)f);
        try {
            return FileUtils.getCheckSum((File)f);
        }
        catch (Throwable err) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.unexpectedException", (Object)f);
            VdbEditPlugin.Util.log(4, err, msg);
            return 0L;
        }
    }

    private long getCheckSum(InputStream is) {
        try {
            return ChecksumUtil.computeChecksum((InputStream)is).getValue();
        }
        catch (Throwable err) {
            String msg = VdbEditPlugin.Util.getString("VdbEditingContextImpl.unexpectedException");
            VdbEditPlugin.Util.log(4, err, msg);
            return 0L;
        }
    }

    protected IPath encodePathForUseInUri(IPath pathToResourceInVdb) {
        String[] pathSegments = pathToResourceInVdb.segments();
        Path pathWithEncoding = Path.ROOT;
        for (int i = 0; i < pathSegments.length; ++i) {
            String segment = pathSegments[i];
            StringBuffer encodedSegment = new StringBuffer();
            String tokenDelimSet = ".?_";
            EnhancedStringTokenizer segmentTokens = new EnhancedStringTokenizer(segment, ".?_");
            while (segmentTokens.hasMoreTokens()) {
                String token = segmentTokens.nextToken();
                String delims = segmentTokens.nextDelimiters();
                String encodedSegmentToken = UriUtil.escape((String)token);
                encodedSegment.append(encodedSegmentToken);
                if (delims == null) continue;
                encodedSegment.append(delims);
            }
            pathWithEncoding = pathWithEncoding.append(encodedSegment.toString());
        }
        return pathWithEncoding;
    }

    protected String encodePathForUseInUri(String pathToResourceInVdb) {
        Path path = new Path(pathToResourceInVdb);
        IPath pathWithEncoding = this.encodePathForUseInUri((IPath)path);
        return pathWithEncoding.toString();
    }

    protected void addModelToValidate(Resource eResource) {
        Assertion.isNotNull((Object)eResource);
        this.addedResourceUrisSinceOpen.add(eResource.getURI());
        if (DEBUG_ON) {
            VdbEditPlugin.Util.log((Object)("addModelToValidate(): Adding " + eResource.getURI().lastSegment()));
        }
    }

    protected void removeModelFromValidate(Resource eResource) {
        Assertion.isNotNull((Object)eResource);
        this.addedResourceUrisSinceOpen.remove(eResource.getURI());
        if (DEBUG_ON) {
            VdbEditPlugin.Util.log((Object)("removeModelFromValidate(): Removing " + eResource.getURI().lastSegment()));
        }
    }

    protected Collection getModelReferences(List eResources, List problems) {
        HashSet<ModelReference> modelReferences = new HashSet<ModelReference>(eResources.size());
        Iterator iter = eResources.iterator();
        while (iter.hasNext()) {
            Resource eResource = (Resource)iter.next();
            ModelReference modelRef = this.getModelReference(eResource);
            if (modelRef == null) continue;
            modelReferences.add(modelRef);
        }
        return modelReferences;
    }

    protected List getInternalResourcesToValidate(List problems) {
        ArrayList<Object> resourcesToValidate = new ArrayList<Object>(this.getVdbContainer().getResources().size());
        Iterator i = this.addedResourceUrisSinceOpen.iterator();
        while (i.hasNext()) {
            Resource eResource = this.getVdbContainer().getResource((URI)i.next(), false);
            if (eResource == null || resourcesToValidate.contains(eResource)) continue;
            resourcesToValidate.add(eResource);
            if (!DEBUG_ON) continue;
            VdbEditPlugin.Util.log((Object)("getInternalResourcesToValidate(): Newly added resource " + eResource.getURI().lastSegment()));
        }
        ArrayList<Resource> referencingResources = new ArrayList<Resource>(this.getVdbContainer().getResources().size());
        Iterator i2 = resourcesToValidate.iterator();
        while (i2.hasNext()) {
            Resource eResource = (Resource)i2.next();
            Resource[] refs = this.getVdbContainer().getResourceFinder().findReferencesTo(eResource, false);
            for (int j = 0; j != refs.length; ++j) {
                Resource r = refs[j];
                if (referencingResources.contains(r) || resourcesToValidate.contains(r)) continue;
                referencingResources.add(r);
            }
        }
        resourcesToValidate.addAll(referencingResources);
        resourcesToValidate.add(this.manifestResource);
        return resourcesToValidate;
    }

    public void addChangeListener(IChangeListener theListener) {
        this.changeListeners.add((Object)theListener);
    }

    public void removeChangeListener(IChangeListener theListener) {
        this.changeListeners.remove((Object)theListener);
    }

    public void fireStateChanged() {
        Object[] listeners = this.changeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((IChangeListener)listeners[i]).stateChanged((IChangeNotifier)this);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners.add((Object)listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners.remove((Object)listener);
    }

    private boolean fireVetoableChange(String key, Object oldValue, Object newValue) {
        try {
            Object[] listeners = this.vetoListeners.getListeners();
            PropertyChangeEvent evt = null;
            for (int i = 0; i < listeners.length; ++i) {
                if (evt == null) {
                    evt = new PropertyChangeEvent(this, key, oldValue, newValue);
                }
                ((VetoableChangeListener)listeners[i]).vetoableChange(evt);
            }
            return true;
        }
        catch (PropertyVetoException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String newName) throws Exception {
        if (this.vdbArchive != null) {
            this.vdbArchive.close();
        }
        boolean prevLoadModelsOnOpen = this.loadModelsOnOpen;
        this.loadModelsOnOpen = false;
        File newFile = new File(newName);
        if (newFile.exists()) {
            throw new IOException(VdbEditPlugin.Util.getString("VdbEditingContextImpl.exists", (Object)newName));
        }
        try {
            if (!this.vdbFilePath.toFile().renameTo(newFile)) {
                throw new IOException(VdbEditPlugin.Util.getString("VdbEditingContextImpl.noRename", (Object)newName));
            }
            this.vdbFilePath = new Path(newName);
        }
        finally {
            this.open();
            this.loadModelsOnOpen = prevLoadModelsOnOpen;
        }
    }

    static {
        ManifestPackageImpl.init();
    }
}

