/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.dqp.internal.config;

import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.modeler.dqp.DqpPlugin;
import com.metamatrix.modeler.dqp.internal.config.ConnectionBindingManager;
import java.util.Collection;
import java.util.Map;

public class ConnectionManager
extends ConnectionBindingManager {
    public ConnectionManager(ConfigurationModelContainer cmc, String filename) throws Exception {
        super(cmc, filename);
    }

    protected boolean importConfig(ConfigurationModelContainer cmc) throws Exception {
        this.loadConfig(cmc);
        return true;
    }

    protected void overrideConnectorType(ComponentType componentType) {
        this.getCMContainerImpl().addComponentType(componentType);
        this.load();
    }

    protected void addConnectorType(ComponentType componentType) {
        this.addConnectorType(componentType, false);
    }

    protected void addConnectorType(ComponentType componentType, boolean doOverwrite) {
        boolean exists = this.isConnectorTypeAlreadyExist(componentType);
        if (!exists || doOverwrite) {
            this.getCMContainerImpl().addComponentType(componentType);
            this.load();
        }
    }

    public boolean isConnectorTypeAlreadyExist(ComponentType componentType) {
        return this.getCMContainerImpl().getComponentTypes().containsKey(componentType.getFullName());
    }

    protected void addConnectorType(ComponentType[] componentType) {
        boolean isLoaded = false;
        for (int idx = 0; idx < componentType.length; ++idx) {
            if (this.isConnectorTypeAlreadyExist(componentType[idx])) continue;
            this.getCMContainerImpl().addComponentType(componentType[idx]);
            isLoaded = true;
        }
        if (isLoaded) {
            this.load();
        }
    }

    protected void addConnectorType(ComponentType[] componentType, boolean doOverwrite) {
        boolean isLoaded = false;
        for (int idx = 0; idx < componentType.length; ++idx) {
            boolean exists;
            ComponentType next = componentType[idx];
            if (next == null || (exists = this.isConnectorTypeAlreadyExist(next)) && !doOverwrite) continue;
            this.getCMContainerImpl().addComponentType(next);
            isLoaded = true;
        }
        if (isLoaded) {
            this.load();
        }
    }

    protected ComponentType getComponentType(String name) {
        return this.getCMContainerImpl().getComponentType(name);
    }

    protected ComponentType getComponentType(ConnectorBinding newBinding) {
        return this.getCMContainerImpl().getComponentType(newBinding.getComponentTypeID().getFullName());
    }

    public Collection getBinding() {
        return this.getBasicConfiguration().getConnectorBindings();
    }

    public ConnectorBinding getBinding(String name) {
        return this.getBasicConfiguration().getConnectorBinding(name);
    }

    public void addBinding(ConnectorBinding newBinding) {
        ComponentType type = this.getCMContainerImpl().getComponentType(newBinding.getComponentTypeID().getFullName());
        if (type != null) {
            this.getBasicConfiguration().addComponentDefn((ComponentDefn)newBinding);
            this.load();
        } else {
            DqpPlugin.Util.log(2, "No matching connector type found for " + newBinding.getComponentTypeID().getFullName());
        }
    }

    protected boolean isBindingAlreadyExist(ConnectorBinding newBinding) {
        return this.getBasicConfiguration().getConnectorBindings().contains(newBinding);
    }

    public void addBinding(Map binding) {
        this.getBasicConfiguration().setConnectors(binding);
        this.load();
    }

    public void removeBinding(ConnectorBinding existingBinding) {
        ComponentType type = this.getCMContainerImpl().getComponentType(existingBinding.getComponentTypeID().getFullName());
        if (type != null && existingBinding.getID() != null) {
            this.getBasicConfiguration().removeComponentObject((ComponentObjectID)((ComponentDefnID)existingBinding.getID()));
            this.load();
        }
    }

    public void removeConnectorType(ComponentType componentType) throws ConfigurationException {
        if (this.getCMContainerImpl().getComponentTypes().containsKey(componentType.getFullName())) {
            this.getCMContainerImpl().remove(componentType.getID());
            this.load();
        }
    }
}

