/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseBatchUpdateException;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerCallAnalyzer;
import com.metamatrix.jdbc.sqlserver.SQLServerConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplResultSet;
import com.metamatrix.jdbc.sqlserver.SQLServerImplResultSetServerSideCursor;
import com.metamatrix.jdbc.sqlserver.tds.TDSCancelRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCCallRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCCursorExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCNonCursorExecuteRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCRequest;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

public final class SQLServerImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   3.52.1.7  $";
    TDSRequest request;
    TDSConnection conn;
    public SQLServerByteOrderedDataWriter writer;
    public SQLServerByteOrderedDataReader reader;
    SQLServerImplResultSet resultSet;
    int resultSetScrollType;
    int resultSetConcurrency;
    public BaseExceptions exceptions;
    BaseBatchUpdateException bbup = null;
    boolean procHasReturnParam;
    boolean isPreparedStatement;
    boolean firstExecute;
    private boolean encodeProcInRPC;
    String procName;
    boolean isBatchRequest;
    private BigDecimal autoGeneratedKeyValue;
    private static final int PREPARE_OPERATION = 1;
    private static final int EXECUTE_OPERATION = 2;
    private static final int EXECUTESQL_OPERATION = 3;
    boolean filterTriggers;
    boolean setRowCount;
    SQLServerCallAnalyzer callAnalyzer;
    int resultTypeReported;
    private boolean cancelOnNextRead = false;
    private boolean cancelableWork = false;

    public SQLServerImplStatement(TDSConnection tDSConnection, int n, int n2, BaseExceptions baseExceptions) {
        this.conn = tDSConnection;
        this.exceptions = baseExceptions;
        this.resultSetScrollType = n;
        this.resultSetConcurrency = n2;
        this.writer = this.conn.getWriter();
        this.reader = this.conn.createReader();
        this.initFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCancelableWork() {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            return this.cancelableWork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelableWork(boolean bl) {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            this.cancelableWork = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCancelOnNextRead() {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            return this.cancelOnNextRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelOnNextRead(boolean bl) {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            this.cancelOnNextRead = bl;
        }
    }

    private void initFields() {
        this.request = null;
        this.resultSet = null;
        this.isPreparedStatement = false;
        this.firstExecute = true;
        this.encodeProcInRPC = false;
        this.procName = null;
        this.procHasReturnParam = false;
    }

    protected void setSQL(BaseSQL baseSQL) {
        if (this.request != null) {
            try {
                this.processAnyCancelReply();
                this.request.unprepare(this.warnings);
                this.request.discardReplyBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initFields();
        super.setSQL(baseSQL);
        this.filterTriggers = this.shouldFilterTriggerResults();
        this.setRowCount = this.shouldSetRowCount();
    }

    public void close() throws SQLException {
        if (this.request != null) {
            this.processAnyCancelReply();
            this.discardUnmaterializedResultSet();
            this.request.unprepare(this.warnings);
            this.request.discardReplyBytes();
        }
        this.reader.close();
    }

    public void reset() throws SQLException {
        if (this.request != null) {
            this.processAnyCancelReply();
            this.request.discardReplyBytes();
        }
        super.reset();
    }

    public void checkForProcedureParameters() throws SQLException {
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        int n = 1;
        baseSQLScanner.setup(this.sql.getFormatted(), '\'', '\"');
        block14: while (n != 12 && n != 11) {
            BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type == 17) continue;
            switch (n) {
                case 1: {
                    this.procName = "";
                    this.procHasReturnParam = false;
                    this.encodeProcInRPC = false;
                    if (baseSQLToken.type == 9 && (baseSQLToken.value.equalsIgnoreCase("execute") || baseSQLToken.value.equalsIgnoreCase("exec"))) {
                        n = 2;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 2: {
                    if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 5;
                        break;
                    }
                    if (baseSQLToken.type == 8) {
                        n = 3;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 3: {
                    if (baseSQLToken.type == 7) {
                        this.procHasReturnParam = true;
                        n = 4;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 4: {
                    if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 5;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 5: {
                    if (baseSQLToken.type == 6) {
                        n = 12;
                        break;
                    }
                    if (baseSQLToken.type == 5) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 6;
                        break;
                    }
                    if (baseSQLToken.type == 15) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 7;
                        break;
                    }
                    if (baseSQLToken.type == 8) {
                        n = 9;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 6: {
                    if (baseSQLToken.type == 9 || baseSQLToken.type == 4) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 5;
                        break;
                    }
                    if (baseSQLToken.type == 5) {
                        this.procName = this.procName + baseSQLToken.value;
                        n = 6;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 7: {
                    if (baseSQLToken.type == 16) {
                        try {
                            Integer.parseInt(baseSQLToken.value);
                            this.procName = this.procName + baseSQLToken.value;
                            n = 8;
                        }
                        catch (Exception exception) {
                            n = 11;
                        }
                        continue block14;
                    }
                    n = 11;
                    break;
                }
                case 8: {
                    if (baseSQLToken.type == 6) {
                        n = 12;
                        break;
                    }
                    if (baseSQLToken.type == 8) {
                        n = 9;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 9: {
                    if (baseSQLToken.type == 6) {
                        n = 12;
                        break;
                    }
                    if (baseSQLToken.type == 1) {
                        n = 10;
                        break;
                    }
                    n = 11;
                    break;
                }
                case 10: {
                    n = baseSQLToken.type == 8 ? 9 : 11;
                }
            }
        }
        if (n == 12) {
            this.encodeProcInRPC = true;
        } else {
            this.procHasReturnParam = false;
            this.encodeProcInRPC = false;
            this.procName = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelWithStatus(int n) throws SQLException {
        TDSConnection tDSConnection = this.conn;
        synchronized (tDSConnection) {
            if (this.conn.getCancelPendingStatement() != null || n == 0 && !this.getCancelableWork()) {
                return false;
            }
            TDSCancelRequest tDSCancelRequest = new TDSCancelRequest(this.conn, this.reader, this.writer);
            tDSCancelRequest.submitRequest(null);
            this.conn.setCancelPendingStatement(this);
            if (n == 0) {
                this.setCancelOnNextRead(true);
            }
            return true;
        }
    }

    private void unprepare() throws SQLException {
        if (this.request != null) {
            this.request.unprepare(this.warnings);
        }
    }

    public int getRequiredSQLProcessing(String string) {
        return 4;
    }

    public void prepare() throws SQLException {
        this.isPreparedStatement = true;
    }

    public void returnOutputParams() throws SQLException {
        int n = this.sql.getParameterCount();
        BaseParameters baseParameters = null;
        if (this.parameterSets == null) {
            return;
        }
        baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        int n2 = 0;
        int n3 = 1;
        while (n3 <= n) {
            BaseParameter baseParameter = baseParameters.get(n3, 2);
            if (baseParameter != null) {
                if (n3 == 1 && this.procHasReturnParam && this.encodeProcInRPC) {
                    ((TDSRPCRequest)this.request).populateReturnParam(baseParameter);
                } else {
                    ((TDSRPCRequest)this.request).populateOuputParam(baseParameter, ++n2);
                }
            }
            ++n3;
        }
    }

    public void execute() throws SQLException {
        Object object;
        this.isBatchRequest = false;
        this.resultTypeReported = 0;
        if (this.setRowCount) {
            if (this.maxRows != ((SQLServerImplConnection)this.implConnection).maxRows) {
                object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
                ((TDSExecuteRequest)object).setSQL("SET ROWCOUNT " + this.maxRows);
                ((TDSExecuteRequest)object).submitRequest(null);
                ((TDSRequest)object).processReply(3, this.warnings);
                ((TDSRequest)object).discardReplyBytes();
                ((SQLServerImplConnection)this.implConnection).maxRows = this.maxRows;
            }
        } else if (0 != ((SQLServerImplConnection)this.implConnection).maxRows) {
            object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
            ((TDSExecuteRequest)object).setSQL("SET ROWCOUNT 0");
            ((TDSExecuteRequest)object).submitRequest(null);
            ((TDSRequest)object).processReply(3, this.warnings);
            ((TDSRequest)object).discardReplyBytes();
            ((SQLServerImplConnection)this.implConnection).maxRows = 0;
        }
        if (this.maxFieldSize == 0) {
            SQLServerImplConnection cfr_ignored_0 = (SQLServerImplConnection)this.implConnection;
            this.maxFieldSize = SQLServerImplConnection.defaultMaxFieldSize;
        }
        if (this.maxFieldSize != ((SQLServerImplConnection)this.implConnection).maxFieldSize) {
            object = new TDSExecuteRequest(this.conn, this.reader, this.writer);
            ((TDSExecuteRequest)object).setSQL("SET TEXTSIZE " + this.maxFieldSize);
            ((TDSExecuteRequest)object).submitRequest(null);
            ((TDSRequest)object).processReply(3, this.warnings);
            ((TDSRequest)object).discardReplyBytes();
            ((SQLServerImplConnection)this.implConnection).maxFieldSize = this.maxFieldSize;
        }
        if (this.isPreparedStatement) {
            if (this.firstExecute) {
                this.checkForProcedureParameters();
                if (this.encodeProcInRPC) {
                    this.createCallRequest();
                } else {
                    this.createPreparedRequest();
                }
                this.firstExecute = false;
            }
        } else {
            this.createUnpreparedRequest();
        }
        if (this.request instanceof TDSRPCCursorExecuteRequest) {
            ((TDSRPCCursorExecuteRequest)this.request).setFetchSize(this.getMaxRows(), this.fetchSize);
        }
        if (!this.isPreparedStatement) {
            if (this.requireServerSideCursor()) {
                ((TDSRPCExecuteRequest)this.request).setSQL(this.sql.getFormatted());
            } else {
                object = this.sql.getFormatted();
                if (this.autoGeneratedKeysRequested) {
                    object = (String)object + this.getScopeIdentitySQL();
                }
                ((TDSExecuteRequest)this.request).setSQL((String)object);
            }
        }
        try {
            this.request.execute(this, this.warnings);
            this.setCancelableWork(false);
        }
        catch (SQLException sQLException) {
            this.setCancelableWork(false);
            this.setCancelOnNextRead(false);
            if (sQLException.getMessage().indexOf("DDTEK1") != -1) {
                this.conn.close();
                throw sQLException;
            }
            throw sQLException;
        }
        this.isBatchRequest = false;
    }

    public String getScopeIdentitySQL() {
        if (this.conn.getTDSVersion() == 1) {
            return " select @@identity";
        }
        return " select SCOPE_IDENTITY()";
    }

    public void executeBatch() throws SQLException, BatchUpdateException {
        if (this.isSimpleSelect()) {
            throw this.exceptions.getException(6053);
        }
        if (this.firstExecute) {
            this.checkForProcedureParameters();
            if (this.encodeProcInRPC) {
                this.createCallRequest();
            } else {
                this.createPreparedRequest();
            }
            this.firstExecute = false;
        }
        try {
            this.bbup = null;
            this.request.execute(this, this.warnings);
            this.setCancelableWork(false);
        }
        catch (SQLException sQLException) {
            this.setCancelableWork(false);
            this.setCancelOnNextRead(false);
            if (sQLException.getMessage().indexOf("DDTEK1") != -1) {
                this.conn.close();
                throw sQLException;
            }
            if (sQLException.getMessage().indexOf("SOCKETTIMEOUT") != -1) {
                throw sQLException;
            }
            if (sQLException.getSQLState() != null && sQLException.getSQLState().startsWith("08")) {
                throw sQLException;
            }
            this.bbup = new BaseBatchUpdateException(sQLException, new int[0]);
        }
        this.isBatchRequest = true;
    }

    public int[] getBatchRowsAffectedCount() throws SQLException {
        int[] nArray = new int[this.parameterSets.size()];
        int n = 0;
        int[] nArray2 = new int[1];
        boolean bl = false;
        while (!bl) {
            try {
                bl = this.request.getResultOfSingleExecuteInBatch(nArray2, this.warnings);
                if (bl) continue;
                nArray[n++] = nArray2[0];
            }
            catch (SQLException sQLException) {
                if (this.bbup == null) {
                    this.bbup = new BaseBatchUpdateException(sQLException, null);
                } else {
                    this.bbup.setNextException(sQLException);
                }
                if (n >= nArray.length) continue;
                nArray[n++] = -3;
            }
        }
        if (this.bbup == null) {
            return nArray;
        }
        if (n == nArray.length) {
            this.bbup.setUpdateCounts(nArray);
            throw this.bbup;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = nArray[n2];
            ++n2;
        }
        this.bbup.setUpdateCounts(nArray3);
        throw this.bbup;
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        if (this.databaseMetaDataResultSet == 3 || this.databaseMetaDataResultSet == 4) {
            return baseColumns;
        }
        BaseColumns baseColumns2 = this.request == null ? this.getColumnInfoBeforeExecute() : this.request.getColumnDescriptions();
        if (baseColumns == null) {
            return baseColumns2;
        }
        if (this.databaseMetaDataResultSet == 8) {
            BaseColumn baseColumn = baseColumns.get(1);
            BaseColumn baseColumn2 = baseColumns2.get(1);
            baseColumn.displaySize = baseColumn2.displaySize;
        } else {
            int n = 1;
            while (n <= baseColumns.count(1)) {
                if (n <= baseColumns2.count(0)) {
                    BaseColumn baseColumn = baseColumns.get(n);
                    BaseColumn baseColumn3 = baseColumns2.get(n);
                    baseColumn.displaySize = baseColumn3.displaySize;
                }
                ++n;
            }
        }
        return baseColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextResultType() throws SQLException {
        try {
            this.discardUnmaterializedResultSet();
            if (this.isBatchRequest) {
                int n = this.resultTypeReported = 3;
                return n;
            }
            if (this.request instanceof TDSRPCCursorExecuteRequest && !((TDSRPCCursorExecuteRequest)this.request).getExecutingSQLDirectly()) {
                int n = this.resultTypeReported = this.request.getResultType();
                return n;
            }
            switch (this.resultTypeReported) {
                case 0: {
                    if (this.filterTriggers) {
                        this.request.processReply(5, this.warnings);
                        break;
                    }
                    this.request.processReply(1, this.warnings);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    this.resultSet = null;
                    this.request.processReply(1, this.warnings);
                }
            }
            if (this.request.getResultType() == 1) {
                this.returnOutputParams();
            }
            int n = this.resultTypeReported = this.request.getResultType();
            return n;
        }
        finally {
            if (this.getCancelOnNextRead()) {
                this.setCancelableWork(false);
                this.setCancelOnNextRead(false);
                throw this.implConnection.exceptions.getException(6078, "HY008");
            }
        }
    }

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        if (!this.filterTriggers) {
            this.request.processReply(5, this.warnings);
        }
        try {
            this.autoGeneratedKeyValue = this.request.getColumn((int)1).data.getBigDecimal(null);
        }
        catch (Exception exception) {
            this.autoGeneratedKeyValue = null;
        }
        if (this.autoGeneratedKeyValue != null) {
            BaseColumns baseColumns = this.request.getColumnDescriptions();
            BaseColumn baseColumn = baseColumns.get(1);
            baseColumn.label = "IDENTITYCOL";
            baseColumn.name = "IDENTITYCOL";
            return baseColumns;
        }
        return null;
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        return new SQLServerAutoGeneratedKeyResultSet();
    }

    public BaseImplResultSet getNextResultSet() {
        if (this.request instanceof TDSRPCCursorExecuteRequest) {
            this.resultSet = this.getConnection().getImplResultSetServerSideCursor();
            if (this.resultSet == null) {
                this.resultSet = new SQLServerImplResultSetServerSideCursor();
            }
            ((SQLServerImplResultSetServerSideCursor)this.resultSet).initialize((TDSRPCCursorExecuteRequest)this.request);
        } else {
            this.resultSet = this.getConnection().getImplResultSet();
            if (this.resultSet == null) {
                this.resultSet = new SQLServerImplResultSet();
            }
            this.resultSet.initialize(this.request);
        }
        return this.resultSet;
    }

    public int getNextRowsAffectedCount() throws SQLException {
        if (this.request != null) {
            return this.request.getNumRowsAffected();
        }
        return 0;
    }

    private boolean isSimpleSelect() {
        return this.sql.getType() == 1;
    }

    private boolean mustDescribeStringOutputParameters() {
        if (this.parameterSets != null && this.parameterSets.size() == 1 && this.getImplConnection().receiveStringParameterType == 2) {
            BaseParameters baseParameters = null;
            baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
            int n = baseParameters.count();
            int n2 = 1;
            while (n2 <= n) {
                BaseParameter baseParameter = baseParameters.getOutput(n2);
                if (baseParameter != null && (baseParameter.sqlType == 1 || baseParameter.sqlType == 12 || baseParameter.sqlType == -1 || baseParameter.sqlType == 2005)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean useServerSideCursor() {
        return this.getImplConnection().useServerSideCursor;
    }

    private boolean shouldFilterTriggerResults() {
        if (this.getImplConnection().alwaysReportTriggerResults) {
            return false;
        }
        if (this.sql.getStatementCount() > 1) {
            return false;
        }
        if (this.sql.getType() == 4 || this.sql.getType() == 5 || this.sql.getType() == 6) {
            return !this.containsNativeExecute();
        }
        return false;
    }

    private boolean shouldSetRowCount() {
        if (this.sql.getStatementCount() > 1) {
            return false;
        }
        if (this.sql.getType() == 1) {
            return !this.containsNativeExecute();
        }
        return false;
    }

    public boolean containsNativeExecute() {
        String string;
        BaseSQLToken baseSQLToken;
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        baseSQLScanner.setup(this.sql.getFormatted(), '\'', '\"');
        do {
            baseSQLToken = baseSQLScanner.getNextToken();
            if (baseSQLToken.type != 6) continue;
            return false;
        } while (baseSQLToken.type == 17 || baseSQLToken.type == 2 || baseSQLToken.type != 9 || !(string = baseSQLToken.value.toLowerCase()).equals("exec") && !string.equals("execute"));
        return true;
    }

    public boolean supportsScrolling(int n) {
        if (n == 1004 || n == 1005) {
            if (this.resultSetConcurrency == 1007) {
                return true;
            }
            return this.getImplConnection().useServerSideUpdatableCursors;
        }
        return false;
    }

    public boolean supportsUpdates() {
        return this.getImplConnection().useServerSideUpdatableCursors;
    }

    public boolean supportsBatchParameters() {
        return true;
    }

    private SQLServerImplConnection getImplConnection() {
        return (SQLServerImplConnection)this.implConnection;
    }

    private SQLServerConnection getConnection() {
        return this.getImplConnection().connection;
    }

    private BaseColumns getColumnInfoBeforeExecute() {
        BaseColumns baseColumns;
        block7: {
            baseColumns = null;
            if (!this.isSimpleSelect()) break block7;
            BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
            String string = this.sql.getFormatted();
            String string2 = "SET FMTONLY ON ";
            baseSQLScanner.setup(string, '\'', '\"');
            if (this.sql.getParameterCount() > 0) {
                while (true) {
                    BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
                    if (baseSQLToken.type != 6) {
                        if (baseSQLToken.type == 8) {
                            string2 = string2 + "null";
                            continue;
                        }
                        string2 = string2 + baseSQLToken.value;
                        continue;
                    }
                    break;
                }
            } else {
                string2 = string2 + string;
            }
            string2 = string2 + " SET FMTONLY OFF";
            try {
                TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer);
                tDSExecuteRequest.setSQL(string2);
                tDSExecuteRequest.submitRequest(null);
                tDSExecuteRequest.processReply(4, this.warnings);
                tDSExecuteRequest.discardReplyBytes();
                baseColumns = tDSExecuteRequest.getColumnDescriptions();
            }
            catch (Exception exception) {}
        }
        return baseColumns;
    }

    private boolean requireServerSideCursor() {
        if (this.isSimpleSelect()) {
            if (this.useServerSideCursor()) {
                return true;
            }
            if (this.supportsScrolling(this.resultSetScrollType)) {
                return true;
            }
            if (this.sql.hasForUpdate()) {
                return true;
            }
            if (this.sql.hasForReadOnly()) {
                return true;
            }
            if (this.getImplConnection().useServerSideUpdatableCursors && this.resultSetConcurrency == 1008) {
                return true;
            }
        }
        return false;
    }

    private void createUnpreparedRequest() {
        this.request = this.requireServerSideCursor() ? this.createCursorRequest() : new TDSExecuteRequest(this.conn, this.reader, this.writer);
    }

    private void createPreparedRequest() throws SQLException {
        TDSRPCExecuteRequest tDSRPCExecuteRequest = this.requireServerSideCursor() ? this.createCursorRequest() : new TDSRPCNonCursorExecuteRequest(this.conn, this.reader, this.writer, this.isPreparedStatement);
        tDSRPCExecuteRequest.createUserParameters(this.parameterSets, this.getImplConnection().maxPrecision, this.getImplConnection().sendStringParametersAsUnicode, this.getImplConnection().receiveStringParameterType);
        if (this.mustDescribeStringOutputParameters()) {
            this.callAnalyzer = new SQLServerCallAnalyzer(this.exceptions, this.conn, this.reader, this.writer, this.sql, tDSRPCExecuteRequest.getUserParameters(), false);
            this.callAnalyzer.describeOuputParams();
        }
        this.changeParameterMarkers();
        String string = this.sql.getFormatted();
        if (this.autoGeneratedKeysRequested) {
            string = string + this.getScopeIdentitySQL();
        }
        tDSRPCExecuteRequest.setSQL(string);
        this.request = tDSRPCExecuteRequest;
    }

    private TDSRPCCursorExecuteRequest createCursorRequest() {
        int n = ((SQLServerImplConnection)this.implConnection).lockingModeConcurrency;
        boolean bl = ((SQLServerImplConnection)this.implConnection).useServerSideUpdatableCursors;
        if (!bl && this.sql.hasForUpdate() && n == 1) {
            n = 0;
            this.warnings.add(7020);
        }
        String string = null;
        try {
            string = this.sql.getSingleTableFromSpecification();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TDSRPCCursorExecuteRequest(this.conn, this.reader, this.writer, this.isPreparedStatement, this.resultSetScrollType, this.resultSetConcurrency, string, bl, n, this.sql.hasForUpdate(), this.sql.hasForReadOnly());
    }

    private void createCallRequest() throws SQLException {
        TDSRPCCallRequest tDSRPCCallRequest = new TDSRPCCallRequest(this.conn, this.reader, this.writer, this.procName, this.procHasReturnParam);
        tDSRPCCallRequest.createUserParameters(this.parameterSets, this.getImplConnection().maxPrecision, this.getImplConnection().sendStringParametersAsUnicode, this.getImplConnection().receiveStringParameterType);
        if (this.mustDescribeStringOutputParameters()) {
            this.callAnalyzer = new SQLServerCallAnalyzer(this.exceptions, this.conn, this.reader, this.writer, this.sql, tDSRPCCallRequest.getUserParameters(), true);
            this.callAnalyzer.describeOuputParams();
        }
        this.request = tDSRPCCallRequest;
    }

    private void changeParameterMarkers() throws SQLException {
        int n = 1;
        while (n <= this.sql.getParameterCount()) {
            BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
            String string = new String("@P" + n + " ");
            this.procHasReturnParam = false;
            String string2 = this.sql.getStringPreceedingParameter(n - 1);
            if (string2 != null && ((string2 = string2.trim().toUpperCase()).endsWith("EXEC") || string2.endsWith("EXECUTE"))) {
                this.procHasReturnParam = true;
            }
            if (!this.procHasReturnParam && baseParameters.get(n, 2) != null) {
                string = string + " OUTPUT";
            }
            this.sql.setParameter(n - 1, string);
            ++n;
        }
    }

    private void discardUnmaterializedResultSet() throws SQLException {
        block2: {
            if (this.resultTypeReported != 2 || this.resultSet != null) break block2;
            this.resultSet = new SQLServerImplResultSet();
            this.resultSet.setImplStatement(this);
            this.resultSet.initialize(this.request);
            try {
                this.resultSet.close();
            }
            catch (Exception exception) {}
        }
    }

    public void processCancelResponse() throws SQLException {
        this.request.clearCancelReply();
    }

    public void processAnyCancelReply() throws SQLException {
        if (this.conn.getCancelPendingStatement() != null) {
            if (this.implConnection.cancelPending) {
                this.implConnection.socketActivityPostCancel();
            } else {
                this.conn.getCancelPendingStatement().processCancelResponse();
            }
            this.resultTypeReported = 0;
        }
    }

    class SQLServerAutoGeneratedKeyResultSet
    extends BaseImplResultSet {
        boolean returnedTheRow = false;

        SQLServerAutoGeneratedKeyResultSet() {
        }

        public boolean fetchAtPosition(int n) throws SQLException {
            if (this.returnedTheRow) {
                return false;
            }
            this.returnedTheRow = true;
            return true;
        }

        public BaseData getData(int n, int n2) throws SQLException {
            return new BaseData(8, (Object)SQLServerImplStatement.this.autoGeneratedKeyValue, (BaseConnection)SQLServerImplStatement.this.conn.connection);
        }

        public void close() throws SQLException {
        }
    }
}

