/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.Socket;
import java.sql.SQLException;

public class DRDAByteOrderedDataReader {
    private static String footprint = "$Revision:   3.22.1.2  $";
    private int numBytesReturnedFromBuffer;
    private int numBytesInBuffer;
    private boolean cacheMoreData = true;
    private int lastNumBytesWriten = 0;
    public int numBytesReadFromCurrentPacket;
    protected boolean moreDataToRead;
    public int packetSize;
    private int dssType;
    private int dssFlags;
    private int corrId;
    private byte[] header;
    private boolean depacketizingExtendedPacket;
    private short extPacketChunkLen;
    private int extPacketHeaderLen;
    byte[] byteArray;
    public int readPosition;
    int byteArrayReadPosition;
    int byteArrayWritePosition;
    public int length;
    int byteArrayLength;
    public boolean readFromByteArray;
    UtilPagedTempBuffer tempBuffer;
    public DRDACommunication comm;
    public boolean interpretAsBigEndian;
    public int queryDataLength;
    private boolean summingQryDta;
    protected UtilTransliterator transliterator;
    protected byte[] staticByteArray;
    private Socket socket;
    private InputStream socketInputStream = null;
    private int timeoutPeriodForReads;
    private int _lenBytes;

    public DRDAByteOrderedDataReader(UtilTransliterator utilTransliterator, DRDACommunication dRDACommunication) {
        this.socket = dRDACommunication.getSocket();
        this.readPosition = 0;
        this.length = 0;
        this.tempBuffer = new UtilPagedTempBuffer();
        this.interpretAsBigEndian = true;
        this.staticByteArray = new byte[256];
        this.transliterator = utilTransliterator;
        this.comm = dRDACommunication;
        this.numBytesReadFromCurrentPacket = 0;
        this.packetSize = 1024;
        this.moreDataToRead = false;
        this.header = new byte[6];
        this.depacketizingExtendedPacket = false;
        this.extPacketChunkLen = 0;
        this.extPacketHeaderLen = 0;
        this.numBytesReturnedFromBuffer = 0;
        this.numBytesInBuffer = 0;
        this.timeoutPeriodForReads = 0;
        try {
            this.socketInputStream = this.socket.getInputStream();
        }
        catch (Exception exception) {}
    }

    public DRDAByteOrderedDataReader(UtilPagedTempBuffer utilPagedTempBuffer, int n, UtilTransliterator utilTransliterator, DRDACommunication dRDACommunication) {
        this.socket = dRDACommunication.getSocket();
        this.readPosition = 0;
        this.length = n;
        this.tempBuffer = utilPagedTempBuffer;
        this.interpretAsBigEndian = true;
        this.staticByteArray = new byte[256];
        this.transliterator = utilTransliterator;
        this.comm = dRDACommunication;
        this.packetSize = 1024;
        this.moreDataToRead = false;
        this.header = new byte[6];
        this.depacketizingExtendedPacket = false;
        this.extPacketChunkLen = 0;
        this.moreDataToRead = false;
        this.header = new byte[6];
        this.depacketizingExtendedPacket = false;
        this.extPacketChunkLen = 0;
        this.extPacketHeaderLen = 0;
        this.numBytesReturnedFromBuffer = 0;
        this.numBytesInBuffer = 0;
        this.timeoutPeriodForReads = 0;
        try {
            this.socketInputStream = this.socket.getInputStream();
        }
        catch (Exception exception) {}
    }

    public int getTimeOutValue() {
        return this.timeoutPeriodForReads;
    }

    public void setTimeOutValue(int n) throws Exception {
        this.timeoutPeriodForReads = n;
        this.socket.setSoTimeout(this.timeoutPeriodForReads);
    }

    public boolean atEndOfReply() throws UtilException {
        return this.readPosition >= this.length;
    }

    public final long getRemainingBytes() {
        return this.length - this.readPosition;
    }

    public boolean peekAhead(int n) throws UtilException {
        short s = this.readInt16();
        this.readPosition -= 2;
        if (this.readPosition < 0) {
            this.readPosition = 0;
        }
        return n == s;
    }

    public void setToReadFromByteArray() {
        this.readFromByteArray = true;
        this.byteArrayReadPosition = 0;
        this.byteArrayWritePosition = 0;
        this.byteArrayLength = this.byteArray.length;
    }

    public void cacheRemainingBytes() throws UtilException {
        if (this.byteArray == null) {
            this.byteArray = new byte[Short.MAX_VALUE];
        }
        this.byteArrayWritePosition = this.readBytes(this.byteArray, 0, this.length - this.readPosition);
    }

    public void addBytesToCache(int n) throws UtilException {
        if (this.byteArray == null) {
            this.byteArray = new byte[Short.MAX_VALUE];
        }
        this.readBytes(this.byteArray, this.byteArrayWritePosition, n);
        this.byteArrayWritePosition += n;
    }

    public void setToBigEndian() {
        this.interpretAsBigEndian = true;
    }

    public byte getByte() throws UtilException {
        byte by;
        if (this.readPosition >= this.length && !this.readFromByteArray || this.byteArrayReadPosition == this.byteArrayLength && this.readFromByteArray) {
            throw new UtilException(1001);
        }
        if (this.readFromByteArray) {
            by = this.byteArray[this.byteArrayReadPosition];
            ++this.byteArrayReadPosition;
        } else {
            return this.tempBuffer.readByte((long)this.readPosition++);
        }
        return by;
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        int n3;
        if (this.readPosition == this.length && !this.readFromByteArray || this.byteArrayReadPosition == this.byteArrayLength && this.readFromByteArray) {
            throw new UtilException(1001);
        }
        if (this.readFromByteArray) {
            n3 = Math.min(n2, this.byteArrayLength - this.byteArrayReadPosition);
            System.arraycopy(this.byteArray, this.byteArrayReadPosition, byArray, n, n3);
            this.byteArrayReadPosition += n3;
        } else {
            n3 = Math.min(n2, this.length - this.readPosition);
            n3 = this.tempBuffer.read((long)this.readPosition, byArray, n, n3);
            this.readPosition += n3;
        }
        return n3;
    }

    public final String readMutuallyExclusiveFDOCAString(String string) throws UtilException {
        String string2 = null;
        short s = this.readInt16();
        if (s != 0) {
            string2 = this.readEncodedString(s, this.comm.MultiByteServerTransliterator);
            this.readAndDiscardBytes(2);
        } else {
            short s2 = this.readInt16();
            string2 = s2 == 0 ? string : this.readEncodedString(s2, this.comm.SingleByteServerTransliterator);
        }
        return string2;
    }

    public final String readMutuallyExclusiveFDOCAString(int n) throws UtilException {
        String string = null;
        short s = this.readInt16();
        if (s != 0) {
            string = this.readEncodedString(s, this.comm.MultiByteServerTransliterator);
            this.readAndDiscardBytes(2);
        } else {
            short s2 = this.readInt16();
            string = s2 == 0 ? Integer.toString(n) : this.readEncodedString(s2, this.comm.SingleByteServerTransliterator);
        }
        return string;
    }

    public byte readInt8() throws UtilException {
        return this.getByte();
    }

    public short readUnsignedInt8() throws UtilException {
        byte by = this.getByte();
        return (short)(by & 0xFF);
    }

    public int readUnsignedInt8asInt() throws UtilException {
        byte by = this.getByte();
        return by & 0xFF;
    }

    public short readInt16() throws UtilException {
        if (this.interpretAsBigEndian) {
            return (short)((this.getByte() & 0xFF) << 8 | this.getByte() & 0xFF);
        }
        return (short)(this.getByte() & 0xFF | (this.getByte() & 0xFF) << 8);
    }

    public int readUnsignedInt16() throws UtilException {
        if (this.interpretAsBigEndian) {
            return (this.getByte() & 0xFF) << 8 | this.getByte() & 0xFF;
        }
        return this.getByte() & 0xFF | (this.getByte() & 0xFF) << 8;
    }

    public int readInt32() throws UtilException {
        this.getArrayOfBytes(this.staticByteArray, 0, 4);
        int n = this.interpretAsBigEndian ? ((this.staticByteArray[0] & 0xFF) << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + ((this.staticByteArray[3] & 0xFF) << 0) : ((this.staticByteArray[0] & 0xFF) << 0) + ((this.staticByteArray[1] & 0xFF) << 8) + ((this.staticByteArray[2] & 0xFF) << 16) + ((this.staticByteArray[3] & 0xFF) << 24);
        return n;
    }

    public long readUnsignedInt32() throws UtilException {
        this.getArrayOfBytes(this.staticByteArray, 0, 4);
        long l = this.interpretAsBigEndian ? (((long)this.staticByteArray[0] & 0xFFL) << 24) + (((long)this.staticByteArray[1] & 0xFFL) << 16) + (((long)this.staticByteArray[2] & 0xFFL) << 8) + (((long)this.staticByteArray[3] & 0xFFL) << 0) : (((long)this.staticByteArray[0] & 0xFFL) << 0) + (((long)this.staticByteArray[1] & 0xFFL) << 8) + (((long)this.staticByteArray[2] & 0xFFL) << 16) + (((long)this.staticByteArray[3] & 0xFFL) << 24);
        return l;
    }

    public float readIEEE32BitFloat() throws UtilException {
        return Float.intBitsToFloat(this.readInt32());
    }

    public long readInt64() throws UtilException {
        this.getArrayOfBytes(this.staticByteArray, 0, 8);
        if (this.interpretAsBigEndian) {
            return ((long)((this.staticByteArray[0] << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + (this.staticByteArray[3] & 0xFF)) << 32) + ((long)((this.staticByteArray[4] << 24) + ((this.staticByteArray[5] & 0xFF) << 16) + ((this.staticByteArray[6] & 0xFF) << 8) + (this.staticByteArray[7] & 0xFF)) & 0xFFFFFFFFL);
        }
        return ((long)((this.staticByteArray[0] & 0xFF) + ((this.staticByteArray[1] & 0xFF) << 8) + ((this.staticByteArray[2] & 0xFF) << 16) + (this.staticByteArray[3] << 24)) & 0xFFFFFFFFL) + ((long)((this.staticByteArray[4] & 0xFF) + ((this.staticByteArray[5] & 0xFF) << 8) + ((this.staticByteArray[6] & 0xFF) << 16) + (this.staticByteArray[7] << 24)) << 32);
    }

    public double readIEEE64BitDouble() throws UtilException {
        return Double.longBitsToDouble(this.readInt64());
    }

    public String readString(int n) throws UtilException {
        byte[] byArray = this.transliterator.getBytesCache();
        byte[] byArray2 = n > byArray.length ? new byte[n] : byArray;
        int n2 = this.getArrayOfBytes(byArray2, 0, n);
        return this.transliterator.decode(byArray2, 0, n2);
    }

    public int readBytes(byte[] byArray, int n, int n2) throws UtilException {
        return this.getArrayOfBytes(byArray, n, n2);
    }

    public InputStream getInputStream(int n) throws UtilException {
        this._lenBytes = n;
        return new InputStream(){
            private int readSoFar;
            private int totalLen;
            private boolean atEnd;
            {
                this.totalLen = DRDAByteOrderedDataReader.this._lenBytes;
            }

            public int read() throws IOException {
                if (this.readSoFar < this.totalLen) {
                    try {
                        byte by = DRDAByteOrderedDataReader.this.getByte();
                        ++this.readSoFar;
                        return by & 0xFF;
                    }
                    catch (UtilException utilException) {
                        return -1;
                    }
                }
                if (this.atEnd) {
                    return -1;
                }
                this.atEnd = true;
                return -1;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = this.totalLen - this.readSoFar;
                if (n3 >= n2) {
                    try {
                        DRDAByteOrderedDataReader.this.readBytes(byArray, n, n2);
                        this.readSoFar += n2;
                        return n2;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                if (n3 > 0) {
                    try {
                        DRDAByteOrderedDataReader.this.readBytes(byArray, n, n3);
                        this.readSoFar = this.totalLen;
                        this.atEnd = true;
                        return n3;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                this.atEnd = true;
                return -1;
            }

            public void close() throws IOException {
                int n = this.totalLen - this.readSoFar;
                if (n > 0) {
                    try {
                        DRDAByteOrderedDataReader.this.readAndDiscardBytes(n);
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                this.readSoFar = this.totalLen;
                this.atEnd = true;
            }
        };
    }

    public InputStream getAsciiStream(int n) throws UtilException {
        return this.transliterator.decodeAsAsciiStream(this.getInputStream(n));
    }

    public Reader getReader(int n) throws UtilException {
        return this.transliterator.decodeAsReader(this.getInputStream(n));
    }

    public void readAndDiscardBytes(int n) throws UtilException {
        if (n > 0) {
            if (this.readFromByteArray) {
                this.byteArrayReadPosition += n;
            } else {
                this.readPosition += n;
            }
        }
    }

    public String readEncodedString(int n, UtilTransliterator utilTransliterator) throws UtilException {
        if (n == 0) {
            return new String();
        }
        UtilTransliterator utilTransliterator2 = this.transliterator;
        this.transliterator = utilTransliterator;
        String string = this.readString(n);
        this.transliterator = utilTransliterator2;
        return string;
    }

    public String[] readDelimitedString(int n, int n2, short s, UtilTransliterator utilTransliterator) throws UtilException {
        if (n2 == 0) {
            return new String[n];
        }
        UtilTransliterator utilTransliterator2 = this.transliterator;
        this.transliterator = utilTransliterator;
        int n3 = 0;
        int n4 = 0;
        String[] stringArray = new String[n];
        Short s2 = new Short(s);
        byte[] byArray = new byte[n2];
        int n5 = this.getArrayOfBytes(byArray, 0, n2);
        int n6 = 0;
        while (n6 < n2) {
            if (byArray[n6] == s2.byteValue()) {
                stringArray[n4++] = this.transliterator.decode(byArray, n3, n6 - n3);
                n3 = n6 + 1;
            } else if (n6 == n2 - 1) {
                stringArray[n4] = this.transliterator.decode(byArray, n3, n6 + 1 - n3);
            }
            ++n6;
        }
        this.transliterator = utilTransliterator2;
        return stringArray;
    }

    public void receive() throws UtilException, SQLException {
        try {
            this.readPosition = 0;
            this.numBytesReadFromCurrentPacket = 0;
            this.moreDataToRead = true;
            this.length = this.populateTempBuffer();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException), "0800");
        }
    }

    private int populateTempBuffer() throws UtilException, SQLException {
        int n = 0;
        int n2 = 0;
        while (this.moreDataToRead) {
            this.signalStartOfPacket();
            n2 = this.getBytesFromSocketIntoTempBuffer(n, this.getNumBytesLeftInCurrentPacket());
            n += n2;
            this.signalEndOfPacket();
        }
        return n;
    }

    public void discardWireBytes() throws UtilException, SQLException {
        this.empty();
        this.receive();
        this.empty();
    }

    public void empty() throws UtilException {
        this.readPosition = this.length;
        this.numBytesInBuffer = 0;
        this.numBytesReturnedFromBuffer = 0;
    }

    public void close() throws UtilException {
        this.readPosition = this.length;
        this.numBytesInBuffer = 0;
        this.numBytesReturnedFromBuffer = 0;
        if (this.tempBuffer != null) {
            this.tempBuffer.truncate(true);
        }
    }

    protected void signalStartOfPacket() throws UtilException, SQLException {
        int n;
        int n2 = 6;
        if (!this.depacketizingExtendedPacket) {
            while (n2 > 0) {
                n2 -= this.getArrayOfBytesFromSocket(this.header, 6 - n2, n2);
            }
        }
        if ((n = ((this.header[0] & 0xFF) << 8) + (this.header[1] & 0xFF)) == 65535 || this.depacketizingExtendedPacket) {
            if (this.depacketizingExtendedPacket) {
                byte[] byArray = new byte[2];
                this.getArrayOfBytesFromSocket(byArray, 0, 2);
                int n3 = ((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0);
                if ((short)n3 == -1) {
                    n = Short.MAX_VALUE;
                    this.extPacketChunkLen = (short)-1;
                    if (this.summingQryDta) {
                        this.queryDataLength += n - 2;
                    }
                } else {
                    n = n3;
                    this.extPacketChunkLen = (short)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0));
                    this.extPacketChunkLen = (short)(this.extPacketChunkLen - 2);
                    if (this.summingQryDta) {
                        this.queryDataLength += this.extPacketChunkLen;
                    }
                }
                this.extPacketHeaderLen = 2;
            } else {
                this.depacketizingExtendedPacket = true;
                n = Short.MAX_VALUE;
                this.extPacketChunkLen = (short)-1;
                this.extPacketHeaderLen = 6;
                if (this.peekCachedByte(0) == -128 && this.peekCachedByte(1) == 4 && this.peekCachedByte(2) == 36 && this.peekCachedByte(3) == 27) {
                    this.queryDataLength = n - 10;
                    this.summingQryDta = true;
                }
            }
        }
        this.dssType = this.header[3] & 0xF;
        this.dssFlags = this.header[3] & 0xF0;
        this.corrId = ((this.header[4] & 0xFF) << 8) + ((this.header[5] & 0xFF) << 0);
        this.packetSize = n;
        if (!this.depacketizingExtendedPacket) {
            this.numBytesReadFromCurrentPacket = 6;
        } else {
            this.numBytesReadFromCurrentPacket = this.extPacketHeaderLen;
            if (this.extPacketChunkLen != -1) {
                this.depacketizingExtendedPacket = false;
            }
        }
    }

    public final int getNumBytesLeftInCurrentPacket() throws UtilException {
        if (!this.moreDataToRead) {
            return 0;
        }
        return this.packetSize - this.numBytesReadFromCurrentPacket;
    }

    protected void signalEndOfPacket() throws UtilException {
        this.numBytesReadFromCurrentPacket = 0;
        this.moreDataToRead = (this.dssFlags & 0x40) != 0 ? true : this.depacketizingExtendedPacket && this.extPacketChunkLen == -1;
    }

    public byte peekByte(int n) throws UtilException {
        if (this.readPosition >= this.length && !this.readFromByteArray || this.byteArrayReadPosition == this.byteArrayLength && this.readFromByteArray) {
            throw new UtilException(1001);
        }
        if (!this.readFromByteArray) {
            return this.tempBuffer.readByte((long)this.readPosition + (long)n);
        }
        byte by = this.byteArray[this.byteArrayReadPosition + n];
        return by;
    }

    public byte peekCachedByte(int n) throws UtilException {
        if (this.numBytesReturnedFromBuffer + n > this.numBytesInBuffer) {
            throw new UtilException(1025);
        }
        return this.comm.socketBuffer[this.numBytesReturnedFromBuffer + n];
    }

    public int getArrayOfBytesFromSocket(byte[] byArray, int n, int n2) throws UtilException, SQLException {
        int n3 = this.numBytesInBuffer - this.numBytesReturnedFromBuffer;
        if (n2 > 0) {
            if (n2 <= n3) {
                System.arraycopy(this.comm.socketBuffer, this.numBytesReturnedFromBuffer, byArray, n, n2);
                this.numBytesReturnedFromBuffer += n2;
                this.lastNumBytesWriten = n + n2;
            } else {
                int n4 = n2;
                if (n3 > 0) {
                    System.arraycopy(this.comm.socketBuffer, this.numBytesReturnedFromBuffer, byArray, n, n3);
                    n4 -= n3;
                    this.numBytesReturnedFromBuffer = this.numBytesInBuffer;
                    this.lastNumBytesWriten = n + n3;
                }
                if (n4 > 0) {
                    try {
                        this.numBytesInBuffer = this.socketInputStream.read(this.comm.socketBuffer, 0, this.comm.socketBufferSize);
                        if (this.numBytesInBuffer == -1) {
                            throw new UtilException(1002);
                        }
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        throw new SQLException("SOCKETTIMEOUT");
                    }
                    catch (IOException iOException) {
                        throw new UtilException(1018, iOException.getMessage());
                    }
                    this.numBytesReturnedFromBuffer = 0;
                    if (!this.cacheMoreData) {
                        if (this.numBytesInBuffer > 0) {
                            if (this.numBytesInBuffer < this.comm.socketBufferSize && n4 >= this.numBytesInBuffer) {
                                n4 = this.numBytesInBuffer;
                            }
                        } else {
                            n4 = -1;
                        }
                    }
                    this.getArrayOfBytesFromSocket(byArray, n + n3, n4);
                }
            }
        }
        if (!this.cacheMoreData && this.lastNumBytesWriten < n2) {
            n2 = this.lastNumBytesWriten;
        }
        return n2;
    }

    public int getBytesFromSocketIntoTempBuffer(long l, int n) throws UtilException, SQLException {
        int n2 = this.numBytesInBuffer - this.numBytesReturnedFromBuffer;
        if (n > 0) {
            if (n <= n2) {
                this.tempBuffer.write(l, this.comm.socketBuffer, this.numBytesReturnedFromBuffer, n);
                this.numBytesReturnedFromBuffer += n;
                this.lastNumBytesWriten = (int)(l + (long)n);
            } else {
                int n3 = n;
                if (n2 > 0) {
                    this.tempBuffer.write(l, this.comm.socketBuffer, this.numBytesReturnedFromBuffer, n2);
                    n3 -= n2;
                    this.numBytesReturnedFromBuffer = this.numBytesInBuffer;
                    this.lastNumBytesWriten = (int)(l + (long)n2);
                }
                if (n3 > 0) {
                    try {
                        this.numBytesInBuffer = this.socketInputStream.read(this.comm.socketBuffer, 0, this.comm.socketBufferSize);
                        if (this.numBytesInBuffer == -1) {
                            throw new UtilException(1002);
                        }
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        throw new SQLException("SOCKETTIMEOUT");
                    }
                    catch (IOException iOException) {
                        throw new UtilException(1018, iOException.getMessage());
                    }
                    this.numBytesReturnedFromBuffer = 0;
                    if (!this.cacheMoreData) {
                        if (this.numBytesInBuffer > 0) {
                            if (this.numBytesInBuffer < this.comm.socketBufferSize && n3 >= this.numBytesInBuffer) {
                                n3 = this.numBytesInBuffer;
                            }
                        } else {
                            n3 = -1;
                        }
                    }
                    this.getBytesFromSocketIntoTempBuffer(l + (long)n2, n3);
                }
            }
        }
        if (!this.cacheMoreData && this.lastNumBytesWriten < n) {
            n = this.lastNumBytesWriten;
        }
        return n;
    }
}

