/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.db2.DB2EscapeTranslator;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.drda.DRDABindRequest;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAExecuteStatementRequest;
import com.metamatrix.jdbc.db2.drda.DRDALoginRequest;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;
import java.text.MessageFormat;

public class DB2PackageManager {
    private static String footprint = "$Revision:   3.14.1.0  $";
    DB2ImplConnection con;
    DRDACommunication comm;
    DRDALoginRequest loginRequest;
    boolean packagesCreated;
    private String databaseName;
    private String collectionId;
    private String grantee;
    private String grantExecute;
    private String replacePackage;
    private String packageOwner;
    private String packageName;
    private String defaultQualifier;
    private boolean withHoldCursors;
    private int dynamicSections;
    private int transactionIsolationLevel;
    private boolean isInitialized;
    public final String baseName = "DDJ";
    public final String[] isoLvl = new String[]{"C", "S", "R", "U", "N"};
    public final String vrm = "330";
    public final String[] suffix = new String[]{"A", "B", "C"};
    public String currentPackage;
    int[] DDJC330A;
    int[] DDJC330B;
    int[] DDJC330C;
    int[] DDJS330A;
    int[] DDJS330B;
    int[] DDJS330C;
    int[] DDJR330A;
    int[] DDJR330B;
    int[] DDJR330C;
    int[] DDJU330A;
    int[] DDJU330B;
    int[] DDJU330C;
    int[] DDJN330A;
    int[] DDJN330B;
    int[] DDJN330C;
    int DDJC330A_last;
    int DDJC330B_last;
    int DDJS330A_last;
    int DDJS330B_last;
    int DDJR330A_last;
    int DDJR330B_last;
    int DDJU330A_last;
    int DDJU330B_last;
    int DDJN330A_last;
    int DDJN330B_last;
    Object[] secs = new Object[15];

    public DB2PackageManager(DRDACommunication dRDACommunication, DB2ImplConnection dB2ImplConnection) {
        this.con = dB2ImplConnection;
        this.comm = dRDACommunication;
    }

    public void initialize(DRDALoginRequest dRDALoginRequest) throws SQLException {
        int n;
        this.loginRequest = dRDALoginRequest;
        this.databaseName = this.con.databaseName;
        this.collectionId = this.con.collectionId;
        this.packageOwner = this.con.packageOwner;
        this.grantee = this.con.grantee;
        this.grantExecute = this.con.grantExecute;
        this.replacePackage = this.con.replacePackage;
        this.defaultQualifier = this.con.defaultQualifier;
        this.withHoldCursors = this.con.holdCursorsOverCommit;
        this.dynamicSections = Integer.parseInt(this.con.dynSectionsString);
        this.transactionIsolationLevel = 2;
        this.packageName = "DDJ" + this.isoLvl[0] + "330" + this.suffix[0];
        if (!this.con.connectProps.get("createDefaultPackage").equalsIgnoreCase("false")) {
            n = this.createPackageSet();
            if (!this.con.grantExecute.equalsIgnoreCase("false")) {
                this.grantPackagePrivileges();
            }
        } else {
            try {
                n = this.getMaxSections();
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -805) {
                    n = this.createPackageSet();
                    if (!this.con.grantExecute.equalsIgnoreCase("false")) {
                        this.grantPackagePrivileges();
                    }
                }
                throw sQLException;
            }
        }
        this.dynamicSections = n;
        this.setupLocalPackageSet();
        if (this.packagesCreated) {
            this.con.warnings.add(7095);
        }
    }

    public int getNumberOfSections() {
        return this.dynamicSections;
    }

    private void setupLocalPackageSet() {
        this.DDJC330A = new int[this.dynamicSections];
        this.DDJC330B = new int[this.dynamicSections];
        this.DDJC330C = new int[2];
        this.DDJS330A = new int[this.dynamicSections];
        this.DDJS330B = new int[this.dynamicSections];
        this.DDJS330C = new int[2];
        this.DDJR330A = new int[this.dynamicSections];
        this.DDJR330B = new int[this.dynamicSections];
        this.DDJR330C = new int[2];
        this.DDJU330A = new int[this.dynamicSections];
        this.DDJU330B = new int[this.dynamicSections];
        this.DDJU330C = new int[2];
        this.DDJN330A = new int[this.dynamicSections];
        this.DDJN330B = new int[this.dynamicSections];
        this.DDJN330C = new int[2];
        this.secs[0] = this.DDJC330A;
        this.secs[1] = this.DDJC330B;
        this.secs[2] = this.DDJC330C;
        this.secs[3] = this.DDJS330A;
        this.secs[4] = this.DDJS330B;
        this.secs[5] = this.DDJS330C;
        this.secs[6] = this.DDJR330A;
        this.secs[7] = this.DDJR330B;
        this.secs[8] = this.DDJR330C;
        this.secs[9] = this.DDJU330A;
        this.secs[10] = this.DDJU330B;
        this.secs[11] = this.DDJU330C;
        this.secs[12] = this.DDJN330A;
        this.secs[13] = this.DDJN330B;
        this.secs[14] = this.DDJN330C;
        int n = 0;
        while (n < this.secs.length) {
            int[] nArray = (int[])this.secs[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = -1;
                ++n2;
            }
            ++n;
        }
        this.isInitialized = true;
    }

    private int getMaxSections() throws SQLException {
        String string = null;
        string = this.comm.serverOS == 8 ? "SELECT ISOLATION FROM QSYS2.SYSPACKAGE WHERE PACKAGE_NAME = '" + this.packageName + "'" : (this.comm.serverOS == 3 ? "SELECT COUNT(*) FROM SYSIBM.SYSPACKSTMT WHERE NAME ='" + this.packageName + "' and COLLID = '" + this.collectionId.trim() + "' AND LOCATION = ''" : "SELECT TOTALSECT FROM SYSIBM.SYSPLAN WHERE NAME = '" + this.packageName + "'");
        DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.con.createImplStatement(1000, 1003);
        dB2ImplStatement.setup(this.con, this.con.warnings);
        dB2ImplStatement.setSQL(new BaseSQL(string, 0, this.con.quotingChar, (BaseEscapeTranslator)new DB2EscapeTranslator(this.con), this.con.exceptions));
        dB2ImplStatement.execute();
        dB2ImplStatement.getNextResultType();
        BaseImplResultSet baseImplResultSet = dB2ImplStatement.getNextResultSet();
        baseImplResultSet.setImplStatement((BaseImplStatement)dB2ImplStatement);
        baseImplResultSet.setWarnings(this.con.warnings);
        int n = 0;
        String string2 = null;
        if (baseImplResultSet.fetchAtPosition(0)) {
            if (this.comm.serverOS == 8) {
                string2 = baseImplResultSet.getData(1, 1).getString(10, this.con.exceptions);
            } else {
                n = baseImplResultSet.getData(1, 4).getInteger(this.con.exceptions);
            }
        }
        baseImplResultSet.close();
        dB2ImplStatement.close();
        if (this.comm.serverOS == 8) {
            return 200;
        }
        if (this.comm.serverOS == 3) {
            return n - 1;
        }
        return n;
    }

    private int createPackageSet() throws SQLException {
        try {
            String string = "DDJ";
            MessageFormat messageFormat = new MessageFormat("DECLARE C0{0} CURSOR FOR S0{0}");
            MessageFormat messageFormat2 = new MessageFormat("DECLARE C0{0} CURSOR WITH HOLD FOR S0{0}");
            String string2 = "CALL :H";
            String string3 = "CALL :H USING DESCRIPTOR :H";
            StringBuffer stringBuffer = null;
            int n = this.dynamicSections;
            Object[] objectArray = new Object[]{new Integer(1)};
            boolean bl = Boolean.valueOf(this.replacePackage);
            if (this.comm.bindsPackagesAsSQLAMv6) {
                this.loginRequest.workAroundv8Bug = true;
                this.loginRequest.submitRequest();
                this.loginRequest.processReply(this.con.warnings);
                this.comm.setServerInfo();
                this.comm.fixSQLAMLevels();
            }
            if (this.comm.serverOS != 3 && this.comm.serverOS != 8) {
                bl = true;
            }
            DRDABindRequest dRDABindRequest = new DRDABindRequest(this.con, this.comm, this.con.dataReader, this.con.dataWriter, this.databaseName, this.collectionId, "", this.defaultQualifier, this.packageOwner, "1", bl);
            int n2 = 0;
            while (n2 < this.suffix.length) {
                int n3 = 0;
                while (n3 < this.isoLvl.length) {
                    if (this.isoLvl[n3] != "N" || this.isoLvl[n3] == "N" && this.comm.serverOS == 8) {
                        string = "DDJ" + this.isoLvl[n3] + "330" + this.suffix[n2];
                        dRDABindRequest.setPackageName(string);
                        dRDABindRequest.setIsoLvl(this.isoLvl[n3]);
                        dRDABindRequest.writeBGNBND();
                        dRDABindRequest.submitRequest();
                        try {
                            dRDABindRequest.processReply(this.con.warnings);
                        }
                        catch (SQLException sQLException) {
                            dRDABindRequest.clearExceptions();
                            bl = !bl;
                            dRDABindRequest.setReplace(bl);
                            dRDABindRequest.writeBGNBND();
                            dRDABindRequest.submitRequest();
                        }
                        if (this.suffix[n2] == "A") {
                            int n4 = 1;
                            while (n4 <= n) {
                                objectArray[0] = new Integer(n4);
                                stringBuffer = new StringBuffer(messageFormat.format(objectArray));
                                int n5 = 0;
                                while (n5 < stringBuffer.length()) {
                                    if (stringBuffer.charAt(n5) == ',') {
                                        stringBuffer.deleteCharAt(n5);
                                    }
                                    ++n5;
                                }
                                dRDABindRequest.writeBNDSQLSTT(stringBuffer.toString(), n4, null);
                                dRDABindRequest.submitRequest();
                                dRDABindRequest.processReply(this.con.warnings);
                                ++n4;
                            }
                        } else if (this.suffix[n2] == "B") {
                            int n6 = 1;
                            while (n6 <= n) {
                                objectArray[0] = new Integer(n6);
                                stringBuffer = new StringBuffer(messageFormat2.format(objectArray));
                                int n7 = 0;
                                while (n7 < stringBuffer.length()) {
                                    if (stringBuffer.charAt(n7) == ',') {
                                        stringBuffer.deleteCharAt(n7);
                                    }
                                    ++n7;
                                }
                                dRDABindRequest.writeBNDSQLSTT(stringBuffer.toString(), n6, null);
                                dRDABindRequest.submitRequest();
                                dRDABindRequest.processReply(this.con.warnings);
                                ++n6;
                            }
                        } else if (this.suffix[n2] == "C" && !this.comm.enableRealStoredProcPrepare) {
                            BaseParameters baseParameters = new BaseParameters(1, this.con.exceptions, (BaseConnection)this.con.db2Connection);
                            baseParameters.set(1, 1, new BaseParameter(1, 10, (Object)"spName", (BaseConnection)this.con.db2Connection));
                            dRDABindRequest.writeBNDSQLSTT(string2, 1, baseParameters);
                            dRDABindRequest.submitRequest();
                            dRDABindRequest.processReply(this.con.warnings);
                            BaseParameters baseParameters2 = new BaseParameters(2, this.con.exceptions, (BaseConnection)this.con.db2Connection);
                            baseParameters2.set(1, 1, new BaseParameter(1, 10, (Object)"spName", (BaseConnection)this.con.db2Connection));
                            baseParameters2.set(2, 1, new BaseParameter(1111, 10, (Object)"spSqlDa", (BaseConnection)this.con.db2Connection));
                            dRDABindRequest.writeBNDSQLSTT(string3, 2, baseParameters2);
                            dRDABindRequest.submitRequest();
                            dRDABindRequest.processReply(this.con.warnings);
                        }
                        dRDABindRequest.writeENDBND(this.dynamicSections);
                        dRDABindRequest.submitRequest();
                        dRDABindRequest.processReply(this.con.warnings);
                        this.con.transactionRequest.submitRequest(1);
                        this.con.transactionRequest.processReply(this.con.warnings);
                    }
                    ++n3;
                }
                ++n2;
            }
            if (this.comm.bindsPackagesAsSQLAMv6) {
                this.loginRequest.workAroundv8Bug = false;
                this.loginRequest.submitRequest();
                this.loginRequest.processReply(this.con.warnings);
                this.comm.setServerInfo();
                this.comm.fixSQLAMLevels();
            }
            this.packagesCreated = true;
            return n;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    private void grantPackagePrivileges() throws SQLException {
        DRDAPkgNamCsn dRDAPkgNamCsn = new DRDAPkgNamCsn(this.databaseName, this.collectionId, "DDJC330A", 1, null);
        DRDAExecuteStatementRequest dRDAExecuteStatementRequest = new DRDAExecuteStatementRequest(this.con, this.comm, this.con.dataReader, this.con.dataWriter, null, dRDAPkgNamCsn);
        String string = "DDJ";
        int n = 0;
        while (n < this.suffix.length) {
            int n2 = 0;
            while (n2 < this.isoLvl.length) {
                if (this.isoLvl[n2] != "N" || this.isoLvl[n2] == "N" && this.comm.serverOS == 8) {
                    string = "DDJ" + this.isoLvl[n2] + "330" + this.suffix[n];
                    String string2 = "GRANT EXECUTE ON PACKAGE " + this.collectionId + "." + string + " TO " + this.grantee.toUpperCase();
                    dRDAExecuteStatementRequest.writeEXCSQLIMM(string2, 0);
                    dRDAExecuteStatementRequest.submitRequest();
                    dRDAExecuteStatementRequest.processMode = 2;
                    dRDAExecuteStatementRequest.processReply(this.con.warnings);
                }
                ++n2;
            }
            ++n;
        }
    }

    public int getAvailableSectionNumber(boolean bl, boolean bl2) throws SQLException {
        int n = 0;
        if (!this.isInitialized) {
            return 1;
        }
        switch (this.con.transactionIsolationLevel) {
            case 0: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJN330C[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJN330C[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJN330B_last = n = this.searchForFreeSection(this.DDJN330B, this.DDJN330B_last);
                    break;
                }
                this.DDJN330A_last = n = this.searchForFreeSection(this.DDJN330A, this.DDJN330A_last);
                break;
            }
            case 2: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJC330C[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJC330C[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJC330B_last = n = this.searchForFreeSection(this.DDJC330B, this.DDJC330B_last);
                    break;
                }
                this.DDJC330A_last = n = this.searchForFreeSection(this.DDJC330A, this.DDJC330A_last);
                break;
            }
            case 1: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJU330C[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJU330C[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJU330B_last = n = this.searchForFreeSection(this.DDJU330B, this.DDJU330B_last);
                    break;
                }
                this.DDJU330A_last = n = this.searchForFreeSection(this.DDJU330A, this.DDJU330A_last);
                break;
            }
            case 4: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJR330C[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJR330C[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJR330B_last = n = this.searchForFreeSection(this.DDJR330B, this.DDJR330B_last);
                    break;
                }
                this.DDJR330A_last = n = this.searchForFreeSection(this.DDJR330A, this.DDJR330A_last);
                break;
            }
            case 8: {
                if (bl) {
                    if (bl2) {
                        n = 2;
                        this.DDJS330C[1] = 1;
                        break;
                    }
                    n = 1;
                    this.DDJS330C[0] = 1;
                    break;
                }
                if (this.withHoldCursors) {
                    this.DDJS330B_last = n = this.searchForFreeSection(this.DDJS330B, this.DDJS330B_last);
                    break;
                }
                this.DDJS330A_last = n = this.searchForFreeSection(this.DDJS330A, this.DDJS330A_last);
            }
        }
        return n;
    }

    public String getPackageName(boolean bl) throws SQLException {
        String string = null;
        switch (this.con.transactionIsolationLevel) {
            case 0: {
                if (bl) {
                    string = "DDJN330C";
                    break;
                }
                if (this.withHoldCursors) {
                    string = "DDJN330B";
                    break;
                }
                string = "DDJN330A";
                break;
            }
            case 2: {
                if (bl) {
                    string = "DDJC330C";
                    break;
                }
                if (this.withHoldCursors) {
                    string = "DDJC330B";
                    break;
                }
                string = "DDJC330A";
                break;
            }
            case 1: {
                if (bl) {
                    string = "DDJU330C";
                    break;
                }
                if (this.withHoldCursors) {
                    string = "DDJU330B";
                    break;
                }
                string = "DDJU330A";
                break;
            }
            case 4: {
                if (bl) {
                    string = "DDJR330C";
                    break;
                }
                if (this.withHoldCursors) {
                    string = "DDJR330B";
                    break;
                }
                string = "DDJR330A";
                break;
            }
            case 8: {
                string = bl ? "DDJS330C" : (this.withHoldCursors ? "DDJS330B" : "DDJS330A");
            }
        }
        return string;
    }

    private int searchForFreeSection(int[] nArray, int n) throws SQLException {
        int n2 = -1;
        if (this.comm.serverType == 8) {
            n = 0;
        }
        int n3 = n;
        while (n3 < this.dynamicSections) {
            if (nArray[n3] == -1) {
                n2 = n3;
                nArray[n3] = 1;
                break;
            }
            ++n3;
        }
        if (n2 == -1 && n > 0) {
            int n4 = 0;
            while (n4 < this.dynamicSections) {
                if (nArray[n4] == -1) {
                    n2 = n4;
                    nArray[n4] = 1;
                    break;
                }
                ++n4;
            }
        }
        if (this.dynamicSections == 0 || n2 == -1) {
            throw this.comm.exceptions.getException(7070);
        }
        return n2 + 1;
    }

    public void updatePackageSections() {
        if (!this.isInitialized) {
            return;
        }
        int n = 0;
        while (n < this.secs.length) {
            int[] nArray = (int[])this.secs[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == 2) {
                    nArray[n2] = -1;
                } else if (nArray[n2] == 1 && (this.comm.serverOS == 8 || this.comm.serverOS == 3)) {
                    nArray[n2] = 3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public boolean isSectionMarkedForPrepare(DRDAPkgNamCsn dRDAPkgNamCsn) {
        if (dRDAPkgNamCsn == null || dRDAPkgNamCsn.sectionNumber == 0 || dRDAPkgNamCsn.packageName == null || !this.isInitialized) {
            return false;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330B")) {
            return this.DDJC330B[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330A")) {
            return this.DDJC330A[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330C")) {
            return this.DDJC330C[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330B")) {
            return this.DDJR330B[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330A")) {
            return this.DDJR330A[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330C")) {
            return this.DDJR330C[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330B")) {
            return this.DDJS330B[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330A")) {
            return this.DDJS330A[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330C")) {
            return this.DDJS330C[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330B")) {
            return this.DDJU330B[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330A")) {
            return this.DDJU330A[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330C")) {
            return this.DDJU330C[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330B")) {
            return this.DDJN330B[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330A")) {
            return this.DDJN330A[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330C")) {
            return this.DDJN330C[dRDAPkgNamCsn.sectionNumber - 1] == 3;
        }
        return false;
    }

    public boolean isSectionMarkedInUse(DRDAPkgNamCsn dRDAPkgNamCsn) {
        if (dRDAPkgNamCsn == null || dRDAPkgNamCsn.sectionNumber == 0 || dRDAPkgNamCsn.packageName == null || !this.isInitialized) {
            return false;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330B")) {
            return this.DDJC330B[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330A")) {
            return this.DDJC330A[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330C")) {
            return this.DDJC330C[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330B")) {
            return this.DDJR330B[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330A")) {
            return this.DDJR330A[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330C")) {
            return this.DDJR330C[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330B")) {
            return this.DDJS330B[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330A")) {
            return this.DDJS330A[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330C")) {
            return this.DDJS330C[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330B")) {
            return this.DDJU330B[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330A")) {
            return this.DDJU330A[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330C")) {
            return this.DDJU330C[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330B")) {
            return this.DDJN330B[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330A")) {
            return this.DDJN330A[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330C")) {
            return this.DDJN330C[dRDAPkgNamCsn.sectionNumber - 1] == 1;
        }
        return false;
    }

    public void freeThisSectionNumber(DRDAPkgNamCsn dRDAPkgNamCsn) throws SQLException {
        if (!this.isInitialized || dRDAPkgNamCsn == null || dRDAPkgNamCsn.sectionNumber == 0) {
            return;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330B")) {
            this.DDJC330B[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330A")) {
            this.DDJC330A[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330C")) {
            this.DDJC330C[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330B")) {
            this.DDJR330B[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330A")) {
            this.DDJR330A[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330C")) {
            this.DDJR330C[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330B")) {
            this.DDJS330B[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330A")) {
            this.DDJS330A[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330C")) {
            this.DDJS330C[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330B")) {
            this.DDJU330B[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330A")) {
            this.DDJU330A[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330C")) {
            this.DDJU330C[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330B")) {
            this.DDJN330B[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330A")) {
            this.DDJN330A[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330C")) {
            this.DDJN330C[dRDAPkgNamCsn.sectionNumber - 1] = -1;
        }
    }

    public void markThisSectionNumber(DRDAPkgNamCsn dRDAPkgNamCsn, int n) throws SQLException {
        if (dRDAPkgNamCsn == null || dRDAPkgNamCsn.sectionNumber == 0 || !this.isInitialized) {
            return;
        }
        if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330B")) {
            if (this.DDJC330B[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJC330B[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330A")) {
            if (this.DDJC330A[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJC330A[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJC330C")) {
            if (this.DDJC330C[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJC330C[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330B")) {
            if (this.DDJR330B[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJR330B[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330A")) {
            if (this.DDJR330A[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJR330A[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJR330C")) {
            if (this.DDJR330C[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJR330C[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330B")) {
            if (this.DDJS330B[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJS330B[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330A")) {
            if (this.DDJS330A[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJS330A[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJS330C")) {
            if (this.DDJS330C[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJS330C[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330B")) {
            if (this.DDJU330B[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJU330B[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330A")) {
            if (this.DDJU330A[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJU330A[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJU330C")) {
            if (this.DDJU330C[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJU330C[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330B")) {
            if (this.DDJN330B[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJN330B[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330A")) {
            if (this.DDJN330A[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJN330A[dRDAPkgNamCsn.sectionNumber - 1] = n;
        } else if (dRDAPkgNamCsn.packageName.equalsIgnoreCase("DDJN330C")) {
            if (this.DDJN330C[dRDAPkgNamCsn.sectionNumber - 1] == -1 && n == 2) {
                return;
            }
            this.DDJN330C[dRDAPkgNamCsn.sectionNumber - 1] = n;
        }
    }
}

